/*---------------------------------------------------------------------------*\
|   GET & SET all ACL from a Drive with all (sub)directories and/or files     |
|   to/from an ASCII File for OS/2 Lan Server 3.0 and higher                  |
|                               (C) Alain Rykaert - IBM-Belgium - SEP95-FEB98 |
\*---------------------------------------------------------------------------*/
    Version = '2.02'

    Parse Upper Arg Option

    Call Init                    /* Initialisation of DLL's and other stuff*/
    Call ChkOpt                          /* Check Options & display Welcome*/
    Call ChkPws                               /* Check the PWS & Admin name*/
    Call Main                                          /* Do the main thing*/
    Call Quit

 MAIN:/* --------------------------------------------------------------------*/

    If Get
     Then Call Get
     Else Call Set

    Return

 GET:/* ---------------------------------------------------------------------*/

   'If exist' OutF 'del' OutF

    ChkDir = '\\'SrvName'\'Left(Source,1)'$'SubStr(Source,3,)

    If Dir  Then Call GetDir
    If File Then Call GetFile

    Return

 GETDIR:/* ------------------------------------------------------------------*/

    Call Time('R')

    Say ' Getting all dirs, please wait ...'

    Call SysFileTree ChkDir, 'Source', 'DOS'
    If Source.0 = 0
      Then Say '! Nothing found'
      Else Do
             Say ' Total directories found:' Source.0 'in:' Trunc(Time('E'),2)
          /* Call RxStemSort 'Source' */
             Do i = 1 to Source.0
               Call GetAcc Source.i
             End
           End

    Return

 GETFILE:/* -----------------------------------------------------------------*/

    Call Time('R')
    Say ' Getting all files, please wait ...'

    Call SysFileTree ChkDir, 'Source', 'FOS'
    If Source.0 = 0
      Then Say '! Nothing found'
      Else Do
             Say ' Total Files found :' Source.0 'in:' Trunc(Time('E'),2)
          /* Call RxStemSort 'Source' */
             Do i = 1 to Source.0
               Call GetAcc Source.i
             End
           End

    Return

 GETACC:/* ------------------------------------------------------------------*/

    Parse Arg Resource

    RC = NetGetInfo(10, 'Access', '\\'SrvName, Resource)
    If RC = 0
      Then Do
          /* Call RxStemSort 'Access'*/
             Do j = 1 to Access.count
               OutT = '   ;'Source.i';'Access.j.UgName';'Access.j.Access';'Access.Audit
               If \Mute Then Say OutT
               If OutT = ''
                 Then Nop
                 Else Call LineOut OutF, OutT
             End
           End
      Else Nop

    Return

 SET:/* ---------------------------------------------------------------------*/

    ExitCode = X2D('FE00')

    Do While Lines(InpF)
      LLine = LineIn(InpF)
      OLine = LLine
      Parse Value LLine With Opt ';' LLine
      Select
        When Opt = '',
         | LLine = '',
         | Left(Strip(Opt),1) = '*' Then Iterate
        When Translate(Opt) = 'A'   Then Call AddACL
        When Translate(Opt) = 'D'   Then Call DelACL
        When Translate(Opt) = 'U'   Then Call UpdACL
        Otherwise Iterate
       End
       If RCode Then ExitCode = X2D('1604')
    End

    Return

 ADDACL:/* ------------------------------------------------------------------*/

    RCode = 0

    Call ReadLine LLine                        /* Read & Interpret the Line*/

    Access.Count    = 1
    Access.1.UgName = AccessControlList
    Access.1.Access = AccessControlPermission
    Access.Audit  = AccessAuditing

    RC = NetAdd(10, 'Access', '\\'ServerName, Resource)
    If RC = 0
      Then RC = ''
      Else Do
             RC = ':' RC
             RCode = 1
           End
    Call Logit 'Add ACL', ServerName'-'Resource'-'AccessControlList'-'AccessControlPermission'-'AccessAuditing, RC

    Return

 DELACL:/* ------------------------------------------------------------------*/

    RCode = 0

    Call ReadLine LLine                        /* Read & Interpret the Line*/

    RC = NetDelete(10, '\\'ServerName, Resource)
    If RC = 0
      Then RC = ''
      Else Do
             RC = ':' RC
             RCode = 1
           End

    Call Logit 'Delete ACL', ServerName'-'AccessControlList'-'AccessControlPermission'-'AccessAuditing, RC

    Return

 UPDACL:/* ------------------------------------------------------------------*/

    RCode = 0

    Call ReadLine LLine                        /* Read & Interpret the Line*/
    Access.Audit    = AccessAuditing
    Access.Count    = 1
    Access.1.UgName = AccessControlList
    Access.1.Access = AccessControlPermission

    RC = NetSetInfo(10, 'Access', '\\'ServerName, Resource)
    If RC = 0
      Then RC = ''
      Else Do
             RC = ':' RC
             RCode = 1
           End
    Call Logit 'Update ACL', ServerName'-'Resource'-'AccessControlList'-'AccessControlPermission'-'AccessAuditing, RC

    Return

 READLINE:/* ----------------------------------------------------------------*/

    Parse Arg LineToRead

    Parse Value LineToRead With Resource ';' ACL ';' ACP ';' AUD .

    AccessControlList       = Translate(Strip(ACL))
    AccessControlPermission = Translate(Strip(ACP))
    AccessAuditing          = Strip(AUD)
 /*
    j = 0
    Do While Resource <> ''
      j = j + 1
      Parse Value Resource With Extract.j '\' Resource
    End

    Resource = Left(Extract.4,1) || ':'
    Do k = 5 to j
      Resource = Resource || '\' || Extract.k
    End

    ServerName = Extract.3
   */

    Parse Upper Value Resource With '\\' ServerName '\' .

    If Trace
      Then Do
             Say ' ServerName              =>'ServerName'<'
             Say ' Resource                =>'Resource'<'
             Say ' AccessControlList       =>'AccessControlList'<'
             Say ' AccessControlPermission =>'AccessControlPermission'<'
             Say ' AccessAuditing          =>'AccessAuditing'<'
           End
      Else Nop

    Return

 CHKOPT:/* ------------------------------------------------------------------*/

   '@echo off'
    SrvName = ''
    Source  = ''
    InpF    = 'RXACL.CSV'
    OutF    = 'RXACL.CSV'
    LogF    = 'LSMT.LOG'
    ChkF    = 'RXACL.CHK'
    Dir     = 0
    File    = 0
    Get     = 0
    Set     = 0
    Mute    = 0
    Trace   = 0
    Pipe    = ''

    Do While Option <> ''
      Parse Value Option With Argument ' ' Option
      Select
        When Left(Argument,5) = '/SRV:' Then SrvName = Substr(Argument,6)
        When Left(Argument,5) = '/INP:' Then InpF    = Substr(Argument,6)
        When Left(Argument,5) = '/OUT:' Then OutF    = Substr(Argument,6)
        When Left(Argument,5) = '/SRC:' Then Source  = Substr(Argument,6)
        When Left(Argument,5) = '/TRG:' Then Target  = Substr(Argument,6)
        When Left(Argument,5) = '/LOG:' Then LogF    = Substr(Argument,6)
        When Left(Argument,5) = '/PIP:' Then Pipe    = Substr(Argument,6)
        When Left(Argument,4) = '/DIR'  Then Dir     = 1
        When Left(Argument,5) = '/FILE' Then File    = 1
        When Left(Argument,4) = '/GET'  Then Get     = 1
        When Left(Argument,4) = '/SET'  Then Set     = 1
        When Left(Argument,2) = '/M'    Then Mute    = 1
        When Left(Argument,2) = '/T'    Then Trace   = 1
        Otherwise Nop
      End
    End

    If SrvName = '' | Get = 0 & Set = 0
     Then Signal GetHelp
     Else Nop

    If \MUTE
      Then Do
             If Get
               Then Do
                      Topic1 = 'RXACLGET'
                      Topic_String.Topic1.1 = SRVNAME
                      Topic_String.Topic1.2 = SOURCE
                      Topic_String.Topic1.3 = OUTF
                      Topic_String.Topic1.4 = LOGF
                      Topic_String.Topic1.5 = DIR
                      Topic_String.Topic1.6 = FILE
                      Topic_String.Topic1.7 = PIPE' '
                      Topic_List = 'RXACLWELCOME' Topic1
                      Call GETANS
                    End
               Else Do
                      Topic1 = 'RXACLSET'
                      Topic_String.Topic1.1 = SRVNAME
                      Topic_String.Topic1.2 = INPF
                      Topic_String.Topic1.3 = LOGF
                      Topic_String.Topic1.4 = CHKF
                      Topic_String.Topic1.5 = PIPE' '
                      Topic_List = 'RXACLWELCOME' Topic1
                      Call GETANS
                    End
            Parse Value SysCurPos() With Old_R Old_C; '@pause'
            Call SysCurPos Old_R, Old_C; Say ESC'[K'
          End
      Else Do
             Say ' ServerName =' SrvName
             Say ' Resource   =' Source
             Say ' OutputFile =' OutF
           End

    Return

 CHKPWS:/* ------------------------------------------------------------------*/

    RC = NetGetInfo(350, 'WkstaInfo','')
    If RC = 0
      Then Do
             ADMName = WkstaInfo.UserName
             PWSName = WkstaInfo.ComputerName
           End
      Else Do
             Call Logit 'Get PWS Info', ,RC
             Call Quit
           End
    Return

 INIT:/* --------------------------------------------------------------------*/

    Call RgUtil   '/m'                                    /* Rexx Utilities*/
    Call RgUtils  '/m'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/m'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . ProgName '.' .
    ProgName = Filespec('N', ProgName)

   '@echo off'
    ESC = '1B'x

    Resource_File = 'RXACL.RSC'
    Call ChkFile Resource_File

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List)
    Parse VALUE SysCurPos() With Old_R Old_C
    Do While Vars_List <> ''
      Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List
      Call SysCurPos Row, Column
      Say X2C(Color) || Topic_String.Topic_Id.Var_Id || ESC'[0m'
      End
    Call SysCurPos Old_R, Old_C

    Return

 GETHELP:/* -----------------------------------------------------------------*/

    Topic1 = 'RXACLHELP'
    Topic_String.Topic1.1= ProgName
    Topic_List = Topic1
    Call GetAns
    Call Quit

    Return

 CHKFILE:/* -----------------------------------------------------------------*/

    Parse Arg File

    RC = Stream(File, 'C', 'Query Exists')
    If RC = ''
      Then Do
             Say '! File' File 'not found'
             Call Quit
          End
      Else Nop

    Return

 LOGIT:/* -------------------------------------------------------------------*/

    Func = Arg(1); Info = Arg(2); RCod = Arg(3)
    RC = LLogit(LogF, Pipe, AdmName, ProgName, Func, Info, RCod)

    Return

 QUIT:/* --------------------------------------------------------------------*/

    Call Stream InpF, 'C', 'Close'
    Call Stream OutF, 'C', 'Close'
    Call Stream ChkF, 'C', 'Close'
    Call Stream LogF, 'C', 'Close'

    Exit ExitCode

