/*---------------------------------------------------------------------------*\
|   GET DASD limits infos from a LAN Server 3.0 and higher                    |
|   and dump it to an ASCII File                                              |
|       (C) Alain Rykaert IBM-Belgium & Hermann Pauli IBM-Germany SEP95-MAY96 |
\*---------------------------------------------------------------------------*/

    Parse Arg Option

    Call INIT                    /* Initialisation of DLL's and other stuff*/
    Call CHKOPT                          /* Check Options & display Welcome*/
    Call CHKPWS                               /* Check the PWS & Admin name*/
    Call COLUMNS                        /* Read the Columns definition file*/
    Call MAIN                                            /* do the main job*/
    Call QUIT                                                       /* Quit*/

 MAIN:/* ------------------------------------------------------ MAIN: -------*/

    if PrgGET
     then call GET
     else call SET

    Return

 GET:/* ------------------------------------------------------ GET:  -------*/

    Call Time('R')

    'if exist' IOUTF 'del' IOUTF

    /* Enumerate DASD directory limit on server */
    DASDInfo.DirPath    = StartPath
    DASDInfo.recursive  = Recurse
    DASDInfo.BufferSize = Buffer

    RC = NetEnumerate(NETDASD, 'DASDInfo', '\\'SRVNAME)

    if RC = 0
     then do
             if DASDInfo.EntriesAvail > DASDInfo.count
              then do
                      Call LOGIT 'NetEnum. DASD', 'Buffer =' Buffer,,
                                 'Buffer error, increase buffer or use more',
                                 'specific start path'
                      return
                   end
              else nop

             Call RxStemSort 'DASDInfo'
             Call LineOut IOUTF, BANNER
             do i = 1 to DASDInfo.count
                if i // 20 = 0
                 then Call LineOut IOUTF, BANNER
                 else Nop
                if \MUTE
                 then do
                         Call SysCurState OFF
                         Call SysCurPos 23 , 0
                      end
                 else Nop
                say '0909'x 'Total DASD limits =' i
                Call WRITEIT i
            end
         end
     else do
             Call LOGIT 'NetEnum. DASD',DASDInfo.DirPath , RC
             return
          end
    Call LineOut IOUTF, ' '

    say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    Return

 WRITEIT:/* ---------------------------------------------------- WRITEIT: -----*/

    parse arg ActPath

    DASDINFO.ActPath.OPT = Left('',COLL.1,' ')    /* Column 1 must be BLANK*/
    DASDINFO.ActPath.RESOURCE_NAME = DASDINFO.DirPath || DASDINFO.ActPath.RESOURCE_NAME

    OUT = ''
    do j = 1 to COLT
       COLNAME = COLN.j
       DATA.j = Left(DASDINFO.ActPath.COLNAME, COLL.j, ' ')
       OUT = OUT || DATA.j || ';'
    end
    Call LineOut IOUTF, OUT
    Call Stream  IOUTF, 'C', 'CLOSE'

    Return

 SET:/* ------------------------------------------------------ SET:  -------*/

    /* Check whether .INI file is correct */
    /* read each line and do opt          */

    Call Time('R')
    CHKLines = 0
    EC = 0
    do while Lines(IOUTF)
       LLINE = TRANSLATE(LineIN(IOUTF))
       OLINE = LLINE
       LLINE = Strip(LLINE)

       parse value LLINE with OPT ';' LLINE
       OPT = Translate(Strip(Opt))
       select
        when OPT = '' | LLINE = '' then Iterate
        when Left(OPT,1)   = '*'   then Iterate
        when OPT           = 'OPT' then nop
        when OPT           = 'D'   then Call DELDASD
        when OPT           = 'A'   then Call ADDDASD
        when OPT           = 'U'   then Call UPDDASD
        otherwise
         do
            call ToCheck
            call Logit 'Main','wrong input allowed options only A, U and D.',,
                              'Invalid option' OPT
         end
       end
       if EC
        then do
                call ToCheck
                EC = 0
             end
        else Nop
    end

    say ;say '0909'x 'Total Time  =' Trunc(Time('E'),2)

    Return

 DELDASD:/* --------------------------------------------------- ToCheck: ----*/

    i = 1
    do while LLINE <> ''
       parse value LLINE with Value ';' LLINE
       i = i+1
       ColName          = Strip(COLN.i)
       DasdInfo.ColName = Strip(Value)
    end
    RC = NetDelete(NETDASD, DasdInfo.resource_name,'\\'SRVNAME)
    if RC <> 0
     then do
             call Logit 'NETDELETE DASD' ,  DasdInfo.resource_name , RC
             EC = 1
             return
          end
     else call Logit 'Delete DASD' , DasdInfo.resource_name

    return

 ADDDASD:/* --------------------------------------------------- ToCheck: ----*/
    DasdInfo.flag = NoComp
    i = 1
    do while LLINE <> ''
       parse value LLINE with Value ';' LLINE
       i = i+1
       ColName          = Strip(COLN.i)
       DasdInfo.ColName = Strip(Value)
    end

    /* Set new DASD directory values */

    RC = NetAdd(NETDASD, 'DasdInfo','\\'SRVNAME)
    if RC <> 0
     then do
             call Logit 'NETADD DASD' ,  DasdInfo.resource_name , RC
             EC = 1
             return
          end
     else call Logit 'Add DASD' , DasdInfo.resource_name

    return

 UPDDASD:/* --------------------------------------------------- ToCheck: ----*/
    i = 1
    do while LLINE <> ''
       parse value LLINE with Value ';' LLINE
       i = i+1
       ColName          = Strip(COLN.i)
       DasdInfo.ColName = Strip(Value)
    end

    /* Set new DASD directory values */
    DirPath             = Strip(DasdINFO.RESOURCE_NAME)

    if DirPath = ''
     then do
            call Logit 'SETDASD UPDATE' , 'No Ressource defined' , 'No Ressource'
            EC = 1
            call return
          end

    if COLP.MAX > 0
     then do
             RC = NetSetInfo(NETDASD, 'max', DasdInfo.MAX,,
                             '\\'SRVNAME, DirPath, NoComp)
             if RC <> 0
              then do
                      call Logit 'NETSETINFO Update' , 'max =' DasdInfo.MAX, RC
                      EC = 1
                      return
                   end
              else call Logit 'Upd. DASD max' , DirPath '-' DasdInfo.MAX
          end
     else nop

    if COLP.THRESH > 0
     then do
             RC = NetSetInfo(NETDASD, 'thresh', DasdInfo.THRESH ,,
                             '\\'SRVNAME, DirPath, NoComp)
             if RC <> 0
              then do
                      call Logit 'NETSETINFO Update' ,,
                                 'thresh =' DasdInfo.THRESH, RC
                      EC = 1
                      return
                   end
              else call Logit 'Upd. DASD thresh' , DirPath '-' DasdInfo.THRESH
          end
     else nop

    if COLP.DELTA > 0
     then do
             RC = NetSetInfo(NETDASD, 'delta', DasdInfo.DELTA,,
                             '\\'SRVNAME, DirPath, NoComp)
             if RC <> 0
              then do
                      call Logit 'NETSETINFO Update' ,,
                                 'delta =' DasdInfo.DELTA, RC
                      EC = 1
                      return
                   end
              else call Logit 'Upd. DASD delta' , DirPath '-' DasdInfo.DELTA
          end
     else nop

    return

 ToCheck:/* --------------------------------------------------- ToCheck: ----*/

    CHKLines = CHKLines + 1
    if CHKLines = 1 | CHKLines // 20 = 0
     then call LineOut CHKF, ALIASLst
     else nop
    Call LineOut CHKF, OLINE
    return

 COLUMNS: /* --------------------------------------------------- COLUMNS: -*/

    BANNER = ''
    i = 0
    COLP.     = 0
    do while Lines(COLF)
       LLINE = LineIn(COLF)
       if Left(LLINE, 1) = '*',
        | Strip(LLINE) = ''
        then iterate
        else Nop
       i = i + 1

       parse value LLINE with COLN ';' COLL
       COLN      = Strip(COLN)
       COLN.i    = COLN
       COLL.i    = Strip(COLL)
       COLP.COLN = i

       BANNER = BANNER || Left(COLN.i, COLL.i, ' ') || ';'
    end

    COLT = i

    Return

 CHKOPT:/* ---------------------------------------------------- CHKOPT: -----*/

    SRVNAME = ''; IOUTF  = 'RXDASD.CSV'; LOGF   = 'LSMT.LOG' ; PIPE      = ''
    CHKF    = 'RXDASD.CHK'
    TRACE   = 0 ; MUTE   = 0           ; Buffer = 4096       ; StartPath = ''
    Recurse = 1 ; PrgGet = 1           ; NoComp = 0

    OPTION = Translate(OPTION)
    do while OPTION <> ''
       Parse value OPTION with ARGUMENT ' ' OPTION
       select
        when Left(ARGUMENT,5) = '/SRV:'   then SRVNAME   = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/INP:'   then IOUTF     = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/OUT:'   then IOUTF     = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/LOG:'   then LOGF      = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/CHK:'   then CHKF      = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/PIP:'   then PIPE      = Substr(ARGUMENT,6)
        when Left(ARGUMENT,5) = '/BUF:'   then Buffer    = Substr(ARGUMENT,6)
        when Left(ARGUMENT,6) = '/PATH:'  then StartPath = Substr(ARGUMENT,7)
        when Left(ARGUMENT,6) = '/NOREC'  then Recurse   = 0
        when Left(ARGUMENT,4) = '/SET'    then PrgGet    = 0
        when Left(ARGUMENT,4) = '/GET'    then PrgGet    = 1
        when Left(ARGUMENT,7) = '/NOCOMP' then NoComp    = 1
        when Left(ARGUMENT,2) = '/M'      then MUTE      = 1
        when Left(ARGUMENT,2) = '/T'      then TRACE     = 1
        otherwise Nop
       end
    end
    if SRVNAME = '' then signal GETHELP

    if \MUTE
     then do
             if PrgGet
              then do
                      Topic1='RXDASDGET'
                      Topic_String.Topic1.1=SRVNAME;
                      Topic_String.Topic1.2=IOUTF;
                      Topic_String.Topic1.3=LOGF;
                      Topic_String.Topic1.4=StartPath' ';
                      Topic_String.Topic1.5=Buffer;
                      if Recurse then Topic_String.Topic1.6='Yes';
                                 else Topic_String.Topic1.6='No';
                      Topic_String.Topic1.7=PIPE' ';
                      Topic_List='RXDASDWELCOME' Topic1;
                      Call GETANS
                   end
              else do
                      Topic1='RXDASDSET'
                      Topic_String.Topic1.1=SRVNAME;
                      Topic_String.Topic1.2=IOUTF;
                      Topic_String.Topic1.3=LOGF;
                      if NoComp then Topic_String.Topic1.4='No';
                                else Topic_String.Topic1.4='Yes';
                      Topic_String.Topic1.5=PIPE' ';
                      Topic_List='RXDASDWELCOME' Topic1;
                      Call GETANS
                   end
             Parse VALUE SysCurPos() With Old_R Old_C; '@pause'
             Call SysCurPos Old_R, Old_C; say ESC'[K'
          end
     else do
             say 'ServerName =' SRVNAME
             say 'LogFile    =' LOGF
             if PrgGet then do
                               say 'OutputFile =' IOUTF
                               say 'StartPath  =' StartPath
                               say 'Buffer     =' Buffer
                               if Recurse
                                then say 'Recurse    =' 'YES'
                                else say 'Recurse    =' 'NO'
                            end
                       else do
                               say 'InputFile ='  IOUTF
                               if NoComp
                                then say 'Compare    =' 'NO'
                                else say 'Compare    =' 'YES'
                            end

            'pause'
          end
    Return

 CHKPWS:/* ---------------------------------------------------- CHKPWS: -----*/

    RC = NetGetInfo(350, 'WKSTAINFO','')
    if RC = 0
     then do
             ADMNAME = WKSTAINFO.UserName
             PWSNAME = WKSTAINFO.ComputerName
          end
     else do
            Call LOGIT 'Get PWS Info', ,RC
            Call Quit
          end
    Return

 INIT:/* ------------------------------------------------------ INIT: -------*/

    Call RgUtil   '/m'                                    /* Rexx Utilities*/
    Call RgUtils  '/m'                                    /* Rexx Utilities*/
    Call RgLSRXUT '/m'                             /* Lan Server Rexx Utils*/

    Parse Upper Source . . P_NAME
    PRGN = Filespec('N', Left(P_NAME, Length(P_NAME) -4))

   '@echo off'
    ESC     = '1B'x

    NETDASD = 750

    COLF    = 'DASD.INI'                         /* Column description file*/
    Call CHKFILE COLF

    Resource_File = 'RXDASD.RSC'
    Call CHKFILE Resource_File

    Return

 GETANS:/* ---------------------------------------------------- GETANS: -----*/

    Vars_List =Ansi_Say(Resource_File Topic_List);
    Parse VALUE SysCurPos() With Old_R Old_C;
    Do While Vars_List <> '';
       Parse VALUE Vars_List With Topic_Id ';' Var_Id ';' Row ';' Column ';' Color ';' Vars_List;
       Call SysCurPos Row, Column;
       Say x2c(Color) || Topic_String.Topic_Id.Var_Id || '1B'x || '[0m';
       End;
    Call SysCurPos Old_R, Old_C;

    Return

 GETHELP:/* --------------------------------------------------- GETHELP: ----*/

    if \MUTE
     then do
             Topic1='RXDASDHELP'
             Topic_String.Topic1.1=PRGN;
             Topic_List=Topic1;
             Call GETANS
          end
     else say 'Incorrect options.'
    Call QUIT

    Return

 CHKFILE:/* --------------------------------------------------- CHKFILE: ----*/

    Parse Arg FILE
    RC = Stream(FILE, 'C', 'QUERY EXIST')
    if RC = ''
     then do
             say ' File' FILE 'not found.'
             Call QUIT
          end
     else Nop
    Call Stream FILE, 'C', 'CLOSE'

    Return

 LOGIT:/* ----------------------------------------------------- LOGIT: ------*/

    FUNC = ARG(1); INFO = ARG(2); RCOD = ARG(3)
    RC = LLOGIT(LOGF, PIPE, ADMNAME, PRGN, FUNC, INFO, RCOD)

    Return

 QUIT:/* ------------------------------------------------------ QUIT: -------*/

    Call LineOut 'LSMT.END', PRGN, 1
    Call Stream  'LSMT.END', 'C', 'CLOSE'
    Call Stream   COLF,      'C', 'CLOSE'
    Call Stream   LOGF,      'C', 'CLOSE'
    Call Stream   IOUTF,     'C', 'CLOSE'
    Exit

 /*--------------------------------------------------------------------------*/
