/*

  REXX Script to install the InJoy Firewall - and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Creating Desktop Folder..."
say

dir = directory() || '\'
CreateFlag = "update"

say "Creating folder"
call SysCreateObject "WPFolder", "InJoy Firewall 4.2 GA", "<WP_DESKTOP>", "OBJECTID=<INJOYFIREFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;BACKGROUND=" || dir || "folderbg.bmp,T;ICONFILE=" || dir || "folder.ico", CreateFlag
call SysCreateObject "WPFolder", "Extras", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIREEXTRASFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;BACKGROUND=" || dir || "folderbg.bmp,T", CreateFlag
call SysCreateObject "WPFolder", "Packet Tracing", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIRETRACEFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;BACKGROUND=" || dir || "folderbg.bmp,T", CreateFlag
call SysCreateObject "WPFolder", "Tools", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIREUTILFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;BACKGROUND=" || dir || "folderbg.bmp,T", CreateFlag
call SysCreateObject "WPFolder", "Log Files", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIRELOGFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;BACKGROUND=" || dir || "folderbg.bmp,T", CreateFlag
call SysCreateObject "WPFolder", "Information", "<INJOYFIREFOLDER>", "OBJECTID=<INJOYFIREINFOFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;BACKGROUND=" || dir || "folderbg.bmp,T", CreateFlag

say "Creating program objects..."


/* Extras */
call SysCreateObject "WPProgram", "IP Forwarding" || d2c(10) || "(Disable)", "<INJOYFIREEXTRASFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "ipgate off" || '"', CreateFlag
call SysCreateObject "WPProgram", "IP Forwarding" || d2c(10) || "(Enable)", "<INJOYFIREEXTRASFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "ipgate on" || '"', CreateFlag
call SysCreateObject "WPProgram", "Uninstall" || d2c(10) || "Device Driver", "<INJOYFIREEXTRASFOLDER>", "EXENAME=" || dir || "UNINSTAL.CMD;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;", CreateFlag
call SysCreateObject "WPProgram", "Run Firewall Server"  || d2c(10) || "in Background", "<INJOYFIREEXTRASFOLDER>", "EXENAME=" || dir || "GATEWAY.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-b", CreateFlag
call SysCreateObject "WPProgram", "Admin Remote Firewall", "<INJOYFIREEXTRASFOLDER>", "EXENAME=" || dir || "FGUI.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-remote", CreateFlag


/* TOOLS */
call SysCreateObject "WPProgram", "Reload DHCP Server" || d2c(10) || "Configuration", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-dhcpd", CreateFlag
call SysCreateObject "WPProgram", "Reload IPSec" || d2c(10) || "Configuration", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-ipsec", CreateFlag
call SysCreateObject "WPProgram", "Kill Firewall", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-kill", CreateFlag
call SysCreateObject "WPProgram", "Restart Firewall", "<INJOYFIREUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-restart", CreateFlag


/* TRACE */
call SysCreateObject "WPProgram", "Delete Trace File", "<INJOYFIRETRACEFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "del " || dir || "packet.trc" || '"', CreateFlag
call SysCreateObject "WPProgram", "Format Trace" || d2c(10) || "(to Screen)", "<INJOYFIRETRACEFOLDER>", "EXENAME=" || dir || "IPFORMAT.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-r packet.trc", CreateFlag
call SysCreateObject "WPProgram", "IP Trace" || d2c(10) || "(Stop)", "<INJOYFIRETRACEFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-off:logbin", CreateFlag
call SysCreateObject "WPProgram", "IP Trace" || d2c(10) || "(Start)", "<INJOYFIRETRACEFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-on:logbin", CreateFlag


/* LOG FILES */
call SysCreateObject "WPProgram", "PPTP Logs", "<INJOYFIRELOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\PPTP.INI", CreateFlag
call SysCreateObject "WPProgram", "PPPoE Logs", "<INJOYFIRELOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\PPPOE.INI", CreateFlag
call SysCreateObject "WPProgram", "DHCPd Logs", "<INJOYFIRELOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\DHCPD.INI", CreateFlag
call SysCreateObject "WPProgram", "IPSec Logs", "<INJOYFIRELOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\IPSEC.INI", CreateFlag


/* URL OBJECTS */
call SysCreateObject "WPUrl", "Online Documentation", "<INJOYFIREINFOFOLDER>", "URL=http://www.bitwiseworks.com/docs.php", CreateFlag
call SysCreateObject "WPUrl", "Purchase", "<INJOYFIREINFOFOLDER>", "URL=http://www.bitwiseworks.com/firewall/purchase.php", CreateFlag
call SysCreateObject "WPUrl", "Product Homepage", "<INJOYFIREINFOFOLDER>", "URL=http://www.bitwiseworks.com/firewall", CreateFlag
call SysCreateObject "WPUrl", "bww bitwise works GmbH", "<INJOYFIREINFOFOLDER>", "URL=http://www.bitwiseworks.com", CreateFlag

/* MAIN ICONS */
call SysCreateObject "WPProgram", "Reload Firewall" || d2c(10) || "Configuration", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-firewall", CreateFlag
call SysCreateObject "WPProgram", "Security Logs", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\FIREWALL.INI", CreateFlag
call SysCreateObject "WPProgram", "InJoy Firewall GUI", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "FGUI.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;", CreateFlag
call SysCreateObject "WPProgram", "InJoy Firewall Server", "<INJOYFIREFOLDER>", "EXENAME=" || dir || "GATEWAY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;", CreateFlag
call SysCreateObject "WPShadow", "readme.txt", "<INJOYFIREFOLDER>", "SHADOWID=" || dir || "readme.txt", CreateFlag
say "Folder creation completed!"
