/* REXX */

/*
 *  File     : TS_INIT
 *  Purpose  :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.17     TAB   Created script
 *
 */


/* ----- */

app = 'TS_INIT'


/* load the REXX utility package */

CALL RXFuncAdd SysIni, RexxUtil, SysIni


/* see if we know where the InJoy code is */

profile = SysIni('USER', 'TS', 'PROFILE')
IF profile = 'ERROR:' THEN DO

   /* search for the InJoy code */

   rc     = status(app, 'INFO', 'Searching for the tunnel slave')
   drives = SysDriveMap('C:', 'LOCAL')
   done   = 0
   loop   = 1
   DO WHILE \ done

      rc = SysFileTree(WORD(drives, loop)||'\ts.exe', file, 'FS')

      IF file.0 > 0 THEN DO

         profile = WORD(file.1, 5)
         profile = SUBSTR(profile, 1, LENGTH(profile) - 3)||'ini'
         rc      = SysIni('USER', 'TS', 'PROFILE', profile)
         done    = 1

      END


      /* step to the next drive */

      IF loop >= WORDS(drives) THEN DO
         rc = status(app, 'ERROR', 'TS not found')
         EXIT 2
         done = 1
      END
      loop = loop + 1

   END

END
rc = status(app, 'INFO', 'TS profile = '||profile)


RETURN 0
