/* REXX */

/*
 *  File    :   TS_RESET
 *  Purpose :
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.12     TAB   Created script
 *
 */


/* */

app        = 'TS_RESET'


/* load the REXX utility package */

CALL RXFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
CALL SysLoadfuncs


/* remove all InJoy references in the user INI file */

profile = SysIni('USER', 'TS', 'PROFILE')
IF profile = 'ERROR:' THEN DO
   rc = status(app, 'ERROR', 'Tunnel configuration not found')
   EXIT 2
END
ELSE DO

   /* pull down the applications */

/* IF isrun('ts')     THEN '@killem ts     > nul 2> nul' */
/* IF isrun('in-joy') THEN '@killem in-joy > nul 2> nul' */


   /* clean up the application data */

   rc = status(app, 'INFO', 'Removing configuration')
   rc = SysIni('USER', 'TS', 'PROFILE', 'DELETE:')
   rc = SysFileDelete(profile)

END


RETURN 0
