/* ------------------------------------------------------------------ */
/* lpr32.cmd                                                          */
/*                                                                    */
/* REXX script to recreate INI data for OS2SYS.INI                    */
/*                                                                    */
/* Created on 28 May 2001 at 23:45:33 by mINI v1.05                  */
/* Code based on Bernd Schemmer's ConvINI                             */
/* ------------------------------------------------------------------ */


/* --------------- Name of INI file to recreate or update ----------- */
curIniFile = "D:\OS2\OS2SYS.INI"
 
/* --------------- Load necessary REXXUTIL function(s) -------------- */
call rxFuncAdd "SysIni", "REXXUTIL", "SysIni"
 
/* ------------------------------------------------------------------ */


/* --------------- Init stem with data ------------------------------ */
iniFileApps.0 = 0 
i = iniFileApps.0 

/* ------------------------------------------------------------------ */
/*  Application: PM_LPR1 */

i=i+1
IniFileApps.i.__Application = "PM_LPR1"
IniFileApps.i.__Keys.0 = 0 

j = IniFileApps.i.__Keys.0 

j = j+1 
IniFileApps.i.__Keys.j.__Key = "DESCRIPTION"
IniFileApps.i.__Keys.j.__Val = "LPR1" || "00"x 
j = j+1 
IniFileApps.i.__Keys.j.__Key = "INITIALIZATION"
IniFileApps.i.__Keys.j.__Val = "127.0.0.1#PRINT#D:\SPOOL;" || "00"x 
j = j+1 
IniFileApps.i.__Keys.j.__Key = "TERMINATION"
IniFileApps.i.__Keys.j.__Val = ";" || "00"x 
j = j+1 
IniFileApps.i.__Keys.j.__Key = "PORTDRIVER"
IniFileApps.i.__Keys.j.__Val = "LPR32;" || "00"x 
j = j+1 
IniFileApps.i.__Keys.j.__Key = "TIMEOUT"
IniFileApps.i.__Keys.j.__Val = "45;" || "00"x 
IniFileApps.i.__Keys.0 = j 

/* ------------------------------------------------------------------ */

iniFileApps.0 = i 

/* ------------------------------------------------------------------ */
say "" 
say "Recreating or updating... " 
say "..." || curIniFile || " (" || IniFileApps.0 || " application(s))" 
say "" 
say "Press any key to continue or CTRL-C to abort ..." 
"@PAUSE >NUL" 
 
do i = 1 to IniFileApps.0 
 
  curApplication = IniFileApps.i.__Application 
 
  say " Writing keys for application """ || , 
      ConvertString( curApplication ) || , 
      """ (" || i || " of " || IniFileApps.0 || ")" 
 
  do j = 1 to IniFileApps.i.__Keys.0 
    curKey = IniFileApps.i.__Keys.j.__Key 
    curVal = IniFileApps.i.__Keys.j.__Val 
 
    say "    Writing key """ || , 
        convertString( curKey ) || , 
        """ (" || j || " of " || , 
        IniFileApps.i.__Keys.0 || ")" 
 
    thisRC = SysIni( curIniFile,, 
                     curApplication,, 
                     curKey,, 
                     curVal ) 
    if thisRC = "ERROR:" then 
      say "Warning: Error writing key <" || , 
          ConvertString( curKey ) || ">!" 
  end 
 
end 
 
exit 
 
/* ------------------------------------------------------------------ */

ConvertString: PROCEDURE 
  parse arg sourceString 
  return translate( sourceString,, 
         "????????????????????????????????" ,, 
         "000102030405060708090A0B0C0D0E0F"x || , 
         "101112131415161718191A1B1C1D1E1F"x ) 
 
/* ------------------------------------------------------------------ */


