/* - - - - - init RexxUtil - - - - - */
If Rxfuncquery('SysLoadFuncs') Then Do
 Call Rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
 Call SysLoadFuncs
End
Trace 'n'
/* - - - - - Get install directory - - - - - */
Parse Source . . instdir .
instdir = Strip(Filespec('d',instdir)||Filespec('p',instdir),'t','\')
Call Directory instdir
ipspool_exe = instdir||'\ipspool.exe'
ipspool_ini = instdir||'\ipspool.ini'
/* get language */
_lang = Value('LANG',,'OS2ENVIRONMENT')
_id = Translate(Left(_lang,2))
If _id = 'ZH' Then Do
 _id = Translate(Substr(_lang,4,2))
 If _id = 'CN' Then _id = 'CX'
End
/* get message file */
ipsmsg_file = Stream(instdir||'\languages\ipsmsg'||_id||'.msg','c','query exists')
If ipsmsg_file = '' Then
 ipsmsg_file = instdir||'\languages\ipsmsgen.msg'

Parse Upper Arg parm .

/* stop ipspool */
If Abbrev(parm,'STOP') Then Do
 Say Rx_msg(1)
 Call SysFileDelete instdir||'\ipspool.txt'
 Return 0
End

/* ipspool install*/
If parm = '' Then Do
 Say Rx_msg(2)
 Call SysCreateObject 'WPFolder','IPSPOOL','<WP_DESKTOP>','OBJECTID=<IPSPOOLFOLDER>','UPDATE'
 Call SysCreateObject 'WPProgram','ipSpool','<IPSPOOLFOLDER>','OBJECTID=<IPSPOOL>;EXENAME='||ipspool_exe||';STARTUPDIR='||instdir||';PROGTYPE=PM;ICONFILE='||instdir||'\ipspool.ico;','UPDATE'
 Call SysCreateObject 'WPProgram','ipSpool - Stop','<IPSPOOLFOLDER>','OBJECTID=<IPSPOOL_STOP>;EXENAME='||instdir||'\install.cmd;PARAMETERS=STOP;STARTUPDIR='||instdir||';ICONFILE='||instdir||'\ipspool_stop.ico;MINIMIZED=YES','UPDATE'
 Call SysCreateObject 'WPProgram','ipSpool - Utility','<IPSPOOLFOLDER>','OBJECTID=<IPSPOOL_UTILITY>;EXENAME='||instdir||'\install.cmd;PARAMETERS=UTILITY;STARTUPDIR='||instdir||';ICONFILE='||instdir||'\ipspool.ico;','UPDATE'
 Call SysCreateObject 'WPShadow','ipSpool - readme','<IPSPOOLFOLDER>','OBJECTID=<IPSPOOL_READ>;SHADOWID='||instdir||'\readme.txt;','UPDATE'
 Say Rx_msg(3)
 Pull ans .
 If Abbrev(ans,'Y') Then
  Call SysCreateObject 'WPShadow','ipSpool','<WP_START>','SHADOWID=<IPSPOOL>;','UPDATE'
 Call SysOpenObject '<IPSPOOLFOLDER>',0,'TRUE'
 Say Rx_msg(28)
 Return 0
End

/* ipSpool utility */
Say Rx_msg(5)

/* load TCP/IP interface */
rc = Rxfuncadd('SockLoadFuncs','rxSock','SockLoadFuncs')
rc = SockLoadFuncs()
rc = Rxfuncadd('FtpLoadFuncs','rxFtp','FtpLoadFuncs')
rc = FtpLoadFuncs()

/* get port list */
Do loop = 1
 names. = ''
 names.0 = 0
 If SysIni(ipspool_ini,'ALL:','ports.') <> 'ERROR:' Then Do
  Do x = 1 To ports.0
   pname = '\PIPE\'||ports.x
   If SysIni('SYSTEM','PM_SPOOLER_PORT',pname) <> 'ERROR:' Then Do
    pdesc = Strip(SysIni('SYSTEM','PM_'||pname,'DESCRIPTION'),'t','00'x)
    If pdesc = 'ERROR:' Then pdesc = ''
    ipaddr = Strip(SysIni(ipspool_ini,ports.x,'ipaddress'),'t','00'x)
    ipport = W2d(SysIni(ipspool_ini,ports.x,'ipport'))
    Call SysStemInsert 'names.',names.0 + 1,ports.x ipaddr ipport pdesc
   End
  End
 End
 If names.0 <> 0 Then Do
  Call SysStemSort 'names.',,'I',,,1,15
  Say Rx_msg(7)
  Do x = 1 To names.0
   Parse Var names.x name addr num desc
   desc = Strip(desc)
   Say Rx_msg(8,x,name,addr,num,desc)
  End x
  Say Rx_msg(9)
  Pull action .
  If action = '' Then
   Leave loop
  action = Left(action,1)
  If Pos(action,'A'||Xrange(1,names.0)) = 0 Then Do
   Say Rx_msg(10,action)
   Iterate loop
  End
 End
 Else
  action = 'A'
 If Datatype(action,'W') Then Do
  Parse Var names.action ipname ipaddr ipport pdesc
  pname = '\PIPE\'||ipname
  pdesc = Strip(pdesc)
  Say Rx_msg(11,ipname,pdesc)
  Parse Pull ans
  If Translate(ans) = 'D' Then Do
   Address cmd ipspool_exe '/d'||ipname
   Iterate loop
  End
  ans = Left(Strip(ans),15)
  If ans <> '' Then Do
   pdesc = ans
   Call SysIni 'SYSTEM','PM_'||pname,'DESCRIPTION',pdesc||'00'x
  End
  Else
   Say Rx_msg(15)
 End
 Else Do
  Say Rx_msg(16)
  Pull ipname .
  If ipname = '' Then Do
   If names.0 = 0 Then
    Leave loop
   Else
    Iterate loop
  End
  If SysIni(ipspool_ini,ipname,'ipaddress') <> 'ERROR:' Then Do
   Say Rx_msg(17,ipname)
   Iterate loop
  End
  pname = '\PIPE\'||ipname
  /* get and check IP address */
  Do Until Valid_ip(ipaddr)
   Say Rx_msg(20,ipname)
   Parse Pull ipaddr .
  End
  /* get and check port number */
  Do Until Valid_port(ipport)
   Say Rx_msg(21,ipaddr)
   Pull ipport .
  End
  Say Rx_msg(27,ipname)
  Parse Pull pdesc
  pdesc = Left(Strip(pdesc),15)
  Say Rx_msg(14,ipname)
  Address cmd ipspool_exe '/c'||ipname '/a'||ipaddr '/p'||ipport
  _irc = rc
  /* temp */
  _irc = (SysIni(ipspool_ini,ipname,'ipaddress') = 'ERROR:')
  If _irc = 0 Then
   If pdesc <> '' Then
   Call SysIni 'SYSTEM','PM_'||pname,'DESCRIPTION',pdesc||'00'x
 End
End
Return 0

/* retrieve msg */
Rx_msg:
Parse Arg _no,_1,_2,_3,_4,_5,_6,_7,_8,_9,.
_msg = ''
If Datatype(_no,'w') Then Do Until \Abbrev(_line,'->')
 _line = SysGetMessage(_no,ipsmsg_file,_1,_2,_3,_4,_5,_6,_7,_8,_9)
 If \Abbrev(_line,'->') Then _msg = Strip(_msg _line)
 Else Do
  _msg = Strip(_msg Subword(_line,2))
  _no = Substr(Word(_line,1),3)
 End
End
Return _msg

Valid_ip: Procedure Expose ipsmsg_file /* validate IP address format */
Parse Arg ipaddr,.
valid = Xrange('a','z')||Xrange('A','Z')||Xrange('0','9')||'!@#%^&()-_'',{}.~'
If (Verify(ipaddr,valid) <> 0) Then Do
 Say Rx_msg(13)
 Return 0
End
valid = Xrange('0','9')||'.'
If Verify(ipaddr,valid) = 0 Then Do
 Parse Var ipaddr p1 '.' p2 '.' p3 '.' p4 .
 If \Datatype(p1,'W') | \Datatype(p2,'W') | \Datatype(p3,'W') | \Datatype(p4,'W') Then Do
  Say Rx_msg(12)
  Return 0
 End
 /* IP Version 4 */
 If (p1 > 255) | (p2 > 255) | (p3 > 255) | (p4 > 255) Then Do
  Say Rx_msg(13)
  Return 0
 End
End
Else Do
 If SockGetHostByName(ipaddr,'t.') Then
  Say Rx_msg(23,ipaddr,t.addr)
End
/* ping IP address */
Parse Value FtpPing(ipaddr,56) With ans .
If \Datatype(ans,'W') Then
 Say Rx_msg(18,ipaddr)
Return 1

Valid_port: Procedure Expose ipsmsg_file /* validate IP port format */
Arg ipport,.
If Datatype(ipport,'W') Then
 If (ipport >= 9100) & (ipport <= 9109) Then
 Return 1
Say Rx_msg(4)
Return 0

W2d: Procedure /* littleendian word to decimal */
_l = C2x(Arg(1))
Return X2d(Substr(_l,7,2)||Substr(_l,5,2)||Substr(_l,3,2)||Substr(_l,1,2))
