/*
 * edit.c - edit 'nup' layout
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "nup.h"
#include "resource.h"

/*
 * manages layout selection
 */

static  int     curLayout ;

static  int     layoutIcons[] = {
    IDI_PORT1, IDI_PORT2, IDI_PORT4, IDI_LAND1, IDI_LAND2, IDI_LAND4 
} ;

/*
 * manages icons
 */

typedef struct _ICONMAP {
    int         id   ;
    HPOINTER    icon ;
} ICONMAP ;

static  ICONMAP    icons[] = {
    { IDI_PORT1,  NULLHANDLE } ,
    { IDI_PORT2,  NULLHANDLE } ,
    { IDI_PORT4,  NULLHANDLE } ,
    { IDI_LAND1,  NULLHANDLE } ,
    { IDI_LAND2,  NULLHANDLE } ,
    { IDI_LAND4,  NULLHANDLE } ,
    { IDI_PORT4A, NULLHANDLE } ,
    { IDI_PORT4B, NULLHANDLE } ,
    { IDI_LAND4A, NULLHANDLE } ,
    { IDI_LAND4B, NULLHANDLE } ,
    { 0,          NULLHANDLE }
} ;

static  HPOINTER    getIcon(int id)
{
    ICONMAP *p ;

    for (p = icons ; p->id != 0 ; p++) {
        if (p->id != id) {
	    continue ;
	}
	if (p->icon == NULLHANDLE) {
	    p->icon = WinLoadPointer(HWND_DESKTOP, NULLHANDLE, p->id) ;
	}
	return p->icon ;
    }
    return NULLHANDLE ;
}

static  void    clsIcons(HWND hwnd)     /* unlink icons from dialog */
{
    WinSendDlgItemMsg(hwnd, IDE_LAYOUT,  SM_SETHANDLE, NULL, NULL) ;
    WinSendDlgItemMsg(hwnd, IDE_ORDER1I, SM_SETHANDLE, NULL, NULL) ;
    WinSendDlgItemMsg(hwnd, IDE_ORDER2I, SM_SETHANDLE, NULL, NULL) ;
}

/*
 * initEdit - initialize edit dialog
 */

static  UCHAR   titleEdit[64] ;

static  void    initEdit(HWND hwnd)
{
    /*
     * set title of this dialog
     */
    
    sprintf(titleEdit, "%s - CAEgҏW", ProgramName) ;
    WinSendMsg(hwnd, WM_SETICON,
	    MPFROMP(WinLoadPointer(HWND_DESKTOP, NULLHANDLE, ID_NUP)), NULL) ;
    WinSetWindowText(hwnd, titleEdit) ;
    
    /*
     * fill Font List
     */

    fontFill(WinWindowFromID(hwnd, IDE_FONT)) ;
    
    /*
     * set limits on SpinButtons
     */

    WinSendDlgItemMsg(hwnd, IDE_LINS, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_LIN_MAX), MPFROMSHORT(LAYOUT_LIN_MIN)) ;
    WinSendDlgItemMsg(hwnd, IDE_COLS, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_COL_MAX), MPFROMSHORT(LAYOUT_COL_MIN)) ;

    WinSendDlgItemMsg(hwnd, IDE_LMARGIN, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_MARGIN_MAX), MPFROMSHORT(LAYOUT_MARGIN_MIN)) ;
    WinSendDlgItemMsg(hwnd, IDE_RMARGIN, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_MARGIN_MAX), MPFROMSHORT(LAYOUT_MARGIN_MIN)) ;
    WinSendDlgItemMsg(hwnd, IDE_TMARGIN, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_MARGIN_MAX), MPFROMSHORT(LAYOUT_MARGIN_MIN)) ;
    WinSendDlgItemMsg(hwnd, IDE_BMARGIN, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_MARGIN_MAX), MPFROMSHORT(LAYOUT_MARGIN_MIN)) ;

    WinSendDlgItemMsg(hwnd, IDE_VSPACE, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_MARGIN_MAX), MPFROMSHORT(LAYOUT_MARGIN_MIN)) ;
    WinSendDlgItemMsg(hwnd, IDE_HSPACE, SPBM_SETLIMITS,
            MPFROMSHORT(LAYOUT_MARGIN_MAX), MPFROMSHORT(LAYOUT_MARGIN_MIN)) ;
}

/*
 * loadInfo - load layout info to Dialog
 */

static  void    loadInfo(HWND hwnd)
{
    LAYPTR  pLay = layoutInfo(curLayout) ;
    HPOINTER    icon1, icon2 ;
    USHORT      chk1,  chk2  ;
    
    /*
     * set current font
     */
    
    fontSelect(WinWindowFromID(hwnd, IDE_FONT), pLay->fname) ;
    
    WinSendDlgItemMsg(hwnd, 
            IDE_PPF, BM_SETCHECK, MPFROMSHORT(pLay->ppf), NULL) ;

    /*
     * set size & margin
     */

    WinSendDlgItemMsg(hwnd, IDE_LINS,
        SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->lines), NULL) ;
    WinSendDlgItemMsg(hwnd, IDE_COLS,
        SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->columns), NULL) ;

    WinSendDlgItemMsg(hwnd, IDE_TMARGIN,
        SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->tmargin), NULL) ;
    WinSendDlgItemMsg(hwnd, IDE_BMARGIN,
        SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->bmargin), NULL) ;
    WinSendDlgItemMsg(hwnd, IDE_LMARGIN,
        SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->lmargin), NULL) ;
    WinSendDlgItemMsg(hwnd, IDE_RMARGIN,
        SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->rmargin), NULL) ;
        
    /*
     * set spacing (depend on current layout)
     */

    switch (curLayout) {
    case LAYOUT_PORT1 :
    case LAYOUT_LAND1 :
        WinEnableWindow(WinWindowFromID(hwnd, IDE_HSPACE), FALSE) ;
	WinEnableWindow(WinWindowFromID(hwnd, IDE_VSPACE), FALSE) ;
	break ;
    case LAYOUT_PORT2 :
        WinEnableWindow(WinWindowFromID(hwnd, IDE_HSPACE), TRUE)  ;
	WinEnableWindow(WinWindowFromID(hwnd, IDE_VSPACE), FALSE) ;
        WinSendDlgItemMsg(hwnd, IDE_HSPACE,
            SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->hspace), NULL) ;
	break ;
    case LAYOUT_LAND2 :
        WinEnableWindow(WinWindowFromID(hwnd, IDE_HSPACE), FALSE) ;
	WinEnableWindow(WinWindowFromID(hwnd, IDE_VSPACE), TRUE)  ;
        WinSendDlgItemMsg(hwnd, IDE_VSPACE,
            SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->vspace), NULL) ;
	break ;
    case LAYOUT_PORT4 :
    case LAYOUT_LAND4 :
        WinEnableWindow(WinWindowFromID(hwnd, IDE_HSPACE), TRUE)  ;
	WinEnableWindow(WinWindowFromID(hwnd, IDE_VSPACE), TRUE)  ;
        WinSendDlgItemMsg(hwnd, IDE_HSPACE,
            SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->hspace), NULL) ;
        WinSendDlgItemMsg(hwnd, IDE_VSPACE,
            SPBM_SETCURRENTVALUE, MPFROMSHORT(pLay->vspace), NULL) ;
	break ;
    }
    
    /*
     * set page order (depend on current layout)
     */

    switch (curLayout) {
    case LAYOUT_PORT1 :
    case LAYOUT_PORT2 :
    case LAYOUT_LAND1 :
    case LAYOUT_LAND2 :
        WinEnableWindow(WinWindowFromID(hwnd, IDE_ORDER1B), FALSE) ;
        WinEnableWindow(WinWindowFromID(hwnd, IDE_ORDER2B), FALSE) ;
	WinShowWindow(WinWindowFromID(hwnd, IDE_ORDER1I), FALSE) ;
	WinShowWindow(WinWindowFromID(hwnd, IDE_ORDER2I), FALSE) ;
        break ;
    case LAYOUT_PORT4 :
    case LAYOUT_LAND4 :
	if (curLayout == LAYOUT_PORT4) {
	    icon1 = getIcon(IDI_PORT4A) ;
	    icon2 = getIcon(IDI_PORT4B) ;
        } else {
	    icon1 = getIcon(IDI_LAND4A) ;
	    icon2 = getIcon(IDI_LAND4B) ;
	}
	if (pLay->pgorder == LAYOUT_ORDER_ROW) {
	    chk1 = TRUE, chk2 = FALSE ;
	} else {
	    chk1 = FALSE, chk2 = TRUE ;
	}
        WinSendDlgItemMsg(hwnd, IDE_ORDER1I, 
	                    SM_SETHANDLE, MPFROMP(icon1), NULL) ;
        WinSendDlgItemMsg(hwnd, IDE_ORDER2I,
	                    SM_SETHANDLE, MPFROMP(icon2), NULL) ;
        WinSendDlgItemMsg(hwnd, IDE_ORDER1B, 
	                    BM_SETCHECK, MPFROMSHORT(chk1), NULL) ;
        WinSendDlgItemMsg(hwnd, IDE_ORDER2B,
	                    BM_SETCHECK, MPFROMSHORT(chk2), NULL) ;
        WinEnableWindow(WinWindowFromID(hwnd, IDE_ORDER1B), TRUE) ;
        WinEnableWindow(WinWindowFromID(hwnd, IDE_ORDER2B), TRUE) ;
	WinShowWindow(WinWindowFromID(hwnd, IDE_ORDER1I), TRUE) ;
	WinShowWindow(WinWindowFromID(hwnd, IDE_ORDER2I), TRUE) ;
        break ;
    }

    /*
     * show layout icon
     */

    WinSendDlgItemMsg(hwnd, IDE_LAYOUT,
        SM_SETHANDLE, MPFROMP(getIcon(layoutIcons[curLayout])), NULL) ;

    /*
     * show drawing options
     */

    WinSendDlgItemMsg(hwnd, 
        IDE_FRAME,  BM_SETCHECK, MPFROMSHORT(pLay->frame),  NULL) ;
    WinSendDlgItemMsg(hwnd, 
        IDE_CENTER, BM_SETCHECK, MPFROMSHORT(pLay->marker), NULL) ;
}

/*
 * saveInfo save layout info from Dialog
 */

static  void    saveInfo(HWND hwnd)
{
    LAYPTR  pLay = layoutInfo(curLayout) ;
    ULONG   chk ;

    /*
     * query font name
     */
     
    WinQueryWindowText(WinWindowFromID(hwnd, IDE_FONT), 64, pLay->fname) ;

    pLay->ppf = (BOOL) WinSendDlgItemMsg(hwnd, 
                            IDE_PPF, BM_QUERYCHECK, NULL, NULL) ;

    /*
     * query size & margin
     */
     
    WinSendDlgItemMsg(hwnd, IDE_LINS, SPBM_QUERYVALUE,
            MPFROMP(&pLay->lines), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;
    WinSendDlgItemMsg(hwnd, IDE_COLS, SPBM_QUERYVALUE,
            MPFROMP(&pLay->columns), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;
    WinSendDlgItemMsg(hwnd, IDE_TMARGIN, SPBM_QUERYVALUE,
            MPFROMP(&pLay->tmargin), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;
    WinSendDlgItemMsg(hwnd, IDE_BMARGIN, SPBM_QUERYVALUE,
            MPFROMP(&pLay->bmargin), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;
    WinSendDlgItemMsg(hwnd, IDE_LMARGIN, SPBM_QUERYVALUE,
            MPFROMP(&pLay->lmargin), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;
    WinSendDlgItemMsg(hwnd, IDE_RMARGIN, SPBM_QUERYVALUE,
            MPFROMP(&pLay->rmargin), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;

    /*
     * query spacing
     */

    WinSendDlgItemMsg(hwnd, IDE_HSPACE, SPBM_QUERYVALUE,
            MPFROMP(&pLay->hspace), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;
    WinSendDlgItemMsg(hwnd, IDE_VSPACE, SPBM_QUERYVALUE,
            MPFROMP(&pLay->vspace), MPFROM2SHORT(0, SPBQ_ALWAYSUPDATE)) ;

    /*
     * query page order
     */
    
    chk = (ULONG) WinSendDlgItemMsg(hwnd, IDE_ORDER1B, 
                                            BM_QUERYCHECK, NULL, NULL) ;
    if (chk) {
        pLay->pgorder = LAYOUT_ORDER_ROW ;
    } else {
        pLay->pgorder = LAYOUT_ORDER_COL ;
    }

    /*
     * query drawing options
     */

    pLay->frame  = (BOOL) WinSendDlgItemMsg(hwnd, 
                            IDE_FRAME, BM_QUERYCHECK, NULL, NULL) ;
    pLay->marker = (BOOL) WinSendDlgItemMsg(hwnd,
                            IDE_CENTER, BM_QUERYCHECK, NULL, NULL) ;
}

/*
 * editProc - dialog procedure for edit dialog
 */

MRESULT EXPENTRY editProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch(msg) {
    
    case WM_INITDLG :
        initEdit(hwnd) ;
	loadInfo(hwnd) ;
	return (MRESULT) 0 ;

    case WM_COMMAND :
        switch (SHORT1FROMMP(mp1)) {
	case IDE_LPREV :
	    saveInfo(hwnd) ;
	    curLayout = layoutPrev(curLayout) ;
	    loadInfo(hwnd) ;
	    return (MRESULT) 0 ;
	    
	case IDE_LNEXT :
	    saveInfo(hwnd) ;
	    curLayout = layoutNext(curLayout) ;
	    loadInfo(hwnd) ;
	    return (MRESULT) 0 ;
	    
	case IDE_DONE  :
	    saveInfo(hwnd) ;
	    clsIcons(hwnd) ;
	    WinDismissDlg(hwnd, IDE_DONE) ;
	    return (MRESULT) 0 ;
        }
    }
    return WinDefDlgProc(hwnd, msg, mp1, mp2) ;
}

/*
 * editLayout - edit nup layout with modal dialog
 */

void    editLayout(HWND hwnd, int layout)
{
    curLayout = layout ;
    WinDlgBox(HWND_DESKTOP, hwnd, editProc, NULLHANDLE, ID_EDIT, NULL) ;
}

