/*
 * main.c - entry of 'nup' program
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "nup.h"

/*
 * myname - adjust and save program names
 */

UCHAR   ProgramPath[256] ;
UCHAR   ProgramName[256] ;
UCHAR   ProfilePath[256] ;

static  void    myname(PSZ me)
{
    PUCHAR  p, last ;

    /*
     * full pathname of program
     */

    for (p = me, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
	    last = p ;
	}
    }
    if (last != NULL) {
        strcpy(ProgramPath, me) ;
    } else if (DosSearchPath(7, "PATH", me, ProgramPath, 256) != 0) {
        strcpy(ProgramPath, me) ;
    }
    
    /*
     * basename of program
     */

    for (p = ProgramPath, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
	    last = p ;
	}
    }
    if (last == NULL) {
        strcpy(ProgramName, ProgramPath) ;
    } else {
        strcpy(ProgramName, &last[1]) ;
    }
    if ((p = strrchr(ProgramName, '.')) != NULL) {
        *p = '\0' ;
    }
    
    /*
     * pathname of Profile
     */

    strcpy(ProfilePath, ProgramPath) ;
    
    if ((p = strrchr(ProfilePath, '.')) == NULL) {
        strcat(ProfilePath, ".ini") ;
    } else {
        strcpy(p, ".ini") ;
    }
}

/*
 * Error Notify
 */

void    nupMessage(PSZ msg)
{
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, ProgramName, 0, MB_OK) ;
}

/*
 * Control Dialog Position
 */

void    dialogAtCenter(HWND hwndDialog)
{
    SWP     posDlg ;
    SWP     posScr ;
    
    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog,   &posDlg) ;

    posDlg.x = (posScr.cx - posDlg.cx) / 2 ;
    posDlg.y = (posScr.cy - posDlg.cy) / 2 ;

    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

void    dialogAtMouse(HWND hwndDialog)
{
    POINTL  pt ;
    SWP     posDlg ;
    SWP     posScr ;
    
    WinQueryPointerPos(HWND_DESKTOP, &pt)    ;
    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog,   &posDlg) ;

    posDlg.x = pt.x - (posDlg.cx / 10)    ;
    posDlg.y = pt.y - (posDlg.cy * 4 / 5) ;

    if (posDlg.x < 0) {
        posDlg.x = 0 ;
    }
    if (posDlg.y < 0) {
        posDlg.y = 0 ;
    }
    if ((posDlg.x + posDlg.cx) > posScr.cx) {
        posDlg.x = posScr.cx - posDlg.cx ;
    }
    if ((posDlg.y + posDlg.cy) > posScr.cy) {
        posDlg.y = posScr.cy - posDlg.cy ;
    }
    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

void    dialogAtWindowBottom(HWND hwndDialog, HWND hwndWindow)
{
    SWP     posDlg ;
    SWP     posWin ;
    SWP     posScr ;
    
    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog, &posDlg) ;
    WinQueryWindowPos(hwndWindow, &posWin) ;

    posDlg.x = posWin.x ;
    posDlg.y = posWin.y ;

    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

/*
 * Current Objects
 */

PPRQINFO3   thePrt = NULL  ;
LAYPTR      theLay = NULL  ;
DOCREC      theDoc = { 0 } ;

/*
 * Program Start Here
 */

HAB     habMain   = NULLHANDLE ;

int     main(int ac, char *av[])
{
    int     i    ;
    HAB     hab  ;
    HMQ     hmq  ;
    QMSG    qmsg ;
    HWND    hwnd ;
    DOCPTR  pDoc ;

    int     optLayout    = -1    ;      /* Layout to Use        */
    PSZ     optPrinter   = NULL  ;      /* -p prtinter          */
    BOOL    optPrint     = FALSE ;      /* print immediate      */
    BOOL    optQuiet     = FALSE ;      /* no setup dialog      */

    _wildcard(&ac, &av) ;

    myname(av[0]) ;
    
    hab = habMain = WinInitialize(0) ;
    hmq = WinCreateMsgQueue(hab, 0)  ;

    layoutInit(hab) ;
    
    /*
     * parse command line arguments, option & file names to print
     */
     
    docListInit(&theDoc) ;
    
    for (i = 1 ; i < ac ; i++) {
        if (av[i][0] != '-') {              /* file to print        */
	    if ((pDoc = docFromFile(av[i])) != NULL) {
	        docAppend(&theDoc, pDoc) ;
	    }
	} else if (isdigit(av[i][1])) {
	    switch (av[i][1]) {
                case '1' : optLayout = LAYOUT_PORT1 ; break ;
		case '2' : optLayout = LAYOUT_PORT2 ; break ;
		case '4' : optLayout = LAYOUT_PORT4 ; break ;
	    }
	} else if (toupper(av[i][1]) == 'W' && isdigit(av[i][2])) {
            switch (av[i][2]) {
                case '1' : optLayout = LAYOUT_LAND1 ; break ;
		case '2' : optLayout = LAYOUT_LAND2 ; break ;
		case '4' : optLayout = LAYOUT_LAND4 ; break ;
            }
	} else if (toupper(av[i][1]) == 'I') {
	    optPrint = TRUE ;
	} else if (toupper(av[i][1]) == 'Q') {
	    optQuiet = TRUE ;
        } else if (toupper(av[i][1]) == 'P') {
	    if (av[i][2] != '\0') {
                optPrinter = &av[i][2] ;
            } else if (av[i+=1] != NULL) {
	        optPrinter = av[i] ;
	    }
        }
    }
    if (docEmpty(&theDoc) && (pDoc = docFromStdin()) != NULL) {
        docAppend(&theDoc, pDoc) ;
    }
    
    /*
     * associate printer & layout
     */
    
    if (optPrinter == NULL) {
        thePrt = printerDefault() ;
    } else {
        thePrt = printerRefer(optPrinter) ;
    }
    if (optLayout == -1) {
        theLay = layoutInfo(layoutCur()) ;
    } else {
        theLay = layoutInfo(optLayout) ;
    }
    if (thePrt == NULL || theLay == NULL || docEmpty(&theDoc)) {
        optPrint = optQuiet = FALSE ;
    }
#ifdef  DEBUG
    printf("Parsed Command Line Arguments\n") ; fflush(stdout) ;
#endif

    /*
     * Start GUI
     */

    if (! optQuiet) {
        setupPrint(optPrint) ;
    } else {
        printDocument(NULLHANDLE) ;
    }
    
    /*
     * cleanup
     */
    
    docListTerm(&theDoc) ;
    layoutDone(hab) ;

    WinDestroyMsgQueue(hmq) ;
    WinTerminate(hab) ;
    
    return 0 ;
}
