/*****************************************************************************/
/* session.cmd
 *
 * HelpDesk for OS/2 - v1.00
 * Copyright 2018 OS/2 VOICE      - all rights reserved
 * Copyright 2018 Richard L Walsh - all rights reserved
 *
 * This script is started by 'client.scr'
 * to run the client's HelpDesk session.
 *
 */
/*****************************************************************************/

/*****************************************************************************/
/*  Main                                                                     */
/*****************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* get the directory we're in */
parse source . . src
path = filespec('drive', src) || filespec('path', src)
path = strip(path, 'trailing', '\')

/* read the Helpdesk's IP address from file */
ip = strip(LineIn('helpdesk.ip'))
call stream 'helpdesk.ip', 'C', 'close'
if ip = '' then do
    say 'the helpdesk IP address is missing or invalid'
    exit
end

/* see if the IP or name contains a port */
port = ''
pos = LastPos(':', ip)
if pos <> 0 then do
    if Verify(ip, '0123456789', N, pos + 1) = 0 then do
        port = '-p' Substr(ip, pos + 1)
	ip = Left(ip, pos - 1)
    end
end

/* create PMVNC entries in os2.ini under app "HelpDesk" */
call SetIniValues

/* avoid an SSH login bug when either of these
 * matches a username in the client's 'passwd' file
 */
call Value 'USER', '', 'OS2ENVIRONMENT'
call Value 'LOGNAME', '', 'OS2ENVIRONMENT'

/* ensure our dlls can be found, then do it */
'@SET BEGINLIBPATH=' || path || ';%BEGINLIBPATH%'
say 'Starting PMVNC...'
'@start /n hdvnc'

say 'Starting SSH...'
say "Please wait for HelpDesk's Welcome message to appear."
say 'If you can not connect, press Ctrl-Break to end HelpDesk.'
'@ssh -F ssh_cfg -tc ssh_term' port ip

/* SSH may not move the cursor when writing to the screen;
 * reposition it to avoid overwriting any messages
 */
call SysCurPos '19', '0'

/* give pmvnc some time to die before trying to delete any files */
say 'Closing PMVNC...'
'@hdvnc -kill'
call SysSleep 2

/* delete all ini entries we created */
call SysIni 'USER', 'HelpDesk', 'DELETE:'

/* remove the current directory and all its files */
'@cd ..'
say 'Deleting temporary files...'
'@del' path||'\* /N & rd' path

say''
say 'Your HelpDesk session has ended.'
say 'Press any key to close this window...'
call SysGetKey 'NOECHO'

exit 0

/*****************************************************************************/

SetIniValues:

    asciiz = x2c(00)

    INI.0 = 6

    /* only accept connections from localhost (i.e. SSH) */
    INI.1 = 'LoopbackOnly'
    INI.1.new = '1'||asciiz

    /* the password is "helpdesk" as encrypted by VNC */
    INI.2 = 'Password'
    INI.2.new = x2c('A1 D0 02 12 5A 9A 27 BC')

    /* HelpDesk will choose the port, not PMVNC */
    INI.3 = 'AutoPortSelect'
    INI.3.new = '0'||asciiz

    /* use an alternate port to avoid conflicts if another
     * copy of PMVNC or VNCServer is already running
     * Important: the port nbr here must match the port
     * used for "RemoteForward" in 'ssh_cfg'
     */
    INI.4 = 'PortNumber'
    INI.4.new = '5927'||asciiz

    /* accept connections - reset to the default */
    INI.5 = 'SocketConnect'
    INI.5.new = '1'||asciiz

    /* allow mouse & keyboard - reset to the default */
    INI.6 = 'InputsEnabled'
    INI.6.new = '1'||asciiz

    do i = 1 to INI.0
        call SysIni 'USER', 'HelpDesk', INI.i, INI.i.new
    end

    return

/*****************************************************************************/
