/************************************************************************\
*                                                                        *
*         Microsoft C  Language Sample TalkThru HLLAPI Module             *
*                                                                        *
*       (C) Copyright Software Corporation of America, Inc. 1991.        *
*       All Rights Reserved.                                             *
*                                                                        *
\************************************************************************/
 
#include "dos.h"
#include "stdio.h"
#include "malloc.h"
#include "ctype.h"

#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#include "os2.h"
 
#include "clim.h"                     /* Include the CLIM header        */
#include "hapi.h"                     /* Include sample subs. header    */
 
/************************************************************************\
*                                                                        *
*        Local definitions and prototypes                                *
*                                                                        *
\************************************************************************/
 
#define  TRUE        1
#define  FALSE       0
 
void SayHello();                      /* simple display routines        */
void SayGoodbye();
void ShowError();
void ShowSessions();
void ShowScreen(char *);
 
void GetString(char *, char *);       /* simple keyboard routines       */
int  WaitKey();
 
/************************************************************************\
*                                                                        *
*        Global Variables                                                *
*                                                                        *
\************************************************************************/
 
int CLIMFunction;                     /* API function                   */
int CLIMLength;                       /* API string length              */
int CLIMReturnCode;                   /* API return code                */
 
/************************************************************************\
*                                                                        *
*        Useful Variables                                                *
*                                                                        *
\************************************************************************/
 
struct Session Sessions[14];          /* A Bunch of Sessions(see hapi.h)*/
 
int NumSessions;                      /* Count of Host Sessions         */
int OurSession;                       /* Index to Current Session       */
 
/************************************************************************\
*                                                                        *
*        Constants                                                       *
*                                                                        *
\************************************************************************/
 
char SessionParms[]=
     "AUTORESET CONLOG ESC=@ NOATTRB NOEAB SRCHFROM SRCHFRWD STREOT";
 
/************************************************************************\
*                                                                        *
*        Semaphores                                                      *
*                                                                        *
\************************************************************************/
PHSEM	phsemAsyncWait;


/************************************************************************\
*                                                                        *
*        Mainline Process                                                *
*                                                                        *
\************************************************************************/
 
main(argc, argv)
    int argc;
    char *argv[];
{
    int    i, not_found, tries;       /* Your basic hard-working ints   */
    char   szString[256];             /* Utility string field           */
    char   szDestination[256];        /* Copy String Destination        */
    char   *pszPS;                    /* Presentation Space Buffer      */
 
/**/
 
    SayHello();                       /* First we introduce ourselves   */
 
/**/
 
    if (HapiSetSessionParms(          /* Try to set Session Parameters  */
            &SessionParms[0], strlen(SessionParms))){
        ShowError();
        exit();
        }
 
/**/
 
                                      /* Lets see what sessions we have */
    HapiQuerySessions(&Sessions[0], sizeof(Sessions));
    if (CLIMLength == 0){             /* If none - bail out             */
        ShowError();
        exit();
        }
    for (i = 0, NumSessions = 0; i < CLIMLength; i++){
        if (Sessions[i].Type == 'H'){ /* Look for host sessions         */
            NumSessions++;            /* Count it and shrink buffer     */
            if (i>0)
                strncpy(&Sessions[NumSessions-1],&Sessions[i],
                        sizeof(struct Session));
            }
        }
    if ( NumSessions == 0 ){          /* If no Host Sessions - bail out */
        ShowError();
        exit();
        }
    ShowSessions();                   /* Show the sessions to the user  */
 
/**/
 
    while(NumSessions > 1){
        printf("Choose a session by pressing the appropriate number key.\n");
        i = WaitKey();
        if (!isdigit(i))
            continue;
        i &= 0x000f;
        if ((i < 1) || (i > NumSessions))
            continue;
        OurSession = i - 1;
        break;
        }
 
/**/
 
                                      /* Try to connect to our session  */
    HapiConnect(Sessions[OurSession].ShortName);
    switch(CLIMReturnCode){
        case RC_OK:                   /* Check for OK return codes      */
        case RC_OK_BUSY:
            break;
        default:                      /* Didn't connect - can't continue*/
            ShowError();
            exit();
        }
    printf("We are connected to session '%c' - press any key to see the screen",
            Sessions[OurSession].ShortName);
    WaitKey();
 
/**/
    printf("We will START HOST ASYNC NOTIFICATION (Set Semaphore)\nand wait for the PS to CHANGE\n\n");
	 if (HapiStartHostAsyncNote(Sessions[OurSession].ShortName,'P',
	 									&phsemAsyncWait))
	   printf("StartHostNotification FAILED,\npress any key to continue\n\n");
	 else	{
		DosSemWait(phsemAsyncWait,120000);		/* wait max 2 minutes */
		DosBeep(100,250);
		printf("Presentation Space has CHANGED...Continue\n\n");
	   printf("We will issue QueryHostUpdate (Set Semaphore Again)\nand WAIT again for PS to CHANGE\n\n");
		if (HapiQueryHostUpdate(Sessions[OurSession].ShortName)) /* Sets Semaphore */
		   printf("QueryHostUpdate FAILED,\npress any key to continue\n\n");
		else	{
			DosSemWait(phsemAsyncWait,120000);		/* wait max 2 minutes */
			DosBeep(100,250); 
			printf("Presentation Space has CHANGED...Continue\n\n");
		   printf("We will Now Stop Host Notification\n\n");
			if (HapiStopHostNote(Sessions[OurSession].ShortName))
			   printf("StopHostNotification FAILED,\npress any key to continue\n\n");
			else
			   printf("HostNotification is STOPPED,\npress any key to continue\n\n");
		}
	 }
    WaitKey();

/**/

	 /* Allocate a presentation space  */
    i = Sessions[OurSession].Size + 1;
    pszPS = malloc(i);
    memset(pszPS,'\0',i);
 
    HapiCopyPS(pszPS);                /* Get the Session Presentation   */
    ShowScreen(pszPS);                /* Show it on the screen          */
 
/**/
 
    HapiGetPosition();                /* Try to get the cursor position */
    if(CLIMReturnCode){               /* Cant find it - who knows why   */
        ShowError();
        exit();
        }
    printf("Cursor is positioned at %d\n\n", CLIMLength);
 
/**/
 
    printf("Now you must enter some keys to be sent. Refer to the Send Key\n");
    printf("function for information on special keys. A \"userid <tab>\n");
    printf("password <enter>\" sequence would look like this:\n\n");
    printf("      joeuser@Tsecret@E\n");
    GetString(&szString[0],"Please enter a string, I have to send something!");
 
    HapiSendKey(&szString[0],0);      /* Try to send the string         */
    if(CLIMReturnCode){               /* Send failed - oops!            */
        ShowError();
        exit();
        }
    printf("Keys \"%s\" sent successfully\n\n", szString);
 
    printf("Waiting for keyboard ready, or one minute to pass");
    HapiWait();                       /* Try to wait                    */
    if(CLIMReturnCode){               /* Wait failed - Oh dear!         */
        ShowError();
        exit();
        }
    printf("\n\n");
    printf("Our wait is over - let's look at the presentation space again");
    WaitKey();
 
    HapiCopyPS(pszPS);                 /* Get the Session Presentation  */
    ShowScreen(pszPS);                 /* Show it on the screen         */
 
/**/
 
    printf("Now I will copy a string from the presentation space to a \n");
    printf("local string in this program.  Please enter a string for me\n");
    printf("to locate (HLLAPI function 6) and retrieve (function 8).\n\n");
    not_found = TRUE;
    tries = 0;
    while(not_found){
        GetString(&szString[0],
                  "Please enter a string, I have to find something!");
        HapiSearchPS(&szString[0], 0, 1);
        if (CLIMReturnCode == 0)
            not_found = FALSE;
          else{
            printf("\"%s\" has not been located, check your spelling and case.\n\n",
                   &szString[0]);
            tries++;
            if (tries > 2){
                ShowError();
                exit();
                }
            }
 
        }
    i = strlen(&szString[0]);
    printf("String \"%s\" located at position %d.  Now I'm fetching it.\n\n",
           &szString[0], CLIMLength); /* Position is returned in length */
    HapiCopyPSString(&szDestination[0], i, CLIMLength);
    if(CLIMReturnCode){               /* Couldn't copy - Tell our user  */
        ShowError();
        exit();
        }
    szDestination[i] = 0;             /* Add the NULL that IBM forgot   */
    printf("String \"%s\" fetched successfully\n", &szDestination[0]);
    printf("Press any key to continue.");
    WaitKey();
    printf("\n\n");
 
 
/**/
 
    HapiReserve();                    /* Try to Reserve our session     */
    if(CLIMReturnCode){               /* Didn't disconnect - too bad    */
        ShowError();
        exit();
        }
    printf("Session reserved successfully\n\n");
 
    printf("Press any key to continue.");
    WaitKey();
    printf("\n\n");
 
/**/
 
    HapiRelease();                    /* Try to Release our session     */
    if(CLIMReturnCode){               /* Didn't disconnect - too bad    */
        ShowError();
        exit();
        }
    printf("Session released successfully\n\n");
 
    printf("Press any key to continue.");
    WaitKey();
    printf("\n\n");
 
/**/
 
    HapiDisconnect();                 /* Try to disconnect our session  */
    if(CLIMReturnCode){               /* Didn't disconnect - too bad    */
        ShowError();
        exit();
        }
    printf("Session disconnected successfully\n\n");
 
/**/
 
    free(pszPS);                      /* Free the PS buffer             */
    SayGoodbye();                     /* Ride off into the sunset       */
    exit();
}
 
 
 
/************************************************************************\
*                                                                        *
*        Simple Display Routines                                         *
*                                                                        *
\************************************************************************/
 
void SayHello()
{
    printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
    printf("TalkThru HLLAPI Sample Program\n");
    printf("(C) Software Corporation of America, Inc.   1991\n\n");
 
}
 
 
 
 
void SayGoodbye()
{
    printf("TalkThru HLLAPI Sample Program Ended\n");
 
}
 
 
 
 
 
void ShowError()
{
    printf("TalkThru HLLAPI Sample Program Ended With Error\n");
    printf("Function %d, Return Code %d, Length %d.\n",
                CLIMFunction,CLIMReturnCode,CLIMLength);
 
}
 
 
 
 
void ShowSessions()
{
int i;
    printf("Session   Short Name   Long Name \n");
    printf("-------   ----------   --------- \n");
    for (i=0;i<NumSessions;i++){
        printf("   %d           %c        %.8s\n",
               (i + 1),
               Sessions[i].ShortName,
               Sessions[i].LongName);
        }
    printf("\n\n");
    OurSession = 0;
}
 
 
 
 
 
void ShowScreen(pszPS)
char *pszPS;
{
int i;
    printf("\n");                     /* Space and display to the user  */
    for ( i = 0; i < 1920; i = i + 80){
        printf("%.80s",pszPS + i);
         }
   printf("This is the current Session Screen - press any key to continue.");
   WaitKey();
   printf("\n\n");
}
 
 
 
 
void GetString(pszString, pszError)
char *pszString;
char *pszError;
{
 
    *pszString = 0;
    while(*pszString == 0){
        printf("\nEnter Data: ");
        if ((gets(pszString) == NULL) || (strlen(pszString) == 0)){
            printf("\n%s\n",pszError);
            }
        }
    printf("\n\n");
}
 
 
 
int WaitKey()
{
 
    return(getchar());
}
 
 
 
 
