/* Installation for Warpcron 2.0
   (c) by Julian Buss
   ideas taken from famous Object Desktop software - try it if you don't know it!
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Say 'Welcome to Warpcron 2.0 WPS installation.'
Say 'This script copies files to the target directory and'
Say 'creates a WPS folder and some objects in it,'
Say 'so that everything''s ready for work :-)'
Say

SourceDir = directory()
Parse Arg TargetDir
UnixTargetDir = Translate(TargetDir, '/', '\')

if TargetDir = '' then do
   Say 'You didn''t give an installation directory.'
   Say 'What would you like to do?'
   Say
   Say '  (W)PS installation only (no copy of files)'
   Say '  (F)ull install, (file copy and creation of WPS objects)'
   Say
   Call Charout, ('Your choice: ')
   Parse Upper Pull Answer
   If Left( Answer, 1 ) = W Then do
     Say 'Okay, I''m ready to create the wps objects now.'
     Say 'Are you ready, too (Y/N)?'
     Parse Upper Pull Answer
     If Left( Answer, 1 ) = N Then call end
     TargetDir = SourceDir
     UnixTargetDir = Translate(TargetDir, '/', '\')
     call CreateObjects
     call end
   end

   Say 'In which directory should I install Warpcron?'
   Say 'Note: must exist, if not, create one NOW.'
   Call Charout, ('Directory: ' )
   Parse Pull TargetDir
end

tmp = directory(TargetDir)
if translate(tmp) <> translate(TargetDir) then do
   Say 'Target directory 'TargetDir' is nonexistent.'
   Say 'Please create it before running installation.'
   Say '(yes, I know, the install.cmd should do this for you...'
   Say ' I will code this later ;-) )'
   Say
   call end
end
else tmp = directory(SourceDir)

Say
say 'Target directory is: 'TargetDir
say 'Current directory is: 'SourceDir
Say 'Should I start (Y/N)?'
Parse Upper Pull Answer
If Left( Answer, 1 ) = N Then call end

'xcopy 'SourceDir'\* 'TargetDir' /S'
Call CreateObjects
say 'done. See "Welcome!" for next steps.'
call end

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

rc = CreateObject( 'WPFolder',,
    'Warpcron',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=32,88;'||,
        'ICONVIEWPOS=6 58 59 20;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<Warpcron>',,
    'Update' )

  rc = CreateObject( 'WPProgram',,
      'Warpcron window',,
      '<Warpcron>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=38,22;'||,
          'EXENAME='TargetDir'\WARPCRON.EXE;'||,
          'STARTUPDIR='TargetDir';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'ICONFILE='SourceDir'\inst\Warpcron.ICO',,
      'Update' )

  rc = CreateObject( 'WPProgram',,
      'WarpcronSetup',,
      '<Warpcron>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=6,22;'||,
          'EXENAME='TargetDir'\WCRSETUP.EXE;'||,
          'STARTUPDIR='TargetDir';'||,
          'PROGTYPE=PM;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='SourceDir'\inst\wcrsetup.ico',,
      'Update' )

  rc = CreateObject( 'WPProgram',,
      'Warpcron Fullscreen',,
      '<Warpcron>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=26,22;'||,
          'EXENAME='TargetDir'\WARPCRON.EXE;'||,
          'STARTUPDIR='TargetDir';'||,
          'PROGTYPE=FULLSCREEN;'||,
          'ICONFILE='SourceDir'\inst\Warpcron.ICO',,
      'Update' )

  rc = CreateObject( 'WPProgram',,
      'End Warpcron',,
      '<Warpcron>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=16,22;'||,
          'EXENAME=cmd.exe;'||,
          'STARTUPDIR='TargetDir';'||,
          'PARAMETERS=/c echo . > 'TargetDir'\endwcr;'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='SourceDir'\inst\End.ICO',,
      'Update' )

  rc = CreateObject( 'WPProgram',,
      'Welcome!',,
      '<Warpcron>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'ICONPOS=6,22;'||,
          'EXENAME='TargetDir'\POPUP.EXE;'||,
          'STARTUPDIR='TargetDir';'||,
          'PARAMETERS=-f'TargetDir'\welcome;'||,
          'PROGTYPE=PM;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='SourceDir'\inst\popup.ico',,
      'Update' )

  call SysCreateObject "WPUrl", "Warpcron 2.0 Documentation", "<Warpcron>", "LOCATOR=file:///"UnixTargetDir"/doc/index.htm";

return

end:

Say 'press ENTER to end installation.'
Parse Pull
exit


