(*
 * Extended Attributes handling library interface
 *
 * Copyright (c) 2000 by Alexander Trunov [2:5069/10, jnc@os2.ru]
 *
 * History:
 *  2000/08/14  initial implementation
 *)

{$Use32+}
unit EALibInt;

interface

uses
  Objects, Os2Def;

{$cdecl+,orgname+}
function InitEALib(ma: Pointer): Boolean;

function EnumEAs(handle: ULONG; coll: PStringCollection): Integer;

function RetrieveEA(handle: ULONG; pszName: PChar; var ea: Pointer;
  var ulEASize: Cardinal): Integer;
function StoreEA(handle: ULONG; pszName: PChar; ea: Pointer;
  ulEASize: ULONG): Integer;

function GetEAType(ea: Pointer): SmallWord;

function RetrieveStringSize(ea: Pointer): ULONG;
function RetrieveString(ea: Pointer; pszValue: PChar): PChar;
function BuildEAFromString(pszValue: PChar; var ulEASize: Cardinal): Pointer;
{$cdecl-}

implementation

const
  ealib = 'EALIB';

{$cdecl+,orgname+}
function InitEALib(ma: Pointer): Boolean; external ealib;

function EnumEAs(handle: ULONG; coll: PStringCollection): Integer; external ealib;

function RetrieveEA(handle: ULONG; pszName: PChar; var ea: Pointer;
  var ulEASize: Cardinal): Integer; external ealib;
function StoreEA(handle: ULONG; pszName: PChar; ea: Pointer;
  ulEASize: ULONG): Integer; external ealib;

function GetEAType(ea: Pointer): SmallWord; external ealib;

function RetrieveStringSize(ea: Pointer): ULONG; external ealib;
function RetrieveString(ea: Pointer; pszValue: PChar): PChar; external ealib;
function BuildEAFromString(pszValue: PChar; var ulEASize: Cardinal): Pointer; external ealib;
{$cdecl-}

end.
