#	Emulate the POSIX dirname command to extract all but the last level
#	of a pathname.

#	Usage:	dirname string

#	Copyright (c) 1996 by Hamilton Laboratories.  All rights reserved.

proc dirname( string )
	local dir, i, j

	@ dir = $string:h

	for i = strlen(dir) by -1 to 1 do
		@ j = substr(dir, i, 1)
		if (j != '/' && j != '\') break
	end
	if (j == '/' || j == '\') then
		@ dir = '\'
	else
		if (j == ':' && i == 2) @ dir = concat(substr(dir, 1, 2), '\')
	end

	return dir
end

dirname $argv
