/* create Memdisk floppy boot example      */
/* Veit Kannegieser 2003.09.12..2003.09.16 */

debug=0
enable_lxlite=1
enable_nelite=1

signal on NOVALUE name ErrorREXX
signal on SYNTAX  name ErrorREXX
signal on FAILURE name ErrorREXX
signal on HALT    name HaltREXX

Call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
Call sysloadfuncs

memdisk_usage=3000000
created_string='created' Date() Time() 'by demo.cmd'

/*-----------------------------------------------------------------*/
Call chapter 'Check LVM support'
dir0=Directory()
if Right(Translate(dir0),4)='\EXE' then
  do
    dir0=Left(dir0,Length(dir0)-Length('\EXE'))
    searchpath=dir0';'dir0'\bin;'dir0'\exe;'dir0'\boot'
  end
else
  searchpath=dir0;

searchpath=searchpath';'dir0'\..;'BootDrive()'\;'BootDrive()'\os2;'BootDrive()'\os2\boot;'BootDrive()'\os2\system;'BootDrive()'\os2\dll;'BootDrive()'\ecs\boot;'

user=Value('USER',,'OS2ENVIRONMENT')
select

  when user=='Veit' then
    do
      searchpath=searchpath';'dir0'\..\..\untar\;..\..\loaddll;D:\extra;D:\extra\cdr;D:\extra\fc2;c:\extra\dfsee'
    end

  /* configure your directory, if demo.cmd does not find some executables.. */
  when user=='your name' then
    do
      searchpath=searchpath';change_this'
    end

otherwise
end

Call Value 'SEARCHPATH', searchpath, 'OS2ENVIRONMENT'

os2lvm_dmd=search_file('os2lvm.dmd')
if os2lvm_dmd=='' then
  boot_volume='a'
else
  boot_volume='z'

/*-----------------------------------------------------------------*/
Call chapter 'process command line'
rsp_input_count=0
rsp_output_count=0
parse arg ParamStr1 ParamStr2 ParamStr3
if ParamStr3<>'' | ParamStr1='?' | ParamStr1='/?' | ParamStr1='-?' then
  do
    Say 'Usage: demo.cmd [ ( - | Inputresponsefile ) [ Outputresponsefile ] ]'
    Say 'Example to record : demo.cmd - demo2.rsp'
    Say 'Example to play   : demo.cmd demo.rsp'
    Exit 99
  end

if ParamStr1<>'' & ParamStr1<>'-' then
  do

    if Stream(ParamStr1, 'c', 'query exist') == '' then
      do
        Say 'file' ParamStr1 'does not exist.'
        Exit 99
      end

    do while Lines(ParamStr1)
      rsp_input_count=rsp_input_count+1
      rsp_input.rsp_input_count=LineIn(ParamStr1)
    end
    Call Stream ParamStr1, 'c', 'close'

  end

/*-----------------------------------------------------------------*/
Call chapter 'Check for memdisk'

packfile_exe=search_file('packfile.exe')
if packfile_exe=='' then
  Call ErrorHalt 'packfile.exe (memdisk) not found.'

path_to_memdisk=Left(packfile_exe,Length(packfile_exe)-Length('\packfile.exe'))
if Right(Translate(path_to_memdisk),4)='\EXE' then
  do
    path_to_memdisk=Left(path_to_memdisk,Length(path_to_memdisk)-Length('\EXE'))
    path_to_memdisk_exe =path_to_memdisk'\exe'
    path_to_memdisk_bin =path_to_memdisk'\bin'
    path_to_memdisk_boot=path_to_memdisk'\boot'
  end
else
  do
    path_to_memdisk_exe =path_to_memdisk
    path_to_memdisk_bin =path_to_memdisk
    path_to_memdisk_boot=path_to_memdisk
  end

/*-----------------------------------------------------------------*/
Call chapter 'Prepare unicode.tar archive'
unicode_tar='n'
if search_file('unicode.sys')<>'' then
  if search_file('untar.dll')<>'' then
    if search_file('untar.msg')<>'' then
      if search_file('loaddll.sys')<>'' then
        if search_file('loaddll.msg')<>'' then
          do
            if Stream('unicode.tar', 'c', 'query exist')=='' then
              if search_file('tar.exe')<>'' then
                do
                  Say 'Copying unicode files'
                  '@mkdir language'
                  '@mkdir language\codepage'
                  '@mkdir language\locale'
                  '@xcopy 'BootDrive()'\language\codepage\* language\codepage\'
                  if RC<>0 then Call ErrorHalt 'RC='RC
                  if Stream(BootDrive()'\language\locale\default.loc', 'c', 'query exist')<>'' then
                    do
                     '@xcopy 'BootDrive()'\language\locale\default.loc language\locale\'
                     if RC<>0 then Call ErrorHalt 'RC='RC
                    end
                  '@attrib -r -s -h -a * /s'
                  Say 'archiving to unicode.tar'
                  '@tar.exe -cpvf unicode.tar language'
                  if RC<>0 then Call ErrorHalt 'RC='RC
                  Say 'cleaning temporary directories'
                  '@del /f /n language\codepage\*'
                  '@del /f /n language\locale\*'
                  '@rd language\locale'
                  '@rd language\codepage'
                  '@rd language'
                end

            if Stream('unicode.tar', 'c', 'query exist')<>'' then
              unicode_tar='y'
          end

/*-----------------------------------------------------------------*/
Call chapter 'Select target'
Say 'Create a example bootable MemDisk floppy or CD-ROM'
Say ''
Say 'this works in 4 major steps'
Say ' 1. ask questions'
Say ' 2. collect files'
Say ' 3. compress files'
Say ' 4. copy to floppy/make ISO-9660 image'
Say ''
Say 'Requirements: '
Say '  running on OS/2 4.5x+(LVM) or 4.0(fp15?)'
Say '  mkisofs2.exe for CD-ROM'
Say '  pmvdmcc.sys'
Say 'Optional:'
Say '  LxLite, NeLite'
Say '  tar.exe+untar.dll+loaddll.sys'
Say 'User programs'
Say '  FC/2, DFSEE, IBM term.exe, arj/(un)zip/rar32'
Say ''
Say 'What do you want create?'
Say 'f) bootable floppy'
Say 'm) emergency boot volume'
Say 'c) bootable CD-ROM'
Say 'q) Quit!'
Say ''
answer=Ask4('Select', 'target_type', 'c', 'f', 'm', 'c', 'q')
Say ''
select
  when answer=='f' then
    do
      target_type='floppy'
      target_vol='A'
      Say 'Floppy, assuming this is '||target_vol||':.'
    end
  when answer=='m' then
    do
      target_type='partition'
      target_vol='C'
      Say 'Please give volume letter. Filesystem must be FAT.'
      Say 'You have to add it to the Bootmanager yourself.'
      Say ''
      Say 'This script will exchange the boot sector code of that volume'
      Say 'and write files to the root directory. Conflicts are very unlikely,'
      Say 'since it only writes files memboot.bin and *.pf, but this example'
      Say 'could be prevented from working, by having a DOS config.sys file present'
      Say 'Recommendation: cleanup before running (Press Ctrl+Pause).'
      Say ''
      Call CharOut , 'Volume letter ? '
      do until target_vol<>''
        pull target_vol
        target_vol=Left(target_vol,1)
      end
      Say 'target volume is '||target_vol||':.'
    end
  when answer=='c' then
    do
      target_type='iso9660'
      target_vol='-'
      target_file=Directory()||'\demo.iso'
      Say 'target file is '||target_file||'.'
    end
otherwise
  Exit 0
end


/*-----------------------------------------------------------------*/
Call chapter 'Recreating empty immediate directories'
'@echo off'
'@mkdir os_files >nul 2>&1'
'@mkdir result >nul 2>&1'
'@mkdir result\BOOTIMGS >nul 2>&1'
Call erase_files 'os_files\*'
Call erase_files 'result\*'
Call erase_files 'result\BOOTIMGS\*'

pf='os_files\demo.pfs'
Call erase_files pf

/* lx='os_files\exepack.cmd'
Call erase_files lx */
lx='\dev\nul'

cf='.\os_files\config.sys'

outputdir='result'
if target_type=='iso9660' then
  do
    '@mkdir result\BOOTIMGS >nul 2>&1'
    Call erase_files 'result\BOOTIMGS\*'
    outputdir='result\BOOTIMGS'
  end
else
  '@rmdir result\BOOTIMGS >nul 2>&1'


/*-----------------------------------------------------------------*/
Call chapter 'Scanning current config.sys for country/codepage/keyboard values'
lang='en_us'
country='1'
codepage='850'
keyboard='ux'
ccf=BootDrive()||'\config.sys'
basedev_count=0
do while lines(ccf)
  ibuf=Strip(linein(ccf),,)
  ibuf=LowCase(ibuf)
  select
    when Abbrev(ibuf,'rem') then
      iterate
    when Abbrev(ibuf,'country=') then
      do
        country=SubStr(ibuf,Length('country=')+1)
        parse Var country country ',' ignore
      end
    when Abbrev(ibuf,'codepage=') then
      do
        codepage=SubStr(ibuf,Length('codepage=')+1)
      end
    when Abbrev(ibuf,'devinfo=kbd,') then
      do
        keyboard=SubStr(ibuf,Length('devinfo=kbd,')+1)
        parse Var keyboard keyboard ',' ignore
      end
    when Abbrev(ibuf,'basedev=') then
      if Pos('.add',ibuf)<>0 | Pos('.flt',ibuf)<>0 then
        do
          basedev_count=basedev_count+1
          basedev.basedev_count=Word(Strip(SubStr(ibuf,Length('basedev=')+1)),1)
          if Pos('^',basedev.basedev_count)<>0 then
            basedev.basedev_count=Left(basedev.basedev_count,Pos('^',basedev.basedev_count)-1);
          if basedev.basedev_count=='daniatapi.flt' then
            basedev.basedev_count='daniatap.flt'
        end
    when Abbrev(ibuf,'libpath=') then
      do
        searchpath=Strip(SubStr(ibuf,Length('libpath=')+1))||';'||searchpath
        Call Value 'SEARCHPATH', searchpath, 'OS2ENVIRONMENT'
      end
  otherwise
  end
end


/*-----------------------------------------------------------------*/
Call chapter 'Scanning current snoop.lst'
snl=BootDrive()||'\os2\boot\snoop.lst'
snoop_count=0
do while lines(snl)
  ibuf=Strip(linein(snl),,)
  ibuf=LowCase(ibuf)
  select
    when        ibuf==''             then nop
    when Abbrev(ibuf,';'           ) then nop
    when Abbrev(ibuf,'netdet'      ) then nop
    when Abbrev(ibuf,'sndgalax.snp') then nop
    when Abbrev(ibuf,'auddrive.snp') then nop
    when Abbrev(ibuf,'jazz16.snp'  ) then nop
    when Abbrev(ibuf,'sndblast.snp') then nop
    when Abbrev(ibuf,'pas16.snp'   ) then nop
    when Abbrev(ibuf,'bsaudio.snp' ) then nop
    when Abbrev(ibuf,'ir.snp'      ) then nop
    when Abbrev(ibuf,'pcmcia.snp'  ) then nop
    when Abbrev(ibuf,'pccoff.'     ) then nop
  otherwise
      snoop_count=snoop_count+1
      snoop.snoop_count=ibuf
  end
end
Call Stream snl, 'c', 'close'


/*-----------------------------------------------------------------*/
Call chapter 'Selection of drivers and programs'
ibm1flpy_add='n'
do i=1 to basedev_count
  if basedev.i=='ibm1flpy.add' then ibm1flpy_add='y'
end

ibm1flpy_add=Ask4('Floppy (ibm1flpy.add)', 'basedev_ibm1flpy.add', ibm1flpy_add, 'y', 'n')
if ibm1flpy_add=='n' then
  do i=1 to snoop_count
    if Abbrev(snoop.i,'ibm1flpy') then snoop.i=''
  end

ibmint13_i13='n'
ibmint13_i13=Ask4('Generic Int13 driver, [<8GB, not recommended!] (ibmint13.i13)', 'basedev_ibmint13.i13', ibmint13_i13, 'y', 'n')

if ibmint13_i13=='n' then
  do i=1 to basedev_count
    select
      when Abbrev(basedev.i,'ibm1flpy') then
        basedev.i=''
      when Abbrev(basedev.i,'ibm2flpy') then
        basedev.i=''
      when Abbrev(basedev.i,'memdisk') then
        basedev.i=''
      when Abbrev(basedev.i,'ibmint13') then
        basedev.i=''
      when Abbrev(basedev.i,'pmvdmcc') then
        basedev.i=''
    otherwise
      /* Say 'basedev_'||basedev.i */
      if Ask4('Adapter device driver '||basedev.i, 'basedev_'||basedev.i, 'y', 'y', 'n')=='n' then
        do
          Parse Var basedev.i basedev.i '.' ignore
          if basedev.i=='danis506' then basedev.i='ibm1s506'
          do j=1 to snoop_count
            if Abbrev(snoop.j,basedev.i) then snoop.j=''
          end
          basedev.i=''
        end
    end
  end

if unicode_tar=='n' then
  do
    Say 'JFS not possible, because loaddll.sys+untar.dll+unicode.tar can not used.'
    unicode='n'
  end
else
  do
    if target_vol=='A' then
      unicode='n'
    else
      unicode='y'
    unicode=Ask4('Unicode for JFS.IFS, arj,..', 'unicode', unicode, 'y', 'n')
  end

jfs='n'
if os2lvm_dmd<>'' then
  if unicode=='y' then
    jfs=Ask4('JFS.IFS', 'jfs.ifs', 'y', 'y', 'n')

if target_vol=='A' then
  hpfs_ifs='n'
else
  hpfs_ifs='y'
hpfs_ifs=Ask4('Access to HPFS', 'hpfs.ifs', hpfs_ifs, 'y', 'n')

hpfs_chk='n'
if hpfs_ifs=='y' then
  do
    hpfs_chk='y'
    hpfs_chk=Ask4('include HPFS ChkDsk', 'hpfs_chkdsk', hpfs_chk, 'y', 'n')
  end

if target_vol=='A' then
  cdfs='n'
else
  cdfs='y'
cdfs=Ask4('Access to CDFS', 'cdfs.ifs', cdfs, 'y', 'n')

fdisk_com='n'
lvm_exe='n'
if os2lvm_dmd=='' then
  do
    if target_vol=='A' then
      fdisk_com='n'
    else
      fdisk_com='y'
    fdisk_com=Ask4('FDisk.COM', 'fdisk.com', fdisk_com, 'y', 'n')
  end
else
  do
    if target_vol=='A' then
      lvm_exe='n'
    else
      lvm_exe='y'
    lvm_exe=Ask4('LVM.EXE', 'lvm.exe', lvm_exe, 'y', 'n')
  end

term_exe='n'
if search_file('t.exe')<>'' | search_file('term.exe')<>'' then
  term_exe=Ask4('OS/2 ASCII terminal program + com.sys', 'term.exe', 'y', 'y', 'n')
else
  Say 'can not find t.exe or term.exe, disabling com.sys and terminal program.'

if target_vol=='A' then
  fc2_exe='n'
else
  fc2_exe='y'
if search_file('fc.exe')<>'' then
  fc2_exe=Ask4('FileCommander/2', 'fc2', fc2_exe, 'y', 'n')

tedit_exe='n'
if fc2_exe=='n' then
  if search_file('tedit.exe')<>'' then
    tedit_exe=Ask4('IBM Tiny Editor', 'tedit', 'n', 'y', 'n')

dfsee='n'
if search_file('dfs.exe')<>'' | search_file('dfsos2.exe')<>'' then
  do
    if target_vol<>'A' then dfsee='y'
    dfsee=Ask4('DFSEE', 'dfsee', dfsee, 'y', 'n')
  end

if target_vol=='A' then
  arj='n'
else
  arj='y'
arj=Ask4('arj/unzip/rar32 <if found>', 'arj_unzip_rar', arj, 'y', 'n')

/*-----------------------------------------------------------------*/
Call chapter 'Collecting files'

if target_type=='iso9660' then
  do
    mkisofs2_exe=search_file('mkisofs2.exe')
    if mkisofs2_exe=='' then
      mkisofs2_exe=search_file('mkisofs.exe')
    if mkisofs2_exe=='' then
      Call ErrorHalt 'mkisofs2.exe (cdrtools*.zip) not found.'
  end

last_pf_file=0
Call LineOut pf, 'rem  file compression script for packfile.exe',1
Call LineOut pf, 'rem ' created_string
Call LineOut pf, ''
Call LineOut pf, 'create archive '||outputdir||'\memdisk.pf'
Call LineOut pf, '  output "'||created_string||'";'
Call LineOut pf, '  output "greetings to Joergen Ibsen for aPLib..";'
Call copy path_to_memdisk_bin||'\os2ldr.sek', 'os_files\os2ldr.sek'
Call LineOut pf, '  bootsector os_files\os2ldr.sek'
Call LineOut pf, '  volumelabel demoboot'

Call LineOut lx,'@echo off'
Call LineOut lx,'rem  prepare executable modules for packfile compression'
Call LineOut lx,'rem ' created_string
Call LineOut lx,''

Call LineOut cf,'rem ' created_string, 1
Call LineOut cf,''

/* startup and kernel */
Call LineOut pf, '  output "unpacking startup and kernel "'
Call install_file 'os2csm.bin','dummycsm.bin'
if search_file('os2ldr.deb')<>'' & debug then
  Call install_file 'os2ldr','os2ldr.deb'
else
  Call install_file 'os2ldr','os2ldr.bin'
Call install_file 'os2ldr.msg'
if search_file('os2krnd')<>'' & debug then
  do
    Call install_file 'os2krnl', 'os2krnd'
    if search_file('os2krnd.sym')<>''  then
      Call install_file 'os2krnl.sym', 'os2krnd.sym'
  end
else
  do
    Call install_file 'os2krnl'
    if search_file('os2krnl.sym')<>'' & debug then
      Call install_file 'os2krnl.sym'
  end
if search_file('os2dump')<>'' then
  Call install_file 'os2dump'
if hpfs_ifs=='y' | cdfs=='y' then
  Call install_file 'oso001.msg'
Call LineOut pf, '  add file os_files\config.sys'

'@echo @echo off > os_files\altf1.cmd'
Call LineOut pf, '  add file os_files\altf1.cmd'
/* could place F5/F6 hint here.. */
'@echo Alt+F1 Screen: > os_files\altf1top.scr'
'@echo Press F5 to enable, F6 to disable hardware detection. >> os_files\altf1top.scr'
Call LineOut pf, '  add file os_files\altf1top.scr'
'@echo. > os_files\altf1mid.scr'
Call LineOut pf, '  add file os_files\altf1mid.scr'
'@echo. > os_files\altf1bot.scr'
Call LineOut pf, '  add file os_files\altf1bot.scr'

'@echo show driver loading>os_files\altf2on.$$$'
Call LineOut pf, '  add file os_files\altf2on.$$$'

Call LineOut cf, 'buffers=32'
Call LineOut cf, 'iopl=yes'
Call LineOut cf, 'memman=swap,protect'
Call LineOut cf, 'swappath='||boot_volume||':'

if fc2_exe=='y' then
  Call LineOut cf, 'protshell='||boot_volume||':\cmd.exe /k fc.exe'
else
  Call LineOut cf, 'protshell='||boot_volume||':\cmd.exe'

Call LineOut cf, 'diskcache=D2,LW' /* ,AC: */
Call LineOut cf, 'protectonly=yes'
Call LineOut cf, 'libpath='||boot_volume||':\;.;\;\os2\dll;\os2\install;'
Call LineOut cf, 'pauseonerror=no' /* ?? yes */
Call LineOut cf, 'codepage='||codepage
Call LineOut cf, 'country='||country||','||boot_volume||':\country.sys'
Call LineOut cf, 'devinfo=kbd,'||keyboard||','||boot_volume||':\keyboard.dcp'
Call LineOut cf, 'devinfo=scr,vga,'||boot_volume||':\viotbl.dcp'
Call LineOut cf, 'set os2_shell='||boot_volume||':\cmd.exe'
Call LineOut cf, 'set path='||boot_volume||':\;\;\os2;\os2\system;\os2\install'
Call LineOut cf, 'set dpath='||boot_volume||':\;\;\os2;\os2\system;\os2\install'
Call LineOut cf, 'set keys=on'
Call LineOut cf, 'set lang='||Value('LANG',,'OS2ENVIRONMENT')
Call LineOut cf, 'set tz='||Value('TZ',,'OS2ENVIRONMENT')
Call LineOut cf, 'set user='||Value('USER',,'OS2ENVIRONMENT')
Call LineOut cf, 'set video_devices=vio_svga'
Call LineOut cf, 'set vio_svga=device(bvhvga)'

Call LineOut cf, 'basedev=pmvdmcc.sys'
Call LineOut cf, 'basedev=ibmkbd.sys'

if boot_volume<>'a' then
  do
    if ibm1flpy_add=='y' then
      Call LineOut cf, 'basedev=ibm1flpy.add'
  end

if ibmint13_i13=='y' then
  do
    Call LineOut cf, 'basedev=ibmint13.i13'
    Call LineOut cf, 'basedev=memdisk.i13'
  end
else
  do
    /* memdisk.add can before after *506.ADD when it gets drive
       letter Z:, having it first ensures it really gets Z: before any
       other HD volume that could be Z:
       In case of superfloppy emulation, FDisk will crash when
       memdisk is before harddisk, and DFSee will show physical/logical
       mismatching size

       however, when an harddisk is empty, *506.ADD will ask the BIOS
       about the geoemtry, but it asks for the wrong drive, when
       memdisk is loaded before: it calculates its drive number
       as $80+count of harddisk like devices already installed by OS/2 drivers
       so it will typically ask for drive $81 (memdisk) instead of $80 (HD)

       */

    do i=1 to basedev_count
      param=''
      if basedev.i=='ibm1s506.add' | basedev.i=='danis506.add' then
        param=' /Shutdown'

      /* ?? /A:0 /!BM /A:1 /!BM, /FORCEGBM */

      if basedev.i<>'' then
        Call LineOut cf, 'basedev='||basedev.i||param

    end

    /* if boot_volume=='a' | boot_volume<>'a' then */
      Call LineOut cf, 'basedev=memdisk.add'

  end

if boot_volume=='a' then
  do
    if ibm1flpy_add=='y' then
      Call LineOut cf, 'basedev=ibm1flpy.add'
  end

Call LineOut cf, 'basedev=os2dasd.dmd'
if os2lvm_dmd<>'' then
  Call LineOut cf, 'basedev=os2lvm.dmd'

Call LineOut cf, 'device=testcfg.sys'
Call LineOut cf, 'device=dos.sys'
if term_exe=='y' then
  Call LineOut cf, 'device=com.sys'


Call install_file 'resource.sys'
if search_file('os2logo')<>'' then
  Call install_file 'os2logo'
Call install_file 'clock01.sys'
Call install_file 'screen01.sys'
Call install_file 'kbdbase.sys'
Call install_file 'pnp.sys'
Call install_file 'isapnp.snp'
Call install_file 'pmvdmcc.sys'
Call install_file 'ibmkbd.sys'

/* snoop.lst */
Call LineOut 'os_files\snoop.lst', ';' created_string
do i=1 to snoop_count
  if snoop.i<>'' then
    Call LineOut 'os_files\snoop.lst', snoop.i
end
Call Stream 'os_files\snoop.lst', 'c', 'close'
Call LineOut pf, '  add file os_files\snoop.lst'

/* snooper drivers */
do i=1 to snoop_count
  if snoop.i<>'' then
    Call install_file snoop.i
end

Call LineOut pf, '  next pointer memdisk'||last_pf_file+1||'.pf'
Call LineOut pf, 'close archive'
Call LineOut pf, ''

/* base device drivers */
last_pf_file=last_pf_file+1
Call LineOut pf, 'create archive '||outputdir||'\memdisk'||last_pf_file||'.pf'
Call LineOut pf, '  output "unpacking base device drivers "'

if ibm1flpy_add=='y' then
  Call install_file 'ibm1flpy.add'

if ibmint13_i13=='y' then
  do
    Call install_file 'ibmint13.i13'
    Call install_file 'memdisk.i13','memdisk.add'
  end
else
  do
    Call install_file 'memdisk.add'
    do i=1 to basedev_count
      select
        when basedev.i=='' then
          nop
        when basedev.i=='daniatap.flt' then
          Call install_file basedev.i, 'daniatapi.flt'
        otherwise
          Call install_file basedev.i
      end
    end
  end

Call install_file 'os2dasd.dmd'
if os2lvm_dmd<>'' then
  Call install_file 'os2lvm.dmd'

Call LineOut pf, '  next pointer memdisk'||last_pf_file+1||'.pf'
Call LineOut pf, 'close archive'
Call LineOut pf, ''


/* device drivers */
last_pf_file=last_pf_file+1
Call LineOut pf, 'create archive '||outputdir||'\memdisk'||last_pf_file||'.pf'
Call LineOut pf, '  output "unpacking device drivers and country/codepage files "'

if cdfs=='y' then
  do
    Call install_file 'os2cdrom.dmd','jjscdrom.dmd'
    Call LineOut cf, 'device=os2cdrom.dmd'
  end

Call install_file 'dos.sys'
Call install_file 'testcfg.sys'
if term_exe=='y' then
  Call install_file 'com.sys'

/* country data files */
Call install_file 'country.sys'
Call install_file 'keyboard.dcp'
if codepage=='850' then
  Call install_file 'viotbl.dcp', 'vtbl850.dcp'
else
  Call install_file 'viotbl.dcp'

Call LineOut pf, '  next pointer memdisk'||last_pf_file+1||'.pf'
Call LineOut pf, 'close archive'
Call LineOut pf, ''


/* Unicode */
if unicode=='y' then
  do
    last_pf_file=last_pf_file+1
    Call LineOut pf, 'create archive '||outputdir||'\memdisk'||last_pf_file||'.pf'
    Call LineOut pf, '  output "unpacking unicode files "'
    Call install_file 'loaddll.sys'
    Call install_file 'loaddll.msg'
    Call install_file 'untar.dll'
    Call install_file 'untar.msg'
    Call install_file 'unicode.tar'
    Call LineOut cf, 'device=loaddll.sys \untar.dll untar \unicode.tar'
    Call install_file 'unicode.sys'
    Call LineOut cf, 'device=unicode.sys'
    Call install_file 'uconv.dll'
    Call install_file 'libuni.dll'
    Call LineOut pf, '  next pointer memdisk'||last_pf_file+1||'.pf'
    Call LineOut pf, 'close archive'
    Call LineOut pf, ''
  end


/* *.dll */
last_pf_file=last_pf_file+1
Call LineOut pf, 'create archive '||outputdir||'\memdisk'||last_pf_file||'.pf'
Call LineOut pf, '  output "unpacking ifs, libraries and executables "'
Call install_file 'ansicall.dll'
Call install_file 'bkscalls.dll'
Call install_file 'bmscalls.dll'
Call install_file 'bvhinit.dll'
Call install_file 'bvhvga.dll'
Call install_file 'bvscalls.dll'
Call install_file 'doscall1.dll'
Call install_file 'kbdcalls.dll'
Call install_file 'moucalls.dll'
Call install_file 'msg.dll'
Call install_file 'nampipes.dll'
Call install_file 'nls.dll'
Call install_file 'os2char.dll'
Call install_file 'quecalls.dll'
Call install_file 'sesmgr.dll','sesmgr.ibm'
Call install_file 'viocalls.dll'


if jfs=='y' then
  do
    Call install_file 'jfs.ifs'
    Call install_file 'jfs.msg'
    Call install_file 'ujfs.dll'
    Call LineOut cf, 'ifs=jfs.ifs /L:1000,30,30' /* autocheck */
  end

if hpfs_ifs=='y' then
  do
    Call install_file 'hpfs.ifs'
    if hpfs_chk='y' then
      do
        Call install_file 'uhpfs.dll'
        Call install_file 'chkdsk32.dll'
        Call install_file 'chkdsk32.exe'
        Call LineOut cf, 'ifs=hpfs.ifs /cache:2048 /autocheck:*'
      end
    else
      do
        Call LineOut cf, 'ifs=hpfs.ifs /cache:2048 /autocheck:'
      end
  end

if cdfs=='y' then
  do
    Call install_file 'cdfs.ifs'
    Call LineOut cf, 'ifs=cdfs.ifs /q'
  end

/* some executables */
Call install_file 'harderr.exe'
Call install_file 'cmd.exe'

if jfs=='y' | hpfs_chk=='y' then
  do
    Call Install_file 'chkdsk.com'
    Call Install_file 'format.com'
  end

Call LineOut pf, '  next pointer memdisk'||last_pf_file+1||'.pf'
Call LineOut pf, 'close archive'
Call LineOut pf, ''

/* extra programs */
last_pf_file=last_pf_file+1
Call LineOut pf, 'create archive '||outputdir||'\memdisk'||last_pf_file||'.pf'
Call LineOut pf, '  output "unpacking user programs "'

if tedit_exe=='y' then
  do
    Call install_file 'tedit.exe'
    if search_file('tedit.hlp')<>'' then
      Call install_file 'tedit.hlp'
  end

if term_exe=='y' then
  do
    if search_file('term.exe')<>'' then
      Call install_file 'term.exe'
    else
      if search_file('t.exe')<>'' then
        Call install_file 't.exe'
  end

if fc2_exe=='y' then
  do
    Call install_file 'fc.exe'
    if search_file('fc.fch')<>'' then
      Call install_file 'fc.fch'
    /* fc.ini is not helpful, recreate.. */
  end

if fdisk_com=='y' then
  Call install_file 'fdisk.com'

if lvm_exe=='y' then
  do
    Call install_file 'lvm.exe'
    Call install_file 'lvm.msg'
    Call install_file 'lvm.dll'
  end

if dfsee=='y' then
  do
    Call install_file 'dfs.exe', 'dfsos2.exe'
    if search_file('dfsee.key')<>'' then
      Call install_file 'dfsee.key'
  end

if arj=='y' then
  do

    if search_file('arj.exe')<>'' then
      if unicode=='y' then
        do
          Call install_file 'arj.exe'
          Call install_file 'libcs.dll'
          if search_file('register.dat')<>'' then
            Call install_file 'register.dat'
        end

    if search_file('unzip.exe')<>'' then
      Call install_file 'unzip.exe'
    if search_file('zip.exe')<>'' then
      Call install_file 'zip.exe'

    if search_file('rar32.exe')<>'' then
      do
        Call install_file 'rar32.exe'
        if search_file('emx.dll')<>'' then
          Call install_file 'emx.dll'
      end

  end


Call LineOut pf, 'close archive' /* no next pointer */
Call LineOut pf, ''


Call Stream cf, 'c', 'close'
Call Stream pf, 'c', 'close'
Call Stream lx, 'c', 'close'


/*-----------------------------------------------------------------*/

'@echo @echo off > os_files\_make_pf.cmd'
'@echo cd .. >> os_files\_make_pf.cmd'
'@echo '||path_to_memdisk_exe||'\packfile.exe' pf '>> os_files\_make_pf.cmd'
'@echo cd os_files >> os_files\_make_pf.cmd'

Call chapter 'compressing files'
'@'||path_to_memdisk_exe||'\packfile.exe' pf
if RC<>0 then Call ErrorHalt 'RC='||RC


/*-----------------------------------------------------------------*/
Call chapter 'configuring memdisk and loader'
/* file variant selection based on language */
lang=LowCase(SubStr(Value('LANG',,'OS2ENVIRONMENT'),1,2))
if lang='sp' then lang='es'

if Stream(path_to_memdisk_bin||'\'||lang||'\memboot.bin', 'C', 'Query Exist') == '' then
  lang='en'
else
  lang=LowCase(lang)

if debug then
  lang='db'

Call copy path_to_memdisk_bin||'\'||lang||'\memboot.bin', outputdir||'\memboot.bin'

copy_fontfile=(lang=='ru')

/* prepare response file for memcfg */
do while lines(path_to_memdisk_exe||'\memcfg.rsp')
  i=i+1
  rsp_line=Strip(linein(path_to_memdisk_exe||'\memcfg.rsp'),,)
  select
    when Abbrev(rsp_line,'$TermEmul$') then
      do
        if target_type=='iso9660' then
          rsp_line='$TermEmul$=yes'
        else
          rsp_line='$TermEmul$=no'
      end
    when Abbrev(rsp_line,'$BootTarg$') then
      do
        if debug then
          rsp_line='$BootTarg$=*'
        else
          rsp_line='$BootTarg$=m'
      end
    when Abbrev(rsp_line,'$SerialDB$') then
      rsp_line='$SerialDB$=no'
    when Abbrev(rsp_line,'$eCS_Menu$') then
      do
        if target_type=='iso9660' then
          rsp_line='$eCS_Menu$=no' /* change if needed .. */
        else
          rsp_line='$eCS_Menu$=no'
      end
    when Abbrev(rsp_line,'$DebugOpt$') then
      rsp_line='$DebugOpt$=0'
    when Abbrev(rsp_line,'$Call_CSM$') then
      rsp_line='$Call_CSM$=no'
    when Abbrev(rsp_line,'$V_Letter$') then
      rsp_line='$V_Letter$='||boot_volume||':'
    when Abbrev(rsp_line,'$Disk_KiB$') then
      if debug then
        rsp_line='$Disk_KiB$=16384'
      else
        rsp_line='$Disk_KiB$='||((memdisk_usage*1.2) % 1024)
    when Abbrev(rsp_line,'$PartType$') then
      if debug then
        rsp_line='$PartType$=no'
      else
        rsp_line='$PartType$=yes'
    when Abbrev(rsp_line,'$LoadFont$') then
      if copy_fontfile then
        rsp_line='$LoadFont$=yes'
      else
        rsp_line='$LoadFont$=no'
    otherwise
  end
  Call LineOut 'os_files\memcfg.rsp', rsp_line
end
Call Stream 'os_files\memcfg.rsp', 'c', 'close'

/* apply memcfg response file */
'@'||path_to_memdisk_exe||'\memcfg.exe' outputdir||'\memboot.bin < os_files\memcfg.rsp >nul 2>&1'

/* copy cd loader or boot sector */
if target_type=='iso9660' then
  do
    Call copy path_to_memdisk_bin||'\'||lang||'\cdloader.bin', outputdir||'\cdloader.bin'
  end
else
  do
    Call copy path_to_memdisk_exe||'\wboot.exe', outputdir||'\wboot.exe'
    Call copy path_to_memdisk_bin||'\memboot.sek', outputdir||'\memboot.sek'
  end

if copy_fontfile then
  do
    fontfile.0=3
    fontfile.1='memboot.f08'
    fontfile.2='memboot.f14'
    fontfile.3='memboot.f16'
    fontfilemissing=0
    do fontfilenum=1 to fontfile.0
      fff=search_file(fontfile.fontfilenum)
      if fff=='' then
        do
          Say 'Warning: could not find font file "'fontfile.fontfilenum'", screen could be unreadable!'D2C(7)
          fontfile.fontfilenum=''
          fontfilemissing=1
        end
      else
        Call copy fff, outputdir||'\'||fontfile.fontfilenum
    end

    if fontfilemissing=1 then Call SysSleep(4)
  end


/*-----------------------------------------------------------------*/
Call chapter 'Installing to target'
if target_type=='iso9660' then
  do
    /* make ISO-9660 image */
    isocmd=mkisofs2_exe||' -iso-level 1 -no-emul-boot -b bootimgs/cdloader.bin -o '||target_file Directory()||'\result'
    '@'||isocmd
    if RC=='1' then
      do
        Say 'Returncode 1, maybe FAT with UPCASE filenames?, retrying..'
        isocmd=mkisofs2_exe||' -iso-level 1 -no-emul-boot -b BOOTIMGS/CDLOADER.BIN -o '||target_file Directory()||'\result'
        '@'||isocmd
      end
    if RC<>0 then Call ErrorHalt 'RC='||RC
    '@echo @echo off > result\makeiso.cmd'
    '@echo rem' created_string '>> result\makeiso.cmd'
    '@echo' isocmd '>> result\makeiso.cmd'
    '@echo if not errorlevel 1 goto end >> result\makeiso.cmd'
    '@echo pause >> result\makeiso.cmd'
    '@echo :end >> result\makeiso.cmd'

    Say ''
    Say 'Done! - resulting file is' target_file
  end
else
  do
    /* copy to floppy or bootable partition */

    Say 'Ready to copy files to' target_vol||':. Please insert media.'
    if Ask4('Continue', 'insert_media_'||target_vol, '', 'y', 'n')=='n' then
      do
        Say 'Then please do it yourself later. files are in' outputdir||'.'
        Exit 1
      end
    Say target_vol||':\wboot.exe'
    Call copy outputdir||'\wboot.exe', target_vol||':\wboot.exe'
    Say target_vol||':\memboot.sek'
    Call copy outputdir||'\memboot.sek', target_vol||':\memboot.sek'
    Say target_vol||':\memboot.bin'
    Call copy outputdir||'\memboot.bin', target_vol||':\memboot.bin'

    if copy_fontfile then
      do fontfilenum=1 to fontfile.0
        if fontfile.fontfilenum<>'' then
          do
            Say target_vol||':\'||fontfile.fontfilenum
            Call copy outputdir||'\'||fontfile.fontfilenum, target_vol||':\'||fontfile.fontfilenum
          end
      end

    Say 'Installing bootsector code'
    '@'||target_vol||':\wboot.exe' target_vol||':\memboot.sek' target_vol||':'
    if RC<>0 then
      Say 'Writing the new bootsector code did not succeed. Do it later yourself.'||D2C(7)

    do i=0 to last_pf_file
      if i==0 then
        pf_name='memdisk.pf'
      else
        pf_name='memdisk'||i||'.pf'
      Say target_vol||':\'||pf_name
      Call SysFileTree outputdir||'\'||pf_name, 'fileinfo', 'F', '*****', '*****'
      filesize=Word(fileinfo.1,3)
      drop fileinfo
      do until free>=filesize
        '@if exist' target_vol||':\'||pf_name 'del' target_vol||':\'||pf_name '>nul 1>&2'
        free=Word(SysDriveInfo(target_vol||':'),2)
        if free<filesize then
          if Ask4('Insert next media! Continue', 'insert_media_'||target_vol, '', 'y', 'n')=='n' then
            Exit 1
      end
      Call copy outputdir||'\'||pf_name, target_vol||':\'||pf_name
    end

    Say ''
    Say 'Done!'
  end

Say ''
Say 'Press Esc to exit.'
do until SysGetKey('NoEcho')==D2C(27)
end
Return 0

/**/

install_file:
  Parse ARG filename, searchfilename

  found=''
  if searchfilename<>'' then
    found=search_file(searchfilename)

  if found=='' then
    found=search_file(filename)

  if found=='' then
    do
      Say 'Can not find file' filename||'.'
      Say '  Please copy it to the current directory and retry.'
      Call ErrorHalt ''
    end

  Say 'Found' found||'.'
  Call copy found, 'os_files\'||filename
  Call Stream 'os_files\'||filename, 'c', 'open'
  filesize=Chars('os_files\'||filename)
  file_signature=CharIn('os_files\'||filename, 1, 2)

  if file_signature=='MZ' | file_signature=='ZM' then
    do
      newexe_start=             C2D(CharIn('os_files\'||filename, 1+60  , 1))
      newexe_start=newexe_start+C2D(CharIn('os_files\'||filename, 1+60+1, 1))*256
      newexe_start=newexe_start+C2D(CharIn('os_files\'||filename, 1+60+2, 1))*256*256
      newexe_start=newexe_start+C2D(CharIn('os_files\'||filename, 1+60+3, 1))*256*256*256
      if (newexe_start>=28) & (newexe_start+64<filesize) then
        file_signature=CharIn('os_files\'||filename, 1+newexe_start, 2)
    end
  Call Stream 'os_files\'||filename, 'c', 'close'

  if filename=='arj.exe' then file_signature='--' /* sfx overlay */

  /* have seen problems with lxlite or repack when used on 14.072a kernel */
  /* again lxlite with 14.098b */
  if filename=='os2krnl' then
    /*if os2lvm_dmd=='' then*/
      file_signature='--'

  if (file_signature=='LX') & enable_lxlite then
    do
      if filename=='os2krnl' then
        exepack='LxLite /c:minStub /B- /U+ /F+        /MRN /MLN os_files\'||filename
      else
        exepack='LxLite /c:default /B- /U+ /F+ /ZS /T /MRN /MLN os_files\'||filename
      Call LineOut lx, 'Call' exepack
      '@Call' exepack '>nul'
    end

  if (file_signature=='NE') & enable_nelite then
    do
      exepack='nelite os_files\'||filename 'os_files\'||filename '/p:0 /s'
      if Pos('.add',filename)<>0 then /* not for cdfs.ifs */
        exepack=exepack '/e+ /l+'

      Call LineOut lx, 'Call' exepack
      '@Call' exepack '>nul'
    end

  Call LineOut pf, '  add file os_files\'||filename


  /* add file to disk usage */
  Call SysFileTree 'os_files\'||filename, 'fileinfo', 'F', '*****', '*****'
  filesize=Word(fileinfo.1,3)
  drop fileinfo
  memdisk_usage=memdisk_usage+filesize
  Return

/**/

search_file:
  Parse ARG s_filename

  rc=SysSearchPath('SEARCHPATH',s_filename)
  if rc<>'' then Return rc

  if debug then Return ''

  rc=SysSearchPath('PATH',s_filename)
  if rc<>'' then Return rc
  rc=SysSearchPath('DPATH',s_filename)
  if rc<>'' then Return rc

  Return ''

/**/

ask4:
  Parse ARG Question , rsptag , default , key1 , key2 , key3 , key4

  if default=='' then
    default='different'

  Call CharOut , Question||' ('
  if key1<>'' then
    do
      if key1==default then
        Call CharOut , D2C(27)||'[1m'||UpCase(key1)||D2C(27)||'[0m'
      else
        Call CharOut , key1
    end
  if key2<>'' then
    do
      if key2==default then
        Call CharOut , '/'||D2C(27)||'[1m'||UpCase(key2)||D2C(27)||'[0m'
      else
        Call CharOut , '/'||key2
    end
  if key3<>'' then
    do
      if key3==default then
        Call CharOut , '/'||D2C(27)||'[1m'||UpCase(key3)||D2C(27)||'[0m'
      else
        Call CharOut , '/'||key3
    end
  if key4<>'' then
    do
      if key4==default then
        Call CharOut , '/'||D2C(27)||'[1m'||UpCase(key4)||D2C(27)||'[0m'
      else
        Call CharOut , '/'||key4
    end
  Call CharOut , ') ? '
  answer=''
  do until answer==key1 | answer==key2 | answer==key3 | answer==key4
    /* first try to get the answer from the input response file */
    if answer='' then
      do rsp_i=1 to rsp_input_count
        if Abbrev(rsp_input.rsp_i,rsptag||'=') then
          do
            Parse Var rsp_input.rsp_i rsptag_dummy '=' answer
            rsp_input.rsp_i = ''
            Leave rsp_i
          end
      end
    else
      do
        answer=SysGetKey('NoEcho')
        if answer=='' then
          answer=CharIn()
        if answer==D2C(13) then
          answer=default
      end
    if answer='' then answer='(invalid)'
  end
  Say answer
  /* rsp_output_count=rsp_output_count+1
  rsp_output.rsp_output_count=rsptag||'='||answer */
  if ParamStr2 <> '' then
    Call LineOut ParamStr2, rsptag||'='||answer
  Return answer

/**/
erase_files:
  Parse ARG files_to_erase
  Call SysFileTree files_to_erase, 'garbage', 'FSO', '*****', '-----'
  do i=1 to garbage.0
    Call SysFileDelete garbage.i
  end i
  drop files_to_erase garbage
  Return

/**/
copy:
  Parse ARG copy_source_file, copy_target_file
  Call SysFileTree copy_source_file,'orgattr','F','*****','*****'
  OA=Translate(SubWord(orgattr.1,4,1),'+++++','ADHRS')
  /* hidden or system attribute set? */
  if SubStr(OA,3,1)=='+' | SubStr(OA,5,1)=='+' then
    Call SysFileTree copy_source_file,'ignore','F','*****','-----'
  '@copy' copy_source_file copy_target_file '>nul'
  RCC=RC
  /* restore hidden or system attribute */
  if SubStr(OA,3,1)=='+' | SubStr(OA,5,1)=='+' then
    Call SysFileTree copy_source_file,'ignore','F','*****',OA
  if RCC<>0 then Call ErrorHalt 'Copy "'copy_source_file'", "'copy_target_file'" RC='||RCC
  Call SysFileTree copy_target_file,'ignore','F','*****','-----'
  drop copy_source_file copy_target_file orgattr OA ignore RCC
  Return

/**/
chapter:
  Parse Arg chapter_title
  Call SysCls
  Say Center('['||chapter_title||']',79,'')
  Return
/**/
ErrorHalt:
  Parse Arg error_message
  if error_message<>'' then
    Say D2C(27)||'[1;33m'||error_message||D2C(27)||'[0m'
  Say ''
  Say 'Press Esc to exit.'
  do until SysGetKey('NoEcho')==D2C(27)
  end
  Exit 99
/**/
BootDrive:
/* if debug then
    Return 'D:'
  else */
    Return SysBootDrive()
/**/
LowCase:
  Parse Arg string1
  Return Translate(string1,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
/**/
UpCase:
  Parse Arg string1
  Return Translate(string1)
/**/
ErrorREXX: /* S.L. */
  say
  parse source . . szThisCmd
  say 'CONDITION'('C') 'signaled at line' SIGL 'of' szThisCmd
  if 'SYMBOL'('RC') == 'VAR' then
    say 'REXX error' RC':' 'ERRORTEXT'(RC)
  say 'Source =' 'SOURCELINE'(SIGL)
  if 'CONDITION'('I') == 'CALL' then do
    szCondition = 'CONDITION'('C')
    say 'Returning'
    return
  end
  trace '?A'
  say 'Exiting'
  call 'SYSSLEEP' 2
  exit
/**/  
HaltREXX:
  Say 'Halt.'
  Exit 99
/**/