/****************************************************************************/
/*                                                                          */
/* Configuration file for adding the F file manager                         */
/*                                                                          */
/* Contributed by Christian Hennecke                                        */
/*                                                                          */
/* Note: You probably need to change the paths                              */
/*   You can do so by adding the correct settings to your bootAble.myCfg    */
/*   so you don't need to change this file at all (just make sure you       */
/*   specify this file after your bootAble.myCfg!)                          */
/*                                                                          */
/* Note: The "complex" way of setting variables below makes sure they do    */
/*   not overwrite previous values                                          */
/*                                                                          */
/****************************************************************************/


; Settings below can be overridden in your bootAble.myCfg

; Application root for F source files
; Drive, and directory, where f.exe is located
; (do not include trailing slash, or file name)
rc=defaultIfNotSet('APPSRC_F',pathName(ifExists('f.exe',fileExists(OSBOOTDRIVE'\F\f.exe'))),'ASK','DIRECTORY')

; Application root for destination
rc=defaultIfNotSet('APPDEST_F',APPDEST_ROOTDEFAULT'\F')

; Write files to CD or boot image
rc=defaultIfNotSet('APPDESTINATION_F','CD')


/* ------------------------------------------------------------------------ */
/* You should not need to change anything below this line ----------------- */
/* ------------------------------------------------------------------------ */


; Acrobat root directory and content
EXTRADIRECTORIES=EXTRADIRECTORIES+1
EXTRADIRECTORY.EXTRADIRECTORIES=APPDEST_F
EXTRADIRECTORYDESTINATION=APPDESTINATION_F
EXTRADIRECTORYFILES.EXTRADIRECTORIES=,
    APPSRC_F'\f.cfg',
    APPSRC_F'\f.exe',
    APPSRC_F'\f.his',
    APPSRC_F'\f.ico',
    APPSRC_F'\f.log',
    APPSRC_F'\f_grep.exe',
    APPSRC_F'\fedit.his',
    APPSRC_F'\fpinit.exe',
    APPSRC_F'\fsample.cfg',
    APPSRC_F'\fsyntax.smp',
    APPSRC_F'\ftpd.log',
    APPSRC_F'\fview.his',
    APPSRC_F'\startf.cmd'
EXTRADIRECTORYADDTOPATHS.EXTRADIRECTORIES='PATH'
EXTRADIRECTORYRECURSE.EXTRADIRECTORIES='YES'

; Add F object to programs folder
_ADDAFTER_EXTRAUSERINI=CRLF||,
    '"PM_InstallObject" "File Manager;WPProgram;<WP_PROGRAMSFOLDER>" "EXENAME=startf.cmd;STARTUPDIR=$$@destinationDrive(APPDESTINATION_F)$$$$APPDEST_F$$;OBJECTID=<FILE_MANAGER>;ICONFILE=$$@destinationDrive(APPDESTINATION_F)$$$$APPDEST_F$$\f.ico"'
