/* pause
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command pauses for some time (default: 60 seconds).
 *   Also signals sequence page progress bar.
 *
 * Copyright (C) 2007 Blonde Guy
 * All Rights Reserved
 */
 
productName = 'Pause'
productDate = '2007-09-18 15:58:10'
productCategory = 'Operation'

appsDir = arg(1)
pauseTime = arg(2)

if pauseTime = '' then do
   pauseTime = cdglobal('pauseTime')
   if pauseTime = '' then do
      pauseTime = 60
   end
end
call LogCdi "Pause for" pauseTime "seconds"
if pauseTime <= 0 then do
   return 0
end

totalticks = pauseTime - 1

do i=1 to pauseTime - 1
   call SysSleep 1
   call LogCdi '!setseqbar' trunc(99 * i / totalticks)
end

return 0

