/* DevFolder.cmd
 *
 * move program object into the Development Folder
 * arg is the program object
 * 
 * if arg is NULL, create the Development Folder used by Suntan Special
 *
 * Copyright (C) 2008 Blonde Guy
 * All Rights Reserved
 */

parse arg programObject
devFolderID = cdglobal('devFolderID')
devFolderName = cdglobal('devFolderName')

if programObject <> '' then do
   rc = SysMoveObject(programObject, devFolderID)
   if rc = 0 then do
      call CreateDevFolder
      rc = SysMoveObject(programObject, devFolderID)
      if rc = 0 then do
         call LogCdi "could not move" programObject "to" devFolderName
      end
      /* close folder when done */
      address cmd '@sendmsg "' || devFolderName || '" WM_CLOSE'
      if rc <> 0 then do
         call LogCdi "Error" rc "closing" devFolderName "folder"
      end
   end
  return devFolderID
end

createDevFolder:

devFolderParent = cdglobal('devFolderParent')

rc = SysCreateObject('WPFolder', devFolderName, devFolderParent,,
                     'OBJECTID=' || devFolderID || ';OPEN=ICON',,
                     'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create" devFolderName "Folder with" devFolderID
end

return devFolderID
