/* eject the CD
 *
 * And update the CD-Letter if needed
 *
 * Copyright (C) 2002 Blonde Guy
 * All Rights Reserved
 */

originalDir = Directory()
tempDir = value('TEMP',,'OS2ENVIRONMENT')

/* if we are using RSJ, then we know the drive letter */
useRSJ = cdglobal('useRSJ')
if useRSJ \= '' then do
   if SysSearchPath('PATH', 'CDATTACH.EXE') \= '' then do
      cdLetter = left(useRSJ, 1)
      '@cdattach' cdLetter || ': -s'
      if rc = 0 then do
         if left(originalDir, 1) = cdLetter then do
            call Directory tempDir
         end
         call LogCdi "Ejected" cdLetter || ": (useRSJ); return code" rc
         return cdLetter
      end
      call LogCdi "Ejected" cdLetter || ": (useRSJ); return code" rc
   end
end

/* if there is a cdLetter in settings, try it */
cdLetter = cdglobal('cdLetter')
if cdLetter \= '' then do
   /* if there is a CD in the drive, eject it */
   thisDriveInfo = SysDriveInfo(cdLetter)
   if thisDriveInfo \= '' then do
      rc = ejectNow(cdLetter || ':')
      if rc = 0 then do
         if left(originalDir, 1) = cdLetter then do
            call Directory tempDir
         end
         call LogCdi "Ejected" cdLetter || ":"
         return cdLetter
      end
      call LogCdi "Ejected" cdLetter || ": (cdLetter) return code" rc
   end
end
/* find the CD out of all used drives
 * note: RSJ attached drives report themselves as a 'remote' drive
 */
map = SysDriveMap('c', 'used')
do while map \= ''
   parse var map testDrive map
   thisDriveInfo = SysDriveInfo(testDrive)
   if SysDriveInfo(testDrive) \= '' then do
      parse var thisDriveInfo thisDrive thisFree thisTotal thisLabel
      if strip(thisLabel) \= 'VFDISK' then do
         rc = ejectNow(testDrive)
         if rc = 0 then do
            if left(originalDir, 1) = left(testDrive, 1) then do
               call Directory tempDir
            end
            call LogCdi "Ejected" testDrive
            return setCDLetter(testDrive)
         end
         else do
            /* call LogCdi "Failed to eject" testDrive "error code" rc */
         end         
      end
   end
end

return ''

/* eject now */
ejectNow: procedure

parse arg testDrive
ejectFile = SysSearchPath('PATH', 'EJECT.EXE')
if ejectFile \= '' then do
   '@eject' testDrive '> nul'
end
if ejectFile = '' or rc = 50 then do
   if SysSearchPath('PATH', 'CDATTACH.EXE') \= '' then do
      '@cdattach' testDrive '-s 2>nul'
   end
end

return rc

/* set the cdLetter */
setCDLetter:

oldCDLetter = cdglobal('cdLetter')
if left(testDrive, 1) = oldCDLetter then return left(testDrive, 1)

appsDir = cdglobal('appsDir')
settingsFile = appsDir || '\Suntan\settings.txt'
if stream(settingsFile, 'c', 'query exists') = '' then do
   call LogCdi "Settings file:" settingsFile "does not exist!"
   return left(testDrive, 1)
end

/* check if the source path needs to be modified */
sourcePath = cdglobal('sourceDir')
j = 0
do while sourcePath \= ''
   parse var sourcePath sourceDir ';' sourcePath
   if sourceDir \= '' then do
      j = j + 1
      Dir.j = sourceDir
   end
end
Dir.0 = j

sourcePathChanged = 0
if Dir.0 > 0 then do
   do j = 1 to Dir.0
      if left(Dir.j, 1) = oldCDLetter then do
         Dir.j = left(testDrive, 1) || substr(Dir.j, 2)
         sourcePathChanged = 1
      end
   end
   
   if sourcePathChanged = 1 then do
      sourcePath = Dir.1
      do j = 2 to Dir.0
         sourcePath = sourcePath || ';' || Dir.j
      end
   end
end

call SetSetting 'cdLetter', left(testDrive, 1)
call LogCdi "Set cdLetter = '" || left(testDrive, 1) || "'"
return left(testDrive, 1)
