/* DirEdCB.cmd
 * handle Directory Editor callback from Display Monitor
 *
 * Arguments
 *   arg(1) - the name of the application to delete
 *
 * Copyright (C) 2016 Blonde Guy
 * All Rights Reserved
 */

if arg() = 0 then do
   return DirEdCB("no argument specified")
end

appName = arg(1)
cr = d2c(13)
cf = cdglobal('setupDir') || '\' || appName || '\cdi.cmd'

if left(appName, 1) = ';' then do
   message = "Setup Directory Editor" || cr || cr ||,
             "Single click each line to get a description of the application",
             "on that line. Click on the Delete button or press Enter",
             "to delete the application."
   call LogCdi "!listcallback" message
   return 0
end

/* rc = beep(524,100) */

if left(appName, 5) = 'ENTER' then do
   appName = substr(appName, 7)
   cf = cdglobal('setupDir') || '\' || appName || '\cdi.cmd'
   response = DeleteApp(cf)
   if response = 'OK' then do
      appDir = cdglobal('setupDir') || '\' || appName
      address cmd '@deltree /y' appDir '> nul'
      if rc <> 0 then do
         call LogCdi "Error" rc "deleting" appDir
         message = "Directory Editor" || cr || cr ||,
                   "Error" rc "deleting" appDir
      end
      else do
         call LogCdi appDir "successfully deleted"
         message = "Directory Editor" || cr || cr ||,
                   appDir "has been successully deleted."
      end
      call LogCdi "!listcallback" message
      return 0
   end
end

/* put up app description */
message = FindDetails(cf)
call LogCdi "!listcallback" message

/* rc = beep(262,100) */

return 0


/* offer to delete the application */
DeleteApp:

parse arg cf
if cf = '' then do
   return "No app could be found in configuration file" cf
end

dialogTitle = "Confirm Delete"
message = "Press OK to delete the application." || cr ||,
          "Press Cancel to keep the application." || cr || cr ||,
          FindDetails(cf)

if productName = '' then do
   return 'Cancel'
end

response = MessageDialog(dialogTitle, 5, message)

return response

/* find the application details in the configuration file */
FindDetails:

parse arg cf
if cf = '' then do
   return "No app could be found in configuration file" cf
end

proc.0 = 0
productName = ''
echo = 0
breakLine = 0
descriptionFound = 0

productName = GetProductName(cf)
if productName = '' then do
   return "The application was not found."
end

productURL = GetProductURL(cf)
extraZip = GetExtraZip(cf)
installDir = GetInstallDir(cf)
productDate = GetProductDate(cf)

do while lines(cf)
   rexxStmt = linein(cf)
   pd = pos('Description', rexxStmt)
   pc = pos('Copyright', rexxStmt)
   pp = pos('Procedure', rexxStmt)

   if pc > 0 then do
      echo = 0
   end

   if pp > 0 & echo = 1 then do
      breakLine = 1
      call addLine strip(substr(rexxStmt, pos('*', rexxStmt) + 1))
   end

   else if echo = 1 then do
      if strip(rexxStmt) = '*' then do
          call addLine ' '
      end
      else do
         call addLine strip(substr(rexxStmt, pos('*', rexxStmt) + 1))
      end
   end

   if pd > 0 then do
      if descriptionFound = 0 then do
         echo = 1
         descriptionFound = 1
         call addLine ' '
      end
   end
end

call stream cf, 'c', 'close'

/* assemble message */
msg = "Product Name:" productName

if translate(right(cf, 7)) = 'CDI.CMD' then do
   appSource = left(cf, length(cf) - 8)
end
else do
   appSource = 'web'
end
msg = msg || cr || "Source:" appSource

if productDate <> '' then do
   msg = msg || cr || "Date available:" productDate
end

/*
iTime = scanDB(appname)
if iTime <> '' then do
   msg = msg || cr || "Date installed:" prettyDate(iTime)
end */

if installDir <> '' then do
   msg = msg || cr || "Installation Directory:" installDir
end

bytesUsed = scanDir(cf)
if bytesUsed <> '' then do
   msg = msg || cr || "Bytes used:" bytesUsed
end

if productURL <> '' then do
   msg = msg || cr || "Web site:" productURL
end

if extraZip <> '' then do
   msg = msg || cr || "Additional files required:" extraZip
end

do i=1 to proc.0
   if strip(proc.i) = '' then do
      msg = msg || cr || cr
   end
   else do
      msg = msg || strip(proc.i) || ' '
   end
end

return msg

GetProductName:
/*
 * argument: file to scan for productName
 */
parse arg cf
productName = ''

do while lines(cf)
   rexxStmt = linein(cf)
   pp = pos('productName', rexxStmt)
   ep = pos('=', rexxStmt)
   if pp > 0 & pp < ep then do
      interpret rexxStmt
      call stream cf, 'c', 'close'
      return productName
   end
end

call stream cf, 'c', 'close'

return productName


GetProductURL:
/*
 * argument: file to scan for productURL
 */
parse arg cf
productURL = ''
foundURL = 0

do while lines(cf)
   rexxStmt = linein(cf)
   pp = pos('productURL', rexxStmt)
   ep = pos('=', rexxStmt)
   if pp = 1 & pp < ep & foundURL = 0 then do
      interpret rexxStmt
      foundURL = 1
   end
end

call stream cf, 'c', 'close'

return productURL


GetExtraZip:
/*
 * argument: file to scan for extraZip
 */
parse arg cf
extraZip = ''
foundZip = 0

do while lines(cf)
   rexxStmt = linein(cf)
   pp = pos('extraZip', rexxStmt)
   ep = pos('=', rexxStmt)
   if pp = 1 & pp < ep & foundZip = 0 then do
      interpret rexxStmt
      foundZip = 1
   end
end

call stream cf, 'c', 'close'

return extraZip


/* add one line to the proc array */
addLine:

parse arg detail

xx = proc.0
xx = xx + 1
proc.xx = detail
proc.0 = xx

return

GetInstallDir:
/*
 * argument: file to scan for installDir
 */
parse arg cf
installDir = ''
appsDir = cdglobal('appsDir')

do while lines(cf)
   rexxStmt = linein(cf)
   pp = pos('installDir', rexxStmt)
   ep = pos('=', rexxStmt)
   if pp > 0 & pp < ep then do
      interpret rexxStmt
      call stream cf, 'c', 'close'
      return installDir
   end
end

call stream cf, 'c', 'close'

return installDir

/* GetProductDate requires CdiDate */

GetProductDate:
/*
 * argument: file to scan for productDate
 */
parse arg cf
productDate = ''

do while lines(cf)
   rexxStmt = linein(cf)
   pp = pos('productDate', rexxStmt)
   ep = pos('=', rexxStmt)
   if pp > 0 & pp < ep then do
      interpret rexxStmt
      call stream cf, 'c', 'close'
      return productDate
   end
end

call stream cf, 'c', 'close'

return CdiDate(cf)

CdiDate:

parse arg cdiName

if RxFuncQuery('SysGetFileDateTime') = 0 then do
   return SysGetFileDateTime(cdiName)
end

/* Fallback if SysGetFileDateTime is not found */
call SysFileTree cdiName, 'cdidat.'
if cdidat.0 <> 1 then do
   call LogCdi "Error: CdiDate found" cdidat.0 "files named" cdiName
   return ''
end
mm = left(cdidat.1, 2)
dd = substr(cdidat.1, 4, 2)
yy = substr(cdidat.1, 7, 2)
hh = substr(cdidat.1, 11, 2)
mn = substr(cdidat.1, 14, 2)
if yy < 80 then yy = '20' || yy
else yy = '19' || yy
if left(mm, 1) = ' ' then mm = '0' || right(mm, 1)
if left(hh, 1) = ' ' then hh = '0' || right(hh, 1)
if substr(cdidat.1, 16, 1) = 'p' then hh = hh + 12

return yy || '-' || mm || '-' || dd hh || ':' || mn || ':00'


/* bytes used */
scanDir:
parse arg cdiName
ls = lastpos('\', cdiName)
appDir = left(cdiName, ls - 1)
call SysFileTree appDir || '\*.*', 'appf.', 'FS'
bytesUsed = 0
do i=1 to appf.0
   parse var appf.i myappdate myapptime myappsize myappflags myappname
   if datatype(myappsize, "Number") = 1 then do
      bytesUsed = bytesUsed + myappsize
   end
end
return bytesUsed
