/* install.cmd
 *
 * shell for installation of Suntan Special
 *
 * Copyright (C) 2019 Blonde Guy
 * All Rights Reserved
 */

/* don't log yet, there isn't a log file */
say "Install version 0.68 by Blonde Guy"

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* put the utility directory into the path */
originalDir = Directory()
parse source os environ prog
utilPath = filespec('drive', prog) || filespec('path', prog) || 'cdutils'
systemPath = strip(value('PATH',,'OS2ENVIRONMENT'), 'Both', ';')
if pos(utilPath, systemPath) <> 1 then do
   call value "PATH", utilPath || ';' || systemPath, "OS2ENVIRONMENT"
end

/* if this is Warp 4, there might not be longnames on the CD-ROM */
if stream(utilPath || '\QuerySettings.cmd', 'c', 'query exists') = '' then do
   tempDir = value('TEMP',,'OS2ENVIRONMENT')
   if tempDir = '' then do
      tempDir = value('TMP',,'OS2ENVIRONMENT')
      call value 'TEMP',tempDir, 'OS2ENVIRONMENT'
   end
   if tempDir = '' then do
      say "TEMP environment variable is not set."
      say "TEMP must be the name of an existing temporary directory."
      return
   end
   suntanZip = filespec('drive', prog) || filespec('path', prog) || 'setup\suntan\suntan06.zip'
   utilPath = tempDir || '\suntan'
   say "A temporary folder will be created:" utilPath
   address cmd '@unzip -q' suntanZip '-d' utilPath
   if rc <> 0 then do
      say "Error" rc "unzipping suntan special"
   end
   address cmd '@mkdir' tempDir || '\setup'
   address cmd '@mkdir' tempDir || '\setup\suntan'
   address cmd '@copy' filespec('drive', prog) || filespec('path', prog) || 'setup\suntan\*.*' tempDir || '\setup\suntan > nul'
   address cmd '@copy' suntanZip tempDir || '\setup\suntan\suntan068.zip'
   if pos(utilPath, systemPath) <> 1 then do
      call value "PATH", utilPath || ';' || systemPath, "OS2ENVIRONMENT"
   end
   call value "AppendMediaPath", filespec('drive', prog) || filespec('path', prog) || 'setup', 'OS2ENVIRONMENT'
   call value "SuntanTempDir", tempDir || '\setup', 'OS2ENVIRONMENT'
end

chooserFile = utilPath || '\Chooser.Cmd'
call Directory utilPath

osDir = value('osdir',,'os2environment')
if osDir = '' then do
   osVersion = 'OS/2 Warp'
end

if osVersion = 'OS/2 Warp' then do
   '@start "Suntan Special" /c /max' chooserFile
end
else do
   '@start "Suntan Special" /c /min' chooserFile
end

say "If you are running in a Full Screen session, switch to the Suntan Special Window now."

call Directory originalDir
return
