{}
{                                                       }
{      Copy/Move/Delete module for FileHalf,            }
{      PDE Desktop for OS/2 Warp                        }
{      }
{      Copyleft stVova [PDE Team], 2003                 }
{                                                       }
{}

{use file with list of files and folders to copy/move/delete}
{ command line parameters: 1. operation [0 = copy, 1 = move, 2 = delete]}
{ 2. Overwrite existing [0 - no, 1 - yes]}
{ 3. operation text = any}
{think, file is in TEMP directory, and named ~fhcomodo.txt}


program Comodo;

{&PMTYPE PM}
{&Use32+}

uses
  Os2Def, Os2Base, Os2PmApi, PmObj, SysUtils, Dos, VPUtils, Classes;

//const

const
  pmFlags = fcf_TitleBar + fcf_SysMenu + fcf_SizeBorder + {fcf_MinMax +}
               fcf_TaskList + fcf_NoByteAlign;

type
  PClockWindow = ^TClockWindow;
  TClockWindow = object(PMWindow)
    PS: HPS;
    ClientSize: PointL;
    function HandleMessage(Window: HWnd; Msg: ULong; Mp1,Mp2 : MParam): MResult; virtual;
    procedure StartupAction; virtual;
  end;

  ClockApplication = object(PMApplication)
    MainWindow: PClockWindow;
    constructor Init;
    destructor Done; virtual;
  end;

  var
    AnalogClock: ClockApplication;
    GlobalDone: Boolean;
    done_f: LongInt;
    total_f: LongInt;
    progress: PChar;
    wnd: HWND;
    operation: String;
    operation_text: PChar;
    flist: TStringList;
    err: LongInt;
    dcpyExist: ULong;

{ Return the smaller of two integer values }

function Min(X, Y: Integer): Integer;
begin
  if X < Y then Min := X else Min := Y;
end;

Procedure InflateRect(Var rec: RectL; X,Y:LongInt);
Begin
     Dec(rec.xLeft, X);
     Dec(rec.yBottom, Y);
     Inc(rec.xRight, X);
     Inc(rec.yTop, Y);
End;

Procedure SetRect(var rec: RECTL; l, r, t, b: LongInt);
Begin
     rec.xLeft := l;
     rec.yBottom := b;
     rec.xRight := r;
     rec.yTop := t;
End;

function DoOperation(p: pointer): LongInt;
var
  afile: TextFile;
  dst, tmp, tag, base: String;
  i, j, k: LongInt;
  src, dest: PChar;
  rc: APIRET;
Begin

  {MAIN FUNCTION. In thread perform copy/move/delete of files and folders listed in ~fhcomodo.txt}
  {in format:}
  {[total]}                     {10}
  {[destination_directory\]}    {d:\}
  {b [base]}                    {b c:\pde}
  {f [file]}                    {f fileahalf.exe}
  {d [folder (directory)]}      {d bitmaps}
  {...}                         {f bitmaps\i.bmp}
  if (operation <> '0') and (operation <> '1') and (operation <> '2') then
      begin
      operation_text := '8-(';
      WinShowWindow(wnd, false); WinShowWindow(wnd, true);
      exit;
      end;

  if FileExists(GetEnv('TEMP')+'\~fhcomodo.txt') then
  begin
    Assign(afile, GetEnv('TEMP')+'\~fhcomodo.txt');
    Reset(afile);
    flist := TStringList.Create;
    Readln(afile, total_f);
    if operation = '1' then  //when move, must copy and delete
      total_f := 2*total_f;
    WinShowWindow(wnd, false); WinShowWindow(wnd, true);
    Readln(afile, dst);
    while not(eof(afile)) do
      begin
      Readln(afile, tmp);
      flist.Add(tmp);
      end;
    Close(afile);
    base := '';
    if (operation = '0') or (operation = '1') then //(copy) or (move (copy part of move))
      begin
      if fList.Count > 0 then
        for i := 0 to fList.Count - 1 do
        begin
        tmp := fList.Strings[i];
        tag := tmp[1];
        Delete(tmp, 1, 2);
        if tag = 'b' then
          begin
          base := tmp;
          //base := ExtractFileName(base);
          if not CreateDir(dst+ExtractFileName(base)) then inc(err);
          //base := tmp + '\';
          end
        else if tag = 'd' then
          begin
          if tmp[2] <> ':' then
            CreateDir(dst+ExtractFileName(base)+'\'+tmp)
            else
            CreateDir(dst+tmp);
          end
        else if tag = 'f' then
          begin
          if tmp[2] <> ':' then
            begin
            src := StrPNew(base+'\'+tmp);
            //tmp := ExtractFileName(tmp);
            dest := StrPNew(dst+ExtractFileName(base)+'\'+tmp);
            rc := DosCopy(src, dest, dcpyExist);//dcpy_Existing);
            if rc <> 0 then inc(err);
            StrDispose(src);
            StrDispose(dest);
            end
            else
            begin
            src := StrPNew(tmp);
            tmp := ExtractFileName(tmp);
            dest := StrPNew(dst+tmp);
            rc := DosCopy(src, dest, dcpyExist);//dcpy_Existing);
            if rc <> 0 then inc(err);
            StrDispose(src);
            StrDispose(dest);
            end;

          end;
          {src := StrPNew(tmp);
          tmp := ExtractFileName(tmp);
          dest := StrPNew(dst+tmp);
          DosCopy(src, dest, dcpy_Existing);
          StrDispose(src);
          StrDispose(dest);}
        inc(done_f);
        WinShowWindow(wnd, false); WinShowWindow(wnd, true);
        end;
      end;

    if err > 0 then
      begin
      flist.free;
      operation_text := '8-(';
      WinShowWindow(wnd, false); WinShowWindow(wnd, true);
      exit;
      end;

    if (operation = '1') or (operation = '2') then //(move (erase part of move)) or (delete)
      begin
      if fList.Count > 0 then
        for i := 0 to fList.Count - 1 do
        begin
        tmp := fList.Strings[i];
        tag := tmp[1];
        Delete(tmp, 1, 2);
        if tag = 'b' then
          begin
          base := tmp;
          end
        else if tag = 'f' then //file
          begin
          if tmp[2] <> ':' then
            begin
            FileSetAttr(base+'\'+tmp, FileGetAttr(base+'\'+tmp) and not faReadOnly);
            src := StrPNew(base+'\'+tmp);
            end
            else
            begin
            FileSetAttr(tmp, FileGetAttr(tmp) and not faReadOnly);
            src := StrPNew(tmp);
            end;

          //DosSetFileInfo
          DosDelete(src);
          StrDispose(src);

          inc(done_f);
          WinShowWindow(wnd, false); WinShowWindow(wnd, true);
          end;
        end;

      k := fList.Count - 1;
      if fList.Count > 0 then
        for i := k downto 0 do
        begin
        tmp := fList.Strings[i];
        tag := tmp[1];
        Delete(tmp, 1, 2);
        if tag = 'b' then
          begin
          base := tmp;

          for j := k downto i do
            begin
            tmp := fList.Strings[j];
            tag := tmp[1];
            Delete(tmp, 1, 2);
            if tag = 'd' then //directory
              begin
              if tmp[2] <> ':' then
                begin
                FileSetAttr(base+'\'+tmp, FileGetAttr(base+'\'+tmp) and not faReadOnly);
                src := StrPNew(base+'\'+tmp);
                end
                else
                begin
                FileSetAttr(tmp, FileGetAttr(tmp) and not faReadOnly);
                src := StrPNew(tmp);
                end;

              DosDeleteDir(src);
              StrDispose(src);

              inc(done_f);
              WinShowWindow(wnd, false); WinShowWindow(wnd, true);
              end;
            end;
            k := i;

          end;
        end;

      if fList.Count > 0 then
        for i := 0 to fList.Count - 1 do
        begin
        tmp := fList.Strings[i];
        tag := tmp[1];
        Delete(tmp, 1, 2);
        if tag = 'b' then
          begin
          FileSetAttr(tmp, FileGetAttr(tmp) and not faReadOnly);
          src := StrPNew(tmp);
          DosDeleteDir(src);
          StrDispose(src);

          inc(done_f);
          WinShowWindow(wnd, false); WinShowWindow(wnd, true);
          end
        end;

      end

  end
  else
  begin {not FileExists ~fhcomodo.txt}
  operation_text := 'comodo.exe [op_code=0,1,2] [op_text]';
  flist.free;
  WinShowWindow(wnd, false); WinShowWindow(wnd, true);
  exit;
  end;

  flist.free;

  GlobalDone := True;
  WinShowWindow(wnd, false); WinShowWindow(wnd, true);

End;

{ ClockApplication }

constructor ClockApplication.Init;
begin
  inherited Init;
  MainWindow := New(PClockWindow, Init('PDE', 'Comodo', pmFlags));
  //cmd_op := operation;
end;

destructor ClockApplication.Done;
begin
  Dispose(MainWindow, Done);
  inherited Done;
end;

{ TClockWindow }

procedure TClockWindow.StartupAction;
var
  Size: Integer;
begin
  //Size := Min(DesktopSize.X div 3, DesktopSize.Y div 3);
  //WinSetWindowPos(FrameWindow, 0, DesktopSize.X - Size, DesktopSize.Y - Size,
  //  Size, Size, swp_Move + swp_Size + swp_Activate + swp_Show);
  WinSetWindowPos(FrameWindow, 0, DesktopSize.X div 3, DesktopSize.Y div 3,
    300, 100, swp_Move + swp_Size + swp_Activate + swp_Show);
end;

{ Handles PM messages }

function TClockWindow.HandleMessage(Window: HWnd; Msg: ULong; Mp1,Mp2: MParam): MResult;
var
  DC: HDC;
  rct: RECTL;
  x1, y1: Word;
begin
  HandleMessage := 0;

  if GlobalDone then
    Msg := wm_close;

  case Msg of
    wm_Create:
      begin

        //if ParamStr(1) <> '' then
        wnd := window;
        progress := StrAlloc(20);
        progress := '>?/?';
        if paramcount > 0 then
          operation := ParamStr(1);

        try
          dcpyExist := StrToInt(ParamStr(2));
          except
          dcpyExist := 0;
          end;

        operation_text := StrAlloc(60);
        try
          operation_text := StrPNew(ParamStr(3));
          except
          operation_text := 'comodo [op_code 0/1/2] [overwrite_existing 1/0] [text]';
          end;

        DC := WinOpenWindowDC(Window);

        VPBeginThread(DoOperation, 32768, nil);

      end;

    wm_Size:
      begin
        ClientSize.X := LongRec(Mp2).Lo;
        ClientSize.Y := LongRec(Mp2).Hi;
      end;

    wm_Paint:
      begin
        PS := WinBeginPaint(Window, 0, @rct);
        WinFillRect(PS, rct, sysclr_DialogBackground);
        {draw text = "operation"}
        SetRect(rct, 10, 200, 65, 40);
        WinDrawText(ps, strlen(operation_text), operation_text, rct, CLR_BLUE, CLR_BLACK, DT_LEFT+DT_TEXTATTRS+DT_TOP);
        {draw text = "done/all"}
        SetRect(rct, 10, 200, 30, 10);
        progress := StrPNew('>'+IntToStr(done_f)+'/'+IntToStr(total_f));
        WinDrawText(ps, strlen(progress), progress, rct, CLR_BLUE, CLR_BLACK, DT_LEFT+DT_TEXTATTRS+DT_TOP);
        WinSetWindowText(FrameWindow, progress);
        //WinSetWindowText(FrameWindow, StrPNew(IntToStr(dcpyExist)));

        SetRect(rct, 10, 260, 45, 33);
        WinDrawBorder(ps, rct, 1, 1, CLR_WHITE, CLR_WHITE, DB_AREAATTRS);

        //InflateRect(rct, -1, -1);
        if (total_f <> 0) then
          begin
          SetRect(rct, 11, 11+Round(248*done_f/total_f), 44, 34);
          WinFillRect(ps, rct, sysclr_ActiveTitle);
          end;

        {draw "STOP" button - ""}
        SetRect(rct, 265, 280, 45, 33);
        WinDrawBorder(ps, rct, 1, 1, sysclr_ButtonLight, sysclr_ButtonLight, 0);
        SetRect(rct, 266, 280, 44, 33);
        WinDrawBorder(ps, rct, 1, 1, sysclr_ButtonDark, sysclr_ButtonDark, 0);
        SetRect(rct, 266, 279, 44, 34);
        WinDrawBorder(ps, rct, 1, 1, sysclr_DialogBackground, sysclr_DialogBackground, 0);
        SetRect(rct, 269, 276, 42, 36);
        WinDrawBorder(ps, rct, 1, 1, sysclr_WindowText, sysclr_WindowText, DB_INTERIOR);

        WinEndPaint(PS);
      end;

    wm_button1click:
      begin
      x1 := points(mp1).x;
      y1 := points(mp1).y;
      if (x1 >= 265) and (x1 <= 280) and (y1 >= 33) and (y1 <= 45) then {"STOP" button pressed}
        GlobalDone := True;
      end;

     else HandleMessage := WinDefWindowProc(Window, Msg, Mp1, Mp2);
   end;
end;

begin
  AnalogClock.Init;
  AnalogClock.Run;
  AnalogClock.Done;
end.
