//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE Desktop Manager (pdm.exe)         //
//  Main unit                             //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit pdmUnit1;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, ExtCtrls, Dialogs,
  pmwin, SysUtils, BSEDos, os2def, Messages, pdmUnit2,
  pdmUnit3, Mask, Spin, {pdedlgs,} pdeNLS, pmgpi, pmdev, pdmCFG, XplorBtn
  , pdmNotesUnit{, LogonUnit, LogoutUnit}
  , pdeDlgsDLL;

//Name of the shared memory object
Const
    SharedMemName='DragDrop_ItemsInfo';

//Drag source identification
Const
    DragSourceId='File or Folder to Copy';

Type
    TMainForm = Class (TForm)
    PopupMenu1: TPopupMenu; // 祣 ⮫
    Timer1: TTimer;         // ᢥ 
    imgNone: TImage;        //㭮  쥪 .⮫, ᫨   㧨 ᢮
    pnlNotes: TPanel;
    imgNotes: TImage;
    memoNotes: TMemo;
    MenuItem2: TMenuItem;
    mNotes: TMenuItem;
    mGroupIcons: TMenuItem;
    mCmd: TMenuItem;
    mOS2window: TMenuItem;
    mOS2fullscreen: TMenuItem;
    mDOSwindow: TMenuItem;
    mWINwindow: TMenuItem;
    MenuItem11: TMenuItem;
    mDOSfullscreen: TMenuItem;
    MenuItem12: TMenuItem;
    mWINfullscreen: TMenuItem;
    mReloadSettings: TMenuItem;
    MenuItem1: TMenuItem;
    mAbout: TMenuItem;
    mAlignIcons: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem4: TMenuItem;
    mNew: TMenuItem;
    MenuItem3: TMenuItem;
    mShootSystem: TMenuItem;
    mNewObject: TMenuItem;
    MenuItem8: TMenuItem;
    mSetup: TMenuItem;
    mScreenSaver: TMenuItem;
    mRefresh: TMenuItem;

    Procedure imgNotesOnMouseMove (Sender: TObject; Shift: TShiftState;
      X: LongInt; Y: LongInt);
    Procedure imgNotesOnMouseDown (Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X: LongInt; Y: LongInt);
    Procedure mNotesOnClick (Sender: TObject);
    Procedure mGroupIconsOnClick (Sender: TObject);
    Procedure mOS2windowOnClick (Sender: TObject);
    Procedure mOS2fullscreenOnClick (Sender: TObject);
    Procedure mDOSwindowOnClick (Sender: TObject);
    Procedure mDOSfullscreenOnClick (Sender: TObject);
    Procedure mWINwindowOnClick (Sender: TObject);
    Procedure mWINfullscreenOnClick (Sender: TObject);
    Procedure mReloadSettingsOnClick (Sender: TObject);
    Procedure mAlignIconsOnClick (Sender: TObject);
    Procedure MenuItem5OnClick (Sender: TObject);
    Procedure MainFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure mNewObjectOnClick (Sender: TObject);
    Procedure MainFormOnCreate (Sender: TObject);
    Procedure MainFormOnClick (Sender: TObject);
    Procedure mPropertiesOnClick (Sender: TObject);
    Procedure MenuItem9OnClick (Sender: TObject);
    Procedure MenuItem10OnClick (Sender: TObject);
    Procedure mShootSystemOnClick (Sender: TObject);
    Procedure MainFormOnDestroy (Sender: TObject);
    Procedure MainFormOnPaint (Sender: TObject; Const rec: TRect);
    Procedure mRefreshOnClick (Sender: TObject);

    Procedure imgOnClick (Sender: TObject);
    Procedure imgOnDragDrop (Sender: TObject; Source: TObject; X: LongInt; Y: LongInt);
    Procedure imgOnDragOver (Sender: TObject; Source: TObject; X: LongInt; Y: LongInt; State: TDragState; Var Accept: Boolean);
    Procedure Timer1OnTimer (Sender: TObject);
    Procedure MainFormOnShow (Sender: TObject);

    Procedure diOnDblClick (Sender: TObject); // DesktopItema
    Procedure diOnClick (Sender: TObject);

  Private
    {Insert private declarations here}
  Protected
    Procedure MouseDown(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);Override;
  Public
    {Insert public declarations here}
    function ShellExecute(fname, fdir, fparam: string; ses_type: Word; shortcut: boolean; bg_fr: Boolean): Boolean;
  End;

  TDragDropItem=Record
    Len:Byte;         //length of string
    Data:Array[0..0] Of Char;
  End;

  PDragDropInfo=^TDragDropInfo;

  TDragDropInfo=Record
    Count:LongWord;   //Count of elements
    Items:Array[0..0] Of TDragDropItem;
  End;

  TDImage = class (TImage)
    Protected
      Procedure MouseDown(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);Override;
    Public
      Procedure Redraw(Const rec:TRect);override;
      selected: boolean;
      num: integer;
      pict: TPicture;
  End;

  TDLabel = class (TLabel)
    Protected
      Procedure MouseDown(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);Override;
  End;

  TDesktopItem = record
    di: TDImage;
    dc: TDLabel;
    dimage: string;
    dtype: string;
    dname: string;
    dpath: string;
    dparam: string;
    ses_type: Word;
  end;

Var
  //new_item: TDesktopItem2;

  MainForm: TMainForm;
  pdebase: String;
  formpicture: TPicture;
  secondcolor: TColor;
  formbitmap: TBitmap;
  di: array[1..44] of TDesktopItem;
  diCount: integer;
  wallpaper, wallpaperstyle, screensaver: string;
  savertime, idletime: ULong;
  wallpaper_present: Boolean;
  prev_x, prev_y: Integer;

  Needlogon, LoggedOn: Boolean;
  pwd, user: String;
  notesX, notesY: Integer;

  NotesEnabled: Boolean;

//procedure APMShutdown(req: String);

Implementation

{procedure APMShutdown(req: String);
var
  can: Boolean;
Begin

if FileExists(pdebase+'Utils\APM\apm.exe') then
  begin
  if req = 'suspend' then
    begin
    MainForm.ShellExecute(pdebase+'Utils\APM\apm.exe', '', '/Suspend', 0, false, false);
    end
  else if req = 'standby' then
    begin
    MainForm.ShellExecute(pdebase+'Utils\APM\apm.exe', '', '/Standby', 0, false, false);
    end
  else //turnoff
    begin
    MainForm.ShellExecute(pdebase+'Utils\APM\apm.exe', '', '/Poweroff-', 0, false, false);
    end;
  end
  else
  begin
  ShutDownForm.Show;
  MainForm.ShellExecute('shutdown.exe', '', '', 0, true, true);
  end;

End;}

Procedure TMainForm.imgNotesOnMouseMove (Sender: TObject; Shift: TShiftState;
  X: LongInt; Y: LongInt);
Begin

  if ssLeft in Shift then
    begin
    pnlNotes.Left := pnlNotes.Left - notesX + X;
    pnlNotes.Top := pnlNotes.Top + NotesY - Y;
    end;

End;

Procedure TMainForm.imgNotesOnMouseDown (Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X: LongInt; Y: LongInt);
Begin

  notesX := X;
  notesY := Y;

End;

Procedure TMainForm.mNotesOnClick (Sender: TObject);
Begin

  {quick notes window}
  //pnlNotes.Visible := not (pnlNotes.Visible);
  {quick notes v.2}
  NotesForm.Show;

End;

//-----------------------------------------
// ப (᮫)

Procedure TMainForm.mOS2windowOnClick (Sender: TObject);
Begin
//OS/2 VIO
  ShellExecute('cmd.exe', '', '', 2, true, true);
End;

Procedure TMainForm.mOS2fullscreenOnClick (Sender: TObject);
Begin
//OS/2
  ShellExecute('cmd.exe', '', '', 1, true, true);
End;

Procedure TMainForm.mDOSwindowOnClick (Sender: TObject);
Begin
//VDM window
  ShellExecute('command.com', '', '', 7, true, true);
End;

Procedure TMainForm.mDOSfullscreenOnClick (Sender: TObject);
Begin
//VDM
  ShellExecute('command.com', '', '', 4, true, true);
End;

Procedure TMainForm.mWINwindowOnClick (Sender: TObject);
Begin
//seamless WIN window
  ShellExecute('win.com', '', '', 7, true, true);
End;

Procedure TMainForm.mWINfullscreenOnClick (Sender: TObject);
Begin
//seamless WIN
  ShellExecute('winos2.com', '', '', 4, true, true);
End;
//-----------------------------------------

//-----------------------------------------
//१㧪 䠩 䨣樨
Procedure TMainForm.mReloadSettingsOnClick (Sender: TObject);
var
  afile: TextFile;
  fcapt: string;
  //fcolor: longint;
  flt: integer;
  //rez: integer;
  //sr: TSearchRec;
  i: integer;
//  tmppict: TBitmap;
Begin

if diCount>0 then
  for i:=1 to diCount do
    begin
    di[i].di.free;
    di[i].dc.free;
    end;

diCount:=0;
wallpaper_present := false;

//ShowMessage('Loaded...');

//formpicture.free;
//formpicture := nil;
if formpicture = nil then
  formpicture:=TPicture.Create(MainForm); //㭮 䮭
  //tmppict := TBitmap.Create;

//desktop color
mainform.color := pdeLoadCfgColor('pdm.cfg', 'desktopcolor');
secondcolor := pdeLoadCfgColor('pdm.cfg', 'secondcolor');
//desktop image
wallpaper := pdeLoadCfgStr('pdm.cfg', 'wallpaper');
//wallpaperstyle := 'stretch';
wallpaperstyle := pdeLoadCfgStrD('pdm.cfg', 'wallpaperstyle', 'stretch');
if (wallpaperstyle <> 'vgradient') then
  begin
  if fileexists(wallpaper) or fileexists(pdebase+wallpaper) then
    begin
    try
      if (wallpaper[2] = ':') then
        formpicture.bitmap.loadfromfile(wallpaper)
      else
        formpicture.bitmap.loadfromfile(pdebase+wallpaper);

      wallpaper_present:=true;
      except
      formpicture.destroy;
      formpicture := nil;
      //tmppict.free;
      wallpaper_present:=false;
      end;
    //formpicture.bitmap.width:=MainForm.Width;
    //formpicture.bitmap.height:=MainForm.Height;
    //formpicture.bitmap.canvas.stretchdraw(0, 0, MainForm.Width, MainForm.Height, tmppict);
    //MainForm.canvas.draw(0, 0, formpicture.graphic);
    //MainForm.canvas.stretchdraw(0, 0, MainForm.Width, MainForm.Height, formpicture.graphic);

    //wallpaper_present:=true;
    end
  else
    begin
    formpicture.destroy;
    formpicture := nil;
    //tmppict.free;
    wallpaper_present:=false;
    end;
  end;
  //tmppict.free;
//screensaver
screensaver := pdeLoadCfgStr('pdm.cfg', 'screensaver');
//time for screensaver
savertime := pdeLoadCfgInt('pdm.cfg', 'savertime');

assignfile(afile, pdebase+'PDEConf\desktop.progs');
reset(afile);
readln(afile);readln(afile);

//MessageBox('x  横', mtInformation, [mbOK]);

while not(eof(afile)) do
  Begin
  inc(diCount);
  //if di[diCount].di=nil then
    di[diCount].di:=TDImage.Create(self);
  di[diCount].di.parent:=MainForm;
  di[diCount].di.width:=pdeLoadCfgIntD('pdm.cfg','iconsize', 32)+2;
  di[diCount].di.height:=di[diCount].di.width;
  di[diCount].di.num:=diCount;
  if (wallpaper_present) and (formpicture <> nil) then
    di[diCount].di.pict:=formpicture
  else
    di[diCount].di.pict:=nil;
  di[diCount].di.OnClick:=diOnClick;
  di[diCount].di.OnDblClick:=diOnDblClick;
  di[diCount].di.DragMode:=dmAutomatic;
  //if di[diCount].dc=nil then
    di[diCount].dc:=TDLabel.Create(self);
  di[diCount].dc.parent:=MainForm;
  di[diCount].dc.PenColor:=clWhite;//not(MainForm.Color);

  readln(afile, di[diCount].dtype);
  readln(afile, fcapt);
  di[diCount].dc.caption:=fcapt;
  readln(afile, di[diCount].dimage);
  try
    if (di[diCount].dimage[2] = ':') then
      di[diCount].di.picture.loadfromfile(di[diCount].dimage)
    else
      di[diCount].di.picture.loadfromfile(pdebase+di[diCount].dimage);
  except
    di[diCount].di.bitmap:=imgNone.Picture.bitmap;
    end;
  readln(afile, flt);
  di[diCount].di.left:=flt;
  readln(afile, flt);
  di[diCount].di.top:=flt;

  di[diCount].dc.AutoSize:=True;
  di[diCount].dc.left:=di[diCount].di.left+(di[diCount].di.Width-di[diCount].dc.Width) div 2;
  di[diCount].dc.top:=di[diCount].di.top+di[diCount].di.height+5;

  readln(afile, di[diCount].dname);
  readln(afile, di[diCount].dpath);
  readln(afile, di[diCount].dparam);  //ࠬ ᪠ (易⥫쭮)
  di[diCount].ses_type:=0;
  readln(afile, di[diCount].ses_type); //⨯ ᨨ (易⥫쭮)
//  MessageBox('㦥 '+IntToStr(diCount), mtInformation, [mbOK]);
  End;
closefile(afile);

//--reload language--
caption := pdeLoadNLS('pdeDesktop', '稩 ⮫');
mRefresh.caption := pdeLoadNLS('RefreshButton', '');
mAlignIcons.caption := pdeLoadNLS('pdmAlignIcons', '஢ 窨');
mGroupIcons.caption := pdeLoadNLS('pdmGroupIcons', '冷 窨');
mSetup.caption := pdeLoadNLS('pdmSetup', '⢠');
mReloadSettings.caption := pdeLoadNLS('pdmReloadCfg', ' ன');
mScreenSaver.caption := pdeLoadNLS('pdmScreenSaver', '࠭⥫ ࠭');
mNotes.caption := pdeLoadNLS('pdmNotes', ' ᪨');
mShootSystem.caption := pdeLoadNLS('pdmShutdown', ' ⥬');
mNew.caption := pdeLoadNLS('menuCreateNew', ' ');
mNewObject.caption := pdeLoadNLS('pdmObject', '쥪');
mCmd.caption := pdeLoadNLS('pdmCommandWindow', ' ப');
mOS2window.caption := pdeLoadNLS('pdmOS2win', 'OS/2-');
mOS2fullscreen.caption := pdeLoadNLS('pdmOS2full', 'OS/2-');
mDOSwindow.caption := pdeLoadNLS('pdmDOSwin', 'DOS-');
mDOSfullscreen.caption := pdeLoadNLS('pdmDOSfull', 'DOS-');
mWINwindow.caption := pdeLoadNLS('pdmWINwin', 'Win-');
mWINfullscreen.caption := pdeLoadNLS('pdmWINfull', 'Win-');
mAbout.caption := pdeLoadNLS('menuAbout', 'ଠ  த');

NotesForm.Caption := mNotes.caption;

End;
//--mReloadSettings-------------------------

Procedure TMainForm.mAlignIconsOnClick (Sender: TObject);
var
  isize, i, dx, dy: integer;
Begin
  //ࠢ 窮 iconsize  2
  isize := pdeLoadCfgIntD('pdm.cfg', 'iconsize', 32);
if diCount>0 then
  for i:=1 to diCount do
    begin
    dx:=di[i].di.left mod isize*2;
    if dx>isize then
      di[i].di.left:=di[i].di.left+isize*2-dx
      else
      di[i].di.left:=di[i].di.left-dx;
    if di[i].di.left<isize then di[i].di.left:=isize;
    dy:=di[i].di.top mod isize*2;
    if dy>isize then
      di[i].di.top:=di[i].di.top+isize*2-dy
      else
      di[i].di.top:=di[i].di.top-dy;
    if di[i].di.top<isize then di[i].di.top:=isize;

    di[i].dc.left:=di[i].di.left+(di[i].di.Width-di[i].dc.Width) div 2;
    di[i].dc.top:=di[i].di.top+di[i].di.height+5;
    di[i].di.Refresh;
    end;
End;

Procedure TMainForm.mGroupIconsOnClick (Sender: TObject);
var
  isize, i, j, h: Integer;
Begin
//㯮冷 窨
isize := pdeLoadCfgIntD('pdm.cfg', 'iconsize', 32);
h:=Screen.Height-Screen.Height mod isize*2;
j:=0;

if diCount>0 then
  for i:=1 to diCount do
    begin
    if (i*isize*2-j*h)>=h then
      inc(j);
    di[i].di.top:=i*isize*2-j*h;
    di[i].di.left:=isize+j*isize*2;

    di[i].dc.left:=di[i].di.left+(di[i].di.Width-di[i].dc.Width) div 2;
    di[i].dc.top:=di[i].di.top+di[i].di.height+5;
    di[i].di.Refresh;
    end;
End;

Procedure TMainForm.MenuItem5OnClick (Sender: TObject);
var
  about, authors, thanks: String;
  afile: TextFile;
  cptn, text, licensefile: String;
  logo: LongInt;
  prms: array[1..24] of ULONG;
  sz: integer;
Begin

//product information
//⮡ࠦ   ଠ樥  .
sz:=SizeOf(prms[1]);
prms[6]:=WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN); //screen.width
prms[7]:=WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
DosQuerySysInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE,               prms[12], sz);
DosQuerySysInfo(QSV_VERSION_MAJOR, QSV_VERSION_MAJOR,         prms[16], sz);
DosQuerySysInfo(QSV_VERSION_MINOR, QSV_VERSION_MINOR,         prms[17], sz);
DosQuerySysInfo(QSV_VERSION_REVISION, QSV_VERSION_REVISION,   prms[18], sz);
DosQuerySysInfo(QSV_TOTPHYSMEM, QSV_TOTPHYSMEM,               prms[20], sz);
DosQuerySysInfo(QSV_TOTRESMEM, QSV_TOTRESMEM,                 prms[21], sz);
DosQuerySysInfo(QSV_TOTAVAILMEM, QSV_TOTAVAILMEM,             prms[22], sz);
//ଠ  த
  about := pdebase+'~ABOUT';
  AssignFile(afile, about);
  Rewrite(afile);

  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.20');
  Writeln(afile, '');
  Writeln(afile, pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  Writeln(afile, pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  Writeln(afile, '');
  Writeln(afile, 'OS/2 Warp '+floattostrf(prms[17]/10, ffFixed, 2, 1)+' ( '+inttostr(prms[16])+'.'+inttostr(prms[17])+' )');
  Writeln(afile, pdeLoadNLS('pdeDescription8', '⥬ :')+' '+chr(64+prms[12])+':\OS2\');
  Writeln(afile, pdeLoadNLS('pdeDescription9', '᪠ :')+' '+inttostr(prms[20] div (1024*1024))+'');
  Writeln(afile, pdeLoadNLS('pdeDescription10', '०:')+' '+inttostr(prms[6])+'x'+inttostr(prms[7]));

  CloseFile(afile);

  authors := pdebase+'AUTHORS';
  thanks := pdebase+'THANKS';
  cptn := pdeLoadNLS('dlgAboutProgram', 'ଠ  த');
  text := pdeLoadNLS('pdeDesktop', '稩 ⮫');
  licensefile := pdebase+'COPYING';
  logo := MainForm.Icon.Handle;
  pdeAboutDialogS(about, authors, thanks, cptn, text, licensefile, logo);

End;

Procedure TMainForm.MainFormOnCloseQuery (Sender: TObject; Var CanClose: Boolean);
var
  afile: TextFile;
  i: Integer;
  cfgdata: TStringList;
Begin

if LoggedOn then
  Begin
{save desktop items on exit}
Assignfile(afile, pdebase+'PDEConf\desktop.progs');
Rewrite(afile);
Writeln(afile, '//Objects on the Desktop, format of record is:');
Write(afile, '//type, caption, icon (full path or path from \..\pde\), X, Y, filename, path, parameters');
if diCount>0 then
for i:=1 to diCount do
  begin
  Writeln(afile);
  Writeln(afile, di[i].dtype);
  Writeln(afile, di[i].dc.caption);
  Writeln(afile, di[i].dimage);
  Writeln(afile, di[i].di.left);
  Writeln(afile, di[i].di.top);
  Writeln(afile, di[i].dname);
  Writeln(afile, di[i].dpath);
  Writeln(afile, di[i].dparam);
  Write(afile, di[i].ses_type);
  end;

  Closefile(afile);

    cfgdata := TStringList.Create;
    cfgdata.Add('//config file of the PDE desktop manager (pdm.exe)');
    cfgdata.Add('iconsize='+pdeLoadCfgStrD('pdm.cfg','iconsize', '32'));
    cfgdata.Add('//desktop color');
    cfgdata.Add('desktopcolor='+IntToStr(Mainform.color));
    cfgdata.Add('secondcolor='+IntToStr(secondcolor));
    cfgdata.Add('//wallpaper (full path or path from \..\pde\)');
    cfgdata.Add('wallpaper='+Wallpaper);
    cfgdata.Add('//center, tile, stretch, vgradient, lefttop, righttop, leftbottom, rightbottom');
    cfgdata.Add('wallpaperstyle='+wallpaperstyle);
    cfgdata.Add('//Screen-saver application');
    cfgdata.Add('screensaver='+screensaver);
    cfgdata.Add('//Time (msec) for screen-saver');
    cfgdata.Add('savertime='+pdeLoadCfgStrD('pdm.cfg', 'savertime', '300000'));
    pdeSaveCfgFile('pdm.cfg', cfgdata);
    cfgdata.free;


  {if pnlNotes.Visible then
    memoNotes.Lines.Add(';-)');
  memoNotes.Lines.SaveToFile(pdebase
    +pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home')
    +'\quicknotes.txt');
  }
  { save quick notes to the file }
  if NotesEnabled then
    NotesForm.List.Lines.Add(';-)');
  NotesForm.List.Lines.SaveToFile(pdebase
    +pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home')
    +'\quicknotes.txt');
  End;
CanClose:=True;

End;

Procedure TMainForm.mNewObjectOnClick (Sender: TObject);
Begin
//ᮧ  窠  ࠡ祬 ⮫
NewForm.Show;
NewForm.BringToFront;
End;

Procedure TMainForm.MainFormOnCreate (Sender: TObject);
Begin
//
pdebase := ExtractFilePath(Application.ExeName);

MainForm.BorderStyle:=bsStealth; //      ᯨ᪥ 

WinSetSysValue(HWND_DESKTOP, SV_CXICON, 32);
WinSetSysValue(HWND_DESKTOP, SV_CYICON, 32);

//
caption := pdeLoadNLS('pdeDesktop', '稩 ⮫');
mRefresh.caption := pdeLoadNLS('RefreshButton', '');
mAlignIcons.caption := pdeLoadNLS('pdmAlignIcons', '஢ 窨');
mGroupIcons.caption := pdeLoadNLS('pdmGroupIcons', '冷 窨');
mSetup.caption := pdeLoadNLS('pdmSetup', '⢠');
//mProperties.caption := pdeLoadNLS('pdmConfigFile', ' 䨣樨');
mReloadSettings.caption := pdeLoadNLS('pdmReloadCfg', ' ன');
mScreenSaver.caption := pdeLoadNLS('pdmScreenSaver', '࠭⥫ ࠭');
mNotes.caption := pdeLoadNLS('pdmNotes', ' ᪨');
mShootSystem.caption := pdeLoadNLS('pdmShutdown', ' ⥬');
mNew.caption := pdeLoadNLS('menuCreateNew', ' ');
mNewObject.caption := pdeLoadNLS('pdmObject', '쥪');
mCmd.caption := pdeLoadNLS('pdmCommandWindow', ' ப');
mOS2window.caption := pdeLoadNLS('pdmOS2win', 'OS/2-');
mOS2fullscreen.caption := pdeLoadNLS('pdmOS2full', 'OS/2-');
mDOSwindow.caption := pdeLoadNLS('pdmDOSwin', 'DOS-');
mDOSfullscreen.caption := pdeLoadNLS('pdmDOSfull', 'DOS-');
mWINwindow.caption := pdeLoadNLS('pdmWINwin', 'Win-');
mWINfullscreen.caption := pdeLoadNLS('pdmWINfull', 'Win-');
mAbout.caption := pdeLoadNLS('menuAbout', 'ଠ  த');

End;

Procedure TMainForm.MainFormOnClick (Sender: TObject);
var
  i: integer;
Begin
if diCount>0 then
  for i:=1 to diCount do
    begin
    if (di[i].di.selected) then di[i].di.selected:=false;
    di[i].di.Refresh;
    di[i].dc.Refresh;
    end;
End;

Procedure TMainForm.mPropertiesOnClick (Sender: TObject);
Begin
//⨥ 䠩 䨣樨 祣 ⮫
//  ShellExecute('e.exe', '', extractfilepath(application.exename)+'pdeConf\pdm.cfg', 0, false);
End;

Procedure TMainForm.MenuItem9OnClick (Sender: TObject);
Begin
// ணࠬ ன DE
//ShellExecute(extractfilepath(application.exename)+'pdeConf.exe', extractfilepath(application.exename), '', 0, false);
  if pdmCfgShow(wallpaper) = 0 then
    begin
    //configuratrion changed, need reload it
    mReloadSettingsOnClick(Sender);
    end;
End;

Procedure TMainForm.MenuItem10OnClick (Sender: TObject);
Begin

BringToFront;

if (screensaver<>'') then
  begin
  //idletime:=0;
  //Timer1.Stop;
  if (screensaver[2] = ':') then  //full path
    ShellExecute(screensaver, extractfilepath(screensaver), '', 1, false, true)
  else
    ShellExecute(extractfilepath(application.exename)+screensaver, extractfilepath(application.exename), '', 1, false, true);
  //Timer1.Start;
  //ShowMessage(screensaver);
  end;

End;

Procedure TMainForm.mShootSystemOnClick (Sender: TObject);
var
  can: Boolean;
Begin
  //⨥ ⥬
  pdeShutdownDlg;
{if pdeLoadCfgInt('general.cfg', 'askforshutdown') = 1 then
  begin
  LogoutForm.ShowModal;
  if Request = 1 then
    begin  //turn off
    ShutDownForm.Show;
    APMShutdown('turnoff');
    end
    else if Request = 2 then
    begin //suspend
    APMShutdown('suspend');
    end
    else if Request = 3 then
    begin //standby
    APMShutdown('standby');
    end;
  end
  else
  begin
  //MainFormOnCloseQuery(Sender, can);
  ShutDownForm.Show;
  APMShutdown('turnoff');
  end;
}

End;

Procedure TMainForm.MainFormOnDestroy (Sender: TObject);
Begin
  //᢮ ⨭  䮭 ⮯
  formpicture.destroy;
  formpicture := nil;
End;

Procedure TMainForm.MainFormOnPaint (Sender: TObject; Const rec: TRect);
var
  __i, __j: Integer;
  //for gradient
  DRed,DGreen,DBlue,DR,DG,DB:Extended;
  StartLoop,EndLoop:LONGINT;
  rect:TRect;
  x, y, dy: Integer;
  s: String;
Begin
//᫨  ,  㥬   ⮯
//Canvas.Brush.Mode := bmOpaque;
Canvas.Pen.Width := 1;
if (wallpaper_present) and (formpicture <> nil) then
  begin
  if (wallpaperstyle = 'center') then
      begin
      if (formpicture.width < MainForm.Width) or (formpicture.Height < MainForm.Height) then
        MainForm.canvas.FillRect(MainForm.ClientRect, MainForm.Color);
      MainForm.canvas.draw((Width -  formpicture.width) div 2
        ,(Height -  formpicture.height) div 2, formpicture.graphic)
      end
    else if (wallpaperstyle = 'tile') then
      begin
      __j := 0;
      repeat
        __i := 0;
        repeat
        MainForm.canvas.draw( __i, __j, formpicture.graphic);
        __i := __i + formpicture.width;
        until __i > Width;
      __j := __j + formpicture.height;
      until __j > Height;
      end
    else if (wallpaperstyle = 'lefttop') then
      begin
      if (formpicture.width < MainForm.Width) or (formpicture.Height < MainForm.Height) then
        MainForm.canvas.FillRect(MainForm.ClientRect, MainForm.Color);
      MainForm.canvas.draw(0, Height -  formpicture.height, formpicture.graphic)
      end
    else if (wallpaperstyle = 'righttop') then
      begin
      if (formpicture.width < MainForm.Width) or (formpicture.Height < MainForm.Height) then
        MainForm.canvas.FillRect(MainForm.ClientRect, MainForm.Color);
      MainForm.canvas.draw(Width -  formpicture.width, Height -  formpicture.height, formpicture.graphic)
      end
    else if (wallpaperstyle = 'leftbottom') then
      begin
      if (formpicture.width < MainForm.Width) or (formpicture.Height < MainForm.Height) then
        MainForm.canvas.FillRect(MainForm.ClientRect, MainForm.Color);
      MainForm.canvas.draw(0 ,0, formpicture.graphic)
      end
    else if (wallpaperstyle = 'rightbottom') then
      begin
      //MainForm.canvas.FillRect(MainForm.ClientRect, MainForm.Color);
      if (formpicture.width < MainForm.Width) or (formpicture.Height < MainForm.Height) then
        MainForm.canvas.FillRect(Rec, MainForm.Color);
      MainForm.canvas.draw(Width -  formpicture.width, 0, formpicture.graphic)
      end
    else //stretch
      MainForm.canvas.stretchdraw(0, 0, Width, Height, formpicture.graphic);
  end
else if (wallpaperstyle = 'vgradient') then
  begin //  - ⨪ ࠤ
  DRed:=TRGB(Mainform.color).Red;
  DGreen:=TRGB(Mainform.color).Green;
  DBlue:=TRGB(Mainform.color).Blue;
  DR:=TRGB(secondcolor).Red-DRed;
  DG:=TRGB(secondcolor).Green-DGreen;
  DB:=TRGB(secondcolor).Blue-DBlue;
  DR:=DR / Height;
  DG:=DG / Height;
  DB:=DB / Height;
  StartLoop:=Height;
  EndLoop:=-1;
  WHILE StartLoop<>EndLoop DO
    BEGIN
    rect.Left:=0;
    rect.Right:=Width;
    rect.Bottom:=StartLoop;
    rect.Top:=rect.Bottom+1;

    Canvas.FillRect(rect,ValuesToRGB(Round(DRed),Round(DGreen),Round(DBlue)));

    DRed:=DRed+DR;
    DGreen:=DGreen+DG;
    DBlue:=DBlue+DB;
    dec(StartLoop);
    END;
  end
else
  MainForm.canvas.FillRect({MainForm.canvas.ClipRect} ClientRect, MainForm.Color);

  {᫨ 祭   (NotesEnabled),  㥬   ⮯}
  if NotesEnabled then
    begin
    Canvas.Pen.Width := 2;
    Canvas.Pen.Color := $00777777;
    Canvas.Pen.Mode := pmMerge;
    Canvas.Brush.Mode := bmTransparent;

    Canvas.MoveTo(2*Width div 3, 1);
    Canvas.LineTo(Width - 1, 1);
    Canvas.LineTo(Width - 1, Height - 1);
    Canvas.LineTo(2*Width div 3, Height - 1);
    Canvas.LineTo(2*Width div 3, 1);

    Canvas.TextOut( 2*Width div 3 + 5, Height - 25, mNotes.caption);
    Canvas.MoveTo(2*Width div 3 + 5, Height - 27);
    Canvas.LineTo(Width - 5, Height - 27);

    x := 2*Width div 3 + 5;
    y := Height - 30 - 25;
    dy := Canvas.TextHeight('A');
    if NotesForm.List.Lines.Count > 0 then
      for __i := 0 to NotesForm.List.Lines.Count - 1 do
      begin
        s := NotesForm.List.Lines[__i];
        if s[1] = '>' then
          begin
          delete(s, 1, 1);
          Canvas.TextOut( x, y, '>');
          end
        else if s[1] = '?' then
          begin
          delete(s, 1, 1);
          Canvas.TextOut( x, y, '!');
          end
        else if s[1] = '!' then
          begin
          delete(s, 1, 1);
          Canvas.TextOut( x, y, '!');
          end;
          Canvas.TextOut( x + 10, y, s);
        y := y - dy;
      end;
    end;

End;

Procedure TMainForm.MouseDown(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);
Begin
  SendToBack;
End;

Procedure TDImage.MouseDown(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);
Begin

End;

Procedure TDLabel.MouseDown(Button:TMouseButton;ShiftState:TShiftState;X,Y:LongInt);
Begin

End;

Procedure TDImage.Redraw(Const rec:TRect);
var
  //i, j: integer;
  //l, t, w, h: integer;
  //trcolor: TColor;
  rec1, rec2: TRect;
  CMode:TBitBltMode;
  //ps_mem, ps_bmp: HPS;
  //dc_mem: HDC;
  //size: SIZEL;
  //Rect, srcR: RectL;
  //aptl: array[0..1] of TRect;
  //aptl: array[0..2] of PointL;

  __i, __j: Integer;
  DRed,DGreen,DBlue,DR,DG,DB:Extended;
  StartLoop,EndLoop:LONGINT;
  rect:TRect;
Begin

rec2.Left:=0; rec2.right:=width;
rec2.Top:=height; rec2.bottom:=0;
rec1.Left:=left; rec1.right:=left+width;
rec1.Top:=screen.height-top; rec1.bottom:=rec1.Top-height;
if pict<>nil then
    begin
    {formbitmap := TBitmap.Create;
    formbitmap.height := screen.height;
    formbitmap.width := screen.width;
    formbitmap.Canvas.StretchDraw(0, 0, formbitmap.width, formbitmap.height, formpicture.graphic);
    formbitmap.Canvas.CopyRect(rec2, canvas, rec1)
    formbitmap.Free;}
    {dc_mem := DevOpenDC(AppHandle, od_memory, '*', 0, nil, 0);
    size.cx := screen.width;
    size.cy := screen.height;
    ps_mem := GpiCreatePS(AppHandle, dc_mem, size, gpia_Assoc or pu_Pels);
    Rect.xLeft := 0;
    Rect.xRight := TForm(Parent).Width-1;
    Rect.yBottom := 0;
    Rect.yTop := TForm(Parent).Height-1;
    WinFillRect(ps_mem, Rect, TForm(Parent).Color);
    srcR.xLeft := 0;
    srcR.xRight := pict.Width - 1;
    srcR.yBottom := 0;
    srcR.yTop := pict.Height - 1;
    }
      {WinDrawBitmap(ps_mem, pict.bitmap.handle, srcR, Rect, 0, 0, DBM_STRETCH);
      //aptl[0] := rec2;
      //aptl[1] := rec1;
      aptl[0].x := 0;
      aptl[0].y := 0;
      aptl[1].x := width-1;
      aptl[1].y := height-1;
      aptl[2].x := left;
      aptl[2].y := screen.height-top-height;

      GpiBitBlt(canvas.handle, ps_mem, 3, aptl[0], ROP_SRCCOPY, BBO_IGNORE);
     ps_mem <> 0 Then GpiDestroyPS(ps_mem);
    If dc_mem <> 0 Then DevCloseDC(dc_mem);}

    //pict.bitmap.Canvas.CopyRect(rec2, canvas, rec1)

    //we have wallpaper image
    Canvas.FillRect(canvas.cliprect, TForm(Parent).Color);
    if (wallpaperstyle = 'center') then
      begin
      Canvas.draw(-Left + (TForm(Parent).Width -  pict.width) div 2
        ,Top + Height - pict.height - (TForm(Parent).Height -  pict.height) div 2, pict.graphic)
      end
    else if (wallpaperstyle = 'tile') then
      begin
      __j := 0;
      repeat
        __i := 0;
        repeat
        //if __j<>0 then
          //canvas.draw( __i - Left, __j +
          //  Top + Height - TForm(Parent).Height + pict.height, pict.graphic)
          //else
          canvas.draw( __i - Left, __j - Bottom, pict.graphic);
        __i := __i + pict.width;
        until __i > TForm(Parent).Width;
      __j := __j + pict.height;
      until __j > TForm(Parent).Height;
      end
    else if (wallpaperstyle = 'lefttop') then
      begin
      canvas.draw(-Left ,Top + Height - TForm(Parent).Height + pict.height, pict.graphic)
      end
    else if (wallpaperstyle = 'righttop') then
      begin
      canvas.draw(TForm(Parent).Width - pict.width - Left
        ,Top + Height - TForm(Parent).Height + pict.height , pict.graphic)
      end
    else if (wallpaperstyle = 'leftbottom') then
      begin
      canvas.draw(-Left, -Bottom, pict.graphic)
      end
    else if (wallpaperstyle = 'rightbottom') then
      begin
      canvas.draw(TForm(Parent).Width - pict.width -Left, -Bottom, pict.graphic)
      end
    else //stretch
      canvas.stretchdraw(-Left, -Bottom, TForm(Parent).Width, TForm(Parent).Height, pict.graphic);

    end
  else if (wallpaperstyle = 'vgradient') then
    begin
    //Canvas.FillRect(canvas.cliprect, TForm(Parent).Color);

    DRed:=TRGB(Mainform.color).Red;
    DGreen:=TRGB(Mainform.color).Green;
    DBlue:=TRGB(Mainform.color).Blue;
    DR:=TRGB(secondcolor).Red-DRed;
    DG:=TRGB(secondcolor).Green-DGreen;
    DB:=TRGB(secondcolor).Blue-DBlue;
    DR:=DR / Mainform.Height;
    DG:=DG / Mainform.Height;
    DB:=DB / Mainform.Height;
    StartLoop:=Height;
    EndLoop:=-1;
    DRed:=DRed+DR*Top;
    DGreen:=DGreen+DG*Top;
    DBlue:=DBlue+DB*Top;

    WHILE StartLoop<>EndLoop DO
      BEGIN
      rect.Left:=0;
      rect.Right:=Width;
      rect.Bottom:=StartLoop;
      rect.Top:=rect.Bottom+1;

      Canvas.FillRect(rect,ValuesToRGB(Round(DRed),Round(DGreen),Round(DBlue)));

      DRed:=DRed+DR;
      DGreen:=DGreen+DG;
      DBlue:=DBlue+DB;
      dec(StartLoop);
      //inc(EndLoop);
      END;

    end
  else
    Canvas.FillRect(canvas.cliprect, TForm(Parent).Color);

rec1:=ClientRect;
InflateRect(rec1, -1, -1);
if icon<>nil then
  begin
  OffsetRect(rec1, 1, -1);
  CMode := icon.Canvas.CopyMode;
  icon.Canvas.CopyMode := cmBlackness;
  icon.draw(Canvas, rec1);
  OffsetRect(rec1, -1, 1);
  icon.Canvas.CopyMode := CMode;
  icon.draw(Canvas, rec1);
  end
else if bitmap<>nil then
  bitmap.draw(Canvas, rec1);

{l:=Left;
t:=Bottom;//Top;
w:=Width;
h:=Height;
trcolor:=canvas.pixels[0, 0];
  for i:=0 to h-1 do
    for j:=0 to w-1 do
      begin
      if (canvas.pixels[j, i]=trcolor) then //bingo!!!
        //if not(selected) then
          if pict.bitmap<>nil then
          Canvas.Pixels[j, i]:=pict.bitmap.Canvas.Pixels[j+l, i+t]//TForm(Parent).Canvas.Pixels[j+l, t+i]
          //Canvas.Pixels[j, i]:=graphic.canvas.pixels[j, i];
            //pict.bitmap.Canvas.Pixels[j+l, i+t]
        else
          Canvas.Pixels[j, i]:=TForm(Parent).Color;
      end;
}
if (selected) then
  Begin
  rec1:=ClientRect;
  //InflateRect(rec1, -1, -1);
  Canvas.DrawFocusRect(Rec1);
  End;
//inherited redraw(rec);
End;

Procedure TMainForm.mRefreshOnClick (Sender: TObject);
var
  i: integer;
Begin
if diCount>0 then
  for i:=1 to diCount do
  begin
    di[i].di.Refresh;
    di[i].dc.Refresh;
  End;
End;

Procedure TMainForm.diOnDblClick (Sender: TObject);
var
  n: integer;
Begin
n:=TDImage(Sender).num;
 if (di[n].dtype='FOLDER') then
   Begin
   if (di[n].dname[2] = ':') then  //full path
     ShellExecute(pdebase+'FileHalf.exe', pdebase, di[n].dname, 0, false, true)
   else
     ShellExecute(pdebase+'FileHalf.exe', pdebase, pdebase+di[n].dname, 0, false, true);
   End
 else if (di[n].dtype='APP') then
   Begin
   if (di[n].dname[2] = ':') then  //full path
     ShellExecute(di[n].dname, di[n].dpath, di[n].dparam, di[n].ses_type, true, true)
   else
     ShellExecute(pdebase+di[n].dname, pdebase+di[n].dpath, di[n].dparam, di[n].ses_type, true, true);

   end
 else if (di[n].dtype='SHORTCUT') then
   ;
End;

Procedure TMainForm.imgOnClick (Sender: TObject);
//var
//  i: integer;
Begin

End;

Procedure TMainForm.diOnClick (Sender: TObject);
var
  i: integer;
Begin
//di[TDImage(Sender).num].dc.color:=clBlue;
//MainForm.SendToBack;
if diCount>0 then
  for i:=1 to diCount do
  begin
    if di[i].di.selected then di[i].di.selected:=false;
    di[i].di.refresh;
    di[i].dc.refresh;
  end;
di[TDImage(Sender).num].di.selected:=true;
di[TDImage(Sender).num].di.refresh;
End;

Procedure TMainForm.imgOnDragDrop (Sender: TObject; Source: TObject; X: LongInt; Y: LongInt);
var
  n: integer;
  SharedMem:PDragDropInfo;
  Temp:^String;
  fsrc: cstring;
  src: string;
  sr2: TSearchRec;
  afile: TextFile;
  basepath: String;
  ext: String;
Begin

  {draging of DesktopItems}
  if (Source is TDImage) then begin
  n:=TDImage(Source).num;
  TDImage(Source).Left:=x-15;
  TDImage(Source).Top:=screen.height-y-15;
  di[n].dc.left:=di[n].di.left+(di[n].di.Width-di[n].dc.Width) div 2;
  di[n].dc.top:=di[n].di.top+di[n].di.height+5;
  di[n].di.invalidate;
  di[n].dc.invalidate;
  end
  {exe/folder from FileHalf}
  else if ((Source Is TExternalDragDropObject)And
        (TExternalDragDropObject(Source).SourceType=drtString)And
        (TExternalDragDropObject(Source).SourceString=DragSourceId)) then
  begin //FileHalf try to drop shortcut on us, gotcha!!!
      If not AccessNamedSharedMem(TExternalDragDropObject(Source).SourceFileName,
                                   SharedMem) Then exit;  //some error
      Temp:=@SharedMem^.Items;
      fsrc:=Temp^;
      src:=fsrc;  // 䠩  

  ext := lowercase(ExtractFileExt(src));
  if (ext = '.bmp') or (ext = '.jpg') or (ext = '.jpe') or (ext = '.jpeg')
    or (ext = '.gif') or (ext = '.pcx') or (ext = '.tif') or (ext = '.tiff')
    or (ext = '.tga') then
    Begin //time to change Wallpaper

    if ext <> '.bmp' then
      src := LoadGBM(src);
    wallpaper := src;

    if (wallpaperstyle = 'vgradient') then
      wallpaperstyle := 'center';
    if fileexists(wallpaper) then
    begin
    wallpaper_present:=true;
    try
      formpicture.bitmap.loadfromfile(wallpaper)
      except
      formpicture.destroy;
      formpicture := nil;
      wallpaper_present:=false;
      end;
    end;

    //each process must free the shared memory !!
    FreeNamedSharedMem(TExternalDragDropObject(Source).SourceFileName);
    Invalidate;
    exit;
    End;

      basepath := pdebase + '\PDEConf\';

  inc(diCount);
  di[diCount].di:=TDImage.Create(self);
  di[diCount].di.parent:=MainForm;
  di[diCount].di.width:=pdeLoadCfgIntD('pdm.cfg','iconsize', 32)+2;
  di[diCount].di.height:=di[diCount].di.width;
  di[diCount].di.num:=diCount;
  if wallpaper_present then
    di[diCount].di.pict:=formpicture
  else
    di[diCount].di.pict:=nil;
  di[diCount].di.OnClick:=diOnClick;
  di[diCount].di.OnDblClick:=diOnDblClick;
  di[diCount].di.DragMode:=dmAutomatic;
  di[diCount].dc:=TDLabel.Create(self);
  di[diCount].dc.parent:=MainForm;
  di[diCount].dc.PenColor:=clWhite;
  di[diCount].di.left := X;
  di[diCount].di.top := Screen.Height - Y;
  di[diCount].dc.AutoSize:=True;
  di[diCount].dc.left:=di[diCount].di.left+(di[diCount].di.Width
    -di[diCount].dc.Width) div 2;
  di[diCount].dc.top:=di[diCount].di.top+di[diCount].di.height+5;
  di[diCount].dparam := '';  //ࠬ ᪠ (易⥫쭮)
  di[diCount].ses_type := 0;

      AssignFile(afile, basepath + 'desktop.progs');
      Reset(afile);
      Seek(afile, filesize(afile));
      Writeln(afile);

      if (FindFirst(src+'\*.*', faAnyFile, sr2)=0) then
        begin  //directory
        FindClose(sr2);
        Writeln(afile, 'FOLDER');
        Writeln(afile, ExtractFileName(src));
        Writeln(afile, 'bitmaps\pdm\Folder.ico');
        Writeln(afile, IntToStr(X));
        Writeln(afile, IntToStr(Screen.Height - Y));

        di[diCount].dtype := 'FOLDER';
        di[diCount].dc.caption := ExtractFileName(src);

        if src[length(src)]<>'\' then
          src := src + '\';
        Writeln(afile, src);
        Writeln(afile, src);

        di[diCount].dimage := 'bitmaps\pdm\Folder.ico';
        di[diCount].di.picture.loadfromfile(pdebase + di[diCount].dimage);
        di[diCount].dname := src;
        di[diCount].dpath := src;
        end
      else
        begin  //application
        FindClose(sr2);
        Writeln(afile, 'APP');
        Writeln(afile, ExtractFileName(src));
        Writeln(afile, 'bitmaps\pdm\Exec.ico');
        Writeln(afile, IntToStr(X));
        Writeln(afile, IntToStr(Screen.Height - Y));
        Writeln(afile, src);
        Writeln(afile, ExtractFilePath(src));

        di[diCount].dtype := 'APP';
        di[diCount].dc.caption := ExtractFileName(src);
        di[diCount].dimage := 'bitmaps\pdm\Exec.ico';
        di[diCount].di.picture.loadfromfile(pdebase + di[diCount].dimage);
        di[diCount].dname := src;
        di[diCount].dpath := ExtractFilePath(src);
        end;
      Writeln(afile);
      Write(afile, '0');
      CloseFile(afile);

      //each process must free the shared memory !!
      FreeNamedSharedMem(TExternalDragDropObject(Source).SourceFileName);
  end;

End;

Procedure TMainForm.imgOnDragOver (Sender: TObject; Source: TObject; X: LongInt; Y: LongInt; State: TDragState; Var Accept: Boolean);
Begin
  Accept:=(Source is TDImage)
             or ((Source Is TExternalDragDropObject)And
             (TExternalDragDropObject(Source).SourceType=drtString)And
             (TExternalDragDropObject(Source).SourceString=DragSourceId));
End;

Procedure TMainForm.Timer1OnTimer (Sender: TObject);
var
  hwndtop: hwnd;
  enum: henum;
  swp1: SWP;
Begin
//᭠砫 ࠢ塞 ᥡ   
//,⥬ - ஢ 
MainForm.SendToBack;
//WinSetWindowPos(MainForm.Frame.Handle, 0, 0, 0, 0, 0,
//  SWP_SHOW Or SWP_ZORDER);

enum:=WinBeginEnumWindows(HWND_DESKTOP);
hwndTop:=WinGetNextWindow(enum);
while (hwndTop<>0) do
  begin

  WinQueryWindowPos(hwndTop, swp1);

  if (swp1.Fl and SWP_MINIMIZE)<>0 then
    WinShowWindow(hwndTop, false);

  hwndTop:=WinGetNextWindow(enum);

  end;
WinEndEnumWindows(enum);

{idletime:=idletime+Timer1.Interval;
if not(idletime<savertime) and (screensaver<>'') then
  begin
  idletime:=0;
  Timer1.Stop;
  ShellExecute(screensaver, '', '', false, true);
  Timer1.Start;
  end;}
End;

Procedure TMainForm.MainFormOnShow (Sender: TObject);
var
  afile: TextFile;
  fcapt: string;
  //fcolor: longint;
  flt: integer;
  rez: integer;
  sr: TSearchRec;
  ftype, fname, fpath, fparams: String;

  t, t2: String;
Begin

If fileexists(extractfilepath(application.exename)+'PDEConf\pswd.cfg') then
    Begin
    Assignfile(afile, extractfilepath(application.exename)+'PDEConf\pswd.cfg');
    Reset(afile);
    Readln(afile, t);
    Readln(afile, t2);
    CloseFile(afile);

    LoginDlg(t, t2, true, true);
    End;

//if not(LoggedOn) then
//  Application.Terminate;

if FileExists(pdebase+'\Utils\pdelogo.exe') then
  ShellExecute(pdebase+'\Utils\pdelogo.exe', pdebase,
    pdeLoadNLS('OS2_IS_UP_AND_RUNNING', ' OS/2 ⥬ 㦥  ⮢  ࠡ') , 0, false, true);

//⠭ 
//MainForm.BorderStyle:=bsStealth; //      ᯨ᪥ 
NewForm.BorderStyle:=bsStealthDlg;
ShutDownForm.BorderStyle:=bsStealth;
Align:=alClient;
MainForm.SendToBack;
//formpicture.Width:=MainForm.Width;
//formpicture.Height:=MainForm.Height;
//formpicture.Align:=alClient;

savertime:=300000;
formpicture:=TPicture.Create(MainForm); //㭮 䮭
Timer1.Start;  // ⠩
pnlNotes.Left := Width - 120;
pnlNotes.Top := 100;

//desktop color
mainform.color := pdeLoadCfgColor('pdm.cfg', 'desktopcolor');
secondcolor := pdeLoadCfgColor('pdm.cfg', 'secondcolor');
//desktop image
wallpaper := pdeLoadCfgStr('pdm.cfg', 'wallpaper');
//wallpaperstyle := 'stretch';
wallpaperstyle := pdeLoadCfgStrD('pdm.cfg', 'wallpaperstyle', 'stretch');
if (wallpaperstyle <> 'vgradient') then
  begin
  if fileexists(wallpaper) or fileexists(pdebase+wallpaper) then
    begin
    try
      if (wallpaper[2] = ':') then
        formpicture.bitmap.loadfromfile(wallpaper)
      else
        formpicture.bitmap.loadfromfile(pdebase+wallpaper);

      //MainForm.canvas.stretchdraw(0, 0, MainForm.Width, MainForm.Height, formpicture.graphic);
      wallpaper_present:=true;
      except
      formpicture.destroy;
      formpicture := nil;
      wallpaper_present:=false;
      end;
    end
  else
    begin
    formpicture.destroy;
    formpicture := nil;
    end;
  end;

//screensaver
screensaver := pdeLoadCfgStr('pdm.cfg', 'screensaver');
//time for screensaver
savertime := pdeLoadCfgInt('pdm.cfg', 'savertime');

//load desktop items from file
assignfile(afile, pdebase+'PDEConf\desktop.progs');
reset(afile);
readln(afile);
readln(afile);

while not(eof(afile)) do
  Begin
  inc(diCount);
  di[diCount].di:=TDImage.Create(self);
  di[diCount].di.parent:=MainForm;
  di[diCount].di.width:=pdeLoadCfgIntD('pdm.cfg','iconsize', 32)+2;
  di[diCount].di.height:=di[diCount].di.width;
  di[diCount].di.num:=diCount;
  if wallpaper_present then
    di[diCount].di.pict:=formpicture
  else
    di[diCount].di.pict:=nil;
  di[diCount].di.OnClick:=diOnClick;
  di[diCount].di.OnDblClick:=diOnDblClick;
  di[diCount].di.DragMode:=dmAutomatic;
  di[diCount].dc:=TDLabel.Create(self);
  di[diCount].dc.parent:=MainForm;
  di[diCount].dc.PenColor:=clWhite;//not(MainForm.Color);

  readln(afile, di[diCount].dtype);
  readln(afile, fcapt);
  di[diCount].dc.caption:=fcapt;
  readln(afile, di[diCount].dimage);
  try
    if (di[diCount].dimage[2] = ':') then //full path
      di[diCount].di.icon.loadfromfile(di[diCount].dimage)
    else
      di[diCount].di.icon.loadfromfile(pdebase+di[diCount].dimage);
  except
    di[diCount].di.bitmap:=imgNone.Picture.bitmap;
    end;
  readln(afile, flt);
  di[diCount].di.left:=flt;
  readln(afile, flt);
  di[diCount].di.top:=flt;

  di[diCount].dc.AutoSize:=True;
  di[diCount].dc.left:=di[diCount].di.left+(di[diCount].di.Width-di[diCount].dc.Width) div 2;
  di[diCount].dc.top:=di[diCount].di.top+di[diCount].di.height+5;

  readln(afile, di[diCount].dname);
  readln(afile, di[diCount].dpath);
  readln(afile, di[diCount].dparam);
  di[diCount].ses_type:=0;
  readln(afile, di[diCount].ses_type); //⨯ ᨨ (易⥫)
  End;
closefile(afile);

//㧪 ணࠬ   "root\ "
rez:=FindFirst(pdebase+pdeLoadCfgStrD('general.cfg', 'userstartup', '\root\StartUp')
  +'\*.*', faAnyFile{faReadOnly Or faHidden Or faSysFile Or faArchive}, sr);
if rez=0 then
  while rez=0 do
    begin
    rez:=FindNext(sr);
    if rez<>0 then break;
    if (sr.name='..') then continue;
    assignfile(afile, pdebase+pdeLoadCfgStrD('general.cfg', 'userstartup', '\root\StartUp')+'\'+sr.name);
    reset(afile);
    readln(afile, ftype);
    if ftype='[SHORTCUT]' then begin
    readln(afile);
    readln(afile, ftype);
    readln(afile, fname);
    readln(afile, fpath);
    readln(afile, fparams);

    if ftype='APP' then
      ShellExecute(fname, fpath, fparams, 0, true, true)
    else if ftype='FOLDER' then
      ShellExecute(pdebase+'FileHalf.exe', pdebase, fname, 0, true, true)
    else if ftype='PDE' then
      ShellExecute(pdebase+fname, pdebase, fparams, 0, true, true);

      end; // [SHORTCUT]
    closefile(afile);

    end;
FindClose(sr);

  { load quick notes from file }
  if FileExists(pdebase+pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home')
    +'\quicknotes.txt') then
    NotesForm.List.Lines.LoadFromFile(pdebase+pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home')
    +'\quicknotes.txt');
  if NotesForm.List.Lines.IndexOf(';-)') <> -1 then
    begin
    NotesForm.List.Lines.Delete(NotesForm.List.Lines.IndexOf(';-)'));
    NotesEnabled := True;
    end;

End;

function TMainForm.ShellExecute(fname, fdir, fparam: string; ses_type: Word; shortcut: boolean; bg_fr: Boolean): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2: pchar;
  rc, rc2: APIRET;
begin

{execute program}

if not(shortcut) and (fparam <> '') then
  fparam:='"'+fparam+'"';  //<-  ஡    䠩

new(fname2);
new(fparam2);
StrPCopy(fname2, fname);
StrPCopy(fparam2, fparam);

//fparam2:=StrCat(fname2, fparam2);

with sd do
  begin
      Length   := sizeof(StartData);
      Related  := {ssf_Related_Child;//}ssf_Related_Independent; // start an independent session
      if bg_fr then
        FgBg     := ssf_Fgbg_Fore           // foreground / background
        else
        FgBg     := ssf_Fgbg_Back;
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := 0;//ssf_InhertOpt_Parent;

      if (ses_type=1) then //⨯ ᨨ ணࠬ SSF_TYPE_DEFAULT (0), SSF_TYPE_FULLSCREEN (1), SSF_TYPE_WINDOWABLEVIO (2), SSF_TYPE_PM (3)
        SessionType := SSF_TYPE_FULLSCREEN //, SSF_TYPE_VDM (4), SSF_TYPE_WINDOWEDVDM (7)
      else if (ses_type=2) then
        SessionType := SSF_TYPE_WINDOWABLEVIO
      else if (ses_type=3) then
        SessionType := SSF_TYPE_PM
      else if (ses_type=4) then
        SessionType := SSF_TYPE_VDM
      else if (ses_type=7) then
        SessionType := SSF_TYPE_WINDOWEDVDM
      else SessionType := ssf_Type_Default;

      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"
rc:=DosSetCurrentDir(fdir);

//MainForm.BringToFront;
//WinSetWindowPos(MainForm.Frame.Handle,HWND_TOP,0,0,0,0,
//  SWP_SHOW Or SWP_ZORDER);

rc2:=DosStartSession(sd, idSession, apid);

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));

//MessageBox('FName:'+fname+' FDir:'+fdir+' FParam:'+fparam+' rc:'+IntToStr(rc)+' rc2:'+IntToStr(rc2), mtInformation, [mbOK]);
Result := True;
end;

Initialization
  RegisterClasses ([TMainForm, TImage, TPopupMenu, TTimer, TMenuItem, TMaskEdit
   , TEdit, TPanel, TMemo]);
End.
