//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit14;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, StdCtrls, Buttons
  , XplorBtn, pdeNLS, Unit9, BSEDOS;

Type
  TShutdownForm = Class (TForm)
    Bevel1: TBevel;
    Image1: TImage;
    pde1: TLabel;
    version1: TLabel;
    gBox: TGroupBox;
    rbShutdown: TRadioButton;
    rbRestart: TRadioButton;
    rbSuspend: TRadioButton;
    bOK: TButton;
    bCancel: TButton;
    Procedure bOKOnClick (Sender: TObject);
    Procedure bCancelOnClick (Sender: TObject);
    Procedure ShutdownFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  ShutdownForm: TShutdownForm;

function pdeShutdownDlg: Integer;

Implementation

function pdeShutdownDlg: Integer;
begin

  {show shutdown dialog}
  {this dialog performs requested operations itself}
  ShutdownForm := TShutdownForm.Create(Application.MainForm);
  Result := 0;

  ShutdownForm.ShowModal;

  if ShutdownForm <> nil then
    ShutdownForm.Free;

end;

//-- TShutdownForm class --

Procedure TShutdownForm.bOKOnClick (Sender: TObject);
Begin

  if rbRestart.Checked then
    _ShellExecute('setboot.exe', '', '/B', True, ssf_Fgbg_Back
    , SSF_CONTROL_INVISIBLE, ssf_Related_Independent)
  else if rbShutdown.Checked then
    APMShutdown('turnoff')
  else
    APMShutdown('standby');

  Close;

End;

Procedure TShutdownForm.bCancelOnClick (Sender: TObject);
Begin
  Close;
End;

Procedure TShutdownForm.ShutdownFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsStealth;

  pde1.caption := pdeLoadNLS('pdeShortName', '  ');
  version1.caption := pdeLoadNLS('pdeVersion', ' x.xx');

  gBox.caption := pdeLoadNLS('pdmLogoutAsk', 'What do you want to do?');
  rbShutdown.caption := pdeLoadNLS('pdmLogoutTurnoff', 'Turn off');
  rbRestart.caption := pdeLoadNLS('pdmLogoutRestart', 'Reboot');
  rbSuspend.caption := pdeLoadNLS('pdmLogoutSuspend', 'Suspend');

  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');

End;

Initialization
  RegisterClasses ([TShutdownForm, TBevel, TImage, TLabel, TGroupBox
   , TRadioButton, TButton]);
End.
