Unit Unit15;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, ExtCtrls, Buttons
  , SysUtils, pdeNLS, BSEDos
  , Unit1, Unit9;

Type
  TWPS2PDEForm = Class (TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Bevel1: TBevel;
    bConvert: TButton;
    bCancel: TButton;
    Label6: TLabel;
    Procedure bConvertOnClick (Sender: TObject);
    Procedure WPS2PDEFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  WPS2PDEForm: TWPS2PDEForm;

//frontend for "WPS2PDE.CMD" by S.P.Camacho
function pdeWPS2PDE: Integer;

Implementation

function pdeWPS2PDE: Integer;
begin

  WPS2PDEForm := TWPS2PDEForm.Create(nil);
  WPS2PDEForm.ShowModal;

  WPS2PDEForm.Free;

end;

Procedure TWPS2PDEForm.bConvertOnClick (Sender: TObject);
var
  basepath: String;
Begin

  basepath := pdeFolder;

  if not FileExists(basepath+'\Utils\WPS2PDE\wps2pde.cmd') then
    begin
    pdeMessageBoxOK(pdeLoadNLS('dlgErrorNotFound', 'Not found')+chr(13)+chr(10)
      +basepath+'\Utils\WPS2PDE\WPS2PDE.CMD', pdeLoadNLS('dlgError', 'Error')
      , Icon.Handle);
    exit;
    end;

  _ShellExecute('cmd.exe', basepath+'\Utils\WPS2PDE\'
    , '/c "'+basepath+'\Utils\WPS2PDE\WPS2PDE.CMD'+'"'
    , True, ssf_Fgbg_Back
    , SSF_CONTROL_INVISIBLE, ssf_Related_Independent);

End;

Procedure TWPS2PDEForm.WPS2PDEFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;
  ClientHeight := 250;

  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');

End;

Initialization
  RegisterClasses ([TWPS2PDEForm, TLabel, TBevel, TButton]);
End.
