//-----------------------------------------
//PDE text editor - eD2.exe              //
//[DE Team], stVova 2003 - 2004         //
//This is free program.                  //
//MAIN MODULE                            //
//-----------------------------------------
Unit EDITU1;

Interface

Uses
  Classes, Forms, Graphics, Buttons, Dialogs, Editors2, StdCtrls,
  SysUtils{, XplorBtn}, CustomFontDialog, pdedlgs, pdeNLS, Dos, BseDos
  , OS2Def, RusChar, InsUnit, PMWin;

Type
  TForm1 = Class (TForm)
    MainMenu1: TMainMenu;
    BtnBar: TToolbar;
    OpenButton1: TSpeedButton;
    NewButton1: TSpeedButton;
    SaveButton1: TSpeedButton;
    CutButton1: TSpeedButton;
    CopyButton1: TSpeedButton;
    PasteButton1: TSpeedButton;
    UndoButton1: TSpeedButton;
    RedoButton1: TSpeedButton;
    TileButton1: TSpeedButton;
    CascadeButton1: TSpeedButton;
    HelpButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Status: TToolbar;
    FromANSI: TSpeedButton;
    FromKOI8: TSpeedButton;
    fSize: TLabel;
    tPos: TLabel;
    Timer1: TTimer;
    Timer2: TTimer;
    mBgColor: TMenuItem;
    MenuItem9: TMenuItem;
    clrDlg: TColorDialog;
    mFGColor: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem11: TMenuItem;
    Dialog1: TFontDialog;
    mCodeIns: TMenuItem;
    MenuItem2: TMenuItem;
    mRusChar: TMenuItem;
    mWinOS2: TMenuItem;
    mKoiOS2: TMenuItem;
    mMacOS2: TMenuItem;
    mIsoOs2: TMenuItem;
    MenuItem13: TMenuItem;
    mOS2Win: TMenuItem;
    mOS2Koi: TMenuItem;
    mOS2Mac: TMenuItem;
    mOS2Iso: TMenuItem;
    MenuItem1: TMenuItem;
    MenuItem5: TMenuItem;
    mClose: TMenuItem;
    mPrevious: TMenuItem;
    mNext: TMenuItem;
    mCloseall: TMenuItem;
    mCascade: TMenuItem;
    mTile: TMenuItem;
    mPaste: TMenuItem;
    mCopy: TMenuItem;
    mCut: TMenuItem;
    mRedo: TMenuItem;
    mUndo: TMenuItem;
    mSaveas: TMenuItem;
    mSave: TMenuItem;
    mOpen: TMenuItem;
    mNew: TMenuItem;
    mSpravka: TMenuItem;
    mWin: TMenuItem;
    mEdit: TMenuItem;
    mWordWrap2: TMenuItem;
    mBtnBar: TMenuItem;
    MenuItem12: TMenuItem;
    mFont: TMenuItem;
    mStatus: TMenuItem;
    mWordWrap: TMenuItem;
    mHelp: TMenuItem;
    mAbout: TMenuItem;
    mHighlight: TMenuItem;
    mSEmpty: TMenuItem;
    MenuItem8: TMenuItem;
    mOptions: TMenuItem;
    mExit: TMenuItem;
    mFile: TMenuItem;
    tMod: TLabel;
    mFind: TMenuItem;
    mReplace: TMenuItem;
    mSearch: TMenuItem;
    mSearchAgain: TMenuItem;
    ToANSI: TSpeedButton;
    mSelectAll: TMenuItem;
    Procedure mCodeInsOnClick (Sender: TObject);
    Procedure mOS2IsoOnClick (Sender: TObject);
    Procedure mOS2MacOnClick (Sender: TObject);
    Procedure mOS2KoiOnClick (Sender: TObject);
    Procedure mIsoOs2OnClick (Sender: TObject);
    Procedure mMacOS2OnClick (Sender: TObject);
    Procedure mHelpOnClick (Sender: TObject);
    Procedure mWordWrap2OnClick (Sender: TObject);
    Procedure mSRexxOnClick (Sender: TObject);
    Procedure mStatusOnClick (Sender: TObject);
    Procedure mBtnBarOnClick (Sender: TObject);
    Procedure mSJavaOnClick (Sender: TObject);
    Procedure mSCPPOnClick (Sender: TObject);
    Procedure mSPHPOnClick (Sender: TObject);
    Procedure Form1OnCloseQuery (Sender: TObject; Var CanClose: Boolean);
    Procedure mFGColorOnClick (Sender: TObject);
    Procedure mBgColorOnClick (Sender: TObject);
    Procedure mSHtmlOnClick (Sender: TObject);
    Procedure SHClick (Sender: TObject);
    Procedure mSEmptyOnClick (Sender: TObject);
    Procedure mFontOnClick (Sender: TObject);
    Procedure mRestoreOnClick (Sender: TObject);
    Procedure mMaxOnClick (Sender: TObject);
    Procedure Form1OnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode;
      Var ReceiveR: TForm);
    Procedure mUpMoveOnClick (Sender: TObject);
    Procedure mDownMoveOnClick (Sender: TObject);
    Procedure mStopMoveOnClick (Sender: TObject);
    Procedure Timer2OnTimer (Sender: TObject);
    Procedure HelpButton1OnClick (Sender: TObject);
    Procedure ToANSIOnClick (Sender: TObject);
    Procedure mReplaceOnClick (Sender: TObject);
    Procedure mSearchAgainOnClick (Sender: TObject);
    Procedure mSearchOnClick (Sender: TObject);
    Procedure mWordWrapOnClick (Sender: TObject);
    Procedure mSelectAllOnClick (Sender: TObject);
    Procedure Form1OnShow (Sender: TObject);
    Procedure Form1OnResize (Sender: TObject);
    Procedure Form1OnCreate (Sender: TObject);
    Procedure Timer1OnTimer (Sender: TObject);
    Procedure Form1OnMDIActivate (Sender: TObject; Child: TForm);
    Procedure HelpButton3OnClick (Sender: TObject);
    Procedure FromANSIOnClick (Sender: TObject);
    Procedure CloseOnClick (Sender: TObject);
    Procedure PreviousOnClick (Sender: TObject);
    Procedure NextOnClick (Sender: TObject);
    Procedure MaximizeOnClick (Sender: TObject);
    Procedure CloseAllOnClick (Sender: TObject);
    Procedure CascadeOnClick (Sender: TObject);
    Procedure TileOnClick (Sender: TObject);
    Procedure PasteOnClick (Sender: TObject);
    Procedure CopyOnClick (Sender: TObject);
    Procedure CutOnClick (Sender: TObject);
    Procedure RedoOnClick (Sender: TObject);
    Procedure UndoOnClick (Sender: TObject);
    Procedure SaveAsOnClick (Sender: TObject);
    Procedure SaveOnClick (Sender: TObject);
    Procedure OpenOnClick (Sender: TObject);
    Procedure NewOnClick (Sender: TObject);

    Procedure WrapGrater80(Sender: TEditor2);
    Procedure DecodeRusChar(flag: Byte);
    Procedure EditorOnShortCut (Sender: TObject; KeyCode: TKeyCode; Var ReceiveR: TForm);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    function ShellExecute(fname, fdir, fparam: string; shortcut: boolean): Boolean;
    function PrepareTagS(var s: String): String;
    Procedure ImportRTF(Editor: TEditor2; fname: String);
  End;

Var
  Form1: TForm1;
  Encoding: String;
  Direction: String;
  fgcolor, bgcolor: TColor;
  TxFont: TFont;
  lastDir: String;

  NLS_pos, NLS_count: String;

  tagS: String;

function Encode(Symbol: String;var EncodedSymbols: String): Integer;
function BackEncode(Symbol: String;var EncodedSymbols: String): Integer;

Implementation

//--Import only text from given RTF file--
Procedure TForm1.ImportRTF(Editor: TEditor2; fname: String);
var
  ch: Char;
  P: Pointer;
  f: File of Char;
Begin


  AssignFile(f, fname);
  Reset(f);
  While (FilePos(f) < FileSize(f)) do
    begin
    Read(f, ch);
    {if ch = '{' then
      begin
      while (ch <> #10) and (FilePos(f)<=FileSize(f)) do
        Read(f, ch);
      end
    else
      begin
      while (ch <> #10) and (FilePos(f)<=FileSize(f)) do
        begin
        Read(f, ch);
        Editor.InsertText(@ch, 1);
        end;
      end;

    //}Editor.InsertText(@ch, 1);
    end;
  Editor.DeselectAll;
  CloseFile(f);

End;
//--End of ImportRTF--

Procedure TForm1.mCodeInsOnClick (Sender: TObject);
Begin

  If ActiveMDIChild=Nil Then exit;

  TagS := '';
  InsForm.ActiveControl := InsForm.InsBox;
  InsForm.ShowModal;

  WinSetActiveWindow(HWND_DESKTOP, Form1.Handle);
  if Tags <> '' then
    begin
    PrepareTagS(TagS);
    TEditor2(ActiveMDIChild).InsertText(@TagS + 1, Length(TagS));
    TEditor2(ActiveMDIChild).DeselectAll;
    end;

End;

function TForm1.PrepareTagS(var s: String): String;
var
  i: Integer;
Begin

while Pos(' - ', s) <> 0 do
  begin
  Insert(chr(13)+chr(10)+chr(13)+chr(10), s, Pos(' - ', s));
  Delete(s, Pos(' - ', s), 3);
  end;

if Pos(' |', s) <> 0 then
  Delete(s, Pos(' |', s), length(s)-Pos(' |', s)+1);

Result := s;

End;

Procedure TForm1.mHelpOnClick (Sender: TObject);
var
  basepath: String;
Begin
//Help? Help!!!!!
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

  if FileExists(basepath+'\Help\eD2.inf') then
    ShellExecute('view.exe', '', basepath+'\Help\eD2.inf', false)
  else if FileExists(basepath+'\pde_help_ru.inf') then
    ShellExecute('view.exe', '', basepath+'\pde_help_ru.inf', false)
  else if FileExists(basepath+'\pde_help_en.inf') then
    ShellExecute('view.exe', '', basepath+'\pde_help_en.inf', false)
  else if FileExists(basepath+'\readme_ru.txt') then
    ShellExecute('e.exe', '', basepath+'\readme_ru.txt', false)
  else if FileExists(basepath+'\readme_en.txt') then
    ShellExecute('e.exe', '', basepath+'\readme_en.txt', false)
  else HelpButton1OnClick( Sender );
End;

Procedure TForm1.mWordWrap2OnClick (Sender: TObject);
Begin
// 㧪 䠩,  ப > 80 ᨬ, 㤥  १
mWordWrap2.Checked := not(mWordWrap2.Checked);
End;

Procedure TForm1.mStatusOnClick (Sender: TObject);
Begin
//ப ﭨ \몫
mStatus.Checked := not(mStatus.Checked);
  if mStatus.Checked then Status.Size := 21
  else Status.Size := 0;
End;

Procedure TForm1.mBtnBarOnClick (Sender: TObject);
Begin
// ⠭  \몫
mBtnBar.Checked := not(mBtnBar.Checked);
  if mBtnBar.Checked then BtnBar.Size := 28
  else BtnBar.Size := 0;
End;

Procedure TForm1.Form1OnCloseQuery (Sender: TObject; Var CanClose: Boolean);
var
  cfgfile: TextFile;
Begin
  try
  AssignFile(cfgfile, extractfilepath(application.exename)+'ed2.cfg');
  Rewrite(cfgfile);

  Writeln(cfgfile, '//Configuration of eD2.exe');
  Writeln(cfgfile, Form1.Top);
  Writeln(cfgfile, Form1.Left);
  Writeln(cfgfile, Form1.Width);
  Writeln(cfgfile, Form1.Height);
  Writeln(cfgfile, mBtnBar.Checked);
  Writeln(cfgfile, mStatus.Checked);
  Writeln(cfgfile, mWordWrap2.Checked);
  Writeln(cfgfile, bgcolor);
  Writeln(cfgfile, fgcolor);
  Writeln(cfgfile, TxFont.FaceName);
  Writeln(cfgfile, TxFont.PointSize);
  //Writeln(cfgfile, );

  except
    pdeMessageBox(pdeLoadNLS('eD2Str37', 'Cann''t save settings.')
      , pdeLoadNLS('dlgError','訡'), nil);
  end;
  CloseFile(cfgfile);

CanClose:=True;
End;

Procedure TForm1.mFGColorOnClick (Sender: TObject);
var
  tmpclr: TColor;
Begin
//梥 ⥪
///if clrDlg.Execute then
//  fgcolor:=clrDlg.rgbcolor;
if pdeColorDialog(tmpclr) then
  fgcolor := tmpclr;
If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).PenColor:=fgcolor;
End;

Procedure TForm1.mBgColorOnClick (Sender: TObject);
var
  tmpclr: TColor;
Begin
//梥 䮭
//if clrDlg.Execute then
//  bgcolor:=clrDlg.rgbcolor;
if pdeColorDialog(tmpclr) then
  bgcolor := tmpclr;
If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).Color:=bgcolor;
End;

//-----------------------------------------
//ᢥ⪠ ᨭ⠪
Procedure TForm1.mSRexxOnClick (Sender: TObject);
Begin

If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).Definition:='dll\rexx';

End;

Procedure TForm1.mSJavaOnClick (Sender: TObject);
Begin

If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).Definition:='dll\java';

End;

Procedure TForm1.mSCPPOnClick (Sender: TObject);
Begin

If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).Definition:='dll\cpp';

End;

Procedure TForm1.mSPHPOnClick (Sender: TObject);
Begin

If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).Definition:='dll\php';

End;

Procedure TForm1.mSHtmlOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  begin
  TEditor2(ActiveMDIChild).Definition:='dll\HTML';

  end;
End;

Procedure TForm1.SHClick (Sender: TObject);
Begin
//If ActiveMDIChild<>Nil Then
//  TEditor2(ActiveMDIChild).Definition:='dll\Pascal';
  If ActiveMDIChild<>Nil Then
    TEditor2(ActiveMDIChild).Definition:='dll\'+TMenuItem(Sender).Hint;
End;
//-----------------------------------------

Procedure TForm1.mSEmptyOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  begin
  TEditor2(ActiveMDIChild).Definition:='';

  end;
End;

Procedure TForm1.mFontOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  if Dialog1.Execute then
    begin
    TEditor2(ActiveMDIChild).Font:=Screen.GetFontFromPointSize(Dialog1.FaceName, Dialog1.PointSize);//Dialog1.EditFont;
    TxFont:=Dialog1.EditFont;
    end;
End;

Procedure TForm1.mRestoreOnClick (Sender: TObject);
Begin
Form1.WindowState:=wsNormal;
End;

Procedure TForm1.mMaxOnClick (Sender: TObject);
Begin
Form1.WindowState:=wsMaximized;
End;

Procedure TForm1.Form1OnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode; Var ReceiveR: TForm);
Begin
if keycode=kbF10 then
  Form1.ActiveControl:=mFile
  {else if keycode=kbEsc then
    begin
    if TEditor2(ActiveMDIChild).Modified then
      if MessageBox(pdeLoadNLS('eD2Str38', ' ࠭ 䠩.')+chr(13)+chr(10)+
        pdeLoadNLS('eD2Str39', ' ࠢ ?'), mtInformation, [mbOK, mbCancel])=cmOK then
        Application.Terminate;
    end;}
End;

Procedure TForm1.mUpMoveOnClick (Sender: TObject);
Begin
Timer2.Start;
Direction:='up';
End;

Procedure TForm1.mDownMoveOnClick (Sender: TObject);
Begin
Timer2.Start;
Direction:='down';
End;

Procedure TForm1.mStopMoveOnClick (Sender: TObject);
Begin
Timer2.Stop;
End;

Procedure TForm1.Timer2OnTimer (Sender: TObject);
var
  Pos:TEditor2Pos;
Begin
If ActiveMDIChild<>Nil Then
  if Direction='up' then
    begin
    //if TEditor2(ActiveMDIChild).VertScrollBar.Position>5 then
    //  TEditor2(ActiveMDIChild).VertScrollBar.Position:=TEditor2(ActiveMDIChild).VertScrollBar.Position-5;
    //pos.X:=TEditor2(ActiveMDIChild).Cursorpos.x;
    //pos.Y:=TEditor2(ActiveMDIChild).Cursorpos.y-1;
    //TEditor2(ActiveMDIChild).GotoPosition(pos);
    end
  else if Direction='down' then
    begin
    //if TEditor2(ActiveMDIChild).VertScrollBar.Position<TEditor2(ActiveMDIChild).VertScrollBar.Max then
    //  TEditor2(ActiveMDIChild).VertScrollBar.Position:=TEditor2(ActiveMDIChild).VertScrollBar.Position+5;
    //pos.X:=TEditor2(ActiveMDIChild).Cursorpos.x;
    //pos.Y:=TEditor2(ActiveMDIChild).Cursorpos.y+1;
    //TEditor2(ActiveMDIChild).GotoPosition(pos);
    end;
End;

Procedure TForm1.HelpButton1OnClick (Sender: TObject);
var
  about, authors, thanks: TStringList;
  cptn, text, licensefile: String;
  logo: Pointer;
Begin
  //MessageBox(' Desktop Environment'+chr(13)+chr(10)+'/2 (Ed)'+chr(13)+chr(10)+'stVova, 2003'+chr(13)+chr(10)+'  8.06.2003', mtInformation, [mbOK]);
  about := TStringList.Create;
  authors := TStringList.Create;
  about.Add(pdeLoadNLS('pdeName','  Desktop Environment')+' v.0.20');
  about.Add('');
  about.Add(pdeLoadNLS('pdeDescription1', '᪠ 窠 짮⥫ '));
  about.Add(pdeLoadNLS('pdeDescription2', '樮 ⥬ OS/2 Warp  eCS'));
  about.Add('');
  about.add(pdeLoadNLS('eD2About2','⮢ । DE'));
  about.add('');
  about.add(pdeLoadNLS('eD2About3','ᢥ⪠ ᨭ⠪ ⥪⮢ ணࠬ'));
  about.add(pdeLoadNLS('eD2About4','४஢ ᪨ ⥪⮢ (ANSI1251, IBM866, KOI8)'));

  authors := TStringList.Create;
  {authors.Add(pdeLoadNLS('pdeAuthors1.1', 'ࣥ , stVova'));
  authors.Add('');}
  authors.Add('Vladymyr Sergeyev, stVova');
  authors.Add('Sergey Sergeyev, SERG');
  authors.Add('e-mail: stVova@ukrpost.com.ua or stVova@ukr.net');
  authors.Add('web: http://os2progg.by.ru');
  thanks := TStringList.Create;
  thanks.Add('Our mother Ludmyla Sergeyeva');
  thanks.Add('');
  thanks.Add('Sergey Posokhov');
  thanks.Add('Andy Key (Generalized Bitmap Module)');
  thanks.Add('Independent JPEG group (JPEG support)');
  thanks.Add('Salvador Parra Camacho');
  //thanks.Add('');
  thanks.Add('KDE Team for graphics and icons (www.kde.org)');
  thanks.Add('GNOME Team for graphics and icons (www.gnome.org)');
  thanks.Add('Aaron Lawrence (ACL Library)');
  thanks.Add('Constantin G. Nekhoroshkov (Encodings tables)');
  thanks.Add('');
  thanks.Add('And all friends from native sity Lutsk (Ukraine, Volyn Region)');

  logo := Form1.Icon;
    pdeAboutDialog(about, authors, thanks, pdeLoadNLS('menuAbout','ଠ  த')
      , pdeLoadNLS('eD2About1','eD2 - । DE'), '', logo);
  about.Free;
  authors.Free;
End;

Procedure TForm1.mReplaceOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).ReplaceTextDlg;
End;

Procedure TForm1.mSearchAgainOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).SearchTextAgain;
End;

Procedure TForm1.mSearchOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).FindTextDlg;
End;

Procedure TForm1.mWordWrapOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  begin
  mWordWrap.Checked:=not(mWordWrap.Checked);
  TEditor2(ActiveMDIChild).WordWrap:=mWordWrap.Checked;
  end;
End;

Procedure TForm1.mSelectAllOnClick (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  TEditor2(ActiveMDIChild).SelectAll;
End;

Procedure TForm1.Form1OnShow (Sender: TObject);
var
  i: Integer;
  fl: String;
  Editor: TEditor2;
  cfgfile: TextFile;
  cfgstr: String;
  cfgint: LongWord;
  ch_bars: String;
  openname: String;
Begin
//㧪 䨣樨
ch_bars:='';
cfgint:=0;
cfgstr:='';
if fileexists(extractfilepath(application.exename)+'ed2.cfg') then
  Begin
  AssignFile(cfgfile, extractfilepath(application.exename)+'ed2.cfg');
  Reset(cfgfile);

  Readln(cfgfile);
  Readln(cfgfile, cfgint);
  if (cfgint > 0) then
    Form1.Top := cfgint;
  Readln(cfgfile, cfgint);
  if (cfgint > 0) then
    Form1.Left := cfgint;
  Readln(cfgfile, cfgint);
  if (cfgint > 100) then
    Form1.Width := cfgint;
  Readln(cfgfile, cfgint);
  if (cfgint > 100) then
    Form1.Height := cfgint;
  Readln(cfgfile, ch_bars);
    if (lowercase(ch_bars) = 'false') then mBtnBarOnClick(Self);
  Readln(cfgfile, ch_bars);
    if (lowercase(ch_bars) = 'false') then mStatusOnClick(Self);
  Readln(cfgfile, ch_bars);
    if (lowercase(ch_bars) = 'false') then mWordWrap2OnClick(Self);
  Readln(cfgfile, bgcolor);
  Readln(cfgfile, fgcolor);
  Readln(cfgfile, cfgstr);
  Readln(cfgfile, cfgint);

  TxFont:=Screen.GetFontFromPointSize(cfgstr, cfgint);
  //Readlnln(cfgfile, );
  CloseFile(cfgfile);
  End;

//  䠩  㧪 ...
if ParamStr(1)<>'' then
  begin
  fl:='';
  for i:=1 to paramcount do
    fl:=fl+ParamStr(i)+' ';
    Delete(fl, length(fl), 1);
    if fl[1]='"' then Delete(fl, 1, 1);
    if fl[length(fl)]='"' then Delete(fl, length(fl), 1);
    //OpenDialog1.FileName:=fl;
    openname := fl;
    Editor.Create(Self);
    Editor.FormStyle:=fsMDIChild;
    Editor.Parent:=Self;
    Editor.LoadFromFile(openname{OpenDialog1.FileName});
    lastdir := extractfilepath(openname);
    Editor.Caption:=openname{OpenDialog1.FileName};
    if (mWordWrap2.Checked) and ((LowerCase(ExtractFileExt(openname{OpenDialog1.FileName}))<>'.sys')
      and (LowerCase(ExtractFileExt(openname{OpenDialog1.FileName}))<>'.ini') and
      (LowerCase(ExtractFileExt(openname{OpenDialog1.FileName}))<>'.cfg')) then
        WrapGrater80(Editor);
    Editor.WindowState:=wsMaximized;
    Editor.Color:=bgColor;
    Editor.PenColor:=fgColor;
    Editor{.Canvas}.Font:=TxFont;
    Editor.OnTranslateShortCut := EditorOnShortCut;
    Editor.Show;
    Editor.BringToFront;
    fSize.Caption:=IntToStr(Editor.CountLines)+' ப';
  end;

//-----Load PDE NLS-----
Form1.Caption := pdeLoadNLS('eD2Str1', '/2');
mFile.Caption := pdeLoadNLS('menuFile', '');
  mNew.Caption := pdeLoadNLS('eD2Str2', '~\tCtrl+N');
  mOpen.Caption := pdeLoadNLS('eD2Str3', '~\tCtrl+O');
  mSave.Caption := pdeLoadNLS('eD2Str4', '~࠭\tCtrl+S');
  mSaveas.Caption := pdeLoadNLS('eD2Str5', '࠭ ~');
  mExit.Caption := pdeLoadNLS('eD2Str6', '~室\tAlt+X');
mEdit.Caption := pdeLoadNLS('menuEdit', 'ࠢ');
  mUndo.Caption := pdeLoadNLS('eD2Str7', '~⬥\tCtrl+Z');
  mRedo.Caption := pdeLoadNLS('eD2Str8', '~\tCtrl+Y');
  mCut.Caption := pdeLoadNLS('eD2Str9', '~\tCtrl+X');
  mCopy.Caption := pdeLoadNLS('eD2Str10', '~஢\tCtrl+C');
  mPaste.Caption := pdeLoadNLS('eD2Str10a', '~⠢\tCtrl+V');
  mSelectAll.Caption := pdeLoadNLS('eD2Str11', '뤥 \tCtrl+A');
  mRusChar.Caption := pdeLoadNLS('eD2Str111', 'pp');
  mCodeIns.Caption := pdeLoadNLS('eD2Str112', ' \tCtrl+Space');
mOptions.Caption := pdeLoadNLS('eD2Str12', '樨');
  mBtnBar.Caption := pdeLoadNLS('menuButtons', '');
  mStatus.Caption := pdeLoadNLS('menuStatus', 'ப ﭨ');
  mHighlight.Caption := pdeLoadNLS('eD2Str13', 'ᢥ⪠ ᨭ⠪');
    mSEmpty.Caption := pdeLoadNLS('eD2Str14', '몫祭');
  mBGcolor.Caption := pdeLoadNLS('eD2Str15', ' 䮭');
  mFGcolor.Caption := pdeLoadNLS('eD2Str16', ' ⥪');
  mFont.Caption := pdeLoadNLS('eD2Str17', ' ⥪');
  mWordWrap.Caption := pdeLoadNLS('eD2Str18', '७ ᫮  ');
  mWordWrap2.Caption := pdeLoadNLS('eD2Str19', '७ ப > 80 ᨬ');
mWin.Caption := pdeLoadNLS('eD2Str20', '~');
  mTile.Caption := pdeLoadNLS('eD2Str21', '~⪮');
  mCascade.Caption := pdeLoadNLS('eD2Str22', '~᪠');
  mCloseall.Caption := pdeLoadNLS('eD2Str23', '~ ');
  mNext.Caption := pdeLoadNLS('eD2Str24', '~饥\tF6');
  mPrevious.Caption := pdeLoadNLS('eD2Str25', '~।饥\tShift+F6');
  mClose.Caption := pdeLoadNLS('eD2Str26', '~\tAlt+F3');
mFind.Caption := pdeLoadNLS('eD2Str27', '');
  mSearch.Caption := pdeLoadNLS('menuFind', '\tCtrl+F');
  mSearchAgain.Caption := pdeLoadNLS('eD2Str28', 'த \tF3');
  mReplace.Caption := pdeLoadNLS('eD2Str29', '\tCtrl+R');
mSpravka.Caption := pdeLoadNLS('menuHelp', '~ࠢ');
  mHelp.Caption := pdeLoadNLS('menuShowHelp', '~맮 ࠢ\tF1');
  mAbout.Caption := pdeLoadNLS('menuAbout', '~ଠ  த\tShift+F1');

NLS_pos := pdeLoadNLS('eD2Str30',' ');
NLS_count := pdeLoadNLS('eD2Str31',' ப')

End;

Procedure TForm1.Form1OnResize (Sender: TObject);
Begin
If ActiveMDIChild<>Nil Then
  begin
  TEditor2(ActiveMDIChild).Width:=Form1.ClientWidth;
  TEditor2(ActiveMDIChild).Height:=Form1.ClientHeight;
  TEditor2(ActiveMDIChild).Bottom:=0;
  TEditor2(ActiveMDIChild).Left:=0;
  end;
End;

Procedure TForm1.Form1OnCreate (Sender: TObject);
var
  SHItem: TMenuItem;
  rez, rez2: Integer;
  tsr: TSearchRec;
Begin
  Timer1.Start;
  bgcolor:=clWhite;
  fgcolor:=clBlack;
  TxFont:=TFont.Create(Self);
  TxFont:=Form1.Font;

//--load syntax highlight modules--
  rez2 := 49;
  rez:=FindFirst(ExtractFilePath(Application.ExeName)+'\DLL\*.dll', faAnyFile, tsr);
  if (tsr.attr and faDirectory)=0 then //file
      begin
      SHItem := TMenuItem.Create(self);
      SHItem.Caption := tsr.name+'\tCtrl+'+IntToStr(rez2 - 48);  //Delete(tsr.name, pos('.', tsr.name), length(tsr.name)-pos('.', tsr.name));
      SHItem.hint := tsr.name;
      SHItem.Shortcut := TKeyCode(kb_Ctrl + kb_Char +TKeyCode(rez2));
      SHItem.onclick:=SHClick;
      mHighlight.add(SHItem);
      inc(rez2);
      end;
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      SHItem := TMenuItem.Create(self);
      SHItem.Caption := tsr.name+'\tCtrl+'+IntToStr(rez2 - 48);  //Delete(tsr.name, pos('.', tsr.name), length(tsr.name)-pos('.', tsr.name));
      SHItem.hint := tsr.name;
      SHItem.Shortcut := TKeyCode(kb_Ctrl + kb_Char +TKeyCode(rez2));
      SHItem.onclick:=SHClick;
      mHighlight.add(SHItem);
      inc(rez2);
      end;
    end;
FindClose(tsr);
//--end load syntax highlight modules--

End;

Procedure TForm1.Timer1OnTimer (Sender: TObject);
Begin

If ActiveMDIChild<>Nil Then
  begin
  tPos.Caption:=NLS_pos+IntToStr(TEditor2(ActiveMDIChild).CursorPos.X)+':'+IntToStr(TEditor2(ActiveMDIChild).CursorPos.Y);
  fSize.Caption:=IntToStr(TEditor2(ActiveMDIChild).CountLines)+NLS_count;

  if TEditor2(ActiveMDIChild).Modified then
    tMod.Caption:='[*]'
  else
    tMod.Caption:='[ ]';
  end;

End;

Procedure TForm1.EditorOnShortCut (Sender: TObject; KeyCode: TKeyCode; Var ReceiveR: TForm);
Begin

if KeyCode = kbCtrlSpace then
  begin
  TagS := '';
  //InsForm.BringToFront;
  //InsForm.Left := Form1.Left;
  //InsForm.Top := Form1.Top;
  InsForm.ActiveControl := InsForm.InsBox;
  InsForm.ShowModal;

  WinSetActiveWindow(HWND_DESKTOP, Form1.Handle);
  if Tags <> '' then
    begin
    PrepareTagS(TagS);
    TEditor2(ActiveMDIChild).InsertText(@TagS + 1, Length(TagS));
    TEditor2(ActiveMDIChild).DeselectAll;
    end;
  end;

End;

Procedure TForm1.Form1OnMDIActivate (Sender: TObject; Child: TForm);
Begin
  If ActiveMDIChild<>Nil Then
      fSize.Caption:=IntToStr(TEditor2(ActiveMDIChild).CountLines-1)+' ப';
End;

Procedure TForm1.CloseOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;
    TEditor2(ActiveMDIChild).Close;
End;

Procedure TForm1.PreviousOnClick (Sender: TObject);
Begin
    Previous;
    If ActiveMDIChild<>Nil Then
      fSize.Caption:=IntToStr(TEditor2(ActiveMDIChild).CountLines-1)+NLS_count;
End;

Procedure TForm1.NextOnClick (Sender: TObject);
Begin
    Next;
    If ActiveMDIChild<>Nil Then
      fSize.Caption:=IntToStr(TEditor2(ActiveMDIChild).CountLines-1)+NLS_count;
End;

Procedure TForm1.MaximizeOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;

    //TEditor2(ActiveMDIChild).WindowState:=wsMaximized;
    TEditor2(ActiveMDIChild).Width:=Form1.ClientWidth;
    TEditor2(ActiveMDIChild).Height:=Form1.ClientHeight;
    TEditor2(ActiveMDIChild).Bottom:=0;
    TEditor2(ActiveMDIChild).Left:=0;

End;

Procedure TForm1.CloseAllOnClick (Sender: TObject);
Begin
    CloseAll;
End;

Procedure TForm1.CascadeOnClick (Sender: TObject);
Begin
    Cascade;
End;

Procedure TForm1.TileOnClick (Sender: TObject);
Begin
    Tile;
End;

Procedure TForm1.PasteOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;
    TEditor2(ActiveMDIChild).PasteFromClipBoard;
End;

Procedure TForm1.CopyOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;
    TEditor2(ActiveMDIChild).CopyToClipBoard;
End;

Procedure TForm1.CutOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;
    TEditor2(ActiveMDIChild).CutToClipBoard;
End;

Procedure TForm1.RedoOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;
    TEditor2(ActiveMDIChild).Redo;
End;

Procedure TForm1.UndoOnClick (Sender: TObject);
Begin
    If ActiveMDIChild=Nil Then exit;
    TEditor2(ActiveMDIChild).Undo;
End;

Procedure TForm1.SaveAsOnClick (Sender: TObject);
var
  savename: String;
Begin
  If ActiveMDIChild=Nil Then exit;
  savename := pdeOpenFileDialog(pdeLoadNLS('eD2Str32','࠭ 䠩'), lastdir,
 pdeLoadNLS('eD2Str33', '⮢ 䠩')+' (*.txt;*.bat;*.htm;*.html;*.php)|'
   +pdeLoadNLS('eD2Str34','室 ⥪')+' (*.pas;*.c;*.cpp;*.bas;*.class;*.java)|'
   +pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|');
   //If SaveDialog1.Execute Then
  if savename <> '' then
    Begin
      try
      TEditor2(ActiveMDIChild).SaveToFile(savename{SaveDialog1.FileName});
      lastdir := extractfilepath(savename);
      TEditor2(ActiveMDIChild).Caption:=TEditor2(ActiveMDIChild).FileName;
      except
        pdeMessageBox(pdeLoadNLS('eDstr36', ' 㤠 ࠭ 䠩')
          , pdeLoadNLS('dlgError','訡'), nil);
      end;
    End;
End;

Procedure TForm1.SaveOnClick (Sender: TObject);
Begin
if ActiveMDIChild=nil then exit;

if TEditor2(ActiveMDIChild).Caption<>'Untitled.txt' then
  TEditor2(ActiveMDIChild).SaveToFile(TEditor2(ActiveMDIChild).FileName)
  else
  SaveAsOnClick (Sender);
End;

Procedure TForm1.OpenOnClick (Sender: TObject);
Var Editor:TEditor2;
    openname: String;
Begin
  if lastdir = '' then lastdir := 'c:\';
 openname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile','⨥ 䠩'), lastdir,
   pdeLoadNLS('eD2Str33', '⮢ 䠩')+' (*.txt;*.rtf;*.bat;*.htm;*.html;*.php)|'
   +pdeLoadNLS('eD2Str34','室 ⥪')+' (*.pas;*.c;*.cpp;*.bas;*.class;*.java)|'
   +pdeLoadNLS('eD2Str35',' 䠩')+' (*.*)|');
   //If OpenDialog1.Execute Then
   if openname <> '' then
   Begin
        Form1.Cursor := crHourGlass;
        Editor.Create(Self);
        Editor.FormStyle:=fsMDIChild;
        Editor.Parent:=Self;
        Editor.WindowState:=wsMaximized;
        Editor.Color:=bgColor;
        Editor.PenColor:=fgColor;
        //Editor.LoadFromFile(OpenDialog1.FileName);
        if LowerCase(ExtractFileExt(openname)) <> '.rtf' then
          Editor.LoadFromFile(openname)
        else
          begin
          //ShowMessage('RTF!');
          ImportRTF(Editor, openname);
          end;

        lastdir := extractfilepath(openname);
        Editor.Caption:=openname;//OpenDialog1.FileName;
        if (mWordWrap2.Checked) and ((LowerCase(ExtractFileExt(openname{OpenDialog1.FileName}))<>'.sys')
          and (LowerCase(ExtractFileExt(openname{OpenDialog1.FileName}))<>'.ini') and
          (LowerCase(ExtractFileExt(openname{OpenDialog1.FileName}))<>'.cfg')) then
            WrapGrater80(Editor);
        Editor{.Canvas}.Font:=TxFont;
        Editor.WordWrap:=mWordWrap.Checked;
        Editor.OnTranslateShortCut := EditorOnShortCut;
        Editor.Show;
        Editor.BringToFront;
        fSize.Caption:=IntToStr(Editor.CountLines)+NLS_count;
        Form1.Cursor := crDefault;
   End;
End;

Procedure TForm1.NewOnClick (Sender: TObject);
Var Editor:TEditor2;
Begin
     Editor.Create(Self);
     Editor.FormStyle:=fsMDIChild;
     Editor.Caption:='Untitled.txt';
     Editor.FileName:=Editor.Caption;
     Editor.Parent:=Self;
     Editor.WindowState:=wsMaximized;
     Editor.Color:=bgColor;
     Editor.PenColor:=fgColor;
     Editor{.Canvas}.Font:=TxFont;
     Editor.WordWrap:=mWordWrap.Checked;
     Editor.OnTranslateShortCut := EditorOnShortCut;
     Editor.Show;
     Editor.BringToFront;
     fSize.Caption:=IntToStr(Editor.CountLines)+NLS_count;
End;

function Encode(Symbol: String;var EncodedSymbols: String): Integer;
var
  j: word;
begin
EncodedSymbols:='';
{४஢  1251->866  KOI8->866}
if Encoding='1251' then
  begin
  for j:=1 to length(Symbol) do
    begin
    if (Ord(Symbol[j])>174)and(Ord(Symbol[j])<224) then
      EncodedSymbols:=EncodedSymbols+Chr(Ord(Symbol[j])-64)
    else if (Ord(Symbol[j])>222)and(Ord(Symbol[j])<240) then
      EncodedSymbols:=EncodedSymbols+Chr(Ord(Symbol[j])-64)
    else if (Ord(Symbol[j])>239)and(Ord(Symbol[j])<=255) then
      EncodedSymbols:=EncodedSymbols+Chr(Ord(Symbol[j])-16)
    else if Ord(Symbol[j])=179 then EncodedSymbols:=EncodedSymbols+'i'
    else if Ord(Symbol[j])=178 then EncodedSymbols:=EncodedSymbols+'I'
    else if Ord(Symbol[j])=186 then EncodedSymbols:=EncodedSymbols+''
    else if Ord(Symbol[j])=170 then EncodedSymbols:=EncodedSymbols+''
    else if Ord(Symbol[j])=191 then EncodedSymbols:=EncodedSymbols+''
    else if Ord(Symbol[j])=175 then EncodedSymbols:=EncodedSymbols+''
    else EncodedSymbols:=EncodedSymbols+Symbol[j];
    end;
  end
else if Encoding='koi8' then
  begin
  for j:=1 to length(Symbol) do
    begin
    if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+''
  else EncodedSymbols:=EncodedSymbols+Symbol[j];
    end;
  end;
Result:=0;
{That's all ;-)}
end;

function BackEncode(Symbol: String;var EncodedSymbols: String): Integer;
var
  j: word;
begin
EncodedSymbols:='';
{४஢  866- (/2)  1251  8}
if Encoding='1251' then
  begin
  for j:=1 to length(Symbol) do
    begin
    if (Ord(Symbol[j])>120)and(Ord(Symbol[j])<160) then
      EncodedSymbols:=EncodedSymbols+Chr(Ord(Symbol[j])+64)
    else if (Ord(Symbol[j])>158)and(Ord(Symbol[j])<176) then
      EncodedSymbols:=EncodedSymbols+Chr(Ord(Symbol[j])+64)
    else if (Ord(Symbol[j])>223)and(Ord(Symbol[j])<=239) then
      EncodedSymbols:=EncodedSymbols+Chr(Ord(Symbol[j])+16)
    else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+chr(179)
    else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+chr(178)
    else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+chr(186)
    else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+chr(170)
    else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+chr(191)
    else if Symbol[j]='' then EncodedSymbols:=EncodedSymbols+chr(175)
    else EncodedSymbols:=EncodedSymbols+Symbol[j];
    end;
  end;

Result:=0;
end;

Procedure TForm1.WrapGrater80(Sender: TEditor2);
var
  i,lcount: LongInt;
  tmpstr1, tmpstr2: String;
Begin
tmpstr1:='';
tmpstr2:='';
//० 騥 ப, ᭨ 䫠 "஢"  Editor
//ਬ  ஦
if TEditor2(Sender).CountLines>0 then
With TEditor2(Sender) do
  Begin
  BeginUpdate;
  lcount := CountLines;
  for i := 1 to lcount do
    Begin
    if (length(lines[i]) > 80) then
      Begin
      tmpstr1 := lines[i];
      tmpstr2 := lines[i];
      delete(tmpstr1, 71, length(lines[i]));
      delete(tmpstr2, 1, 70);
  while ((tmpstr2[1]<>' ') and (tmpstr2[1]<>';') and (tmpstr2[1]<>',') and
        (tmpstr2[1]<>'>')) and (length(tmpstr2) > 1) do
        begin
        tmpstr1 := tmpstr1 + tmpstr2[1];
        delete(tmpstr2, 1, 1);
        end;
      tmpstr1 := tmpstr1 + tmpstr2[1];
      delete(tmpstr2, 1, 1);

      Lines[i] := tmpstr1;
      InsertLine(i + 1, Tmpstr2);
      inc(lcount);
      End;
    End;
  EndUpdate;
  CursorPos.X := 1;
  CursorPos.Y := 1;
  Modified := False;
  End;

End;

function TForm1.ShellExecute(fname, fdir, fparam: string; shortcut: boolean): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2: pchar;
  rc, rc2: APIRET;
begin
if not(shortcut) and (fparam <> '') then
  fparam:='"'+fparam+'"';  //<-  ஡    䠩
new(fname2);
new(fparam2);
StrPCopy(fname2, fname);
StrPCopy(fparam2, fparam);

//fparam2:=StrCat(fname2, fparam2);

with sd do
  begin
      Length   := sizeof(StartData);
      Related  := ssf_Related_Independent; // start an independent session
      FgBg     := ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := ssf_InhertOpt_Parent;
      SessionType := ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"
rc:=DosSetCurrentDir(fdir);
rc2:=DosStartSession(sd, idSession, apid);

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));

if rc2 <> 0 then //ERROR!!!
  pdeMessageBox(pdeLoadNLS('dlgRunErrorProgram', 'ணࠬ:')+' '+fname+chr(13)+
    chr(10)+pdeLoadNLS('dlgErrorCode', ' 訡:')+' '+IntToStr(rc2)
  , pdeLoadNLS('dlgRunErrorCaption', '訡 ᪠'), HelpButton1.Glyph);
end;

//--cyryllic decoding menu

Procedure TForm1.DecodeRusChar(flag: Byte);
var
  i: LongInt;
  enc: String;
  Editor:TEditor2;
Begin

  If ActiveMDIChild=Nil Then Exit;

  Form1.Cursor := crHourGlass;

  Editor.Create(Self);
  Editor.FormStyle:=fsMDIChild;
  Editor.Caption:=ExtractFilePath(TEditor2(ActiveMDIChild).Caption)+'_'
    +ExtractFileName(TEditor2(ActiveMDIChild).Caption);
  Editor.FileName:=Editor.Caption;

  for i:=1 to TEditor2(ActiveMDIChild).CountLines do
    begin
    enc := ConvertString(TEditor2(ActiveMDIChild).Lines[i], flag);
    Editor.InsertLine(i, enc);
    end;

  Editor.Parent:=Self;
  Editor.WindowState:=wsMaximized;
  Editor.Color:=bgColor;
  Editor.PenColor:=fgColor;
  Editor{.Canvas}.Font:=TxFont;
  Editor.WordWrap:=mWordWrap.Checked;
  Editor.OnTranslateShortCut := EditorOnShortCut;
  Editor.Show;
  Editor.BringToFront;

  Form1.Cursor := crDefault;

End;

Procedure TForm1.mOS2IsoOnClick (Sender: TObject);
Begin

  {os/2->iso}
  DecodeRusChar(Alt_2_Iso);

End;

Procedure TForm1.mOS2MacOnClick (Sender: TObject);
Begin

  {os/2->mac}
  DecodeRusChar(Alt_2_Mac);

End;

Procedure TForm1.mOS2KoiOnClick (Sender: TObject);
Begin

  {os/2->Koi}
  DecodeRusChar(Alt_2_Koi);

End;

Procedure TForm1.mIsoOs2OnClick (Sender: TObject);
Begin

  {iso->os/2}
  DecodeRusChar(Iso_2_Alt);

End;

Procedure TForm1.mMacOS2OnClick (Sender: TObject);
Begin

  {mac->os/2}
  DecodeRusChar(Mac_2_Alt);

End;

Procedure TForm1.FromANSIOnClick (Sender: TObject);
Begin

  {win->os/2}
  DecodeRusChar(Win_2_Alt);

End;

Procedure TForm1.HelpButton3OnClick (Sender: TObject);
Begin

  {koi8->os/2}
  DecodeRusChar(Koi_2_Alt);

End;

Procedure TForm1.ToANSIOnClick (Sender: TObject);
Begin

  {os/2->win}
  DecodeRusChar(Alt_2_win);

End;

//----------------------

Initialization
  RegisterClasses ([TForm1, TMainMenu, TToolbar, TSpeedButton, TOpenDialog,
    TSaveDialog, TLabel, TTimer, TMenuItem, TColorDialog, TFontDialog]);
End.
