//--------------------------------------//
//Materials of DelphiKingdom            //
//code by Constantin G. Nekhoroshkov   //
//used in PDE for OS/2 by stVova        //
//29.02.2004                            //
//--------------------------------------//

Unit RusChar;
interface
Const
   //Alt decode contants
   ALT_2_ISO=1;
   ALT_2_KOI=2;
   ALT_2_MAC=3;
   ALT_2_WIN=4;
   //Iso decode contants
   ISO_2_ALT=5;
   ISO_2_KOI=6;
   ISO_2_MAC=7;
   ISO_2_WIN=8;
   //Koi decode contants
   KOI_2_ALT=9;
   KOI_2_ISO=10;
   KOI_2_MAC=11;
   KOI_2_WIN=12;
   //Mac decode contants
   MAC_2_ALT=13;
   MAC_2_ISO=14;
   MAC_2_KOI=15;
   MAC_2_WIN=16;
   //Win decode contants
   WIN_2_ALT=17;
   WIN_2_ISO=18;
   WIN_2_KOI=19;
   WIN_2_MAC=20;

        Function ALT2ISO(Ch1: byte): byte;
        Function ALT2KOI(Ch1: byte): byte;
        Function ALT2MAC(Ch1: byte): byte;
        Function ALT2WIN(Ch1: byte): byte;
        Function ISO2ALT(Ch1: byte): byte;
        Function ISO2KOI(Ch1: byte): byte;
        Function ISO2MAC(Ch1: byte): byte;
        Function ISO2WIN(Ch1: byte): byte;
        Function KOI2ALT(Ch1: byte): byte;
        Function KOI2ISO(Ch1: byte): byte;
        Function KOI2MAC(Ch1: byte): byte;
        Function KOI2WIN(Ch1: byte): byte;
        Function MAC2ALT(Ch1: byte): byte;
        Function MAC2ISO(Ch1: byte): byte;
        Function MAC2KOI(Ch1: byte): byte;
        Function MAC2WIN(Ch1: byte): byte;
        Function WIN2ALT(Ch1: byte): byte;
        Function WIN2ISO(Ch1: byte): byte;
        Function WIN2KOI(Ch1: byte): byte;
        Function WIN2MAC(Ch1: byte): byte;
        Function ConvertString(InputString: string; Convert_Flag: byte): string;
implementation
const
   ALTTable: array [1..64] of byte =(
                                     128, 129, 130, 131, 132, 133, 134, 135,
                                     136, 137, 138, 139, 140, 141, 142, 143,
                                     144, 145, 146, 147, 148, 149, 150, 151,
                                     152, 153, 154, 155, 156, 157, 158, 159,
                                     160, 161, 162, 163, 164, 165, 166, 167,
                                     168, 169, 170, 171, 172, 173, 174, 175,
                                     224, 225, 226, 227, 228, 229, 230, 231,
                                     232, 233, 234, 235, 236, 237, 238, 239
                                     );
   ISOTable: array [1..64] of byte =(
                                     176, 177, 178, 179, 180, 181, 182, 183,
                                     184, 185, 186, 187, 188, 189, 190, 191,
                                     192, 193, 194, 195, 196, 197, 198, 199,
                                     200, 201, 202, 203, 204, 205, 206, 207,
                                     208, 209, 210, 211, 212, 213, 214, 215,
                                     216, 217, 218, 219, 220, 221, 222, 223,
                                     224, 225, 226, 227, 228, 229, 230, 231,
                                     232, 233, 234, 235, 236, 237, 238, 239
                                    );
   KOITable: array [1..64] of byte =(
                                     225, 226, 247, 231, 228, 229, 246, 250,
                                     233, 234, 235, 236, 237, 238, 239, 240,
                                     242, 243, 244, 245, 230, 232, 227, 254,
                                     251, 253, 255, 249, 248, 252, 224, 241,
                                     193, 194, 215, 199, 196, 197, 214, 218,
                                     201, 202, 203, 204, 205, 206, 207, 208,
                                     210, 211, 212, 213, 198, 200, 195, 222,
                                     219, 221, 223, 217, 216, 220, 192, 209
                                    );
   MACTable: array [1..64] of byte =(
                                     128, 129, 130, 131, 132, 133, 134, 135,
                                     136, 137, 138, 139, 140, 141, 142, 143,
                                     144, 145, 146, 147, 148, 149, 150, 151,
                                     152, 153, 154, 155, 156, 157, 158, 159,
                                     224, 225, 226, 227, 228, 229, 230, 231,
                                     232, 233, 234, 235, 236, 237, 238, 239,
                                     240, 241, 242, 243, 244, 245, 246, 247,
                                     248, 249, 250, 251, 252, 253, 254, 223
                                     );
   WINTable: array [1..64] of byte =(
                                     192, 193, 194, 195, 196, 197, 198, 199,
                                     200, 201, 202, 203, 204, 205, 206, 207,
                                     208, 209, 210, 211, 212, 213, 214, 215,
                                     216, 217, 218, 219, 220, 221, 222, 223,
                                     224, 225, 226, 227, 228, 229, 230, 231,
                                     232, 233, 234, 235, 236, 237, 238, 239,
                                     240, 241, 242, 243, 244, 245, 246, 247,
                                     248, 249, 250, 251, 252, 253, 254, 255
                                     );

Function ALT2ISO(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ALTTable[i]=ch1 then begin
   ALT2ISO:=ISOtable[i];
   exit;
  end;
 end;
 ALT2ISO:=ch1;
end;
Function ALT2KOI(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ALTTable[i]=ch1 then begin
   ALT2KOI:=KOItable[i];
   exit;
  end;
 end;
 ALT2KOI:=ch1;
end;
Function ALT2MAC(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ALTTable[i]=ch1 then begin
   ALT2MAC:=MACtable[i];
   exit;
  end;
 end;
 ALT2MAC:=ch1;
end;
Function ALT2WIN(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ALTTable[i]=ch1 then begin
   ALT2WIN:=WINtable[i];
   exit;
  end;
 end;
 ALT2WIN:=ch1;
end;
Function ISO2ALT(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ISOTable[i]=ch1 then begin
   ISO2ALT:=ALTtable[i];
   exit;
  end;
 end;
 ISO2ALT:=ch1;
end;
Function ISO2KOI(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ISOTable[i]=ch1 then begin
   ISO2KOI:=KOItable[i];
   exit;
  end;
 end;
 ISO2KOI:=ch1;
end;
Function ISO2MAC(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ISOTable[i]=ch1 then begin
   ISO2MAC:=MACtable[i];
   exit;
  end;
 end;
 ISO2MAC:=ch1;
end;
Function ISO2WIN(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If ISOTable[i]=ch1 then begin
   ISO2WIN:=WINtable[i];
   exit;
  end;
 end;
 ISO2WIN:=ch1;
end;
Function KOI2ALT(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If KOITable[i]=ch1 then begin
   KOI2ALT:=ALTtable[i];
   exit;
  end;
 end;
 KOI2ALT:=ch1;
end;
Function KOI2ISO(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If KOITable[i]=ch1 then begin
   KOI2ISO:=ISOtable[i];
   exit;
  end;
 end;
 KOI2ISO:=ch1;
end;
Function KOI2MAC(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If KOITable[i]=ch1 then begin
   KOI2MAC:=MACtable[i];
   exit;
  end;
 end;
 KOI2MAC:=ch1;
end;
Function KOI2WIN(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If KOITable[i]=ch1 then begin
   KOI2WIN:=WINtable[i];
   exit;
  end;
 end;
 KOI2WIN:=ch1;
end;
Function MAC2ALT(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If MACTable[i]=ch1 then begin
   MAC2ALT:=ALTtable[i];
   exit;
  end;
 end;
 MAC2ALT:=ch1;
end;
Function MAC2ISO(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If MACTable[i]=ch1 then begin
   MAC2ISO:=ISOtable[i];
   exit;
  end;
 end;
 MAC2ISO:=ch1;
end;
Function MAC2KOI(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If MACTable[i]=ch1 then begin
   MAC2KOI:=KOItable[i];
   exit;
  end;
 end;
 MAC2KOI:=ch1;
end;
Function MAC2WIN(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If MACTable[i]=ch1 then begin
   MAC2WIN:=WINtable[i];
   exit;
  end;
 end;
 MAC2WIN:=ch1;
end;
Function WIN2ALT(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If WINTable[i]=ch1 then begin
   WIN2ALT:=ALTtable[i];
   exit;
  end;
 end;
 WIN2ALT:=ch1;
end;
Function WIN2ISO(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If WINTable[i]=ch1 then begin
   WIN2ISO:=ISOtable[i];
   exit;
  end;
 end;
 WIN2ISO:=ch1;
end;
Function WIN2KOI(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If WINTable[i]=ch1 then begin
   WIN2KOI:=KOItable[i];
   exit;
  end;
 end;
 WIN2KOI:=ch1;
end;
Function WIN2MAC(Ch1: byte): byte;
Var
 i: byte;
begin
 For i:=1 to 64 do begin
  If WINTable[i]=ch1 then begin
   WIN2MAC:=MACtable[i];
   exit;
  end;
 end;
 WIN2MAC:=ch1;
end;

Function ConvertString(InputString: string; Convert_Flag: byte): string;
Var
           i: word;
 ConvertByte: byte;
begin
   ConvertString:='';
   If InputString='' then exit;
   for i:=1 to length(InputString) do begin
    ConvertByte:=ord(InputString[i]);
    Case Convert_Flag of

     ALT_2_ISO: ConvertByte:=Alt2Iso(ConvertByte);
     ALT_2_KOI: ConvertByte:=Alt2Koi(ConvertByte);
     ALT_2_MAC: ConvertByte:=Alt2Mac(ConvertByte);
     ALT_2_WIN: ConvertByte:=Alt2Win(ConvertByte);

     ISO_2_ALT: ConvertByte:=Iso2Alt(ConvertByte);
     ISO_2_KOI: ConvertByte:=Iso2Koi(ConvertByte);
     ISO_2_MAC: ConvertByte:=Iso2Mac(ConvertByte);
     ISO_2_WIN: ConvertByte:=Iso2Win(ConvertByte);

     KOI_2_ALT: ConvertByte:=Koi2Alt(ConvertByte);
     KOI_2_ISO: ConvertByte:=Koi2Iso(ConvertByte);
     KOI_2_MAC: ConvertByte:=Koi2Mac(ConvertByte);
     KOI_2_WIN: ConvertByte:=Koi2Win(ConvertByte);

     MAC_2_ALT: ConvertByte:=Mac2Alt(ConvertByte);
     MAC_2_ISO: ConvertByte:=Mac2Iso(ConvertByte);
     MAC_2_KOI: ConvertByte:=Mac2Koi(ConvertByte);
     MAC_2_WIN: ConvertByte:=Mac2Win(ConvertByte);

     WIN_2_ALT: ConvertByte:=Win2Alt(ConvertByte);
     WIN_2_ISO: ConvertByte:=Win2Iso(ConvertByte);
     WIN_2_KOI: ConvertByte:=Win2Koi(ConvertByte);
     WIN_2_MAC: ConvertByte:=Win2Mac(ConvertByte);

    end;
    InputString[i]:=chr(ConvertByte);
   end;
   ConvertString:=InputString;
end;


begin
end.
//---End of Unit RusChar