// Split frames class

void    drawBorderAroundWindow (HPS hps, HWND hwnd, int borderType)
{
   RECTL rcl;
   SWP swp;

   //DosBeep (1000, 100);
   WinQueryWindowPos (hwnd, &swp);

   rcl.xLeft = swp.x - 1;
   rcl.xRight = swp.x + swp.cx + 1;
   rcl.yBottom = swp.y - 1;
   rcl.yTop = swp.y + swp.cy + 1;

   switch (borderType)
   {
      case BORDERTYPE_INVISIBLE: break;

      case BORDERTYPE_SUNKEN:
      WinDrawBorder (hps, &rcl, 1, 1, 0, 0, 0x0800);
      break;

      case BORDERTYPE_NORMAL:
      WinDrawBorder (hps, &rcl, 1, 1, 0, 0, 0x0400);
      break;

      case BORDERTYPE_BLACK:
      WinDrawBorder (hps, &rcl, 1, 1, 0, 0, DB_STANDARD);
      break;

      case BORDERTYPE_SUPER:
      WinDrawBorder (hps, &rcl, 2, 2, 0x00888888, 0, 0x1000);
      break;

      case BORDERTYPE_ENTRY:
      WinDrawBorder (hps, &rcl, 2, 2, 0x00888888, 0x00FFFFFF, 0x4000);
      break;
   }
}


void    resizeSplitframe (PSPLITDATA psd, int width, int height)
{
   int a, b;
   PFRAMEPACK pfp, pfp2;

   if (!width || !height) return; // nothing to do.

   if (psd->splitPack->splitType & SPLITTYPE_VERTICAL)
   {
      pfp = &psd->leftTop.fp;
      pfp2 = &psd->rightBottom.fp;

      if ((pfp->frameType & FRAMETYPE_AUTOSIZE) &&
          (pfp2->frameType & FRAMETYPE_AUTOSIZE)) // check for too many shit ;-(
         pfp2->frameType &= ~FRAMETYPE_AUTOSIZE;

      if (pfp->frameType & FRAMETYPE_AUTOSIZE)
      {
         a = (pfp2->size > 0) ? (height - pfp2->size) :
             (height + pfp2->size * height / 100);
      }
      else
      {
         a = (pfp->size > 0) ? pfp->size : (-pfp->size * height / 100);
      }

      WinSetWindowPos (psd->leftTop.hwnd,
                       HWND_TOP,
                       pfp->leftMargin,
                       pfp->bottomMargin,
                       width - pfp->leftMargin - pfp->rightMargin,
                       max (a - pfp->bottomMargin - pfp->topMargin, 0),
                       SWP_MOVE | SWP_SIZE | SWP_SHOW | SWP_ZORDER);

      if (pfp2->frameType & FRAMETYPE_AUTOSIZE)
      {
         b = (pfp->size > 0) ? (height - pfp->size) :
             (height + pfp->size * height / 100);
      }
      else
      {
         b = (pfp2->size > 0) ? pfp2->size : (-pfp2->size * height / 100);
      }

      WinSetWindowPos (psd->rightBottom.hwnd,
                       HWND_TOP,
                       pfp2->leftMargin,
                       pfp2->bottomMargin + a,
                       width - pfp2->leftMargin - pfp2->rightMargin,
                       max (b - pfp2->bottomMargin - pfp2->topMargin, 0),
                       SWP_MOVE | SWP_SIZE | SWP_SHOW | SWP_ZORDER);

   } else
   {
      pfp2 = &psd->leftTop.fp;
      pfp = &psd->rightBottom.fp;

      if ((pfp->frameType & FRAMETYPE_AUTOSIZE) &&
          (pfp2->frameType & FRAMETYPE_AUTOSIZE)) // check for too many shit ;-(
         pfp2->frameType &= ~FRAMETYPE_AUTOSIZE;

      if (pfp->frameType & FRAMETYPE_AUTOSIZE)
      {
         a = (pfp2->size > 0) ? (width - pfp2->size) :
             (width + pfp2->size * width / 100);
      }
      else
      {
         a = (pfp->size > 0) ? pfp->size : (-pfp->size * width / 100);
      }

      WinSetWindowPos (psd->rightBottom.hwnd,
                       HWND_TOP,
                       pfp->leftMargin,
                       pfp->bottomMargin,
                       max (a - pfp->leftMargin - pfp->rightMargin, 0),
                       height - pfp->bottomMargin - pfp->topMargin,
                       SWP_MOVE | SWP_SIZE | SWP_SHOW | SWP_ZORDER);

      if (pfp2->frameType & FRAMETYPE_AUTOSIZE)
      {
         b = (pfp->size > 0) ? (width - pfp->size) :
             (width + pfp->size * width / 100);
      }
      else
      {
         b = (pfp2->size > 0) ? pfp2->size : (-pfp2->size * width / 100);
      }

      WinSetWindowPos (psd->leftTop.hwnd,
                       HWND_TOP,
                       a + pfp2->leftMargin,
                       pfp2->bottomMargin,
                       max (b - pfp2->leftMargin - pfp2->rightMargin, 0),
                       height - pfp2->bottomMargin - pfp2->topMargin,
                       SWP_MOVE | SWP_SIZE | SWP_SHOW | SWP_ZORDER);
   }
}

void    frameCreate (HWND hwnd, PFRAMEDATA pfd, HWND hwndSibling)
{

pfd->hwnd = WinCreateWindow (hwnd,
                             pfd->fp.windowClass,
                             pfd->fp.windowText,
                             pfd->fp.windowStyle,
                             0, 0, 0, 0,
                             hwnd,
                             hwndSibling,
                             pfd->fp.windowID,
                             pfd->fp.windowData,
                             NULL);
}

int     checkSplitTrack (PSPLITDATA psd, short x, short y)
{
   SWP swp1, swp2;

   if (!(psd->splitPack->splitType & SPLITTYPE_SIZEABLE)) return 0;

   WinQueryWindowPos (psd->leftTop.hwnd, &swp1);
   WinQueryWindowPos (psd->rightBottom.hwnd, &swp2);

   if (psd->splitPack->splitType & SPLITTYPE_VERTICAL)
   {
      if (((swp1.y + swp1.cy) <= y) && (swp2.y > y)) return 1;
   } else
   {
      if (((swp2.x + swp2.cx) <= x) && (swp1.x > x)) return 2;
   }

return 0;
}

void    trackSplitFrame (PSPLITDATA psd, int x, int y)
{
   SWP swp1, swp2, swp;
   TRACKINFO tiStruct;

   if (!(psd->splitPack->splitType & SPLITTYPE_SIZEABLE)) return;

   WinQueryWindowPos (psd->leftTop.hwnd, &swp1);
   WinQueryWindowPos (psd->rightBottom.hwnd, &swp2);
   WinQueryWindowPos (psd->hwnd, &swp);

   if (psd->splitPack->splitType & SPLITTYPE_VERTICAL)
   {
      tiStruct.cxBorder = 2;
      tiStruct.cyBorder = 2;
      tiStruct.cxGrid = 0;
      tiStruct.cyGrid = 0;

      tiStruct.rclTrack.xLeft = 0;
      tiStruct.rclTrack.xRight = swp.cx;
      tiStruct.rclTrack.yTop = y + 1;
      tiStruct.rclTrack.yBottom = y - 1;

      tiStruct.rclBoundary.xLeft = 0;
      tiStruct.rclBoundary.xRight = swp.cx;
      tiStruct.rclBoundary.yTop = swp.cy;
      tiStruct.rclBoundary.yBottom = 0;

      tiStruct.ptlMinTrackSize.x = swp.cx;
      tiStruct.ptlMinTrackSize.y = 3;
      tiStruct.ptlMaxTrackSize.y = 3;
      tiStruct.ptlMaxTrackSize.x = swp.cx;
      tiStruct.fs = TF_ALLINBOUNDARY | TF_MOVE;

      if (WinTrackRect (psd->hwnd, (HPS)0L, &tiStruct))
      {
         if (!(psd->leftTop.fp.frameType & FRAMETYPE_AUTOSIZE))
         {
            psd->leftTop.fp.size += (psd->leftTop.fp.size > 0) ?
                                     y - tiStruct.rclTrack.yTop - 1 :
                                     ((y - tiStruct.rclTrack.yTop - 1) * 100) / swp.cy;
         } else
         {
            psd->rightBottom.fp.size -= (psd->rightBottom.fp.size > 0) ?
                                     y - tiStruct.rclTrack.yTop - 1 :
                                     ((y - tiStruct.rclTrack.yTop - 1) * 100) / swp.cy;
         }

         resizeSplitframe (psd, swp.cx, swp.cy);
         WinInvalidateRect (psd->hwnd, NULL, TRUE);
      }
   } else
   {
      tiStruct.cxBorder = 2;
      tiStruct.cyBorder = 2;
      tiStruct.cxGrid = 0;
      tiStruct.cyGrid = 0;

      tiStruct.rclTrack.xLeft = x - 1;
      tiStruct.rclTrack.xRight = x + 1;
      tiStruct.rclTrack.yTop = swp.cy;
      tiStruct.rclTrack.yBottom = 0;

      tiStruct.rclBoundary.xLeft = 0;
      tiStruct.rclBoundary.xRight = swp.cx;
      tiStruct.rclBoundary.yTop = swp.cy;
      tiStruct.rclBoundary.yBottom = 0;

      tiStruct.fs = TF_ALLINBOUNDARY | TF_MOVE;

      tiStruct.ptlMinTrackSize.x = 3;
      tiStruct.ptlMinTrackSize.y = swp.cy;
      tiStruct.ptlMaxTrackSize.y = swp.cy;
      tiStruct.ptlMaxTrackSize.x = 3;

      if (WinTrackRect (psd->hwnd, (HPS)0L, &tiStruct))
      {

         if (!(psd->leftTop.fp.frameType & FRAMETYPE_AUTOSIZE))
         {
            psd->leftTop.fp.size -= (psd->leftTop.fp.size > 0) ?
                                     (x - tiStruct.rclTrack.xLeft + 1) :
                                     ((x - tiStruct.rclTrack.xLeft + 1) * 100) / swp.cx;
         } else
         {
            psd->rightBottom.fp.size += (psd->rightBottom.fp.size > 0) ?
                                     (x - tiStruct.rclTrack.xLeft + 1) :
                                     ((x - tiStruct.rclTrack.xLeft + 1) * 100) / swp.cx;
         }

         resizeSplitframe (psd, swp.cx, swp.cy);
         WinInvalidateRect (psd->hwnd, NULL, TRUE);
      }
   }
}


MRESULT EXPENTRY splitWindowProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PSPLITDATA psd;
   MRESULT mrc;

   if (msg == WM_CREATE)
   {
      psd = (PSPLITDATA) malloc (sizeof (*psd));

      if (psd)
      {
         PCREATESTRUCT pcs = (PCREATESTRUCT)mp2;

         memset (psd, 0, sizeof (*psd));
         psd->splitPack = (PSPLITPACK)mp1;
         psd->hwnd = hwnd;

         if (psd->splitPack)
         {
            psd->leftTop.fp = psd->splitPack->leftTop; // copy frames
            psd->rightBottom.fp = psd->splitPack->rightBottom;

            frameCreate (hwnd, &psd->leftTop, HWND_TOP);
            frameCreate (hwnd, &psd->rightBottom, psd->leftTop.hwnd);

            if (psd->splitPack->splitWindowProc)
            {
               psd->splitPack->splitWindowProc (hwnd, msg, mp1, mp2, &mrc);
            }

            resizeSplitframe (psd, pcs->cx, pcs->cy);
         }

         WinSetWindowULong (hwnd, 0, (ULONG)psd);
      }
   } else
   {
      HPS hps;
      RECTL rcl;

      psd = (PSPLITDATA) WinQueryWindowULong (hwnd, 0);

      if (psd->splitPack->splitWindowProc &&
          psd->splitPack->splitWindowProc (hwnd, msg, mp1, mp2, &mrc))
         return mrc;

      switch (msg)
      {
         case WM_SIZE:
         resizeSplitframe (psd, SHORT1FROMMP (mp2), SHORT2FROMMP (mp2));
         break;

         case WM_PAINT:

         hps = WinBeginPaint (hwnd, 0, &rcl);
         GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
         WinFillRect (hps, &rcl, psd->splitPack->bgColor);

         drawBorderAroundWindow (hps, psd->leftTop.hwnd,
                                 psd->leftTop.fp.borderType);

         drawBorderAroundWindow (hps, psd->rightBottom.hwnd,
                                 psd->rightBottom.fp.borderType);

         WinEndPaint (hps);
         return (MRESULT) 1L;

         case WM_MOUSEMOVE:
         {
            int i = checkSplitTrack (psd, SHORT1FROMMP (mp1), SHORT2FROMMP (mp1));
            WinSetPointer (HWND_DESKTOP,
                           WinQuerySysPointer (HWND_DESKTOP,
                                               ((i == 0) ? SPTR_ARROW :
                                               ((i == 1) ? SPTR_SIZENS : SPTR_SIZEWE)), FALSE));
         return (MRESULT) 0L;
         }

         case WM_BUTTON1DOWN:
         {
            if (checkSplitTrack (psd, SHORT1FROMMP (mp1), SHORT2FROMMP (mp1)) > 0)
            {
               trackSplitFrame (psd, SHORT1FROMMP (mp1), SHORT2FROMMP (mp1));
               //DosBeep (500, 100);
            }

         return (MRESULT) 0L;
         }

         case WM_DESTROY: // delete instance data
         free (psd);
         break;
      }
   }

return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

void EXPENTRY registerSplitframe (HAB hab)
{
   WinRegisterClass (hab, WC_SPLITFRAME, (PFNWP)splitWindowProc,
                     CS_SIZEREDRAW, sizeof (ULONG));
}

