(****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                         System TRAY sample source                        *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************)

{
Programa de ejemplo para la bandeja del sistema.
Traducido al espaol y mejorado ligeramente
Por J. Francisco Garca Mtz.
Mxico
2/Ene/2001
}

  program TrayEx;

  {&PMTYPE PM}
  {&Use32+}

  Uses Os2Def, Os2Base, Os2PmApi, TrayApi, SysUtils;

  {$R trayex.res}

  Const
        ID_RESOURCE = 100;

  Var
    hwndFrame  : HWND;
    hwndClient : HWND;
    _hmq       : HMQ;
    _qmsg      : QMSG;
    _hab       : HAB;
    i          : byte; //contador para nombres de recursos de iconos
    hIcon      : Array [0..5] of HPOINTER;
    Ptl        : PointL; //coordenadas del apuntador del ratn.
    a          :integer; //Contador de iconos
    hwndMenu : HWND;  //manejador del men.
    AutoChanging:Boolean; //Bandera indicadora del estado de la opcin del men Auto-Cambiar icono

  Function ClientWndProc( wnd : HWND  ; msg : ULONG ;
                          mp1 : MPARAM; mp2 : MPARAM): MRESULT; cdecl;
  Var
    rcl          : RECTL; //rectngulo (coordenadas)
    PS           : HPS;
    Mensaje          : String;
  Const lColorB  : LONG  = CLR_CYAN;
        lColorF  : LONG  = CLR_DARKBLUE;
        szMsg    : PChar = 'Hola, mundo!';

  Procedure ChangeIcon;
     Begin
        Inc (a) ;
        a :=a mod 5 ;
        WinSendMsg(hwndFrame,WM_SETICON,MPARAM(hIcon[a]),0) ; // Cambia el icono de la ventana
        ChangeTrayIcon(wnd,0) ; // Avisa a Systray que el icono ha cambiado
     End;


  Begin
    Case msg Of
      WM_BUTTON1CLICK or $2000: // 0x2000 significa un mensaje de Systray.
            ChangeIcon;
      WM_BUTTON2click or $2000: // 0x2000 significa un mensaje de Systray.
         Begin
            WinQueryPointerPos (HWND_DESKTOP, ptl); // obtiene las coordenadas del apuntador del ratn en el escritorio.
            WinMapWindowPoints (HWND_DESKTOP,wnd , ptl, 1) ; //Mapea las coordenadas del escritorio a la aplicacin.
            WinPopupMenu(WND, wnd, hwndMenu, ptl.x, ptl.y, 0, // muestra el men emergente.
                PU_HCONSTRAIN   or // fuerza el men a que quepa en la pantalla horizontalmente.
                PU_VCONSTRAIN or // fuerza el men a que quepa en la pantalla verticalmente.
                PU_MOUSEBUTTON1  or //Usar el men con el botn 1 del ratn.
                PU_MOUSEBUTTON2 or  //Usar el men con el botn 2 del ratn.
                PU_KEYBOARD //Usar el men con el teclado.
                );
         End;
      WM_COMMAND:
         Case Integer(Mp1) Of
            201:WinSetWindowPos(hwndFrame,HWND_TOP,0,0,0,0,SWP_ACTIVATE or SWP_SHOW or SWP_ZORDER or SWP_RESTORE) ; //Restaura la ventana.
            205:ChangeIcon;
            202:WinPostMsg(wnd, WM_CLOSE, MPARAM(0), MPARAM(0)); //Enva el mensaje de cerrar la ventana.
            204:
            Begin
               Mensaje := 'Ejemplo de aplicacin que usa la bandeja del sistema'+#0;
               WinMessageBox(
                  HWND_DESKTOP,
                  hwndFrame,                // Manejador de la ventana cliente
                  @mensaje[1],                  // Cuerpo del mensaje
                  'Acerca del ejemplo Systray',   // Ttulo del mensaje
                  0,                         // Identificador del cuadro de mensaje
                  MB_Information OR MB_OK OR
                  MB_moveable OR
                  MB_ApplModal);       // banderas de icono y botn
            End;
            206:
            Begin
               If AutoChanging Then
                  Begin
                     WinStopTimer (_hab,wnd,1);
                     WinSendMsg (hwndMenu, MM_SETITEMATTR,
                        MPFROM2SHORT (206, 1),
                        MPFROM2SHORT (MIA_CHECKED, 0));
                     AutoChanging:=False
                  End
               Else
                  If WinStartTimer(_hab,wnd,1,500) <> 0 THEN
                     Begin
                        WinSendMsg (hwndMenu, MM_SETITEMATTR,
                           MPFROM2SHORT (206, 1),
                           MPFROM2SHORT (MIA_CHECKED, MIA_CHECKED)) ;
                        AutoChanging:=True
                     End
                  Else
                     WinMessageBox (HWND_DESKTOP, wnd,
                        'Demasiados temporizadores en el sistema',
                        'Error Auto-cambiar icono', 0,
                        MB_OK OR MB_WARNING)
            End
         End;
      WM_TIMER:ChangeIcon;
      WM_CREATE:
        Begin
        InitializeTrayApi(wnd); //Inicializa la bandeja del sistema.
        End;
      WM_DDE_INITIATEACK:
        Begin
        AnswerTrayApiDdeAck(mp1); // Contestar a Systray cuando pregunta si estamos listos.
        AddTrayIcon(wnd,0); // Agregar el icono de la aplicacin a la badeja.
        End;
      WM_DESTROY:
        Begin
        DeleteTrayIcon(wnd); // Borrar el icono de la bandeja del sistema (MUY Importante)
        End;
      WM_PAINT:
        Begin

        WinQueryWindowRect(wnd, rcl);
        PS := WinBeginPaint(Wnd, 0, @Rcl);
        WinFillRect(PS, Rcl, lColorB);
        WinDrawText(PS, -1, szMsg, rcl, lColorF, lColorB,
                    DT_CENTER or DT_VCENTER);
        WinEndPaint(PS);

        ClientWndProc := 0; exit;
        End;
    End;
    ClientWndProc := WinDefWindowProc (wnd, msg, mp1, mp2);
  End;



  Const flFrameFlags : ULONG =
                        FCF_TITLEBAR      Or  (*  Barra de ttulo                       *)
                        FCF_SIZEBORDER    Or  (*  Borde ajustable de tamao             *)
                        FCF_MINMAX        Or  (*  Botones Min y Max                     *)
                        FCF_SYSMENU       Or  (*  Men del sistema                      *)
                        FCF_SHELLPOSITION Or  (*  Posicin y tamao del sistema         *)
                        FCF_TASKLIST      Or  (*  Poner el nombre en la lista de tareas *)
                        FCF_ICON           ;  (*  Iconizar                              *)

  Begin
    _hab := WinInitialize(0);
    _hmq := WinCreateMsgQueue(_hab, 0);
    a:=0;
    WinRegisterClass(
       _hab,                   (* Manejador del ancla de bloque                     *)
       'TrayExClient',         (* Nombre de la clase a registrar                    *)
       ClientWndProc,          (* Procedimiento para manejar la ventana de la clase *)
       CS_SIZEREDRAW Or        (* Estilo de la clase                                *)
       CS_HITTEST,             (* Estilo de la clase                                *)
       0);                     (* Bytes extra a reservar                            *)

    hwndFrame := WinCreateStdWindow(
                 HWND_DESKTOP,       (* El padre es la ventana del escritorio        *)
                 WS_VISIBLE,         (* Hacer el marco de la ventana visible         *)
                 flFrameFlags,       (* Controles del marco                          *)
                 'TrayExClient',     (* Clase de la ventana para el cliente          *)
                 'Ejemplo de bandeja del sistema',     (* Ttulo de la ventana       *)
                 WS_VISIBLE,         (* Hacer la ventana cliente visible             *)
                 0,                  (* Recursos en mdulo de la aplicacin          *)
                 ID_RESOURCE,        (* Identificador de los recursos                *)
                 nil);               (* Apuntador al manejador de la ventana cliente *)

    for i:=100 to 104 do  // carga cada uno de los iconos a este arreglo.
       hIcon[i-100] := WinLoadPointer(HWND_DESKTOP,NULLHANDLE,i) ;

    hwndMenu := WinLoadMenu(HWndFrame, 0, 100); // carga el men emergente.
    AutoChanging:=False; //Estado inicial de la opcin Auto-cambiar icono.


    While WinGetMsg(_hab, _qmsg, 0, 0, 0) Do // procesa los mensajes.
          WinDispatchMsg(_hab, _qmsg);
    WinDestroyWindow(hwndFrame);        // Destruye la ventana.
    WinDestroyMsgQueue(_hmq);           // Destruye la cola de mensajes.
    WinTerminate(_hab);                 // Termina su relacin con el S.O.
    Halt(0);                            // Termina el programa.
  End.



