/***********************************************************************/
/* CIDINST.CMD Workplace Security CID utility                          */
/*                                                                     */
/*                                                                     */
/*  Function:  Automated Workplace Security Installation               */
/*                                                                     */
/*                                                                     */
/*  Command format: CIDINST action regcode password  "name"            */
/*                                                                     */
/*  Command line options:                                              */
/*                                                                     */
/*   action   = INSTALL,DELETE,UPDATE, or RESTORE (required)           */
/*                                                                     */
/*   regcode  = product registration code (install only)               */
/*                                                                     */
/*   password = Master password of your choice (install only)          */
/*                                                                     */
/*   "name"   =  Name or company that the product is registered to     */
/*               (must be in quotes)                                   */
/*                                                                     */
/*  Example:                                                           */
/*                                                                     */ 
/*     CIDINST INSTALL ABCDEF123456 MASTER "Maple Valley Software"     */
/*                                                                     */
/*  Note: Change the Source_directory and Target_directory             */
/*        as appropriate for your installation.                        */
/*                                                                     */
          Source_directory  = "C:\TEMP" 
          Target_directory  = "D:\WPSECURE"
/*                                                                     */
/*                                                                     */
/* Workplace Security Copyright (C) 1995, 1996 Maple Valley Software   */
/***********************************************************************/
 

'@Echo Off'
/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialize */
irc = 0
log_date = insert('-',date('S'),6)
log_date = insert('-',log_date,4)
log_time = substr(time('L'),1,11)   
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

parse upper arg install_action regcode password .  
parse arg . . . name



if wordpos(install_action,"INSTALL UPDATE RESTORE DELETE") = 0 then do
     say 'CIDINST action not specified.'
     exit 65280
     end

if install_action = "INSTALL" then do
     if regcode = '' then do 
     say 'CIDINST INSTALL requires the registration code and master password.'
     exit 65280
     end
 
     if password = '' then do 
     say 'CIDINST INSTALL requires the registration code and master password.'
     exit 65280
     end
   end

/* Build CID install options */
Product_name        = '/P:"Workplace Security"'
Install_Catalog     = "/C:"||Source_directory||"\WPSECURE.ICF"
Install_log         = Target_directory||"\CIDINST.LOG"
Response_file       = Target_directory||"\WPSECURE.RSP"

/* Create Target Directory */
Result = SysFileTree( Target_directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Target_directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End

Call SysCls


/* build Response file */

call lineout Response_file,,1           /* open the file */ 
call lineout Response_file,"FILE         = "Target_directory 
call lineout Response_file,"WORK         = "Target_directory 
call lineout Response_file,"COMP         = Workplace Security"
call lineout Response_file,"CFGUPDATE    = MANUAL" 
call lineout Response_file,"OVERWRITE    = YES"
call lineout Response_file,"SAVEBACKUP   = YES"
call lineout Response_file,"DELETEBACKUP = NO"
call lineout Response_file              /* close the file */

Install_action = translate(install_action)
if install_action = "INSTALL" then Action = "/A:I"
if install_action = "DELETE"  then Action = "/A:D"
if install_action = "UPDATE"  then Action = "/A:U"
if install_action = "RESTORE" then Action = "/A:R"
 
CID_Install_Options = Action "/X /O:DRIVE /S:"||Source_directory " /T:"||Target_directory "/R:"||Response_file "/L1:"||Install_log   

call directory(Source_directory)

"INSTALL.EXE" Product_name CID_Install_Options Install_Catalog   
irc = rc    /* save return code from installer */
call directory(Target_directory)

if install_action = "INSTALL" then do
   'REGISTER.EXE' regcode password name
   rrc = rc 
   log_time = substr(time('L'),1,11)   
   if rrc = 0 then call lineout Install_log, log_date log_time ' Workplace Security Registration complete'
   if rrc = 1 then call lineout Install_log, log_date log_time ' ERROR: Invalid registration code'
   if rrc = 2 then call lineout Install_log, log_date log_time ' ERROR: Invalid registration parameters' 
   if rrc <> 0 then irc = 65280 
   end

Signal DONE 

FAILURE:
call lineout Install_log, log_date log_time ' REXX failure: Error in CIDINST.CMD'
irc = 65042
Signal DONE

HALT:
call lineout Install_log, log_date log_time ' REXX halt: Error in CIDINST.CMD'
irc = 65042
Signal DONE

SYNTAX:
call lineout Install_log, log_date log_time ' REXX syntax error: Error in CIDINST.CMD'
irc = 65042
Signal DONE

DONE:
Exit irc
