/*
 * repclass.c:
 *      This file contains the REPCLASS utility for registering
 *      a new WPS class and replacing an existing class with it
 *      in one step. The command-line syntax is:
 *
 *          repclass <oldclass> <newclass> [<dllname>]
 *
 *      If <dllname> is specified, <newclass> is registered and
 *      replaces <oldclass>.
 *
 *      If <dllname> is omitted, the replacement of <oldclass>
 *      with <newclass> is undone and <newclass> is de-registered.
 *
 *      Initial release: Aug. 12, 1998
 *      This version: 0.82. Made the output msgs a bit more lucid.
 *
 *      Copyright (C) 1997-98 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#include <stdio.h>
#include <os2.h>

/*
 * main:
 *      evaluate the command line, perform error checking
 *      and do all the (de)registering and (un)replacing.
 */

void main(int argc, char *argv[])
{
    /* The argv array will contain the following:
     *         0         1          2            3
     *      repclass <oldclass> <newclass> [<dllname>]
     */

    BOOL rc1, rc2;

    if (argc == 4) {
        // four parameters: user wants registering.
        // First register <newclass>
        printf("Registrando %s en la lista de clases del WPS: ", argv[2]);
        if (WinRegisterObjectClass(argv[2], argv[3])) {
            printf("Bien\n");
        } else {
            printf("Error!\n");
        }
        // Then replace <oldclass> with <newclass>.
        printf ("Sustituyendo %s por %s: ", argv[1], argv[2]);
        if (WinReplaceObjectClass(argv[1], argv[2], TRUE)) {
            printf("Bien\n");
        } else {
            printf("Error!\n");
        }
    } else if (argc == 3) {
        // three parameters: user wants deregistering.
        // First undo replacement of <oldclass> with <newclass>.
        printf ("Des-sustituyendo %s por %s: ", argv[2], argv[1]);
        if (WinReplaceObjectClass(argv[1], argv[2], FALSE)) {
            printf("Bien\n");
        } else {
            printf("Error!\n");
        }
        // Then deregister <newclass>.
        printf ("Desregistrando %s: ", argv[2]);
        if (WinDeregisterObjectClass(argv[2])) {
            printf("Bien\n");
        } else {
            printf("Error!\n");
        }
    } else {
        // neither three nor four parameters: explain ourselves.
        printf("repclass V0.82 (w) (c) 1998 Ulrich Mller\n");
        printf("Parte del paquete XFolder.\n");
        printf("Software libre bajo la Licencia Pblica General GNU (GPL).\n");
        printf("Vase el archivo COPYING en el directorio de instalacin para ms detalles.\n");
        printf("Sustituye una clase dada del WPS o deshace la sustitucin.\n");
        printf("Uso: repclass <original> <nueva> [<nombredll>]\n");
        printf("donde:\n");
        printf("   <original>  el nombre de una clase del WPS instalada actualmente;\n");
        printf("   <nueva>     el nombre de la nueva clase que va a sustituirla;\n");
        printf("   <nombredll> el nombre del archivo DLL que contiene la nueva clase; si no se\n");
        printf("               encuentra en el LIBPATH, deber especificar la ruta completa.\n");
        printf("Si se omite <nombredll>, se retirar la clase <nueva> de la lista de sustituciones\n");
        printf("de la clase <original>.\n");
        printf("Los nombres de las clases son sensibles a maysculas/minsculas.\n");
        printf("Ejemplos:\n");
        printf("   repclass WPFolder XFolder xfolder.dll -- registrar XFolder\n");
        printf("   repclass WPFolder XFolder             -- desregistrar XFolder\n");
    }
}

