#
# Makefile for XFolder National Language Support.
#
# For use with IBM NMAKE, which is part of IBM C-Set/2 and VisualAge C++.
# This file will probably not work with other MAKE utilities, such as
# GNU make or DMAKE.
#
# This makefile assumes that certain toolkit tools are on the PATH.
# In addition, you must put the "unlock" utility from the "tools"
# directory on your PATH, or this will fail.
#
# Copyright (C) 1997-99 Ulrich Mller.
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, in version 2 as it comes in the COPYING
# file of the XFolder main distribution.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# Required changes for translating the NLS DLL: three lines below.
#

# This is the language code for the language that the NLS DLL
# will support. Change this to a different language code, and
# the makefile will support your langauge.
LANGUAGE = 049
# Change this to the directory where you installed XFolder.
# The output files will automatically be copied there to.
!ifndef XFOLDERPATH
!error The environment variable XFOLDERPATH is not defined. Terminating.
!endif
XFRUNNING = $(XFOLDERPATH)

#
# DO NOT CHANGE THE FOLLOWING
#

#
# Set up a few environment variables.
#

CC      = icc /Ge- /Se
LINK    = ilink
RC      = rc -i ..
OBJS = xfldr$(LANGUAGE).obj
XFLDHELP = $(XFRUNNING)\help

#
# Define the suffixes for files which NMAKE will work on.
# .SUFFIXES is a reserved NMAKE keyword ("pseudotarget") for
# defining file extensions that NMAKE will recognize.
#

.SUFFIXES: .msg .txt .c .obj .dll .rc .res .html .ipf .hlp .inf

#
# Now define inference rules for what to do with certain file
# types, based on their file extension.
# The syntax we need here is ".fromext.toext".
# So whenever NMAKE encounters a .toext file, it
# executes what we specify here.
#

.c.obj:
        $(CC) -I$(INCLUDE) -c $<

#
# Now define inference rules for the different file types.
#

all: xfldr$(LANGUAGE).dll $(XFLDHELP)\xfldr$(LANGUAGE).msg

$(XFLDHELP)\xfldr$(LANGUAGE).msg: xfldr$(LANGUAGE).msg
        cmd.exe /c copy $(@B).msg $(XFLDHELP)

xfldr$(LANGUAGE).msg: $$(@B).txt
         mkmsgf $*.txt $*.msg

xfldr$(LANGUAGE).obj: $$(@B).c

xfldr$(LANGUAGE).dll: $$(@B).def $(OBJS) $$(@B).res ..\main\dlgids.h
         $(LINK) $*.def $(OBJS) /OUT:$*.dll
         $(RC) -p -x2 $*.res $*.dll
         unlock $(XFRUNNING)\bin\$*.dll
         cmd.exe /c del $(XFRUNNING)\bin\$*.dll
         cmd.exe /c copy $*.dll $(XFRUNNING)\bin

xfldr$(LANGUAGE).res: $$(@B).rc $$(@B).dlg *.bmp *.ico ..\main\dlgids.h
         $(RC) -r -x2 $*.rc $*.res


