/*#include <som.h>
#define INCL_DOS
#define INCL_WIN
#define INCL_ERRORS
#define INCL_DOSMISC
#define INCL_WINWORKPLACE
#include <os2.h>*/
#include "vncv.ih"
#include "debug.h"

#ifndef DosQueryModFromEIP
APIRET APIENTRY  DosQueryModFromEIP(HMODULE *phMod, ULONG *pObjNum,
                                    ULONG BuffLen, PCHAR pBuff, ULONG *pOffset,
                                    ULONG Address);
#endif

HMODULE wpsutilGetModuleHandle()
{
  HMODULE    hmod = NULLHANDLE;
  ULONG      ulObjectNumber  = 0;
  ULONG      ulOffset        = 0;
  CHAR       szModName[_MAX_PATH];

  DosQueryModFromEIP( &hmod, &ulObjectNumber,
                      sizeof( szModName), szModName,
                      &ulOffset, (ULONG)wpsutilGetModuleHandle );
  return hmod;
}

BOOL wpsutilLoadStrNew(PVOID somSelf, PSZ pszClass, ULONG ulKey,
                       PSZ *ppszValue)
{
  ULONG      cbValue;
  PSZ        pszValue;

  if ( !_wpRestoreString( somSelf, pszClass, ulKey, NULL, &cbValue ) )
    return FALSE;

  if ( cbValue == 0 )
    pszValue = NULL;
  else
  {
    cbValue++;
    pszValue = malloc( cbValue );
    if ( pszValue == NULL )
      return FALSE;

    if ( !_wpRestoreString( somSelf, pszClass, ulKey, pszValue, &cbValue ) )
    {
      free( pszValue );
      return FALSE;
    }
  }

  *ppszValue = pszValue;

  return TRUE;
}

BOOL wpsutilSetupStrNew(PVOID somSelf, PSZ pszSetupString, PSZ pszKey,
                        PSZ *ppszValue)
{
  ULONG      cbValue;
  PSZ        pszValue;

  if ( !_wpScanSetupString( somSelf, pszSetupString, pszKey, NULL, &cbValue ) )
    return FALSE;

  if ( cbValue == 0 )
    pszValue = NULL;
  else
  {
    cbValue++;
    pszValue = malloc( cbValue );
    if ( pszValue == NULL )
      return FALSE;

    if ( !_wpScanSetupString( somSelf, pszSetupString, pszKey, pszValue,
                              &cbValue ) )
    {
      free( pszValue );
      return FALSE;
    }
  }

  *ppszValue = pszValue;

  return TRUE;
}

BOOL wpsutilSetupReadBool(PVOID somSelf, PSZ pszSetupString, PSZ pszKey,
                          PBOOL pfValue)
{
  CHAR       acBuf[4] = { 0 };
  ULONG      cbBuf;

  cbBuf = sizeof(acBuf);
  if ( !_wpScanSetupString( somSelf, pszSetupString, pszKey, acBuf, &cbBuf ) )
    return FALSE;

  strupr( acBuf );

  switch( *((PULONG)&acBuf) )
  {
    case (ULONG)'\0SEY':    // YES
    case (ULONG)'\0\0\0Y':  // Y
    case 0x00000031:        // 1
    case (ULONG)'\0\0NO':   // ON
      *pfValue = TRUE;
      return TRUE;
  }

  switch( *((PULONG)&acBuf) )
  {
    case (ULONG)'\0\0ON':   // NO
    case (ULONG)'\0\0\0N':  // N
    case 0x00000030:        // 0
    case (ULONG)'\0FFO':    // OFF
      *pfValue = FALSE;
      return TRUE;
  }

  return FALSE;
}

BOOL wpsutilSetupReadULong(PVOID somSelf, PSZ pszSetupString, PSZ pszKey,
                           PULONG pulValue)
{
  CHAR       acBuf[32];
  ULONG      cbBuf;
  PCHAR      pcEnd;

  cbBuf = sizeof(acBuf);
  if ( !_wpScanSetupString( somSelf, pszSetupString, pszKey, acBuf, &cbBuf )
       || ( cbBuf == 0 ) )
    return FALSE;

  *pulValue = (ULONG)strtol( acBuf, &pcEnd, 0 );

  return pcEnd != acBuf;
}

/*
   PVOID wpsutilIconFromBitmap(HBITMAP hBmp, PULONG pulSize)

   Creates an icon from the bitmap. Result is a pointer to icon data - like
   ICO-file content in memory. Pointer should be destroyed with free().
   Returns NULL on error.
 */

static VOID _initBmFileHdr2(PBITMAPFILEHEADER2 pHdr)
{
  memset( pHdr, 0, sizeof(BITMAPFILEHEADER2) );
  pHdr->usType = BFT_COLORICON;
  pHdr->cbSize = sizeof(BITMAPFILEHEADER2);
  pHdr->bmp2.cbFix = sizeof(BITMAPINFOHEADER2);
  pHdr->bmp2.cPlanes = 1;
}

PVOID wpsutilIconFromBitmap(HBITMAP hBmp, PULONG pulSize)
{
  HAB        hab = WinQueryAnchorBlock( HWND_DESKTOP );
  HDC        hdcIco = DevOpenDC( hab, OD_MEMORY, "*", 0, NULL, NULLHANDLE );
  HBITMAP    hbmIco = NULLHANDLE;
  HPS        hpsIco = NULLHANDLE;
  PBYTE      pbIconData = NULL, pbPtr;
  SIZEL      sizelIco;
  CHAR       acbmih[sizeof(PBITMAPINFOHEADER2) + (sizeof(RGB2) * 256)] = { 0 };
  PBITMAPINFOHEADER2 pbmih = (PBITMAPINFOHEADER2)&acbmih;
  PBITMAPINFO2       pbmi = NULL;
  RECTL      rectlIcon;
  LONG       lRC;
  ULONG      cbMaskLine, cbMask, cbIco;
  ULONG      ulCY, ulCX;
  BOOL       fSuccess = FALSE;

  if ( hdcIco == NULLHANDLE )
  {
    debugCP( "DevOpenDC() failed" );
    return NULL;
  }

  do
  {
    // Create a memory presentation space for the icon image.

    sizelIco.cx = WinQuerySysValue( HWND_DESKTOP, SV_CXICON );
    sizelIco.cy = WinQuerySysValue( HWND_DESKTOP, SV_CYICON );
    hpsIco = GpiCreatePS( hab, hdcIco, &sizelIco,
                          PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC );
    if ( hpsIco == NULLHANDLE )
    {
      debugCP( "GpiCreatePS() failed. Memory PS was not created." );
      break;
    }

    pbmih->cbFix      = sizeof(BITMAPINFOHEADER2);
    pbmih->cx         = sizelIco.cx;
    pbmih->cy         = sizelIco.cy;
    pbmih->cPlanes    = 1;
    pbmih->cBitCount  = 24;
    pbmi = (PBITMAPINFO2)pbmih;
    hbmIco = GpiCreateBitmap( hpsIco, pbmih, 0, NULL, pbmi );
    if ( ( hbmIco == GPI_ERROR ) || ( hbmIco == NULLHANDLE ) )
    {
      debug( "GpiCreateBitmap() failed: %u x %u, bpp: %u",
             pbmih->cx, pbmih->cy, pbmih->cBitCount );
      break;
    }

    if ( GpiSetBitmap( hpsIco, hbmIco ) == HBM_ERROR )
    {
      debug( "GpiSetBitmap(%u, %u) failed", hpsIco, hbmIco );
      break;
    }

    // Draw icon image in memory presentation space.

    // Query bitmap size.
    memset( pbmih, 0, sizeof(*pbmih) );
    pbmih->cbFix = sizeof(BITMAPINFOHEADER2);
    if ( !GpiQueryBitmapInfoHeader( hBmp, pbmih ) )
    {
      debug( "GpiQueryBitmapInfoHeader(%u,) failed", hBmp );
      break;
    }

    // Calculate proportional size and position (at center) of image.
    if ( (pbmih->cy * sizelIco.cx) < (sizelIco.cy * pbmih->cx) )
    {
      ulCX = sizelIco.cx;
      ulCY = (ulCX * pbmih->cy) / pbmih->cx;
      rectlIcon.xLeft = 0;
      rectlIcon.yBottom = ( sizelIco.cy - ulCY ) / 2;
    }
    else
    {
      ulCY = sizelIco.cy;
      ulCX = (ulCY * pbmih->cx) / pbmih->cy;
      rectlIcon.yBottom = 0;
      rectlIcon.xLeft = ( sizelIco.cx - ulCX ) / 2;
    }
    rectlIcon.xRight = rectlIcon.xLeft + ulCX;
    rectlIcon.yTop   = rectlIcon.yBottom + ulCY;

    // Draw (compressing) given bitmap to the new image.
    if ( !WinDrawBitmap( hpsIco, hBmp, NULL, (PPOINTL)&rectlIcon, 0, 0,
                         DBM_NORMAL | DBM_STRETCH ) )
    {
      debug( "WinDrawBitmap(,%u,,,,,) failed", hBmp );
      break;
    }

    // Make pointer (icon) data.

    // Calculate mask bitmap size.
    cbMaskLine = ( (sizelIco.cx + 31) / 32 ) * 4;
    cbMask = cbMaskLine * 2 /* 2: AndXor mask - double height */ * sizelIco.cy;
    // Calculate color image bitmap size.
    cbIco = sizelIco.cx * 3 * sizelIco.cy;

    /* Fill icon data:
     *   AndXor mask bitmap header,
     *   Paletter AndXor mask bitmap: 2 x RGB = 6 bytes,
     *   Color bitmap header,
     *   AndXor mask bitmap data,
     *   Color bitmap data.
     */
    pbIconData = malloc( (sizeof(BITMAPFILEHEADER2) * 2) + 8 + cbMask + cbIco );
    if ( pbIconData == NULL )
      break;
    pbPtr = pbIconData;

    // Header for the mask bitmap in pointer (icon).
    _initBmFileHdr2( (PBITMAPFILEHEADER2)pbPtr );
    ((PBITMAPFILEHEADER2)pbPtr)->xHotspot = sizelIco.cx / 2;
    ((PBITMAPFILEHEADER2)pbPtr)->yHotspot = sizelIco.cy / 2;
    ((PBITMAPFILEHEADER2)pbPtr)->offBits  = sizeof(BITMAPFILEHEADER2) * 2 + 8;
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cx  = sizelIco.cx;
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cy  = sizelIco.cy * 2; // Two masks: AND, XOR.
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cBitCount = 1;         // Number of bits per pel within a plane.
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cclrImportant = 2;     // Minimum number of color indexes for satisfactory appearance of the bit map.
    pbPtr += sizeof(BITMAPFILEHEADER2);
    *((PULONG)pbPtr) = 0;                  // Palette, first color.
    pbPtr += 4;
    *((PULONG)pbPtr) = 0x00FFFFFF;         // Palette, second color.
    pbPtr += 4;

    // Header for the color bitmap in pointer (icon).
    _initBmFileHdr2( (PBITMAPFILEHEADER2)pbPtr );
    ((PBITMAPFILEHEADER2)pbPtr)->xHotspot = sizelIco.cx / 2;
    ((PBITMAPFILEHEADER2)pbPtr)->yHotspot = sizelIco.cy / 2;
    ((PBITMAPFILEHEADER2)pbPtr)->offBits  = sizeof(BITMAPFILEHEADER2) * 2 + 8 +
                                            cbMask;
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cx  = sizelIco.cx;
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cy  = sizelIco.cy;
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cBitCount = 24;        // Number of bits per pel within a plane.
    ((PBITMAPFILEHEADER2)pbPtr)->bmp2.cclrUsed = 1 << 24;    // Number of color indexes used.
    pbPtr += sizeof(BITMAPFILEHEADER2);

    // Fill mask data for the pointer (icon).
    memset( pbPtr, 0x00, sizelIco.cy * cbMaskLine );
    pbPtr += sizelIco.cy * cbMaskLine;
    memset( &pbPtr[sizelIco.cy * cbMaskLine], 0x00, sizelIco.cy * cbMaskLine );
    if ( ulCX == sizelIco.cx ) // Horizontal?
    {
      for( ulCY = 0; ulCY < sizelIco.cy; ulCY++ )
      {
        memset( pbPtr,
                ( ulCY < rectlIcon.yBottom ) || ( ulCY >= rectlIcon.yTop )
                  ? 0xFF : 0x00,
                cbMaskLine );
        pbPtr += cbMaskLine;
      }
    }
    else
    {
      PBYTE           pbMask = pbPtr;
      BYTE            bMask = 0;

      for( ulCX = 0; ulCX < sizelIco.cx; ulCX++ )
      {
        if ( ( ulCX < rectlIcon.xLeft ) || ( ulCX >= rectlIcon.xRight ) )
          bMask |= 1 << (7 - (ulCX & 0x1F));

        if ( (ulCX & 0x07) == 0x07 )
        {
          *pbMask = bMask;
          bMask = 0;
          pbMask++;
        }
      }

      if ( (ulCX & 0x07) != 0x07 )
        *pbMask = bMask;
      pbMask = pbPtr;

      for( ulCY = 1; ulCY < sizelIco.cy; ulCY++ )
      {
        pbPtr += cbMaskLine;
        memcpy( pbPtr, pbMask, cbMaskLine );
      }
      pbPtr += cbMaskLine;
    }

    // Append color data to the pointer (icon).
    memset( pbmih, 0, sizeof(BITMAPINFOHEADER2) );
    pbmih->cbFix     = sizeof(BITMAPINFOHEADER2);
    pbmih->cPlanes   = 1;
    pbmih->cBitCount = 24;

    lRC = GpiQueryBitmapBits( hpsIco, 0, sizelIco.cy, pbPtr,
                              (PBITMAPINFO2)pbmih );
    if ( ( lRC == 0 ) || ( lRC == GPI_ALTERROR ) )
    {
      debugCP( "GpiQueryBitmapBits() failed" );
      break;
    }

    // Return size of the icon data.
    pbPtr += cbIco;
    *pulSize = pbPtr - pbIconData;

    fSuccess = TRUE;   // All done, no errors.
  }
  while( FALSE );


  // Free objects.

  if ( hpsIco != NULLHANDLE )
  {
    GpiSetBitmap( hpsIco, NULLHANDLE );
    GpiDestroyPS( hpsIco );
  }

  DevCloseDC( hdcIco );

  if ( hbmIco != NULLHANDLE )
    GpiDeleteBitmap( hbmIco );

  if ( !fSuccess )
  {
    // Error occurred.
    if ( pbIconData != NULL )
      free( pbIconData );
    return NULL;
  }

  return pbIconData;
}
