/****************************************************************************************/
/*                                                                                      */
/* COPYRIGHT    Copyright (C) 2023 Lars Erdmann                                         */
/*                                                                                      */
/* This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0. */
/* If a copy of the MPL was not distributed with this file,                             */
/* You can obtain one at https://mozilla.org/MPL/2.0/.                                  */
/*                                                                                      */
/* This Source Code Form is "Incompatible With Secondary Licenses",                     */
/* as defined by the Mozilla Public License, v. 2.0.                                    */
/*                                                                                      */
/****************************************************************************************/

/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.47
 */


/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using template emitter:
 *      SOM Emitter emitxtm: 2.23.1.9
 */

#ifndef SOM_Module_assoccls_Source
#define SOM_Module_assoccls_Source
#endif
#define AssocCls_Class_Source

#define INCL_BASE
#define INCL_PM
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <stdarg.h>
#include <builtin.h>
#include <wpfolder.xh>
#include <wpdataf.xh>
#include <cam.xh>
#define _RETAIL /* to completely eliminate the ...MethodDebug(...) debugging output to SOMOutCharRoutine (default:stdout) */
#include "assoccls.xih"


SOM_Scope void SOMLINK somDefaultInit(AssocCls *somSelf, som3InitCtrl* ctrl)
{
    AssocClsData *somThis; /* set in BeginInitializer */
    somInitCtrl globalCtrl;
    somBooleanVector myMask;
    AssocClsMethodDebug("AssocCls","somDefaultInit");
    AssocCls_BeginInitializer_somDefaultInit;

    AssocCls_Init_WPAbstract_somDefaultInit(somSelf, ctrl);

    /*
     * local AssocCls initialization code added by programmer
     */
}


SOM_Scope void SOMLINK somDestruct(AssocCls *somSelf, octet doFree,
                                   som3DestructCtrl* ctrl)
{
    AssocClsData *somThis; /* set in BeginDestructor */
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;
    AssocClsMethodDebug("AssocCls","somDestruct");
    AssocCls_BeginDestructor;

    /*
     * local AssocCls deinitialization code added by programmer
     */

    AssocCls_EndDestructor;
}


SOM_Scope MRESULT  SOMLINK wpDragOver(AssocCls *somSelf, HWND hwndCnr,
                                      PDRAGINFO pdrgInfo)
{
    /* AssocClsData *somThis = AssocClsGetData(somSelf); */
    AssocClsMethodDebug("AssocCls","wpDragOver");

    USHORT usOp = DOR_NEVERDROP, usDefault = 0;

    if (DrgAccessDraginfo(pdrgInfo)) {                                      /* make sure we can access the drgdrp structure (better be safe than sorry) */
       PDRAGITEM pdrgItem = NULL;
       SOMObject *wpObject = NULL;
       ULONG ulItems = DrgQueryDragitemCount(pdrgInfo);
       for (ULONG i=0;i<ulItems;i++) {
          pdrgItem = DrgQueryDragitemPtr(pdrgInfo,i);
          if (!DrgVerifyRMF(pdrgItem,"DRM_OBJECT","DRF_OBJECT")) {          /* reject everything that is not a WPS object */
             break;
          } /* endif */
          wpObject = (SOMObject *)OBJECT_FROM_PREC(pdrgItem->ulItemID);
          if (!somIsObj(wpObject) || !wpObject->somIsA(_WPDataFile)) {      /* reject everything that is not valid or not a file object */
             break;
          } /* endif */
       } /* endfor */
       if (i>=ulItems) {
          usOp = DOR_DROP;                                                  /* only allow drop if ALL objects satisfy the criteria above */
          usDefault = DO_MOVE;
       } /* endif */
       DrgFreeDraginfo(pdrgInfo);
    } /* endif */

    return MRFROM2SHORT(usOp,usDefault);
}

SOM_Scope MRESULT  SOMLINK wpDrop(AssocCls *somSelf, HWND hwndCnr,
                                  PDRAGINFO pdrgInfo, PDRAGITEM pdrgItem)
{
    M_AssocClsData *somThis = M_AssocClsGetData(_AssocCls);
    AssocClsMethodDebug("AssocCls","wpDrop");

    ULONG ulResult = RC_DROP_ERROR;
    SOMClass *somClasses[10];

    if (DrgAccessDraginfo(pdrgInfo)) {
       ULONG ulItems = DrgQueryDragitemCount(pdrgInfo);
       WPDataFile *wpDataFile = NULL;
       for (ULONG i=0;i<ulItems;i++) {
          PDRAGITEM pdrgItem = DrgQueryDragitemPtr(pdrgInfo,i);
          ULONG j=0;

          wpDataFile = (WPDataFile *)OBJECT_FROM_PREC(pdrgItem->ulItemID);
          memset(somClasses,0,sizeof(somClasses));
          ULONG ret = somThis->camQueryBecomeableClasses(somThis->CAMObject,wpDataFile,somClasses,9);
          while (somClasses[j]) {                                                                       /* search for last entry in "suggested classes" list */
              j++;
          } /* endwhile */
          if (j) {
             --j;
             somThis->camBecomeInstanceOf(somThis->CAMObject,wpDataFile,somClasses[j]);                 /* set the class to that last entry */
             wpDataFile->wpSaveImmediate();                                                             /* MAKE SURE YOU IMMEDIATELY SAVE THE CHANGES TO THE FILE's EAs ! */
             wpDataFile->wpRefresh(0,NULL);                                                             /* MAKE SURE YOU IMMEDIATELY REFRESH THAT OBJECTS VISUAL REPRESENTATION ! */
          } /* endif */
       } /* endfor */
       if (somIsObj(wpDataFile)) {
          WPFolder *wpFolder = (WPFolder *)wpDataFile->wpQueryFolder();
          wpFolder->wpRefresh(0,NULL);                                                                  /* MAKE SURE YOU IMMEDIATELY REFRESH THE CONAINTING FOLDER'S VISUAL REPRESENTATION ! */
       } /* endif */                                                                                    /* NOT SAVING OBJECT STATE OR REFRESHING WILL LEAD TO A SHITPOT FULL OF TROUBLE with WPS */
       DrgFreeDraginfo(pdrgInfo);
       ulResult = RC_DROP_DROPCOMPLETE;
    }

    return MRFROMLONG(ulResult);
}

SOM_Scope void  SOMLINK wpclsInitData(M_AssocCls *somSelf)
{
    M_AssocClsData *somThis = M_AssocClsGetData(somSelf);
    M_AssocClsMethodDebug("M_AssocCls","wpclsInitData");

    M_AssocCls_parent_M_WPAbstract_wpclsInitData(somSelf);

    /* the "easy" way to create a som ID, without the fuzz of "somIdFromString" function   */
    /* see "System Object Model Programming Guide" -> "SOM manipulations using somId's"    */
    /* of course, you can only do that is the somId string is known/static at compile time */
    static char *CAMClassName = "ClassAssociationManager";
    static somId CAMclassId = &CAMClassName;

    static char *AssocClassName = "AssocCls";
    static somId AssocClsclassId = &AssocClassName;

    static char *str1 = "camQueryBecomeableClasses";
    static char *str2 = "camBecomeInstanceOf";
    static somId mthd1Id = &str1;
    static somId mthd2Id = &str2;

    /* the "ClassAssociationManager" class implements the "Become" functionality */
    /* however, it is implemented in PMWP but not exported from the DLL          */
    /* therefore, we dynamically search for the DLL it is implemented in (PMWP)  */
    /* and then we have the class (object) create an instance of that class      */
    /* we will use that instance later on to call the methods we need            */
    /* (camQueryBecomeableClasses, camBecomeInstanceOf)                          */
    /* we save the "ClassAssociationManager" class object and also the created   */
    /* instance in the AssocCls class object for later use                       */
    somThis->CAMClass  = SOMClassMgrObject->somFindClass(CAMclassId,0,0);
    somThis->CAMObject = (ClassAssociationManager *)somThis->CAMClass->somNew();

    /* again, the "ClassAssociationManager" class is not exported and therefore  */
    /* we cannot directly access its methods. We therefore query the function    */
    /* pointers for the two methods we need to invoke later one                  */
    /* we save the method pointers in the AssocCls class object                  */
    somThis->camQueryBecomeableClasses =
    (somTD_ClassAssociationManager_camQueryBecomeableClasses)somThis->CAMClass->somFindSMethod(mthd1Id);

    somThis->camBecomeInstanceOf =
    (somTD_ClassAssociationManager_camBecomeInstanceOf)somThis->CAMClass->somFindSMethod(mthd2Id);

    /* we need this DLL's module handle later on (in the wpclsQueryIcon method)  */
    /* we therefore first query the module where the "AssocCls" is               */
    /* implemented in (which is exactly this DLL) and we then query the          */
    /* module handle for later use                                               */
    DosQueryModuleHandle(SOMClassMgrObject->somLocateClassFile(AssocClsclassId,0,0),&somThis->hModule);
}

SOM_Scope void  SOMLINK wpclsUnInitData(M_AssocCls *somSelf)
{
    M_AssocClsData *somThis = M_AssocClsGetData(somSelf);
    M_AssocClsMethodDebug("M_AssocCls","wpclsUnInitData");

    somThis->CAMObject->somFree();
    somThis->CAMObject = NULL;

    M_AssocCls_parent_M_WPAbstract_wpclsUnInitData(somSelf);
}

SOM_Scope PSZ  SOMLINK wpclsQueryTitle(M_AssocCls *somSelf)
{
    M_AssocClsData *somThis = M_AssocClsGetData(somSelf);
    M_AssocClsMethodDebug("M_AssocCls","wpclsQueryTitle");

    return "Class Associator";
}

SOM_Scope ULONG  SOMLINK wpclsQueryStyle(M_AssocCls *somSelf)
{
    M_AssocClsData *somThis = M_AssocClsGetData(somSelf);
    M_AssocClsMethodDebug("M_AssocCls","wpclsQueryStyle");

    /* for the user object, we do not want a template in the templates folder */
    /* we also do not want it to be copied or printed but we want to ensure   */
    /* that it is visible */
    return (M_AssocCls_parent_M_WPAbstract_wpclsQueryStyle(somSelf) | CLSSTYLE_DONTTEMPLATE | CLSSTYLE_NEVERCOPY | CLSSTYLE_NEVERPRINT & ~CLSSTYLE_NEVERVISIBLE);
}


SOM_Scope ULONG  SOMLINK wpclsQueryIconData(M_AssocCls *somSelf,
                                            PICONINFO pIconInfo)
{
    M_AssocClsData *somThis = M_AssocClsGetData(somSelf);
    M_AssocClsMethodDebug("M_AssocCls","wpclsQueryIconData");

    /* do not forget to check for pIconInfo pointer: */
    /* if it is NULL, you ONLY return the required ICONINFO size */
    if (pIconInfo) {
        memset(pIconInfo,0,sizeof(ICONINFO));
        pIconInfo->cb = sizeof(ICONINFO);
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->hmod    = somThis->hModule;
        pIconInfo->resid   = 1;
    } /* endif */

    return sizeof(ICONINFO);
}

