/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.help3;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.webworks.help3.Cell;
import com.webworks.help3.CompareCells;
import com.webworks.help3.CompareLinkCells;
import com.webworks.help3.GeneralUtils;
import com.webworks.help3.LinkCell;
import com.webworks.help3.Matrix;
import com.webworks.help3.MatrixEnumeration;
import com.webworks.help3.OS;
import com.webworks.help3.PropertyChangeSupport;
import com.webworks.help3.VetoableChangeSupport;
import com.webworks.help3.WWHelp;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;

public class SearchList
extends Panel
implements Serializable,
ItemSelectable,
FocusListener,
MouseListener,
MouseMotionListener,
AdjustmentListener,
KeyListener {
    public static final long CLICKTHRESHOLD = 250L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected static final int BORDER = 1;
    protected static final int RESIZE_FUDGE_FACTOR = 3;
    private Boolean bNoHoverText = null;
    Font f = null;
    static Color thirtyThreePercentGray = new Color(0x212121);
    static Color sixtySixPercentGray = new Color(0x434343);
    protected PopupText popupText = null;
    protected Color colorBg = Color.white;
    protected Color colorFg = Color.black;
    protected Color colorHBg = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
    protected Color colorHFg = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
    protected Color headingBg = SystemColor.control;
    protected Color headingFg = SystemColor.controlText;
    protected boolean allowSorting = true;
    protected boolean focusIndicatedVisually = true;
    protected boolean multiSelect = false;
    protected boolean allowResizingOfColumns = true;
    protected String[] headings;
    protected boolean headingVisible = true;
    protected int headingHeight = 0;
    protected Font headingFont;
    private int[] splitters;
    protected int[] columnAlignments;
    protected int defaultColumnAlignment = 0;
    protected int[] columnSizes = null;
    protected int columnClicked = -1;
    protected int lastColumnClicked = -1;
    protected int memoryClick = -1;
    protected int selectedRow = -1;
    protected BitSet highlightedRows = new BitSet();
    protected Matrix cells = new Matrix();
    protected Font cellFont;
    protected int cellHeight = 0;
    protected int cellAscent = 0;
    protected int cellDescent = 0;
    protected int topRow;
    protected int cachedHeight = -1;
    protected int cachedWidth = -1;
    protected int cachedLastSplitter = -1;
    protected int dragColumn = -1;
    protected int xDragLast = -1;
    protected int sbVPosition = 0;
    protected int sbHPosition = 0;
    protected int verticalScrollbarWidth = 0;
    protected int scrollbarHeight = 0;
    protected int hScrollbarLineIncrement = 4;
    protected int minColumnWidth = 10;
    protected transient long clickTime = 0L;
    protected String actionCommand = "RowSelected:";
    protected Scrollbar verticalScrollbar;
    protected Scrollbar horizontalScrollbar;
    protected CompareCells defaultColumnSorter = new CompareLinkCells();
    protected Hashtable columnCompareCellsRoutines = new Hashtable();
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected FocusListener focusListener = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected transient boolean isDragging = false;
    protected transient boolean clickedInHeadings = false;
    protected transient boolean sbVShow = false;
    protected transient boolean sbHShow = false;
    protected transient boolean forceRedraw = false;
    protected transient boolean forceColumnSizeRecalc = false;
    protected transient boolean forceFullRedraw = false;
    protected transient boolean isSuppressRedraw = false;
    protected transient boolean redrawWasSupressed = false;
    protected transient boolean hasFocus = false;
    protected transient Image offscreenImage = null;
    protected transient Graphics offscreenImageGraphics = null;
    protected static boolean isSun1_1;

    static {
        String string = System.getProperty("java.vendor");
        String string2 = System.getProperty("java.version");
        isSun1_1 = !(!string.startsWith("Sun Microsystems Inc.") && !string.startsWith("Apple") && !string.startsWith("Symantec Corporation") && !string.startsWith("Microsoft Corp.") && !string.startsWith("Netscape") || !string2.startsWith("11") && !string2.startsWith("1.1"));
    }

    public SearchList() {
        this(0, false, Color.white);
    }

    public SearchList(int n) {
        this(n, false, Color.white);
    }

    public SearchList(int n, boolean bl) {
        this(n, bl, Color.white);
    }

    public SearchList(int n, boolean bl, Color color) {
        this.internalCreateColumns(n);
        this.multiSelect = bl;
        super.setLayout(null);
        this.f = WWHelp.getSecurityType().equals("ms_ie") ? WWHelp.getFontX(WWHelp.fontName, 0, WWHelp.fontSize) : new Font(WWHelp.fontName, 0, WWHelp.fontSize);
        try {
            this.setHeadingFont(this.f);
            this.setCellFont(this.f);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        this.colorBg = color;
        this.setBackground(this.colorBg);
        this.verticalScrollbar = new Scrollbar(1);
        this.verticalScrollbar.hide();
        this.add(this.verticalScrollbar);
        this.horizontalScrollbar = new Scrollbar(0);
        this.horizontalScrollbar.hide();
        this.add(this.horizontalScrollbar);
        if (OS.isSolaris() || OS.isLinux()) {
            this.verticalScrollbar.setBackground(Color.lightGray);
            this.horizontalScrollbar.setBackground(Color.lightGray);
        }
        if (WWHelp.getSecurityType().equals("ms_ie")) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            this.popupText = new PopupText(this);
        } else {
            this.popupText = new PopupText(this);
        }
        ((Component)this.popupText).hide();
    }

    public void setNoHoverText(Boolean bl) {
        this.bNoHoverText = bl;
    }

    public void setMultipleMode(boolean bl) throws PropertyVetoException {
        if (this.multiSelect != bl) {
            Boolean bl2 = new Boolean(this.multiSelect);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("multipleMode", bl2, bl3);
            this.multiSelect = bl;
            if (!this.multiSelect) {
                int[] nArray = this.getSelectedRows();
                int n = 1;
                while (n < nArray.length) {
                    this.deselectRow(nArray[n]);
                    ++n;
                }
            }
            this.changes.firePropertyChange("multipleMode", bl2, bl3);
        }
    }

    public boolean isMultipleMode() {
        return this.multiSelect;
    }

    public void setFocusIndicatedVisually(boolean bl) throws PropertyVetoException {
        if (this.focusIndicatedVisually != bl) {
            Boolean bl2 = new Boolean(this.focusIndicatedVisually);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("focusIndicatedVisually", bl2, bl3);
            this.focusIndicatedVisually = bl;
            this.changes.firePropertyChange("focusIndicatedVisually", bl2, bl3);
            this.repaintFocus();
        }
    }

    public boolean isFocusIndicatedVisually() {
        return this.focusIndicatedVisually;
    }

    public void setNumberOfCols(int n) throws PropertyVetoException {
        Integer n2;
        Integer n3 = new Integer(this.getNumberOfCols());
        if (!n3.equals(n2 = new Integer(n))) {
            this.vetos.fireVetoableChange("numberOfCols", n3, n2);
            this.internalCreateColumns(0);
            this.resizeHeadings(n);
            this.forceColumnSizeRecalc = true;
            this.changes.firePropertyChange("numberOfCols", n3, n2);
            this.triggerRedraw();
        }
    }

    public void setColumns(int n) throws PropertyVetoException {
        this.setNumberOfCols(n);
    }

    public int getNumberOfCols() {
        return this.headings.length;
    }

    public int getNumberOfRows() {
        return this.cells.rows();
    }

    public void setHeadingVisible(boolean bl) throws PropertyVetoException {
        if (this.headingVisible != bl) {
            Boolean bl2 = new Boolean(this.headingVisible);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("headingVisible", bl2, bl3);
            this.headingVisible = bl;
            this.changes.firePropertyChange("headingVisible", bl2, bl3);
            if (this.headingVisible) {
                this.calculateHeadingHeight();
            } else {
                this.headingHeight = 0;
            }
            this.forceFullRedraw = true;
            this.triggerRedraw();
        }
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public String getHeading(int n) {
        return this.headings[n];
    }

    public void setHeading(String string, int n) throws PropertyVetoException {
        String string2 = this.headings[n];
        if (!GeneralUtils.objectsEqual(string2, string)) {
            String string3 = string;
            this.vetos.fireVetoableChange("heading", string2, string3);
            this.headings[n] = string;
            this.changes.firePropertyChange("heading", string2, string3);
            this.triggerRedraw();
        }
    }

    public String[] getHeadings() {
        return this.headings;
    }

    public void setHeadings(String[] stringArray) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            String[] stringArray2 = this.getHeadings();
            this.vetos.fireVetoableChange("headings", stringArray2, stringArray);
            if (stringArray.length == 0) {
                this.internalCreateColumns(0);
            } else {
                this.calcHeadings(stringArray);
            }
            this.changes.firePropertyChange("headings", stringArray2, stringArray);
        }
        finally {
            Object var4_4 = null;
            this.forceColumnSizeRecalc = true;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
    }

    public Font getHeadingFont() {
        return this.headingFont;
    }

    public void setHeadingFont(Font font) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.headingFont, font)) {
            Font font2 = this.getHeadingFont();
            this.vetos.fireVetoableChange("headingFont", font2, font);
            this.headingFont = font;
            this.changes.firePropertyChange("headingFont", font2, font);
            if (this.headingVisible) {
                this.calculateHeadingHeight();
                this.triggerRedraw();
            }
        }
    }

    public Font getCellFont() {
        return this.cellFont;
    }

    public void setCellFont(Font font) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.cellFont, font)) {
            Font font2 = this.cellFont;
            this.vetos.fireVetoableChange("cellFont", font2, font);
            this.cellFont = font;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.cellAscent = fontMetrics.getAscent();
            this.cellDescent = fontMetrics.getDescent();
            this.cellHeight = fontMetrics.getHeight();
            this.changes.firePropertyChange("cellFont", font2, font);
            this.triggerRedraw();
        }
    }

    public void setHeadingColors(Color color, Color color2) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            this.setHeadingFg(color);
            this.setHeadingBg(color2);
        }
        finally {
            Object var5_4 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
    }

    public Color getHeadingFg() {
        return this.headingFg;
    }

    public void setHeadingFg(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.headingFg, color)) {
            Color color2 = this.headingFg;
            this.vetos.fireVetoableChange("headingFg", color2, color);
            this.headingFg = color;
            this.changes.firePropertyChange("headingFg", color2, color);
            this.triggerRedraw();
        }
    }

    public Color getHeadingBg() {
        return this.headingBg;
    }

    public void setHeadingBg(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.headingBg, color)) {
            Color color2 = this.headingBg;
            this.vetos.fireVetoableChange("headingBg", color2, color);
            this.headingBg = color;
            this.changes.firePropertyChange("headingBg", color2, color);
            this.triggerRedraw();
        }
    }

    public void setCellColors(Color color, Color color2) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            this.setCellFg(color);
            this.setCellBg(color2);
        }
        finally {
            Object var5_4 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
    }

    public Color getCellFg() {
        return this.colorFg;
    }

    public void setCellFg(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.colorFg, color)) {
            Color color2 = this.colorFg;
            this.vetos.fireVetoableChange("cellFg", color2, color);
            this.colorFg = color;
            this.changes.firePropertyChange("cellFg", color2, color);
            this.triggerRedraw();
        }
    }

    public void setCellBg(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.colorBg, color)) {
            Color color2 = this.colorBg;
            this.vetos.fireVetoableChange("cellBg", color2, color);
            this.colorBg = color;
            this.changes.firePropertyChange("cellBg", color2, color);
            this.triggerRedraw();
        }
    }

    public Color getCellBg() {
        return this.colorBg;
    }

    public void setColumnAlignments(String[] stringArray) throws PropertyVetoException {
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        String[] stringArray2 = this.getColumnAlignments();
        this.vetos.fireVetoableChange("columnAlignments", stringArray2, stringArray);
        if (stringArray != null) {
            this.columnAlignments = new int[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                int n2 = this.defaultColumnAlignment;
                if (string != null) {
                    if (string.equalsIgnoreCase("Left")) {
                        n2 = 0;
                    } else if (string.equalsIgnoreCase("Center")) {
                        n2 = 1;
                    } else if (string.equalsIgnoreCase("Right")) {
                        n2 = 2;
                    }
                }
                this.columnAlignments[n] = n2;
                ++n;
            }
        } else {
            this.columnAlignments = null;
        }
        this.changes.firePropertyChange("columnAlignments", stringArray2, stringArray);
        this.triggerRedraw();
    }

    public String[] getColumnAlignments() {
        if (this.columnAlignments == null) {
            return null;
        }
        String[] stringArray = new String[this.columnAlignments.length];
        int n = 0;
        while (n < stringArray.length) {
            String string;
            switch (this.getColumnAlignment(n)) {
                default: {
                    string = "Left";
                    break;
                }
                case 1: {
                    string = "Center";
                    break;
                }
                case 2: {
                    string = "Right";
                }
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public void setColumnAlignment(int n, int n2) throws PropertyVetoException {
        this.rangeCheckAlignment(n2);
        this.rangeCheckColumn(n);
        Integer n3 = new Integer(this.getColumnAlignment(n));
        Integer n4 = new Integer(n2);
        this.vetos.fireVetoableChange("columnAlignment", n3, n4);
        if (this.columnAlignments == null) {
            this.columnAlignments = new int[this.headings.length];
            int n5 = 0;
            while (n5 < this.headings.length) {
                this.columnAlignments[n5] = -1;
                ++n5;
            }
        }
        this.columnAlignments[n] = n2;
        this.changes.firePropertyChange("columnAlignment", n3, n4);
        this.triggerRedraw();
    }

    public int getColumnAlignment(int n) {
        int n2;
        if (this.columnAlignments != null && n < this.columnAlignments.length && (n2 = this.columnAlignments[n]) != -1) {
            return this.columnAlignments[n];
        }
        return this.getDefaultColumnAlignment();
    }

    public int getDefaultColumnAlignment() {
        return this.defaultColumnAlignment;
    }

    public void setDefaultColumnAlignment(int n) throws PropertyVetoException {
        this.rangeCheckAlignment(n);
        if (this.defaultColumnAlignment != n) {
            Integer n2 = new Integer(this.defaultColumnAlignment);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("defaultColumnAlignment", n2, n3);
            this.defaultColumnAlignment = n;
            this.changes.firePropertyChange("defaultColumnAlignment", n2, n3);
            this.triggerRedraw();
        }
    }

    public void setColumnSizes(String[] stringArray) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            if (stringArray != null && stringArray.length == 0) {
                stringArray = null;
            }
            String[] stringArray2 = this.getColumnSizes();
            this.vetos.fireVetoableChange("columnSizes", stringArray2, stringArray);
            if (stringArray != null) {
                this.columnSizes = new int[stringArray.length];
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = 0;
                    try {
                        String string = stringArray[n2];
                        if (string != null) {
                            n3 = Integer.parseInt(string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.columnSizes[n2] = n3;
                    if (this.splitters.length > n2 + 1) {
                        this.splitters[n2 + 1] = n += this.columnSizes[n2];
                    }
                    ++n2;
                }
                if (this.splitters.length > 1) {
                    this.splitters[0] = 0;
                }
            } else {
                this.columnSizes = null;
                this.adjustHeadings();
            }
            this.changes.firePropertyChange("columnSizes", stringArray2, stringArray);
        }
        finally {
            Object var4_9 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
    }

    public String[] getColumnSizes() {
        return this.intArrayToStringArray(this.columnSizes);
    }

    public int getColumnSize(int n) {
        return this.splitters[n + 1];
    }

    public void setSelectedRow(int n) throws IllegalArgumentException {
        if (n < 0 || n > this.cells.rows() - 1) {
            throw new IllegalArgumentException("InvalidRowNumber, row = " + n);
        }
        this.selectRow(n);
    }

    public int getSelectedRow() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public void selectAll() {
        if (!this.multiSelect) {
            return;
        }
        int n = this.getNumberOfRows();
        int n2 = 0;
        while (n2 < n) {
            this.selectRow(n2);
            ++n2;
        }
    }

    public void deselectAll() {
        int[] nArray = this.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            this.deselectRow(nArray[n]);
            ++n;
        }
    }

    public int[] getSelectedRows() {
        int n = this.highlightedRows.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.highlightedRows.get(n3)) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (this.highlightedRows.get(n4)) {
                nArray[n2++] = n4;
            }
            ++n4;
        }
        return nArray;
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        Object[] objectArray = new Integer[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = new Integer(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public void setMinColumnWidth(int n) throws PropertyVetoException {
        if (this.minColumnWidth != n && n > 0) {
            Integer n2 = new Integer(this.minColumnWidth);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("minColumnWidth", n2, n3);
            this.minColumnWidth = n;
            this.changes.firePropertyChange("minColumnWidth", n2, n3);
        }
    }

    public boolean setSupressRedraw(boolean bl) {
        boolean bl2 = this.isSuppressRedraw;
        this.isSuppressRedraw = bl;
        if (this.isSuppressRedraw != bl2 && !this.isSuppressRedraw && this.redrawWasSupressed) {
            this.redrawWasSupressed = false;
            this.triggerRedraw();
        }
        return bl2;
    }

    protected void resizeHeadings(int n) {
        if (n == this.headings.length) {
            return;
        }
        int n2 = n - this.headings.length;
        String[] stringArray = new String[this.headings.length + n2];
        int[] nArray = new int[stringArray.length + 1];
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (n3 < this.headings.length) {
                stringArray[n3] = this.headings[n3];
                nArray[n3 + 1] = this.splitters[n3 + 1];
            } else {
                stringArray[n3] = "Column " + (n3 + 1);
                nArray[n3 + 1] = nArray[n3] + this.getMinColumnWidth();
            }
            ++n3;
        }
        this.headings = stringArray;
        this.splitters = nArray;
        if (this.columnSizes == null) {
            this.forceColumnSizeRecalc = true;
        }
    }

    public void setAllowSorting(boolean bl) throws PropertyVetoException {
        if (this.allowSorting != bl) {
            Boolean bl2 = new Boolean(this.allowSorting);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("allowSorting", bl2, bl3);
            this.allowSorting = bl;
            this.changes.firePropertyChange("allowSorting", bl2, bl3);
        }
    }

    public boolean isAllowSorting() {
        return this.allowSorting;
    }

    public void setAllowResizingOfColumns(boolean bl) throws PropertyVetoException {
        if (this.allowResizingOfColumns != bl) {
            Boolean bl2 = new Boolean(this.allowResizingOfColumns);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("allowResizingOfColumns", bl2, bl3);
            this.allowResizingOfColumns = bl;
            this.changes.firePropertyChange("allowResizingOfColumns", bl2, bl3);
        }
    }

    public boolean isAllowResizingOfColumns() {
        return this.allowResizingOfColumns;
    }

    public int getMinColumnWidth() {
        return this.minColumnWidth;
    }

    public void adjustHeadings() {
        if (this.headings.length == 0) {
            this.internalCreateColumns(0);
            this.triggerRedraw();
        } else {
            Dimension dimension = this.size();
            int n = 0;
            int n2 = (dimension.width - this.verticalScrollbarWidth) / this.headings.length;
            int n3 = dimension.width - this.verticalScrollbarWidth - this.headings.length * n2;
            this.splitters[0] = 0;
            int n4 = 0;
            while (n4 < this.headings.length) {
                this.splitters[n4 + 1] = n += n2 + (n4 < n3 ? 1 : 0);
                ++n4;
            }
        }
    }

    public void createColumns(int n) {
        this.internalCreateColumns(n);
        this.triggerRedraw();
    }

    protected void internalCreateColumns(int n) {
        this.headings = new String[n];
        this.splitters = new int[n + 1];
        this.columnAlignments = null;
        this.columnSizes = null;
    }

    public void clear() {
        this.cells.removeAllElements();
        this.xDragLast = -1;
        this.isDragging = false;
        this.selectedRow = -1;
        this.highlightedRows = new BitSet();
        this.topRow = 0;
        this.sbVPosition = 0;
        this.triggerRedraw();
    }

    public void removeRow(int n) {
        int n2 = this.cells.rows();
        if (n < 0 || n > n2 - 1) {
            return;
        }
        this.cells.removeRow(n);
        if (this.highlightedRows.get(n)) {
            this.highlightedRows.clear(n);
        }
        int n3 = n + 1;
        while (n3 < n2) {
            if (this.highlightedRows.get(n3)) {
                this.highlightedRows.clear(n3);
                this.highlightedRows.set(n3 - 1);
            }
            ++n3;
        }
        this.triggerRedraw();
    }

    public CompareCells getColumnSorter(int n) {
        CompareCells compareCells = (CompareCells)this.columnCompareCellsRoutines.get(new Integer(n));
        if (compareCells == null) {
            compareCells = this.getDefaultColumnSorter();
        }
        return compareCells;
    }

    public void setColumnSorter(int n, CompareCells compareCells) {
        this.columnCompareCellsRoutines.put(new Integer(n), compareCells);
    }

    public CompareCells getDefaultColumnSorter() {
        return this.defaultColumnSorter;
    }

    public void setDefaultColumnSorter(CompareCells compareCells) {
        this.defaultColumnSorter = compareCells;
    }

    public void addCell(int n, int n2, Cell cell) {
        this.addCellImpl(n, n2, cell);
    }

    protected void addCellImpl(int n, int n2, Cell cell) {
        this.cells.updateElement(n, n2, cell);
        this.triggerRedraw();
    }

    protected void addCellNoUpdate(int n, int n2, Cell cell) {
        this.cells.updateElement(n, n2, cell);
    }

    public LinkCell getCell(int n, int n2) {
        try {
            LinkCell linkCell = (LinkCell)this.cells.elementAt(n, n2);
            if (linkCell != null) {
                return linkCell;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        return null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.splitters[this.splitters.length - 1] = this.getSize().width;
        if (this.offscreenImage == null) {
            this.redraw();
        }
        if (this.offscreenImage != null) {
            Font font = graphics.getFont();
            if (font == null) {
                font = this.headingFont;
                ((Component)this).setFont(font);
                return;
            }
            Dimension dimension = this.size();
            if (this.cachedWidth != dimension.width || this.cachedHeight != dimension.height || this.forceRedraw) {
                this.redraw();
            }
            int n = dimension.height - this.scrollbarHeight;
            int n2 = dimension.width - this.verticalScrollbarWidth;
            graphics.translate(-this.sbHPosition, 0);
            if (this.sbVShow && this.sbHShow) {
                graphics.setColor(SystemColor.control);
                if (OS.isSolaris() || OS.isLinux()) {
                    graphics.setColor(Color.lightGray);
                }
                graphics.fillRect(this.sbHPosition + n2, n, this.verticalScrollbarWidth, this.scrollbarHeight);
                graphics.setColor(Color.black);
                graphics.drawRect(this.sbHPosition + n2 - 1, n - 1, this.verticalScrollbarWidth, this.scrollbarHeight);
            }
            graphics.clipRect(this.sbHPosition, 0, n2, n);
            graphics.drawImage(this.offscreenImage, 0, 0, this);
            graphics.setColor(Color.black);
            graphics.drawRect(this.sbHPosition, 0, n2 - 1, n - 1);
        }
    }

    protected void rangeCheckColumn(int n) {
        if (n < 0 || n > this.headings.length - 1) {
            throw new IllegalArgumentException("InvalidColumnIndex, column = " + n);
        }
    }

    protected void rangeCheckAlignment(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("InvalidAlignment");
        }
    }

    protected void calcVerticalScrollbarPosition(boolean bl) {
        Dimension dimension = this.size();
        if (this.cells.rows() * this.cellHeight > dimension.height - this.headingHeight - 1 - (this.headingHeight > 0 ? 0 : 1) - (bl ? this.scrollbarHeight : 0)) {
            this.sbVShow = true;
            this.verticalScrollbarWidth = this.verticalScrollbar.preferredSize().width - 1;
        } else {
            this.sbVShow = false;
            this.verticalScrollbarWidth = 0;
        }
        if (this.columnSizes == null && (this.forceColumnSizeRecalc || this.cachedWidth != dimension.width - this.verticalScrollbarWidth)) {
            this.adjustHeadings();
        }
        this.forceColumnSizeRecalc = false;
    }

    public void redraw() {
        int n;
        int n2;
        Dimension dimension = this.size();
        if (this.columnSizes != null) {
            n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.columnSizes.length) {
                n3 += this.columnSizes[n4];
                if (this.columnSizes[n4] == 0) {
                    ++n2;
                }
                ++n4;
            }
            if (n2 != 0) {
                n = (this.size().width - n3) / n2;
                n3 = 0;
                int n5 = 0;
                while (n5 < this.columnSizes.length) {
                    if (this.columnSizes[n5] == 0) {
                        this.columnSizes[n5] = n;
                    }
                    n3 += this.columnSizes[n5];
                    if (this.splitters.length > n5 + 1) {
                        this.splitters[n5 + 1] = n3;
                    }
                    ++n5;
                }
            }
        }
        this.forceRedraw = false;
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        boolean bl = this.isSuppressRedraw;
        this.isSuppressRedraw = true;
        try {
            this.calcVerticalScrollbarPosition(false);
        }
        finally {
            Object var4_5 = null;
            this.isSuppressRedraw = bl;
        }
        n2 = this.splitters[this.splitters.length - 1];
        if (n2 > dimension.width - this.verticalScrollbarWidth) {
            this.sbHShow = true;
            this.scrollbarHeight = this.horizontalScrollbar.preferredSize().height - 1;
            bl = this.isSuppressRedraw;
            this.isSuppressRedraw = true;
            try {
                this.calcVerticalScrollbarPosition(true);
            }
            finally {
                Object var5_10 = null;
                this.isSuppressRedraw = bl;
            }
        } else {
            this.sbHShow = false;
            this.scrollbarHeight = 0;
        }
        if (!this.sbVShow) {
            this.sbVPosition = 0;
        }
        if (!this.sbHShow) {
            this.sbHPosition = 0;
        }
        int n6 = Math.max(n2, dimension.width + this.sbHPosition);
        if (this.offscreenImage == null || this.offscreenImageGraphics == null || this.cachedWidth != n6 || this.cachedHeight != dimension.height || this.cachedLastSplitter != n2 || this.offscreenImage.getWidth(this) != n6 || this.forceFullRedraw) {
            this.forceFullRedraw = false;
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
            this.offscreenImage = this.createImage(n6, dimension.height);
            this.cachedWidth = dimension.width;
            this.cachedHeight = dimension.height;
            this.cachedLastSplitter = n2;
            if (this.offscreenImageGraphics != null) {
                this.offscreenImageGraphics.dispose();
                this.offscreenImageGraphics = null;
            }
            if (this.offscreenImage != null) {
                this.offscreenImageGraphics = this.offscreenImage.getGraphics();
            }
            if (this.offscreenImageGraphics != null && this.offscreenImageGraphics.getClip() == null) {
                this.offscreenImageGraphics.setClip(0, 0, n6, dimension.height);
            }
        }
        if (this.offscreenImageGraphics != null) {
            this.offscreenImageGraphics.setColor(this.colorBg);
            this.offscreenImageGraphics.fillRect(0, 0, this.offscreenImage.getWidth(this), dimension.height);
        }
        int n7 = this.cells.rows();
        if (this.sbVShow) {
            n = this.getNumVisibleRows();
            this.verticalScrollbar.reshape(dimension.width - this.verticalScrollbarWidth, 0, this.verticalScrollbarWidth, dimension.height - this.scrollbarHeight);
            this.verticalScrollbar.setValues(this.sbVPosition, n, 0, n7 - (isSun1_1 ? 0 : n));
            this.verticalScrollbar.setPageIncrement(n - 1);
            this.verticalScrollbar.show();
        } else {
            this.topRow = 0;
            this.verticalScrollbar.hide();
        }
        if (this.sbHShow) {
            this.horizontalScrollbar.reshape(0, dimension.height - this.scrollbarHeight, dimension.width - this.verticalScrollbarWidth, this.scrollbarHeight);
            this.horizontalScrollbar.setValues(this.sbHPosition, dimension.width - this.verticalScrollbarWidth, 0, n2 - (isSun1_1 ? 0 : dimension.width - this.verticalScrollbarWidth));
            this.horizontalScrollbar.setPageIncrement(dimension.width - this.verticalScrollbarWidth);
            this.horizontalScrollbar.setLineIncrement(this.hScrollbarLineIncrement);
            this.horizontalScrollbar.show();
        } else {
            this.horizontalScrollbar.hide();
        }
        if (this.offscreenImageGraphics != null && this.headings.length > 0) {
            this.drawHeading(false);
            if (n2 > 0) {
                this.offscreenImageGraphics.clipRect(0, 0, n2, dimension.height);
            }
            int n8 = n = this.cellHeight > 0 ? this.getNumVisibleRows() : 0;
            if (n > n7) {
                n = n7;
            }
            this.drawRows(this.topRow, n, false);
        }
    }

    public void changeSelection(int n, int n2) {
        int[] nArray;
        int n3;
        boolean bl = this.setSupressRedraw(true);
        try {
            block13: {
                n3 = this.getNumberOfRows();
                if (n < n3 && n > -1) break block11;
                nArray = this.getSelectedRows();
                if (!this.multiSelect) break block12;
                if ((n2 & 1) == 1) break block13;
                if ((n2 & 2) != 2) break block14;
            }
            Object var5_6 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
        {
            block12: {
                block14: {
                    return;
                }
                this.deselectEvent(n, nArray);
            }
            this.highlightedRows = new BitSet();
            this.paintSelection(nArray);
            this.repaint();
        }
        Object var5_7 = null;
        this.triggerRedraw();
        this.setSupressRedraw(bl);
        {
            block11: {
                return;
            }
            if (this.multiSelect) {
                this.multiSel(n, n2);
            } else {
                this.singleSel(n, n2);
            }
            if (n < this.topRow) {
                this.topRow = n;
                if (this.topRow < 0) {
                    this.topRow = 0;
                }
                this.sbVPosition = this.topRow;
                this.verticalScrollbar.setValue(this.sbVPosition);
                this.triggerRedraw();
            }
            if (n - this.topRow + 1 > this.getNumVisibleRows()) {
                this.topRow = n;
                if (this.topRow > n3 - this.getNumVisibleRows()) {
                    this.topRow -= this.topRow - (n3 - this.getNumVisibleRows());
                }
                this.sbVPosition = this.topRow;
                this.verticalScrollbar.setValue(this.sbVPosition);
                this.triggerRedraw();
            }
            this.selectedRow = n;
            this.drawRows(this.selectedRow, 1, true);
        }
        Object var5_8 = null;
        this.triggerRedraw();
        this.setSupressRedraw(bl);
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.verticalScrollbar.addAdjustmentListener(this);
        this.horizontalScrollbar.addAdjustmentListener(this);
        this.addFocusListener(this);
    }

    public synchronized void removeNotify() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        this.verticalScrollbar.removeAdjustmentListener(this);
        this.horizontalScrollbar.removeAdjustmentListener(this);
        this.removeFocusListener(this);
        super.removeNotify();
    }

    private void multiSel(int n, int n2) {
        if ((n2 & 2) == 2) {
            if (this.highlightedRows.get(n)) {
                this.deselectRow(n);
            } else {
                this.removeSelectionBorder();
                this.selectRow(n);
            }
        } else if ((n2 & 1) == 1) {
            if (this.selectedRow == -1) {
                this.selectedRow = n;
            }
            int n3 = Math.min(this.selectedRow, n);
            while (n3 <= Math.max(this.selectedRow, n)) {
                if (n3 >= 0) {
                    this.highlightedRows.set(n3);
                }
                ++n3;
            }
            this.sourceItemEvent(1);
            this.selectedRow = -1;
            this.paintSelection(this.getSelectedRows());
        } else {
            int[] nArray = this.getSelectedRows();
            this.deselectEvent(n, nArray);
            this.highlightedRows = new BitSet();
            this.removeSelectionBorder();
            this.selectedRow = -1;
            this.paintSelection(nArray);
            this.selectRow(n);
        }
    }

    private void singleSel(int n, int n2) {
        if (this.selectedRow >= 0 && this.highlightedRows.get(this.selectedRow)) {
            if (this.selectedRow != n) {
                this.deselectRow(this.selectedRow);
                this.selectRow(n);
            } else if ((n2 & 2) == 2) {
                this.deselectRow(this.selectedRow);
            }
        } else {
            this.removeSelectionBorder();
            this.selectRow(n);
        }
    }

    private void deselectEvent(int n, int[] nArray) {
        int n2 = nArray.length;
        if (n2 > 1 || n2 == 1 && this.selectedRow != n) {
            this.sourceItemEvent(2);
        }
    }

    protected void paintSelection(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 - this.sbVPosition >= 0 && n2 - this.sbVPosition <= this.getNumVisibleRows() + 1) {
                this.drawRows(n2, 1, true);
            }
            ++n;
        }
    }

    public void selectRow(int n) {
        if (!this.highlightedRows.get(n)) {
            int n2;
            if (!this.multiSelect && (n2 = this.getSelectedRow()) != -1 && n2 != n) {
                this.deselectRow(n2);
            }
            this.highlightedRows.set(n);
            this.sourceItemEvent(1);
            this.drawRows(n, 1, true);
        }
    }

    public void deselectRow(int n) {
        if (this.highlightedRows.get(n)) {
            this.highlightedRows.clear(n);
            this.sourceItemEvent(2);
            if (n == this.selectedRow) {
                this.removeSelectionBorder();
            } else {
                this.drawRows(n, 1, true);
            }
        }
    }

    protected void removeSelectionBorder() {
        if (this.selectedRow != -1) {
            int n = this.selectedRow;
            this.selectedRow = -1;
            this.drawRows(n, 1, true);
            this.selectedRow = n;
        }
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        long l;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.requestFocus();
        this.clickedInHeadings = false;
        if (n2 < this.headingHeight) {
            int n3;
            if (this.allowResizingOfColumns) {
                n3 = 1;
                while (n3 < this.splitters.length - 1) {
                    int n4 = this.splitters[n3];
                    if (n < Math.min(n4 - this.sbHPosition + 3, this.size().width - this.verticalScrollbarWidth) && n > n4 - this.sbHPosition - 3) {
                        this.dragColumn = n3;
                        this.isDragging = true;
                        this.offscreenImageGraphics.setClip(0, 0, Math.max(this.splitters[this.splitters.length - 1], this.size().width + this.sbHPosition), this.size().height);
                        this.mouseDragged(mouseEvent);
                        return;
                    }
                    ++n3;
                }
            }
            if (this.allowSorting) {
                n3 = 0;
                while (n3 < this.headings.length) {
                    if (n > this.splitters[n3] - this.sbHPosition && n < this.splitters[n3 + 1] - this.sbHPosition) {
                        this.clickedInHeadings = true;
                        this.columnClicked = n3;
                        this.drawHeading(true);
                        this.repaint();
                        return;
                    }
                    ++n3;
                }
            }
            return;
        }
        Dimension dimension = this.getSize();
        if (n >= dimension.width - this.verticalScrollbarWidth || n2 >= dimension.height - this.scrollbarHeight) {
            return;
        }
        int n5 = (n2 - this.headingHeight) / this.cellHeight + this.topRow;
        if (n5 < 0 || n5 > this.cells.rows() - 1) {
            return;
        }
        int n6 = this.selectedRow;
        this.changeSelection(n5, mouseEvent.getModifiers());
        long l2 = mouseEvent.getWhen();
        if ((this.selectedRow == n6 || n6 < 0) && (l = l2 - this.clickTime) < 250L) {
            this.sourceActionEvent(this.selectedRow);
        }
        this.clickTime = l2;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (this.isDragging) {
            if (n < 0) {
                n = 0;
            }
            boolean bl = false;
            this.xDragLast = Math.max(this.splitters[this.dragColumn - 1] + this.minColumnWidth, n + this.sbHPosition);
            int n2 = this.xDragLast - this.splitters[this.dragColumn];
            int n3 = this.dragColumn + 1;
            while (n3 < this.splitters.length - 1) {
                int n4 = this.splitters[n3];
                int n5 = n3;
                this.splitters[n5] = this.splitters[n5] + n2;
                if (n4 != this.splitters[n3]) {
                    bl = true;
                }
                ++n3;
            }
            if (this.splitters[this.dragColumn] != this.xDragLast) {
                this.splitters[this.dragColumn] = this.xDragLast;
                bl = true;
            }
            this.xDragLast = -1;
            this.isDragging = false;
            if (mouseEvent.getY() > this.headingHeight) {
                this.setCursor(new Cursor(0));
            }
            if (bl && this.columnSizes == null) {
                try {
                    this.setColumnSizes(this.intArrayToStringArray(this.getColumnSizesFromSplitters()));
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
            this.triggerRedraw();
            return;
        }
        if (this.columnClicked != -1) {
            CompareCells compareCells = this.getColumnSorter(this.columnClicked);
            compareCells.setCurrentBitSet(this.highlightedRows);
            compareCells.setSelectedRow(this.selectedRow);
            if (this.columnClicked == this.lastColumnClicked) {
                compareCells.reverse();
            }
            this.cells.sort(compareCells, this.columnClicked);
            this.selectedRow = compareCells.getSelectedRow();
            this.lastColumnClicked = this.columnClicked;
            this.columnClicked = -1;
            this.triggerRedraw();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getCursor().getType() != 0 && !this.isDragging) {
            this.setCursor(new Cursor(0));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.allowResizingOfColumns) {
            int n2;
            n = 0;
            if (mouseEvent.getY() < this.headingHeight) {
                n2 = mouseEvent.getX();
                int n3 = 1;
                while (n3 < this.splitters.length - 1) {
                    int n4 = this.splitters[n3];
                    if (n2 < Math.min(n4 - this.sbHPosition + 3, this.size().width - this.verticalScrollbarWidth) && n2 > n4 - this.sbHPosition - 3) {
                        n = 1;
                        break;
                    }
                    ++n3;
                }
            }
            int n5 = n2 = n != 0 ? 10 : 0;
            if (n2 != this.getCursor().getType()) {
                this.setCursor(new Cursor(n2));
            }
        }
        if (this.bNoHoverText == null || this.bNoHoverText != null && !this.bNoHoverText.booleanValue()) {
            int n6;
            n = (mouseEvent.getY() - this.headingHeight) / this.cellHeight + this.topRow;
            if (n < 0 || n > this.cells.rows() - 1 || mouseEvent.getX() > this.splitters[1]) {
                return;
            }
            LinkCell linkCell = (LinkCell)this.cells.elementAt(n, 0);
            String string = linkCell.getText();
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
            int n7 = fontMetrics.stringWidth(string);
            Rectangle rectangle = new Rectangle(0, (n - this.topRow) * this.cellHeight + this.headingHeight, n7 + 5, (n6 = fontMetrics.getHeight()) + 2);
            if (rectangle.inside(mouseEvent.getX(), mouseEvent.getY()) && rectangle.width + rectangle.x > this.splitters[1]) {
                Point point = this.getLocationOnScreen();
                this.popupText.setText(string);
                this.popupText.move(point.x + rectangle.x, point.y + rectangle.y);
                if (WWHelp.getSecurityType().equals("ms_ns") || System.getSecurityManager().checkTopLevelWindow(this.popupText)) {
                    this.popupText.resize(rectangle.width, rectangle.height);
                    if (this.popupText.getInsets().bottom == 0) {
                        this.popupText.show();
                    }
                } else if (this.bNoHoverText != null && !this.bNoHoverText.booleanValue()) {
                    this.popupText.resize(rectangle.width, rectangle.height * 2);
                    this.popupText.show();
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Dimension dimension = this.size();
        if (!this.isDragging) {
            if (this.clickedInHeadings) {
                if (this.columnClicked > -1) {
                    int n3 = this.columnClicked == 0 ? 0 : this.splitters[this.columnClicked] - this.sbHPosition;
                    int n4 = this.columnClicked == this.headings.length - 1 ? dimension.width : this.splitters[this.columnClicked + 1] - this.sbHPosition;
                    if (n < n3 || n > n4 || n2 > this.headingHeight || n2 < 0) {
                        this.memoryClick = this.columnClicked;
                        this.columnClicked = -1;
                        this.drawHeading(false);
                        Graphics graphics = this.getGraphics();
                        this.paint(graphics);
                    }
                } else if (this.memoryClick > -1) {
                    int n5 = this.memoryClick == 0 ? 0 : this.splitters[this.memoryClick] - this.sbHPosition;
                    int n6 = this.memoryClick == this.headings.length - 1 ? dimension.width : this.splitters[this.memoryClick + 1] - this.sbHPosition;
                    if (n > n5 && n < n6 && n2 < this.headingHeight && n2 > 0) {
                        this.columnClicked = this.memoryClick;
                        this.memoryClick = -1;
                        this.drawHeading(true);
                        Graphics graphics = this.getGraphics();
                        this.paint(graphics);
                    }
                }
            }
        } else {
            if (n < 0) {
                n = 0;
            }
            if (n + this.sbHPosition < this.splitters[this.dragColumn - 1] + this.minColumnWidth) {
                return;
            }
            int n7 = Math.min(n, this.xDragLast - this.sbHPosition);
            int n8 = Math.max(n, this.xDragLast - this.sbHPosition);
            this.offscreenImageGraphics.setColor(this.colorBg);
            this.offscreenImageGraphics.setXORMode(Color.gray);
            this.offscreenImageGraphics.drawLine(this.xDragLast, 0, this.xDragLast, dimension.height);
            this.offscreenImageGraphics.drawLine(n + this.sbHPosition, 0, n + this.sbHPosition, dimension.height);
            this.offscreenImageGraphics.setColor(this.getForeground());
            this.offscreenImageGraphics.setPaintMode();
            this.xDragLast = n + this.sbHPosition;
            this.repaint(n7, 0, n8 - n7 + 1, this.size().height);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        switch (keyEvent.getKeyCode()) {
            case 40: {
                if (this.selectedRow >= this.cells.rows() - 1) break;
                this.changeSelection(this.selectedRow + 1, n);
                break;
            }
            case 34: {
                this.changeSelection(Math.min(this.selectedRow + this.getNumVisibleRows(), this.cells.rows() - 1), n);
                break;
            }
            case 38: {
                if (this.selectedRow <= 0) break;
                this.changeSelection(this.selectedRow - 1, n);
                break;
            }
            case 33: {
                this.changeSelection(Math.max(this.selectedRow - this.getNumVisibleRows(), 0), n);
                break;
            }
            case 39: {
                int n2 = this.horizontalScrollbar.getMaximum() - (isSun1_1 ? this.size().width - this.verticalScrollbarWidth : 0);
                if (!this.sbHShow || this.sbHPosition >= n2) break;
                this.horizontalScrollbar.setValue(Math.min(this.sbHPosition += this.hScrollbarLineIncrement, n2));
                this.repaint();
                break;
            }
            case 37: {
                if (this.sbHPosition <= 0) break;
                this.horizontalScrollbar.setValue(Math.max(this.sbHPosition -= this.hScrollbarLineIncrement, 0));
                this.repaint();
                break;
            }
            case 10: {
                if (this.selectedRow <= -1) break;
                this.sourceActionEvent(this.selectedRow);
                break;
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.verticalScrollbar) {
            if (this.topRow != this.verticalScrollbar.getValue()) {
                this.sbVPosition = this.topRow = this.verticalScrollbar.getValue();
                this.triggerRedraw();
            }
        } else if (adjustmentEvent.getSource() == this.horizontalScrollbar && this.sbHPosition != this.horizontalScrollbar.getValue()) {
            this.sbHPosition = this.horizontalScrollbar.getValue();
            this.triggerRedraw();
        }
    }

    protected void sourceItemEvent(int n) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, n));
        }
    }

    protected void repaintFocus() {
        if (this.selectedRow != -1) {
            this.drawRows(this.selectedRow, 1, true);
        }
        this.paintSelection(this.getSelectedRows());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaintFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.repaintFocus();
    }

    protected void sourceActionEvent(int n) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, String.valueOf(this.actionCommand) + n));
        }
    }

    protected int getNumVisibleRows() {
        return (this.size().height - this.headingHeight - this.scrollbarHeight - 1 - (this.headingHeight > 0 ? 0 : 1)) / this.cellHeight;
    }

    protected void drawRows(int n, int n2, boolean bl) {
        int n3 = n - this.sbVPosition;
        if (n3 < 0 || n3 > this.getNumVisibleRows() - 1) {
            return;
        }
        MatrixEnumeration matrixEnumeration = this.cells.elements();
        Cell cell = null;
        if (n > 0) {
            cell = (Cell)matrixEnumeration.advanceTo(n);
        }
        while (matrixEnumeration.hasMoreElements() || cell != null) {
            Rectangle rectangle;
            Rectangle rectangle2;
            int n4 = 1;
            boolean bl2 = this.highlightedRows.get(n);
            int n5 = this.headingHeight + (this.headingHeight > 0 ? 0 : 1) + n3 * this.cellHeight;
            int n6 = this.headings.length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = this.splitters[n7 + 1] - this.splitters[n7];
                if (this.offscreenImage != null) {
                    this.offscreenImageGraphics.setColor(bl2 ? this.colorHBg : this.colorBg);
                    this.offscreenImageGraphics.fillRect(n4, n5, n8 + 4, this.cellHeight);
                    this.offscreenImageGraphics.setColor(bl2 ? this.colorHFg : this.colorFg);
                }
                if (cell == null) {
                    cell = (Cell)matrixEnumeration.nextElement();
                }
                if (this.offscreenImage != null && cell != null && matrixEnumeration.currRow() == n && matrixEnumeration.currCol() == n7) {
                    cell.drawCell(this.offscreenImageGraphics, this.getColumnAlignment(n7), this.splitters[n7] + 3, n5, n8, this.cellHeight, this.cellAscent);
                    cell = null;
                }
                if (cell != null && matrixEnumeration.currRow() < n) {
                    cell = null;
                }
                n4 = this.splitters[n7 + 1] - 3;
                ++n7;
            }
            if (this.hasFocus & this.focusIndicatedVisually && this.offscreenImage != null && n == this.selectedRow && (rectangle2 = this.offscreenImageGraphics.getClipRect()) != null) {
                this.offscreenImageGraphics.setColor(this.colorBg);
                this.offscreenImageGraphics.setXORMode(Color.gray);
                this.offscreenImageGraphics.drawRect(1, n5, rectangle2.width - 3, this.cellHeight - 1);
                this.offscreenImageGraphics.setPaintMode();
            }
            if (this.offscreenImage != null && bl && (rectangle = this.offscreenImageGraphics.getClipRect()) != null) {
                this.repaint(0, n5, rectangle.width, this.cellHeight);
            }
            if (--n2 == 0) break;
            ++n;
            ++n3;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void drawColumnHeading(Rectangle rectangle, boolean bl) {
        if (OS.isMacintosh()) {
            this.offscreenImageGraphics.setColor(Color.black);
            this.offscreenImageGraphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            this.offscreenImageGraphics.setColor(bl ? Color.gray : this.headingBg);
            this.offscreenImageGraphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            if (bl) {
                this.offscreenImageGraphics.setColor(Color.black);
            }
            this.offscreenImageGraphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + 1, rectangle.y + rectangle.height - 2);
            this.offscreenImageGraphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
            this.offscreenImageGraphics.setColor(bl ? thirtyThreePercentGray : Color.white);
            this.offscreenImageGraphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
            this.offscreenImageGraphics.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
            this.offscreenImageGraphics.setColor(bl ? sixtySixPercentGray : Color.gray);
            this.offscreenImageGraphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            this.offscreenImageGraphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        } else {
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
            this.draw3DBox(rectangle, bl ^ true);
            this.offscreenImageGraphics.setColor(this.headingBg);
            this.offscreenImageGraphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
    }

    protected void draw3DBox(Rectangle rectangle, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        this.offscreenImageGraphics.setColor(bl ? Color.black : Color.white);
        this.offscreenImageGraphics.drawLine(n3, n2, n3, n4);
        this.offscreenImageGraphics.drawLine(n3 + 1, n2, n3 + 1, n4);
        this.offscreenImageGraphics.drawLine(n, n4, n3, n4);
        this.offscreenImageGraphics.drawLine(n, n4 + 1, n3, n4 + 1);
        this.offscreenImageGraphics.setColor(bl ? Color.white : Color.gray);
        this.offscreenImageGraphics.drawLine(n, n2, n3 - 2, n2);
        this.offscreenImageGraphics.drawLine(n, n2, n, n4 - 1);
    }

    protected void calculateHeadingHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.headingFont);
        this.headingHeight = fontMetrics.getHeight() + fontMetrics.getLeading() + 7;
    }

    protected void drawHeading(boolean bl) {
        Serializable serializable;
        if (!this.headingVisible) {
            return;
        }
        if (this.headings.length > 0) {
            serializable = this.offscreenImageGraphics.getFont();
            FontMetrics fontMetrics = this.offscreenImageGraphics.getFontMetrics();
            int n = this.splitters[0];
            int n2 = 0;
            while (n2 < this.headings.length) {
                int n3 = this.splitters[n2 + 1];
                int n4 = n3 - n;
                Rectangle rectangle = new Rectangle(n, 0, n4, this.headingHeight);
                boolean bl2 = this.columnClicked == n2;
                this.drawColumnHeading(rectangle, bl2);
                String string = this.headings[n2];
                if (string != null) {
                    this.offscreenImageGraphics.setColor(this.headingFg);
                    this.offscreenImageGraphics.setFont(this.f);
                    int n5 = fontMetrics.stringWidth(string);
                    int n6 = n4 - 3;
                    int n7 = bl && bl2 ? 1 : 0;
                    int n8 = this.headingHeight - 6 + n7;
                    Shape shape = this.offscreenImageGraphics.getClip();
                    this.offscreenImageGraphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    switch (this.getColumnAlignment(n2)) {
                        case 0: {
                            this.offscreenImageGraphics.drawString(string, n + 8 + n7, n8);
                            break;
                        }
                        case 1: {
                            if (n5 > n6) {
                                this.offscreenImageGraphics.drawString(string, n + 8 + n7, n8);
                                break;
                            }
                            this.offscreenImageGraphics.drawString(string, n + (n6 - n5) / 2 + n7, n8);
                            break;
                        }
                        case 2: {
                            if (n5 > n6) {
                                this.offscreenImageGraphics.drawString(string, n + 8 + n7, n8);
                                break;
                            }
                            this.offscreenImageGraphics.drawString(string, n + n6 - n5 - 6 + n7, n8);
                            break;
                        }
                    }
                    this.offscreenImageGraphics.setClip(shape);
                    if (bl2) {
                        this.offscreenImageGraphics.drawLine(rectangle.x + 1, this.headingHeight - 1, n3 - 3, this.headingHeight - 1);
                    }
                    n = n3 - 1;
                }
                ++n2;
            }
        }
        serializable = this.size();
        int n = this.splitters[this.splitters.length - 1];
        if (n < this.sbHPosition + serializable.width - this.verticalScrollbarWidth) {
            Rectangle rectangle = new Rectangle(n - 1, 0, this.sbHPosition + serializable.width - this.verticalScrollbarWidth - n + 1, this.headingHeight);
            this.drawColumnHeading(rectangle, false);
        }
    }

    protected String[] intArrayToStringArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            String string = "";
            try {
                string = String.valueOf(nArray[n]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    protected int[] getColumnSizesFromSplitters() {
        int[] nArray = new int[this.headings.length];
        int n = 0;
        while (n < this.headings.length) {
            nArray[n] = this.splitters[n + 1] - this.splitters[n];
            ++n;
        }
        return nArray;
    }

    protected void triggerRedraw() {
        if (!this.isSuppressRedraw) {
            this.forceRedraw = true;
            this.repaint();
        } else {
            this.redrawWasSupressed = true;
        }
    }

    protected void calcHeadings(String[] stringArray) {
        block5: {
            this.headings = new String[stringArray.length];
            this.splitters = new int[stringArray.length + 1];
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.setHeading(stringArray[n], n);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
                ++n;
            }
            if (this.columnSizes == null) break block5;
            try {
                this.setColumnSizes(this.intArrayToStringArray(this.columnSizes));
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    class PopupText
    extends Window
    implements MouseListener {
        String text = null;
        SearchList parent = null;

        PopupText(SearchList searchList2) {
            super(new Frame());
            this.parent = searchList2;
            ((Component)this).setBackground(new Color(255, 255, 200));
            this.setForeground(Color.black);
        }

        PopupText(SearchList searchList2, String string) {
            super(new Frame());
            this.parent = searchList2;
            this.text = string;
            ((Component)this).setBackground(new Color(255, 255, 200));
            this.setForeground(Color.black);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setFont(SearchList.this.f);
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics(SearchList.this.f);
            int n = fontMetrics.getHeight();
            graphics.drawString(this.text, 2, n - 2);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }

        public synchronized void addNotify() {
            super.addNotify();
            this.addMouseListener(this);
        }

        void setText(String string) {
            this.text = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = this.parent.getLocationOnScreen();
            Point point2 = this.getLocationOnScreen();
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            mouseEvent.translatePoint(n, n2);
            ((Component)this).hide();
            this.parent.dispatchEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((Component)this).hide();
        }
    }
}

