/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.help3;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.webworks.help3.ColorUtils;
import com.webworks.help3.OS;
import com.webworks.help3.WWHelp;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class XList
extends Panel
implements FocusListener,
MouseListener,
MouseMotionListener,
KeyListener,
ItemSelectable {
    public static final long CLICKTHRESHOLD = 500L;
    public static final int PLAIN = 0;
    public static final int DISABLED = 1;
    public static final int CROSSREFERENCE = 2;
    protected String actionCommand = "RowSelected:";
    PopupText popupText = null;
    Boolean bNoHoverText;
    ActionListener actionListener = null;
    Vector items = new Vector();
    Vector listeners = new Vector();
    Font defaultFont = null;
    Font italicFont = null;
    boolean showVBar;
    boolean showHBar;
    boolean hasFocus;
    boolean actionOccured = false;
    int rows = 0;
    int selected = 0;
    int focused = 0;
    int visibleIndex = 0;
    int maxVWidth = -1;
    int vPos = 0;
    int hPos = 0;
    long lastClick = 0L;
    boolean bNoAltFont;
    Image textImage;
    protected Scrollbar vBar;
    protected Scrollbar hBar;

    public XList() {
        this(0);
    }

    public XList(int n) {
        this.setBackground(Color.white);
        this.vBar = new XListVBar(1);
        this.vBar.hide();
        this.add(this.vBar);
        this.hBar = new XListHBar(0);
        this.hBar.hide();
        this.add(this.hBar);
        if (OS.isSolaris() || OS.isLinux()) {
            this.vBar.setBackground(Color.lightGray);
            this.hBar.setBackground(Color.lightGray);
        }
        this.bNoAltFont = false;
        if (WWHelp.getSecurityType().equals("ms_ie")) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            this.popupText = new PopupText(this, "text string");
        } else {
            this.popupText = new PopupText(this, "text string");
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItem(int n) {
        return ((XListItem)this.items.elementAt((int)n)).text;
    }

    public String getSortItem(int n) {
        return ((XListItem)this.items.elementAt((int)n)).key;
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.items.size()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public void add(String string, String string2) {
        this.add(string, string2, 0);
    }

    public void add(String string, String string2, int n) {
        this.items.addElement(new XListItem(string, string2, n));
        this.rows = this.items.size();
        this.maxVWidth = -1;
    }

    public void removeAll() {
    }

    public synchronized void remove(String string) {
        int n = this.items.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in list");
        }
        this.remove(n);
    }

    public void remove(int n) {
    }

    public synchronized int getSelectedIndex() {
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        if (this.selected == -1) {
            return "";
        }
        XListItem xListItem = (XListItem)this.items.elementAt(this.selected);
        return xListItem.text.trim();
    }

    public synchronized String getSelectedSortItem() {
        if (this.selected == -1) {
            return "";
        }
        XListItem xListItem = (XListItem)this.items.elementAt(this.selected);
        return xListItem.key.trim();
    }

    private void selectAndNotify(int n) {
        if (n >= this.rows) {
            return;
        }
        this.selected = n;
        this.focused = n;
        this.redraw(this.getGraphics());
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ItemListener itemListener = (ItemListener)this.listeners.elementAt(n2);
            itemListener.itemStateChanged(new ItemEvent(this, 701, this.items.elementAt(n), 1));
            ++n2;
        }
    }

    public void select(int n) {
        if (n > this.rows) {
            return;
        }
        this.selected = n;
        this.focused = n;
        this.vPos = this.selected;
        this.redraw(this.getGraphics());
    }

    public void select(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.rows) {
            XListItem xListItem = (XListItem)this.items.elementAt(n);
            String string2 = xListItem.key;
            if (string2.equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.selected = -1;
            return;
        }
        this.select(n);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void selectFocus(int n) {
        if (n >= this.rows) {
            this.focused = this.rows - 1;
            return;
        }
        if (n < 0) {
            this.focused = 0;
            return;
        }
        this.focused = n;
        int n2 = this.getNumVisibleRows(this.getGraphics());
        if (this.focused < this.vPos) {
            this.actionOccured = true;
            this.vPos = this.focused;
            this.redraw(this.getGraphics());
        } else if (this.focused > this.vPos + n2 - 1) {
            this.vPos = this.focused - n2 + 1;
            this.actionOccured = true;
            this.redraw(this.getGraphics());
        } else {
            this.actionOccured = true;
            this.redrawImage(this.getGraphics());
        }
    }

    public synchronized void deselect(int n) {
    }

    public boolean isIndexSelected(int n) {
        return true;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int n) {
    }

    public Dimension getPreferredSize(int n) {
        return new Dimension();
    }

    public Dimension getPreferredSize() {
        return new Dimension();
    }

    public Dimension getMinimumSize(int n) {
        return new Dimension();
    }

    public Dimension getMinimumSize() {
        return new Dimension();
    }

    private int getNumVisibleRows(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.getSize().height;
        if (this.hBar.isVisible()) {
            return (n2 - this.hBar.size().height) / n;
        }
        return n2 / n;
    }

    public void addItemListener(ItemListener itemListener) {
        this.listeners.addElement(itemListener);
    }

    public void paint(Graphics graphics) {
        this.redraw(graphics);
    }

    public void triggerRedraw() {
        this.repaint();
    }

    void redrawImage(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.size();
        int n = this.vBar.isVisible() ? this.vBar.size().width : 0;
        int n2 = this.hBar.isVisible() ? this.hBar.size().height : 0;
        if (this.actionOccured) {
            this.actionOccured = false;
            this.drawTextImage(new Dimension(dimension.width - n - 1, dimension.height - n2 - 1));
        }
        graphics.clipRect(2, 2, dimension.width - n - 2, dimension.height - n2 - 2);
        graphics.drawImage(this.textImage, 0, 0, this);
    }

    private void redraw(Graphics graphics) {
        int n;
        Dimension dimension = this.size();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = this.getNumVisibleRows(graphics);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 2);
        graphics.setColor(ColorUtils.lighten(Color.lightGray, 0.5));
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
        this.showVBar = n2 < this.rows;
        if (this.maxVWidth == -1) {
            n = 0;
            while (n < this.items.size()) {
                XListItem xListItem = (XListItem)this.items.elementAt(n);
                String string = xListItem.text;
                int n3 = fontMetrics.stringWidth(string);
                if (n3 > this.maxVWidth) {
                    this.maxVWidth = n3;
                }
                ++n;
            }
        }
        this.showHBar = this.maxVWidth > dimension.width;
        if (this.showVBar) {
            n = this.vBar.getPreferredSize().width;
            int n4 = this.hBar.getPreferredSize().height;
            if (this.showHBar) {
                this.vBar.reshape(dimension.width - n - 2, 2, n, dimension.height - 4 - n4);
            } else {
                this.vBar.reshape(dimension.width - n - 2, 2, n, dimension.height - 4);
            }
            this.vBar.setValues(this.vPos, n2, 0, this.rows + 2);
            this.vBar.setPageIncrement(n2 - 1);
            if (!this.vBar.isVisible()) {
                this.vBar.show();
            }
        } else {
            this.vBar.hide();
            this.vPos = 0;
        }
        n = this.vBar.size().width;
        if (this.showHBar) {
            int n5 = this.hBar.getPreferredSize().height;
            if (this.showVBar) {
                this.hBar.reshape(2, dimension.height - n5 - 2, dimension.width - n - 4, n5);
            } else {
                this.hBar.reshape(2, dimension.height - n5 - 2, dimension.width - 4, n5);
            }
            this.hBar.setValues(this.hPos, dimension.width - n - 4, 0, this.maxVWidth + 4);
            this.hBar.setPageIncrement(dimension.width - n);
            this.hBar.setLineIncrement(4);
            this.hBar.show();
        } else {
            this.hPos = 0;
            this.hBar.hide();
        }
        int n6 = this.hBar.size().height;
        if (this.defaultFont == null) {
            this.defaultFont = graphics.getFont();
            this.italicFont = !this.bNoAltFont ? new Font(this.defaultFont.getName(), 2, this.defaultFont.getSize()) : graphics.getFont();
        }
        if (this.hBar.isVisible() && this.vBar.isVisible()) {
            graphics.setColor(SystemColor.control);
            if (OS.isSolaris() || OS.isLinux()) {
                graphics.setColor(Color.lightGray);
            }
            graphics.fillRect(dimension.width - n - 1, dimension.height - n6 - 1, n - 2, n6 - 2);
        }
        graphics.setColor(Color.black);
        this.actionOccured = true;
        this.redrawImage(graphics);
    }

    private void drawTextImage(Dimension dimension) {
        if (this.textImage != null) {
            this.textImage.flush();
            this.textImage = null;
        }
        this.textImage = this.createImage(dimension.width, dimension.height);
        Graphics graphics = this.textImage.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.getNumVisibleRows(graphics);
        if (this.defaultFont == null) {
            this.defaultFont = graphics.getFont();
            this.italicFont = !this.bNoAltFont ? new Font(this.defaultFont.getName(), 2, this.defaultFont.getSize()) : graphics.getFont();
        }
        int n3 = this.vPos;
        while (n3 < this.vPos + n2) {
            if (n3 >= this.rows) break;
            XListItem xListItem = (XListItem)this.items.elementAt(n3);
            String string = xListItem.text;
            if (n3 == this.selected) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(0, n * (n3 - this.vPos) + 6, dimension.width - 1, n);
                graphics.setColor(SystemColor.textHighlightText);
                if (xListItem.textStyle == 2) {
                    graphics.setFont(this.italicFont);
                    graphics.drawString(string, 4 - this.hPos, n * (n3 - this.vPos + 1) + 4);
                } else if (xListItem.textStyle == 1) {
                    graphics.setFont(this.italicFont);
                    graphics.drawString(string, 4 - this.hPos, n * (n3 - this.vPos + 1) + 4);
                } else {
                    graphics.setFont(this.defaultFont);
                    graphics.drawString(string, 4 - this.hPos, n * (n3 - this.vPos + 1) + 4);
                }
            } else {
                graphics.setColor(Color.black);
                if (xListItem.textStyle == 2) {
                    graphics.setFont(this.italicFont);
                    graphics.drawString(string, 4 - this.hPos, n * (n3 - this.vPos + 1) + 4);
                } else if (xListItem.textStyle == 1) {
                    graphics.setFont(this.italicFont);
                    graphics.drawString(string, 4 - this.hPos, n * (n3 - this.vPos + 1) + 4);
                } else {
                    graphics.setFont(this.defaultFont);
                    graphics.drawString(string, 4 - this.hPos, n * (n3 - this.vPos + 1) + 4);
                }
            }
            if (n3 == this.focused && this.hasFocus) {
                this.drawDashedRect(graphics, 2, n * (n3 - this.vPos) + 6, dimension.width - 4, n - 1);
            }
            ++n3;
        }
    }

    void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawDashedHLine(graphics, n, n2, n3);
        this.drawDashedHLine(graphics, n, n2 + n4, n3);
        this.drawDashedVLine(graphics, n, n2, n4);
        this.drawDashedVLine(graphics, n + n3, n2, n4);
    }

    void drawDashedVLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            graphics.setColor(Color.black);
            graphics.drawLine(n, n4, n, n4);
            graphics.setColor(Color.white);
            graphics.drawLine(n, ++n4, n, n4);
            ++n4;
        }
    }

    void drawDashedHLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n;
        while (n4 < n + n3) {
            graphics.setColor(Color.black);
            graphics.drawLine(n4, n2, n4, n2);
            graphics.setColor(Color.white);
            graphics.drawLine(++n4, n2, n4, n2);
            ++n4;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.actionOccured = true;
        this.redrawImage(this.getGraphics());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.actionOccured = true;
        this.redrawImage(this.getGraphics());
    }

    public void setNoHoverText(Boolean bl) {
        this.bNoHoverText = bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.vBar.size().width;
        int n2 = this.hBar.size().height;
        Rectangle rectangle = new Rectangle(2, 2, this.size().width - n, this.size().height - n2);
        Point point = mouseEvent.getPoint();
        if (!rectangle.contains(point)) {
            return;
        }
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = this.getNumVisibleRows(graphics);
        int n5 = (point.y - 2) / n3 + this.vPos;
        if (n5 > this.rows) {
            return;
        }
        long l = mouseEvent.getWhen();
        if (n5 == this.selected) {
            long l2 = l - this.lastClick;
            if (l2 < 500L) {
                this.actionPerformed();
            }
        } else {
            this.actionOccured = true;
            this.selectAndNotify(n5);
        }
        this.lastClick = l;
    }

    void actionPerformed() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, String.valueOf(this.actionCommand) + this.selected));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.bNoHoverText == null || this.bNoHoverText != null && !this.bNoHoverText.booleanValue()) {
            int n;
            int n2 = this.vBar.size().width;
            int n3 = this.hBar.size().height;
            Rectangle rectangle = new Rectangle(2, 2, this.size().width - n2, this.size().height - n3);
            Point point = mouseEvent.getPoint();
            if (!rectangle.contains(point)) {
                return;
            }
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.getHeight();
            int n5 = this.getNumVisibleRows(graphics);
            int n6 = (point.y - 2) / n4 + this.vPos;
            if (n6 > this.rows) {
                return;
            }
            int n7 = fontMetrics.stringWidth(this.getItem(n6));
            Rectangle rectangle2 = new Rectangle(1, n4 * (n6 - this.vPos) + 4, n7 + 5, (n = fontMetrics.getHeight()) + 2);
            if (rectangle2.inside(point.x, point.y)) {
                if (rectangle2.width + rectangle2.x > this.getSize().width - n2) {
                    point = this.getLocationOnScreen();
                    this.popupText.setText(this.getItem(n6));
                    this.popupText.move(point.x + rectangle2.x, point.y + rectangle2.y);
                    if (WWHelp.getSecurityType().equals("ms_ns") || System.getSecurityManager().checkTopLevelWindow(this.popupText)) {
                        this.popupText.resize(rectangle2.width, rectangle2.height);
                        if (this.popupText.getInsets().bottom == 0) {
                            this.popupText.show();
                            this.popupText.repaint();
                        }
                    } else {
                        this.popupText.resize(rectangle2.width, rectangle2.height * 2);
                        this.popupText.show();
                        this.popupText.repaint();
                    }
                }
            } else if (this.popupText != null) {
                ((Component)this.popupText).hide();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        switch (keyEvent.getKeyCode()) {
            case 40: {
                this.selectFocus(this.focused + 1);
                break;
            }
            case 34: {
                int n2 = this.getNumVisibleRows(this.getGraphics());
                if (this.focused + n2 - 1 < this.rows) {
                    this.vPos = this.vPos + n2 - 1;
                    this.vBar.setValue(this.vPos);
                    this.selectFocus(this.focused + n2 - 1);
                    this.vBar.paint(this.vBar.getGraphics());
                    break;
                }
                this.vPos = this.rows - 1;
                this.vBar.setValue(this.vPos);
                this.selectFocus(this.rows - 1);
                this.vBar.paint(this.vBar.getGraphics());
                break;
            }
            case 38: {
                this.selectFocus(this.focused - 1);
                break;
            }
            case 33: {
                int n3 = this.getNumVisibleRows(this.getGraphics());
                if (this.focused - n3 + 1 > 0) {
                    this.selectFocus(this.focused - n3 + 1);
                    break;
                }
                this.selectFocus(0);
                break;
            }
            case 39: {
                if (this.hPos < this.hBar.getMaximum() - this.hBar.getVisibleAmount()) {
                    this.hPos += 3;
                }
                this.redraw(this.getGraphics());
                break;
            }
            case 37: {
                if (this.hPos > 0) {
                    this.hPos -= 3;
                }
                this.redraw(this.getGraphics());
                break;
            }
            case 10: {
                if (this.focused <= -1) break;
                this.selectAndNotify(this.focused);
                break;
            }
        }
    }

    public void removeItemListener(ItemListener itemListener) {
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.items.elementAt(this.selected)};
        return objectArray;
    }

    private class XListItem {
        public String key;
        public String text;
        public int textStyle;

        XListItem(String string, String string2) {
            this.key = string;
            this.text = string2;
            this.textStyle = 0;
        }

        XListItem(String string, String string2, int n) {
            this.key = string;
            this.text = string2;
            this.textStyle = n;
        }
    }

    private class XListVBar
    extends Scrollbar
    implements AdjustmentListener,
    ComponentListener {
        public XListVBar() {
        }

        public XListVBar(int n) {
            super(n);
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (XList.this.vPos != XList.this.vBar.getValue()) {
                XList.this.vPos = XList.this.vBar.getValue();
                XList.this.actionOccured = true;
                XList.this.redrawImage(this.getParent().getGraphics());
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (!this.isShowing()) {
                this.hide();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void addNotify() {
            super.addNotify();
            this.addAdjustmentListener(this);
            this.addComponentListener(this);
        }
    }

    private class XListHBar
    extends Scrollbar
    implements AdjustmentListener,
    ComponentListener {
        public XListHBar() {
        }

        public XListHBar(int n) {
            super(n);
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (!this.isShowing()) {
                this.hide();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (XList.this.hPos != XList.this.hBar.getValue()) {
                XList.this.hPos = XList.this.hBar.getValue();
                XList.this.actionOccured = true;
                XList.this.redrawImage(this.getParent().getGraphics());
            }
        }

        public void addNotify() {
            super.addNotify();
            this.addAdjustmentListener(this);
            this.addComponentListener(this);
        }
    }

    class PopupText
    extends Window
    implements MouseListener,
    MouseMotionListener,
    FocusListener {
        String text = null;
        Panel tv = null;

        PopupText() {
            super(new Frame());
            ((Component)this).setBackground(new Color(255, 255, 200));
            this.setForeground(Color.black);
        }

        PopupText(Panel panel, String string) {
            super(new Frame());
            this.tv = panel;
            this.text = string;
            ((Component)this).setBackground(new Color(255, 255, 200));
            this.setForeground(Color.black);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Font font = WWHelp.getFontX(WWHelp.fontName, 0, WWHelp.fontSize);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            graphics.drawString(this.text, 2, n - 2);
        }

        public synchronized void addNotify() {
            super.addNotify();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        void setText(String string) {
            this.text = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = this.tv.getLocationOnScreen();
            Point point2 = this.getLocationOnScreen();
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            mouseEvent.translatePoint(n, n2);
            ((Component)this).hide();
            this.tv.dispatchEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((Component)this).hide();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.tv.requestFocus();
        }
    }
}

