/*======================================================================================================*/
/* Telespace map C plugin										*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	2002-Nov-19 16:54:07									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <stdio.h>

#include <EMalloc.h>
#include <EPlugins.h>

#include <E3D/EMacros.h>
#include <E3D/Matrix.h>
#include <E3D/Panel.h>
#include <E3D/Polygon.h>
#include <E3D/Scene.h>
#include <E3D/StatusPanel.h>
#include <E3D/3DWindow.h>

#include <EGUI/PushButton.h>
#include <EGUI/Dialog.h>

#include <Xe/Label.h>


extern EpCImage		Image_Map;
extern EpCImage		Image_MapActive;
extern EpCImage		Image_MapArm;


EPlugin*		TSMap_Plugin=NULL;

static EguiItem		_MenuButtons[16],
			_ToolPanelButtons[2];

static unsigned int	_NumOfMenuButtons=0,
			_NumOfToolPanelButtons=0;

#include "Map.h"

#include "FollowCamera.h"
#include "Mover.h"
#include "Stationary.h"
#include "Streetlight.h"


int	TSMap_CurrentModelType=E3dTS_STATIONARY;
int	TSMap_CurrentModelDir=E3dTS_DIR_BUILDING;


enum
{
 E3dCR_SAVE_MAP=1
};


/*======================================================================*/
/* Collect selected Models and make sure they have the Telespace Info	*/
/*======================================================================*/
void TSMap_CollectModelsToEdit()
{
 E3dModel**	LSelectedModels;
 E3dModel*	LModel;
 char*		LNameStr=NULL;
 int		LNumOfSelectedModels, LC, LNewTelespaceModels=0;


 if((LNumOfSelectedModels=E3d_SceneGetSelectedModels(E3d_Scene, &LSelectedModels, FALSE))>0)
 {
  E3dModelInfo*	LInfo;

  for(LC=0;LC<LNumOfSelectedModels;LC++)
  {
   LModel=LSelectedModels[LC];

   if((E3d_ModelInfoByClass(LModel, TSMap_StationaryInfo.Class)==NULL)&&
      (E3d_ModelInfoByClass(LModel, TSMap_StreetlightInfo.Class)==NULL)&&
      (E3d_ModelInfoByClass(LModel, TSMap_MoverInfo.Class)==NULL)&&
      (E3d_ModelInfoByClass(LModel, TSMap_FollowCameraInfo.Class)==NULL))
   {
//printf("Set to %d\n", TSMap_CurrentModelType);fflush(stdout);
    switch(TSMap_CurrentModelType)
    {
     case E3dTS_STATIONARY:
      M_SetClassOnModel(E3dStationary, TSMap_Stationary);
     break;

     case E3dTS_STREETLIGHT:
      M_SetClassOnModel(E3dStreetlight, TSMap_Streetlight);
     break;

     case E3dTS_FOLLOWCAMERA:
      M_SetClassOnModel(E3dFollowCamera, TSMap_FollowCamera);
     break;

     case E3dTS_MOVER:
      M_SetClassOnModel(E3dMover, TSMap_Mover);
     break;
    }
   }
  }

  TSMap_EditedModels=LSelectedModels;
  _NumOfTelespaceModels=LNumOfSelectedModels;

  E3d_ModelsAddLock(LSelectedModels, LNumOfSelectedModels);

  E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);

  switch(LNewTelespaceModels)
  {
   case 1:	E3dp_PrintMessage(0, 5000, "1 Model was set to class '%s'", LNameStr);break;
   case 0:	break;
   default:	E3dp_PrintMessage(0, 5000, "%d Models were set to class '%s'", LNewTelespaceModels, LNameStr);break;
  }
 }
 else E3dp_PrintMessage(0, 5000, "Select at least one Model");
}


/*======================================*/
/* Menu/ToolPanel callback		*/
/*======================================*/
static void _MCB(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 if(TSMap_EditedModels) return;

 TSMap_CollectModelsToEdit();

//printf("TSModels %d\n", _NumOfTelespaceModels);fflush(stdout);

 if(TSMap_EditedModels)
 {
  if(((EguiPushButtonCallbackStruct*)LCallData)->Reason==ECR_OPTIONS)
  {
   TSMap_PopupDialog(TSMap_EditedModels[0]);return;
  }

  switch((int)LClientData)
  {
   case E3dCR_SAVE_MAP:
    {
     EModel**		LRootModels;
     EModel*		LModel;
     FILE*		LOutFile=fopen("map.xml", "w");
     EScene*		LScene=E3d_Scene;
     unsigned int	LC, LN, LTSObjs=0;


     if(LOutFile)
     {
      LRootModels=LScene->RootModels;


 fprintf(LOutFile, "<Project>TeleSpace town</Project>\n\n");
 fprintf(LOutFile, "<Remark>Saved by EQUINOX-3D</Remark>\n\n");

      for(LC=0, LN=LScene->NumOfRootModels;LC<LN;LC++)
      {
       LModel=LRootModels[LC];

       switch(LModel->Type)
       {
	case EMDL_NORMAL:
	 {
	  char*	LFileName = LModel->FileName;

	  if(!LFileName) LFileName = LModel->Name;

 E3dp_PrintMessage(0, 5000, "%s ", LFileName);

	  if(LModel->Info)
	  {
	   E3dModelInfo*	LInfo = LModel->Info[0];

	   if(LInfo)
	   {

 fprintf(LOutFile, "\n<Entity>\n");

	    if(LInfo->Class==TSMap_StationaryInfo.Class)
	    {
	     fprintf(LOutFile, " <File>%s</File>\n <Location>%f %f %f</Location>\n", LFileName, LModel->Translation.X, LModel->Translation.Y, LModel->Translation.Z);
//	    fprintf(LOutFile, " <hrLocation>0x60 %d %d  %d %d  %d %d</hrLocation>\n", 10, 20,  30, 40,  50, 60);

	     if((LModel->Rotation.X!=0.0)||(LModel->Rotation.Y!=0.0)||(LModel->Rotation.Z!=0.0))
	     {
	      fprintf(LOutFile, " <Rotation>%3.2f %3.2f %3.2f</Rotation>\n", LModel->Rotation.X, LModel->Rotation.Y, LModel->Rotation.Z);
	     }
	     LTSObjs++;
	    }
 fprintf(LOutFile, "</Entity>\n");
	   }
	  }
	 }
	break;
       }
      }

//E3dp_PrintMessage(0, 5000, "%d Objects saved into TeleSpace MAP", LTSObjs);

      fclose(LOutFile);
     }
    }
   break;
  }
 }
}


/*======================================*/
/* Entry point of the plugin		*/
/*======================================*/
int Plugin_Init(EPlugin* LPlugin)
{
 EpImage*	LImage;
 EpImage*	LActiveImage;
 EpImage*	LArmImage;

 TSMap_Plugin=LPlugin;


// Initialize Model classes
//
 TS_StationaryInit();
 TS_StreetlightInit();
 TS_MoverInit();
 TS_FollowCameraInit();


 EpM_RGBA8ImageFromCStruct(LImage, Image_Map);
 EpM_RGBA8ImageFromCStruct(LActiveImage, Image_MapActive);
 EpM_RGBA8ImageFromCStruct(LArmImage, Image_MapArm);
 _ToolPanelButtons[_NumOfToolPanelButtons++]=EGUI_AddPushButtonImg("Tool->Create", "TSMap-C", '\0', NULL, NULL, FALSE, "Left button: Save Telespace Map\nRight button: edit Telespace attributes on selected Model", _MCB, (EPointer) E3dCR_SAVE_MAP, LImage, LActiveImage, LArmImage);

 return(0);
}


/*======================================*/
/* Exit method of the plugin		*/
/*======================================*/
int Plugin_Exit()
{
 unsigned int	LC;


// Remove menu and ToolBar buttons
//
 for(LC=0;LC<_NumOfMenuButtons;LC++) if(_MenuButtons[LC]) EGUI_DestroyItem(_MenuButtons[LC]);
 for(LC=0;LC<_NumOfToolPanelButtons;LC++) if(_ToolPanelButtons[LC]) EGUI_DestroyItem(_ToolPanelButtons[LC]);

// Deactivate classes
//
 TS_StationaryDeactivate();
 TS_StreetlightDeactivate();
 TS_MoverDeactivate();
 TS_FollowCameraDeactivate();


 return(0);
}
