/*======================================================================================================*/
/* Telespace map plugin, GUI										*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* - Streetlight object class										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	2002-Nov-14 16:53:06									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <stdio.h>

#include <EMalloc.h>
#include <EPlugins.h>


#include <E3D/EMacros.h>
#include <E3D/3DWindow.h>

#include <EGUI/PushButton.h>
#include <EGUI/Dialog.h>

#include <Xe/Matrix.h>
#include <Xe/ToggleButton.h>


#include "Map.h"

#include "Streetlight.h"



// Streetlight Object
//
#define ROffset(field) (void*)(EPtrOffset(E3dStreetlightInfo, field))
EResource _StreetlightResources[]=
{
 { "On",	EResBOOLEAN,	ROffset(On), NULL },
 { "",		EResNULL,	NULL, NULL }
};
#undef ROffset


// Class template
//
E3dStreetlightInfo	TSMap_StreetlightInfo;


static Widget		_OnBW;


static Arg		Args[256];
static Cardinal		ArgCnt;


enum
{
 CR_TOGGLE_ON
};


/*==============================================*/
/* Widget callback for the Streetlight class	*/
/*==============================================*/
static void _CB_Streetlight(Widget LI, XtPointer LClientData, XtPointer LCallData)
{
 E3dStreetlightInfo*	LInfo;
 unsigned int		LC;


 switch((int)LClientData)
 {
  case CR_TOGGLE_ON:
   for(LC=0;LC<_NumOfTelespaceModels;LC++)
   {
    LInfo=(E3dStreetlightInfo*)E3d_ModelInfoByClass(TSMap_EditedModels[LC], TSMap_StreetlightInfo.Class);

    if(LInfo)
    {
     LInfo->On=((XeToggleButtonCallbackStruct*)LCallData)->set;
     break;
    }
   }
  break;
 }
}


/*==============================================*/
/* Update GUI from the class record		*/
/*==============================================*/
void TS_StreetlightUpdateGUI()
{
 E3dStreetlightInfo*	LInfo;
 unsigned int		LC;


 for(LC=0;LC<_NumOfTelespaceModels;LC++)
 {
  LInfo=(E3dStreetlightInfo*)E3d_ModelInfoByClass(TSMap_EditedModels[LC], TSMap_StreetlightInfo.Class);

  if(LInfo) { XeToggleButtonSetState(_OnBW, LInfo->On, False);break; }
 }
}


/*==============================================*/
/* Create Matrix widget				*/
/*==============================================*/
Widget TS_StreetlightCreateMatrix(Widget LParentW)
{
 Widget	LMatrixW;


 EXtStart;
 EXtSetArg(XeNshadowThickness, 0);
 EXtSetArg(XeNbackground, EGUI_BackgroundColor);
 EXtSetArg(XeNorientation, XeVERTICAL);
 EXtSetArg(XeNxSpacing, 4);EXtSetArg(XeNySpacing, 7);
 LMatrixW=XtCreateWidget("StreetlightMatrixW", xeMatrixWidgetClass, LParentW, Args, ArgCnt);

 EXtStart;
 EXtSetArg(XeNbackground, EGUI_BackgroundColor);
 EXtSetArg(XeNselectColor, EGUI_HighlightColor);
 EXtSetArg(XeNshadowThickness, 0);
 EXtSetArg(XeNhighlightThickness, 0);
 EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);EXtSetArg(XeNmarginBottom, 0);
 EXtSetArg(XeNfontList, EGUI_LabelFontList);
 EXtSetArg(XeNset, TSMap_StreetlightInfo.On);
 _OnBW=XtCreateManagedWidget("On", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
 XtAddCallback(_OnBW, XeNvalueChangedCallback, (XtCallbackProc)_CB_Streetlight, (XtPointer)CR_TOGGLE_ON);

 return(LMatrixW);
}


/*==============================================*/
/* EditProc for the "Streetlight" Model type	*/
/*==============================================*/
static int _EditProc(E3dModel* LModel, E3dModelInfo* LInfo)
{
 TSTmpl_EditProc(E3dStreetlight, TSMap_Streetlight);
}


/*==============================================*/
/* Initialize class				*/
/*==============================================*/
void TS_StreetlightInit()
{
 E3dModelClass	LStreetlightClass=
   {
    "Streetlight",			// Name
    sizeof(E3dStreetlightInfo),		// StructSize
    _EditProc,			// EditProc
    NULL,				// RemoveProc
    NULL,				// DestroyProc
    _StreetlightResources		// Resources
   };

 TSMap_StreetlightInfo.Class=E3d_ModelClassRegister(&LStreetlightClass);
 TSMap_StreetlightInfo.On=TRUE;
}


/*==============================================*/
/* Deactivate class				*/
/*==============================================*/
void TS_StreetlightDeactivate()
{
 if(TSMap_StreetlightInfo.Class) E3d_ModelClassDeactivate(TSMap_StreetlightInfo.Class);
}
