/*======================================================================================================*/
/* Telespace map plugin, GUI										*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	2002-Nov-19 16:54:41									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <stdio.h>

#include <EMalloc.h>
#include <EPlugins.h>


#include <E3D/EMacros.h>
#include <E3D/Matrix.h>
#include <E3D/Model.h>
#include <E3D/3DWindow.h>
#include <E3D/Panel.h>
#include <E3D/Scene.h>
#include <E3D/StatusPanel.h>

#include <EGUI/PushButton.h>
#include <EGUI/Dialog.h>

#include <Xe/Label.h>
#include <Xe/Matrix.h>
#include <Xe/Scale.h>
#include <Xe/ToggleButton.h>


#include "Map.h"

#include "FollowCamera.h"
#include "Mover.h"
#include "Stationary.h"
#include "Streetlight.h"


extern Widget	TS_StationaryCreateMatrix(Widget LParentW);
extern void	TS_StationaryInit();



extern EPlugin*		TSMap_Plugin;
extern int		TSMap_CurrentModelType;
extern int		TSMap_CurrentModelDir;


static Widget		_ModelTypesOptionMenuW=NULL,
			_ModelDirOptionMenuW = NULL;




static Widget		_ModelTypeMatrixWs[16];
static int		_MatrixWNum=0;

static EguiItem		_Dialog=NULL;

static Arg		Args[256];
static Cardinal		ArgCnt;


extern EpCImage		Image_MapBig;


E3dModelPanel		_ModelPanel;

// Currently edited Model
//
E3dModel**	TSMap_EditedModels=NULL;
unsigned int	_NumOfTelespaceModels=0;


static EguiOptionMenuRec	_ModelTypes[]=
{
 { "Stationary",	E3dTS_STATIONARY,	NULL, (XtPointer)E3dTS_STATIONARY,	NULL },
 { "Streetlight",	E3dTS_STREETLIGHT,	NULL, (XtPointer)E3dTS_STREETLIGHT,	NULL },
 { "Mover",		E3dTS_MOVER,		NULL, (XtPointer)E3dTS_MOVER,		NULL },
 { "FollowCamera",	E3dTS_FOLLOWCAMERA,	NULL, (XtPointer)E3dTS_FOLLOWCAMERA,	NULL }
};

static EguiOptionMenuRec	_ModelDirs[]=
{
 { "Building",		E3dTS_DIR_BUILDING,	NULL, (XtPointer)E3dTS_DIR_BUILDING,	NULL },
 { "Vehicle",		E3dTS_DIR_VEHICLE,	NULL, (XtPointer)E3dTS_DIR_VEHICLE,	NULL },
 { "Misc",		E3dTS_DIR_MISC,		NULL, (XtPointer)E3dTS_DIR_MISC,	NULL }
};




/*======================================*/
/* Dialog callback			*/
/*======================================*/
static void _DCB(EguiItem LI, EPointer LClientData, EPointer LCallData)
{
 switch((int)LClientData)
 {
  case EguiCANCEL:
// Unlock edited Models and close the dialog box
//
   if(TSMap_EditedModels)
   {
    E3d_ModelsDelLock(TSMap_EditedModels, _NumOfTelespaceModels);
    EFree(TSMap_EditedModels);TSMap_EditedModels=NULL;_NumOfTelespaceModels=0;
   }

   EGUI_UndisplayShell(_Dialog);TSMap_Plugin->LockCount-=1;
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;
 }
}


/*==============================================*/
/* Update dialog box				*/
/*==============================================*/
static void _UpdateDialog()
{
 E3dModel*	LModel=TSMap_EditedModels[0];
 int		LC, LType=0;


 if(E3d_ModelInfoByClass(LModel, TSMap_StationaryInfo.Class)) LType=E3dTS_STATIONARY;
 else if(E3d_ModelInfoByClass(LModel, TSMap_StreetlightInfo.Class)) LType=E3dTS_STREETLIGHT;
 else if(E3d_ModelInfoByClass(LModel, TSMap_MoverInfo.Class)) LType=E3dTS_MOVER;
 else if(E3d_ModelInfoByClass(LModel, TSMap_FollowCameraInfo.Class)) LType=E3dTS_FOLLOWCAMERA;

printf("Type=%d\n", LType);fflush(stdout);

// Manage Matrix widget for the selected Model type and unmanage the rest
//
 for(LC=0;LC<_MatrixWNum;LC++)
 {
  if(LC==(LType-1)) XtManageChild(_ModelTypeMatrixWs[LC]);
  else XtUnmanageChild(_ModelTypeMatrixWs[LC]);
 }

// Update the ModelPanel part of the dialog box, using the 0th Model...
//
 E3d_ModelPanelUpdate(&_ModelPanel, TSMap_EditedModels[0]);


 EGUI_OptionMenuSetOptionByNumber(_ModelTypesOptionMenuW, LType-1);


 TS_StationaryUpdateGUI();
 TS_MoverUpdateGUI();
}


/*======================================================*/
/* Set Telespace Model type (OptionMenu callback)	*/
/*======================================================*/
static void _CB_CurrentModelType(EguiItem LI, EPointer LClientData, EPointer LCallData)
{
 int	LType=((EguiOptionMenuCallbackStruct*)LCallData)->Value;


 if(TSMap_CurrentModelType != LType)
 {
  EModel*	LModel;
  E3dModelInfo*	LInfo;
  char*		LNameStr=NULL;
  unsigned int	LC, LNewTelespaceModels=0;


  TSMap_CurrentModelType=LType;


  for(LC=0;LC<_NumOfTelespaceModels;LC++)
  {
   LModel=TSMap_EditedModels[LC];

   E3d_ModelInfoRemoveAll(LModel);

   switch(TSMap_CurrentModelType)
   {
    case E3dTS_STATIONARY:
     M_SetClassOnModel(E3dStationary, TSMap_Stationary);
    break;

    case E3dTS_STREETLIGHT:
     M_SetClassOnModel(E3dStreetlight, TSMap_Streetlight);
    break;

    case E3dTS_MOVER:
     M_SetClassOnModel(E3dMover, TSMap_Mover);
    break;

    case E3dTS_FOLLOWCAMERA:
     M_SetClassOnModel(E3dFollowCamera, TSMap_FollowCamera);
    break;
   }
  }

  _UpdateDialog();
 }
}


/*==============================================*/
/* Set Telespace Model directory		*/
/*==============================================*/
static void _CB_CurrentModelDir(EguiItem LI, EPointer LClientData, EPointer LCallData)
{
 int	LValue=((EguiOptionMenuCallbackStruct*)LCallData)->Value;


 if(TSMap_CurrentModelDir != LValue)
 {
  TSMap_CurrentModelDir = LValue;
  _UpdateDialog();
 }
}


enum
{
 CR_TOGGLE_ON
};


/*======================================*/
/* Pop up the dialog			*/
/*======================================*/
void TSMap_PopupDialog(E3dModel* LModel)
{
 if(_Dialog==NULL)
 {
  EguiArg		LArgs[32];
  int			LArgCnt;
  EguiItem		LDialog=E3d_VaModelDialogCreate("Telespace v0.1.2", TSMap_EditedModels[0], &_ModelPanel, EguiNiconCImage, &Image_MapBig, NULL),
			LI;
  EguiVisual*		LVisual=EGUI_TruecolorVisual;
  Widget		LTopMatrixW;
  Widget		LWAs[16];
  unsigned int		LWAN;


  if(LDialog==NULL) return;

  _Dialog=LDialog;
//  LArgCnt=0;
//  EguiSetArg(EguiNshowAsDefault, True, LArgs, LArgCnt);
//  LI=EGUI_CreatePushButton("Set on selection", LDialog, LArgs, LArgCnt);
//  EGUI_AddCallback(LI, EguiNactivateCallback, _DCB, (EPointer)EguiOK);

  LArgCnt=0;
  EguiSetArg(EguiNshowAsDefault, True, LArgs, LArgCnt);
  LI=EGUI_CreatePushButton("Close", LDialog, LArgs, LArgCnt);
  EGUI_AddCallback(LI, EguiNactivateCallback, _DCB, (EPointer)EguiCANCEL);

  LTopMatrixW=EGUI_DialogGetChild(LDialog, EguiDIALOG_WORK_AREA);
  EXtStart;
  EXtSetArg(XeNySpacing, 4);
  XtSetValues(LTopMatrixW, Args, ArgCnt);

  if(LVisual)
  {
   LWAN=0;

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNbuttonColor, EGUI_ButtonColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_MenuFontList);
   EXtSetArg(XeNlabelFontList, EGUI_LabelFontList);
   EXtSetArg(XeNcastShadowWidth, 4);
   EXtSetArg(XeNmenuPaneBackground, EGUI_OptionMenuColor);
   LWAs[LWAN++]=_ModelDirOptionMenuW=EGUI_OptionMenuCreate(LTopMatrixW, NULL, _ModelDirs, sizeof(_ModelDirs)/sizeof(EguiOptionMenuRec), TSMap_CurrentModelDir, "Directory:", _CB_CurrentModelDir, &_ModelPanel, Args, ArgCnt);
   XtManageChild(_ModelDirOptionMenuW);


   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNbuttonColor, EGUI_ButtonColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_MenuFontList);
   EXtSetArg(XeNlabelFontList, EGUI_LabelFontList);
   EXtSetArg(XeNcastShadowWidth, 4);
   EXtSetArg(XeNmenuPaneBackground, EGUI_OptionMenuColor);
   if(LVisual)
   {
    EXtSetArg(EguiNvisual, LVisual);
   }
   LWAs[LWAN++]=_ModelTypesOptionMenuW=EGUI_OptionMenuCreate(LTopMatrixW, NULL, _ModelTypes, sizeof(_ModelTypes)/sizeof(EguiOptionMenuRec), TSMap_CurrentModelType, "Model Type:", _CB_CurrentModelType, &_ModelPanel, Args, ArgCnt);
   XtManageChild(_ModelTypesOptionMenuW);


   XeIndentWidgetsFromLeft(LWAs, LWAN, 4);


   {
    Widget	LMainMatrixW, LMatrixW;

    EXtStart;
    EXtSetArg(XeNshadowThickness, 1);EXtSetArg(XeNshadowType, XeSHADOW_IN);
    EXtSetArg(XeNbackground, EGUI_BackgroundColor);
    EXtSetArg(XeNorientation, XeVERTICAL);
    EXtSetArg(XeNxSpacing, 4);EXtSetArg(XeNySpacing, 5);
    EXtSetArg(XeNmarginWidth, 4);EXtSetArg(XeNmarginHeight, 4);
    LMainMatrixW=XtCreateManagedWidget("MainMatrixW", xeMatrixWidgetClass, LTopMatrixW, Args, ArgCnt);

    _ModelTypeMatrixWs[_MatrixWNum++]=TS_StationaryCreateMatrix(LMainMatrixW);


    EXtStart;
    EXtSetArg(XeNshadowThickness, 0);
    EXtSetArg(XeNbackground, EGUI_BackgroundColor);
    EXtSetArg(XeNorientation, XeVERTICAL);
    EXtSetArg(XeNxSpacing, 4);EXtSetArg(XeNySpacing, 7);
    _ModelTypeMatrixWs[_MatrixWNum++]=LMatrixW=XtCreateWidget("StreetlightMatrixW", xeMatrixWidgetClass, LMainMatrixW, Args, ArgCnt);



    _ModelTypeMatrixWs[_MatrixWNum++]=TS_MoverCreateMatrix(LMainMatrixW);


    EXtStart;
    EXtSetArg(XeNshadowThickness, 0);
    EXtSetArg(XeNbackground, EGUI_BackgroundColor);
    EXtSetArg(XeNorientation, XeVERTICAL);
    EXtSetArg(XeNxSpacing, 4);EXtSetArg(XeNySpacing, 7);
    _ModelTypeMatrixWs[_MatrixWNum++]=LMatrixW=XtCreateWidget("FollowCameraMatrixW", xeMatrixWidgetClass, LMainMatrixW, Args, ArgCnt);


   }
  }

  _UpdateDialog();

  TSMap_Plugin->LockCount+=1;

  EGUI_RaiseShell(_Dialog);
  EGUI_CenterShellToItem(_Dialog, E3dp_TopShell);
  return;
 }
 _UpdateDialog();

 if(EGUI_ShellDisplayStatus(_Dialog)==EguiNOT_DISPLAYED) TSMap_Plugin->LockCount+=1;

 EGUI_RaiseShell(_Dialog);
}
