/*======================================================================================================*/
/* Create a vector (represented by a linear Spline)							*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	1996-Dec-17 23:48:32									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <math.h>
#include <stdio.h>


#include <EMalloc.h>
#include <EPlugins.h>


#include <Xe/Label.h>
#include <Xe/Matrix.h>
#include <Xe/Scale.h>
#include <Xe/ToggleButton.h>

#include <EGUI/PushButton.h>
#include <EGUI/Dialog.h>

#include <E3D/E3D.h>
#include <E3D/3DWindow.h>


extern EpCImage		Image_VectorBig;


static EPlugin*		_Plugin=NULL;


static EguiItem		_Dialog=NULL;
static Widget		_ArrowTB,
			_VTMLW, _TypeMatrixW, _P1P2BW, _P1LengthBW,
			_VX1ScaleW, _VY1ScaleW, _VZ1ScaleW, _VX2ScaleW, _VY2ScaleW, _VZ2ScaleW;

static E3dModel*	_Model=NULL;
static E3dGeometry*	_Geometry=NULL;

static EguiItem		_MenuButton=NULL;


static Arg		Args[256];
static Cardinal		ArgCnt;


enum
{
 E3dCR_XYZ1=EguiCUSTOM0,
 E3dCR_XYZ2,
 E3dCR_P1_P2,
 E3dCR_P1_LENGTH,
 E3dCR_ARROW
};



#define ROffset(field) (void*)(EPtrOffset(E3dVectorInfo, field))
EResource _Resources[]=
{
 { "X",			EResFLOAT32,	ROffset(Position.X), NULL },
 { "Y",			EResFLOAT32,	ROffset(Position.Y), NULL },
 { "Z",			EResFLOAT32,	ROffset(Position.Z), NULL },
 { "X1",		EResFLOAT32,	ROffset(Vector.X), NULL },
 { "Y1",		EResFLOAT32,	ROffset(Vector.Y), NULL },
 { "Z1",		EResFLOAT32,	ROffset(Vector.Z), NULL },

 { "Mode",		EResCHAR,	ROffset(CoordinateMode), NULL },
 { "Arrow",		EResBOOLEAN,	ROffset(ArrowOn), NULL },
 { "",			EResNULL,	NULL, NULL }
};


static E3dVectorInfo	_Info;
static E3dGeometryPanel	_GeometryPanel;
static EBool		_CreateMode=FALSE;


/*======================================*/
/* Update the dialog			*/
/*======================================*/
static void _UpdateDialog(E3dVectorInfo* LVectorInfo)
{
 E3d_GeometryPanelUpdate(&_GeometryPanel, _Geometry);

 XeScaleSetValueD(_VX1ScaleW, LVectorInfo->Position.X, False);
 XeScaleSetValueD(_VY1ScaleW, LVectorInfo->Position.Y, False);
 XeScaleSetValueD(_VZ1ScaleW, LVectorInfo->Position.Z, False);

 switch(LVectorInfo->CoordinateMode)
 {
  case E3dVTM_P1_P2:
   XeToggleButtonSetState(_P1P2BW, True, False);
   XeToggleButtonSetState(_P1LengthBW, False, False);

   XeScaleSetValueD(_VX2ScaleW, LVectorInfo->Vector.X+LVectorInfo->Position.X, False);
   XeScaleSetValueD(_VY2ScaleW, LVectorInfo->Vector.Y+LVectorInfo->Position.Y, False);
   XeScaleSetValueD(_VZ2ScaleW, LVectorInfo->Vector.Z+LVectorInfo->Position.Z, False);
  break;

  case E3dVTM_P1_LENGTH:
   XeToggleButtonSetState(_P1P2BW, False, False);
   XeToggleButtonSetState(_P1LengthBW, True, False);

   XeScaleSetValueD(_VX2ScaleW, LVectorInfo->Vector.X, False);
   XeScaleSetValueD(_VY2ScaleW, LVectorInfo->Vector.Y, False);
   XeScaleSetValueD(_VZ2ScaleW, LVectorInfo->Vector.Z, False);
  break;
 }
}


/*======================================*/
/* Dialog callback			*/
/*======================================*/
static void _DCB(EguiItem LI, EPointer LClientData, EPointer LCallData)
{
 switch((int)LClientData)
 {
  case EguiOK:
   _Geometry->LockCount-=1;
   if(_Geometry->LockCount==0) E3d_GeometryUpdateForDisplay(_Geometry, E3dGF_LOCKUNLOCK);

   EGUI_UndisplayShell(_Dialog);_Plugin->LockCount-=1;_Model=NULL;_Geometry=NULL;
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;

  case EguiAPPLY:
   _Geometry->LockCount-=1;
   if(_Geometry->LockCount==0) E3d_GeometryUpdateForDisplay(_Geometry, E3dGF_LOCKUNLOCK);

   _CreateMode=TRUE;
   _Model=NULL;_Geometry=NULL;

   if((_Model=E3d_VectorTest(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, _Info.ArrowOn))!=NULL)
   {
    _Geometry=_Model->Geometries[0];
    E3d_SceneAddModelHrc(E3d_Scene, _Model);
    E3dp_SceneLayoutOnSchematics(E3d_Scene);
   }

   _UpdateDialog(&_Info);
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;

  case EguiCANCEL:
   _Geometry->LockCount-=1;
   if(_Geometry->LockCount==0)
   {
    if(_CreateMode) { E3d_SceneRemoveModelHrc(E3d_Scene, _Model);E3d_ModelHrcFree(_Model, TRUE); }
    else E3d_GeometryUpdateForDisplay(_Geometry, E3dGF_LOCKUNLOCK);
   }

   EGUI_UndisplayShell(_Dialog);_Plugin->LockCount-=1;_Model=NULL;_Geometry=NULL;
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;
 }
}

/*======================================*/
/* Dialog Xt callback			*/
/*======================================*/
static void _XtDCB(Widget LW, XtPointer LClientData, XtPointer LCallData)
{
 E3dModel*		LModel;
 E3dSpline*		LSpline;
 E3dSplineCV*		LCV;
 double			LX, LY, LZ;


 if(_Model==NULL) return;
 if(_Geometry==NULL) return;

 LModel=_Model;
 switch((int)LClientData)
 {
  case E3dCR_XYZ1:
  case E3dCR_XYZ2:
   LCV=(LSpline=(E3dSpline*)(LModel->Geometries[0]))->CVs;
   LCV[0].Position.X=LX=XeScaleGetValueD(_VX1ScaleW);
   LCV[0].Position.Y=LY=XeScaleGetValueD(_VY1ScaleW);
   LCV[0].Position.Z=LZ=XeScaleGetValueD(_VZ1ScaleW);
   switch(_Info.CoordinateMode)
   {
    case E3dVTM_P1_P2:
     LX=XeScaleGetValueD(_VX2ScaleW);
     LY=XeScaleGetValueD(_VY2ScaleW);
     LZ=XeScaleGetValueD(_VZ2ScaleW);
    break;

    case E3dVTM_P1_LENGTH:
     LX+=XeScaleGetValueD(_VX2ScaleW);
     LY+=XeScaleGetValueD(_VY2ScaleW);
     LZ+=XeScaleGetValueD(_VZ2ScaleW);
    break;
   }
   if(_Info.ArrowOn)
   {
    LSpline->NumOfCVs=10;E3d_CreateVectorArrow(LCV, LX, LY, LZ);
   }
   else { LSpline->NumOfCVs=10;LCV[1].Position.X=LX;LCV[1].Position.Y=LY;LCV[1].Position.Z=LZ; }

   E3d_SplineCreateLinearSegments(LSpline);

   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;

  case E3dCR_P1_P2:
   if(((XeToggleButtonCallbackStruct*)LCallData)->set)
   {
    _Info.CoordinateMode=E3dVTM_P1_P2;
    if(_Model!=NULL)
    {
     LCV=(LSpline=(E3dSpline*)(_Model->Geometries[0]))->CVs;
     LCV[0].Position.X=XeScaleGetValueD(_VX1ScaleW);
     LCV[0].Position.Y=XeScaleGetValueD(_VY1ScaleW);
     LCV[0].Position.Z=XeScaleGetValueD(_VZ1ScaleW);
     LX=XeScaleGetValueD(_VX2ScaleW);
     LY=XeScaleGetValueD(_VY2ScaleW);
     LZ=XeScaleGetValueD(_VZ2ScaleW);
     if(_Info.ArrowOn)
     {
      LSpline->NumOfCVs=10;E3d_CreateVectorArrow(LCV, LX, LY, LZ);
     }
     else { LSpline->NumOfCVs=2;LCV[1].Position.X=LX;LCV[1].Position.Y=LY;LCV[1].Position.Z=LZ; }

     E3d_SplineCreateLinearSegments(LSpline);
     E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
    }
   }
  break;

  case E3dCR_P1_LENGTH:
   if(((XeToggleButtonCallbackStruct*)LCallData)->set)
   {
    _Info.CoordinateMode=E3dVTM_P1_LENGTH;
    if(_Model!=NULL)
    {
     LCV=(LSpline=(E3dSpline*)(_Model->Geometries[0]))->CVs;
     LCV[0].Position.X=LX=XeScaleGetValueD(_VX1ScaleW);
     LCV[0].Position.Y=LY=XeScaleGetValueD(_VY1ScaleW);
     LCV[0].Position.Z=LZ=XeScaleGetValueD(_VZ1ScaleW);
     LX+=XeScaleGetValueD(_VX2ScaleW);
     LY+=XeScaleGetValueD(_VY2ScaleW);
     LZ+=XeScaleGetValueD(_VZ2ScaleW);
     if(_Info.ArrowOn)
     {
      LSpline->NumOfCVs=10;E3d_CreateVectorArrow(LCV, LX, LY, LZ);
     }
     else { LSpline->NumOfCVs=2;LCV[1].Position.X=LX;LCV[1].Position.Y=LY;LCV[1].Position.Z=LZ; }
     E3d_SplineCreateLinearSegments(LSpline);
     E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
    }
   }
  break;

  case E3dCR_ARROW:
   if(_Model!=NULL)
   {
    LCV=(LSpline=(E3dSpline*)(_Model->Geometries[0]))->CVs;
    LX=XeScaleGetValueD(_VX2ScaleW);
    LY=XeScaleGetValueD(_VY2ScaleW);
    LZ=XeScaleGetValueD(_VZ2ScaleW);
    switch(_Info.CoordinateMode)
    {
     case E3dVTM_P1_LENGTH:
      LX+=XeScaleGetValueD(_VX1ScaleW);
      LY+=XeScaleGetValueD(_VY1ScaleW);
      LZ+=XeScaleGetValueD(_VZ1ScaleW);
     break;
    }
    _Info.ArrowOn=((XeToggleButtonCallbackStruct*)LCallData)->set;
    if(_Info.ArrowOn)
    {
     LSpline->NumOfCVs=10;E3d_CreateVectorArrow(LCV, LX, LY, LZ);
    }
    else { LSpline->NumOfCVs=2;LCV[1].Position.X=LX;LCV[1].Position.Y=LY;LCV[1].Position.Z=LZ; }
    E3d_SplineCreateLinearSegments(LSpline);
    E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
   }
  break;
 }
}


/*======================================*/
/* Pop up the dialog			*/
/*======================================*/
static void _PopupDialog(E3dVectorInfo* LVectorInfo)
{
 if(_Dialog==NULL)
 {
  Widget	LTopMatrixW, LMatrixW, LTmpW1;
  Widget	LTraverseWs[7];		// For TextField traversal
  EguiItem	LDialog;
  int		LTraverseN;

  LDialog=E3d_GeometryDialogCreate("Vector", _Geometry, &_GeometryPanel, _DCB, &Image_VectorBig);
  _Dialog=LDialog;

  LTopMatrixW=EGUI_DialogGetChild(LDialog, EguiDIALOG_WORK_AREA);
  EXtStart;
  EXtSetArg(XeNorientation, XeVERTICAL);
  EXtSetArg(XeNySpacing, 4);
  XtSetValues(LTopMatrixW, Args, ArgCnt);


  EXtStart;
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNhighlightThickness, 0);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNselectColor, EGUI_HighlightColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  EXtSetArg(XeNset, _Info.ArrowOn);
  _ArrowTB=XtCreateManagedWidget("Arrow", xeToggleButtonWidgetClass, LTopMatrixW, Args, ArgCnt);
  XtAddCallback(_ArrowTB, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_ARROW);

  EXtStart;
  EXtSetArg(XeNmarginTop, 4);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
  _VTMLW=XtCreateManagedWidget("Type:", xeLabelWidgetClass, LTopMatrixW, Args, ArgCnt);
 
  EXtStart;
  EXtSetArg(XeNradioBehavior, True);
  EXtSetArg(XeNorientation, XeHORIZONTAL);
  EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
  _TypeMatrixW=XtCreateManagedWidget("", xeMatrixWidgetClass, LTopMatrixW, Args, ArgCnt);

  EXtStart;
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNhighlightThickness, 0);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
  EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
  EXtSetArg(XeNselectColor, EGUI_HighlightColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  EXtSetArg(XeNset, (Boolean)(_Info.CoordinateMode==E3dVTM_P1_P2));
  _P1P2BW=LTmpW1=XtCreateManagedWidget("P1-P2", xeToggleButtonWidgetClass, _TypeMatrixW, Args, ArgCnt);
  XtAddCallback(LTmpW1, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_P1_P2);

  EXtStart;
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNhighlightThickness, 0);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
  EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
  EXtSetArg(XeNselectColor, EGUI_HighlightColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  EXtSetArg(XeNset, (Boolean)(_Info.CoordinateMode==E3dVTM_P1_LENGTH));
  _P1LengthBW=LTmpW1=XtCreateManagedWidget("P1-Length", xeToggleButtonWidgetClass, _TypeMatrixW, Args, ArgCnt);
  XtAddCallback(LTmpW1, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_P1_LENGTH);


  EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);

  EXtStart;
  EXtSetArg(XeNmarginWidth, 2);EXtSetArg(XeNmarginHeight, 2);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNorientation, XeHORIZONTAL);
  EXtSetArg(XeNnumOfColumns, 3);
  EXtSetArg(XeNxSpacing, 2);
  EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
  LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LTopMatrixW, Args, ArgCnt);

  LTraverseN=0;
  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 9);EXtSetArg(XeNdecimalPoints, 5);
  EXtSetArg(XeNminimum, -100000000);EXtSetArg(XeNmaximum, 100000000);EXtSetArg(XeNvalue, 0);
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);EXtSetArg(XeNcreateScale, False);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LTraverseWs[LTraverseN++]=_VX1ScaleW=XtCreateManagedWidget("XYZ:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
  XtAddCallback(_VX1ScaleW, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_XYZ1);

  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 9);EXtSetArg(XeNdecimalPoints, 5);
  EXtSetArg(XeNminimum, -100000000);EXtSetArg(XeNmaximum, 100000000);EXtSetArg(XeNvalue, 0);
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);EXtSetArg(XeNcreateScale, False);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LTraverseWs[LTraverseN++]=_VY1ScaleW=XtCreateManagedWidget("", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
  XtAddCallback(_VY1ScaleW, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_XYZ1);

  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 9);EXtSetArg(XeNdecimalPoints, 5);
  EXtSetArg(XeNminimum, -100000000);EXtSetArg(XeNmaximum, 100000000);EXtSetArg(XeNvalue, 0);
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);EXtSetArg(XeNcreateScale, False);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LTraverseWs[LTraverseN++]=_VZ1ScaleW=XtCreateManagedWidget("", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
  XtAddCallback(_VZ1ScaleW, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_XYZ1);

  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 9);EXtSetArg(XeNdecimalPoints, 5);
  EXtSetArg(XeNminimum, -100000000);EXtSetArg(XeNmaximum, 100000000);EXtSetArg(XeNvalue, 100000);
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);EXtSetArg(XeNcreateScale, False);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LTraverseWs[LTraverseN++]=_VX2ScaleW=XtCreateManagedWidget("XYZ:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
  XtAddCallback(_VX2ScaleW, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_XYZ2);

  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 9);EXtSetArg(XeNdecimalPoints, 5);
  EXtSetArg(XeNminimum, -100000000);EXtSetArg(XeNmaximum, 100000000);EXtSetArg(XeNvalue, 100000);
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);EXtSetArg(XeNcreateScale, False);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LTraverseWs[LTraverseN++]=_VY2ScaleW=XtCreateManagedWidget("", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
  XtAddCallback(_VY2ScaleW, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_XYZ2);

  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 9);EXtSetArg(XeNdecimalPoints, 5);
  EXtSetArg(XeNminimum, -100000000);EXtSetArg(XeNmaximum, 100000000);EXtSetArg(XeNvalue, 100000);
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNmarginWidth, 0);EXtSetArg(XeNmarginHeight, 0);
  EXtSetArg(XeNorientation, XeHORIZONTAL);EXtSetArg(XeNcreateScale, False);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LTraverseWs[LTraverseN++]=_VZ2ScaleW=XtCreateManagedWidget("", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
  XtAddCallback(_VZ2ScaleW, XeNvalueChangedCallback, _XtDCB, (XtPointer)E3dCR_XYZ2);

// Set up TextField traversal
//
  XeRingTraversal(LTraverseWs, LTraverseN);
 }
 else _UpdateDialog(LVectorInfo);

 EGUI_RaiseShell(_Dialog);_Plugin->LockCount+=1;
}


/*======================================*/
/* Menu callback			*/
/*======================================*/
static void _MCB(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 EBool	LSuccess;

 if(_Geometry) return;

 LSuccess=FALSE;
 if((_Model=E3d_VectorTest(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, _Info.ArrowOn))!=NULL)
 {
  _Geometry=_Model->Geometries[0];
  LSuccess=E3d_SceneAddModelHrc(E3d_Scene, _Model);
  E3dp_SceneLayoutOnSchematics(E3d_Scene);
 }

 _CreateMode=TRUE;
 if(LSuccess)
 {
  if(((EguiPushButtonCallbackStruct*)LCallData)->Reason==ECR_OPTIONS) _PopupDialog(&_Info);
  else
  {
   _Geometry->LockCount-=1;
   if(_Geometry->LockCount==0) E3d_GeometryUpdateForDisplay(_Geometry, E3dGF_LOCKUNLOCK);
   _Plugin->LockCount-=1;_Model=NULL;_Geometry=NULL;
  }
  E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
 }
}


/*==============================================*/
/* EditProc for the "Vector" Geometry type	*/
/*==============================================*/
static int _EditProc(E3dModel* LModel, E3dGeometry* LGeometry, E3dGeometryInfo* LInfo, int LLODIndex)
{
 E3dTplEditProc_CHist(E3dVector, _);
}


/*======================================*/
/* Entry point of the plugin		*/
/*======================================*/
int Plugin_Init(EPlugin* LPlugin)
{
 E3dGeometryClass	LGeoClass=
   {
    "Vector",			// Name
    sizeof(E3dVectorInfo),	// StructSize
    _EditProc,			// EditProc
    NULL,			// DestroyProc
    _Resources			// Resources
   };


 _Plugin=LPlugin;

 if((_Info.Class=E3d_GeometryClassRegister(&LGeoClass))!=NULL)
 {
  E3d_VectorInit(&(_Info.Vector), 1.0, 1.0, 1.0);
  E3d_3DPositionInit(&(_Info.Position), 0.0, 0.0, 0.0);
  _Info.ArrowOn=TRUE;
  _Info.CoordinateMode=E3dVTM_P1_LENGTH;
  _MenuButton=EGUI_AddPushButton("Menu->Create", "Vector", '\0', NULL, NULL, TRUE, NULL, _MCB, (EPointer)0);
 }
 return(0);
}


/*======================================*/
/* Exit method of the plugin		*/
/*======================================*/
int Plugin_Exit()
{
 if(_MenuButton!=NULL) EGUI_DestroyItem(_MenuButton);

 if(_Info.Class!=NULL) E3d_GeometryClassDeactivate(_Info.Class);

 return(0);
}
