/*======================================================================================================*/
/* Rendering setup plugin for EQUINOX-3D								*/
/*													*/
/* Plugin for EQUINOX-3D										*/
/*													*/
/* AUTHOR:	Gabor Nagy										*/
/* DATE:	1996-Nov-29 23:01:33									*/
/*													*/
/* EQUINOX-3D(TM), 3DPanel(TM) and 3DLib(TM) Copyright (C) 1995 By Gabor Nagy. All rights reserved.	*/
/*======================================================================================================*/
#include <stdio.h>


#include <EPlugins.h>

#include <Xe/Matrix.h>
#include <Xe/PushButton.h>
#include <Xe/Scale.h>
#include <Xe/Separator.h>
#include <Xe/ToggleButton.h>

#include <EGUI/Dialog.h>

#include <Color/XColor.h>
#include <Color/Panel.h>

#include <E3D/3DWindow.h>



extern EpCImage		Image_LensOrtho, Image_LensOrthoActive, Image_LensOrthoArm,
			Image_LensPerspective,
			Image_LensPerspectiveActive,
			Image_LensPerspectiveArm;



static EPlugin*		_Plugin=NULL;

enum
{
 CR_XSIZE=EguiCUSTOM0+1,
 CR_YSIZE,
 CR_KEEP_RATIO,
 CR_PROGRESSIVE_1x1,
 CR_PROGRESSIVE_2x2,
 CR_PROGRESSIVE_4x4,
 CR_PROGRESSIVE_8x8,
 CR_PROGRESSIVE_16x16,
 CR_STARTPIXELSIZE,
 CR_ANTIALIASING_NONE,
 CR_ANTIALIASING_4x,
 CR_ANTIALIASING_6x,
 CR_ANTIALIASING_9x,
 CR_HDR_IMAGE,
 CR_ORTHO,
 CR_PERSPECTIVE,
 CR_FISHEYE,
 CR_REAR_FISHEYE,
 CR_PANORAMA,
 CR_SPHERICAL,
 CR_FIELD_OF_VIEW,
 CR_FOCAL_LENGTH,
 CR_APERTURE,
 CR_X_ZOOM,
 CR_Y_ZOOM,
 CR_GLOW,
 CR_FOG,
 CR_FOGNEAR,
 CR_FOGFAR,
 CR_FOGDENSITY,
 CR_SHADOWS,
 CR_REFLECTIONS,
 CR_TRANSPARENCY,
 CR_REFRACTIONS,
 CR_RAYDEPTH,
 CR_GRIDXCOUNT,
 CR_GRIDYCOUNT,
 CR_GRIDZCOUNT
};


static EguiItem		_MenuButton=NULL;

static EguiItem		_RenderSetupDialog=NULL;


static Widget		_XSizeW=NULL, _YSizeW=NULL, _KeepRatioW,
			_Progressive1x1BW, _Progressive2x2BW, _Progressive4x4BW, _Progressive8x8BW, _Progressive16x16BW, _StartPixelSizeW=NULL,
			_OrthoBW=NULL, _PerspectiveBW=NULL, _FisheyeBW=NULL, _RearFisheyeBW=NULL, _AngleMapBW, _PanoramaBW=NULL, _SphericalBW=NULL,
			_FieldOfViewScaleW=NULL, _FocalLengthW=NULL, _ApertureW=NULL, _XZoomW=NULL, _YZoomW=NULL,
			_AntiAliasingNoneBW=NULL, _AntiAliasing4xBW=NULL, _AntiAliasing6xBW=NULL, _AntiAliasing9xBW=NULL,
			_HDRImageBW=NULL,
			_FogBW=NULL, _FogNearScaleW=NULL, _FogFarScaleW=NULL,
			_BackgroundColorSwatchW=NULL,
			_ShadowsBW, _ReflectionsBW, _TransparencyBW, _RefractionsBW, _MaxRayDepthW,
			_GridXCountW, _GridYCountW, _GridZCountW;

static Arg		Args[256];
static Cardinal		ArgCnt;


static EBool		_KeepRatio=TRUE;


EcColorPanelRec*	_ColorPanel=NULL;


static EGUIFolder	_CameraSettingsDrawer, _ImageSettingsDrawer, _BackgroundColorDrawer, _RayTracingOptionsDrawer, _AdvancedOptionsDrawer;


static Widget		_SaveFormatsW=NULL;
static EguiOptionMenuRec	_RenderersOM[64];


//#define MAX_XRES	800
//#define MAX_YRES	800

#define MAX_XRES	1920
#define MAX_YRES	1200

static float		_ImageAspectRatio;


//================================================
// Manage / unmanage lens parameter widgets
//================================================
static void _ManageLensWidgets(E3dCamera* LCamera)
{
 switch(LCamera->LensType)
 {
  case E3dLENS_ORTHO:
   XtUnmanageChild(_FieldOfViewScaleW);
//   XtUnmanageChild(_FocalLengthW);
//   XtUnmanageChild(_ApertureW);
//   XtManageChild(_XZoomW);
//   XtManageChild(_YZoomW);
  break;

  case E3dLENS_PERSPECTIVE:
   XtManageChild(_FieldOfViewScaleW);
//   XtManageChild(_FocalLengthW);
//   XtManageChild(_ApertureW);
//   XtUnmanageChild(_XZoomW);
//   XtUnmanageChild(_YZoomW);
  break;

  case E3dLENS_FISHEYE:
  case E3dLENS_REAR_FISHEYE:
   XtUnmanageChild(_FieldOfViewScaleW);
//   XtUnmanageChild(_FocalLengthW);
//   XtUnmanageChild(_ApertureW);
//   XtUnmanageChild(_XZoomW);
//   XtUnmanageChild(_YZoomW);
  break;

/*
  case E3dLENS_PANORAMA:
   XtUnmanageChild(_FieldOfViewScaleW);
   XtUnmanageChild(_FocalLengthW);
   XtUnmanageChild(_ApertureW);
   XtUnmanageChild(_XZoomW);
   XtManageChild(_YZoomW);
  break;

  case E3dLENS_SPHERICAL:
   XtUnmanageChild(_FieldOfViewScaleW);
   XtUnmanageChild(_FocalLengthW);
   XtUnmanageChild(_ApertureW);
   XtUnmanageChild(_XZoomW);
   XtUnmanageChild(_YZoomW);
  break;
*/
 }
/*
   EXtStart;
   EXtSetArg(XeNsensitive, False);
   XtSetValues(_FieldOfViewScaleW, Args, ArgCnt);
   XtSetValues(_FocalLengthW, Args, ArgCnt);
   EXtStart;
   EXtSetArg(XeNsensitive, True);
   XtSetValues(_ZoomW, Args, ArgCnt);
*/
}


//========================================
// Dialog callback
//========================================
static void _DCB_RenderSetup(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 E3dRenderInfo*	LRenderInfo=&(E3d_Scene->RenderInfo);

 switch((int)LClientData)
 {
  case EguiOK:
   EGUI_UndisplayShell(_RenderSetupDialog);_Plugin->LockCount-=1;
  break;

  case EguiCANCEL:
   EGUI_UndisplayShell(_RenderSetupDialog);_Plugin->LockCount-=1;
  break;

  case CR_XSIZE:
   LRenderInfo->ImageXSize=((XeScaleCallbackStruct*)LCallData)->IntValue;

   if(_KeepRatio)
   {
    float	LFX=(float)(LRenderInfo->ImageXSize);

    LRenderInfo->ImageYSize=(int)(LFX / _ImageAspectRatio + 0.5);
    XeScaleSetValue(_YSizeW, LRenderInfo->ImageYSize, False);
   }
  break;

  case CR_YSIZE:
   LRenderInfo->ImageYSize=((XeScaleCallbackStruct*)LCallData)->IntValue;

   if(_KeepRatio)
   {
    float	LFY=(float)(LRenderInfo->ImageYSize);

    LRenderInfo->ImageXSize=(int)(LFY * _ImageAspectRatio + 0.5);
    XeScaleSetValue(_XSizeW, LRenderInfo->ImageXSize, False);
   }
  break;

  case CR_STARTPIXELSIZE:
   LRenderInfo->StartPixelSize=((XeScaleCallbackStruct*)LCallData)->IntValue;
  break;

  case CR_PROGRESSIVE_1x1:
   LRenderInfo->StartPixelSize=1;
  break;

  case CR_PROGRESSIVE_2x2:
   LRenderInfo->StartPixelSize=2;
  break;

  case CR_PROGRESSIVE_4x4:
   LRenderInfo->StartPixelSize=4;
  break;

  case CR_PROGRESSIVE_8x8:
   LRenderInfo->StartPixelSize=8;
  break;

  case CR_PROGRESSIVE_16x16:
   LRenderInfo->StartPixelSize=16;
  break;

  case CR_KEEP_RATIO:
   _KeepRatio=((XeToggleButtonCallbackStruct*)LCallData)->set;
   if(_KeepRatio) _ImageAspectRatio=((float)(LRenderInfo->ImageXSize))/((float)(LRenderInfo->ImageYSize));
  break;

  case CR_X_ZOOM:
   LRenderInfo->Camera->XZoom=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;

  case CR_Y_ZOOM:
   LRenderInfo->Camera->YZoom=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;

  case CR_ANTIALIASING_NONE:
   LRenderInfo->AntiAliasing=E3dAA_NONE;
  break;

  case CR_ANTIALIASING_4x:
   LRenderInfo->AntiAliasing=E3dAA_4x;
  break;

  case CR_ANTIALIASING_6x:
   LRenderInfo->AntiAliasing=E3dAA_6x;
  break;

  case CR_ANTIALIASING_9x:
   LRenderInfo->AntiAliasing=E3dAA_9x;
  break;

  case CR_HDR_IMAGE:
   LRenderInfo->CreateHDRImage=((XeToggleButtonCallbackStruct*)LCallData)->set;
  break;

  case CR_FOG:
   LRenderInfo->Fog=((XeToggleButtonCallbackStruct*)LCallData)->set;
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;

  case CR_FOGNEAR:
   LRenderInfo->FogNear=XeScaleGetValueD(_FogNearScaleW);
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;

  case CR_FOGFAR:
   LRenderInfo->FogFar=XeScaleGetValueD(_FogFarScaleW);
   E3dp_Refresh3DWindows(E3dDF_ALL, E3dVM_ALL);
  break;

  case CR_SHADOWS:
   LRenderInfo->Shadows=((XeToggleButtonCallbackStruct*)LCallData)->set;
  break;

  case CR_REFLECTIONS:
   LRenderInfo->Reflections=((XeToggleButtonCallbackStruct*)LCallData)->set;
  break;

  case CR_TRANSPARENCY:
   LRenderInfo->Transparency=((XeToggleButtonCallbackStruct*)LCallData)->set;
  break;

  case CR_REFRACTIONS:
   LRenderInfo->Refractions=((XeToggleButtonCallbackStruct*)LCallData)->set;
  break;

  case CR_RAYDEPTH:
   LRenderInfo->MaxRayDepth=((XeScaleCallbackStruct*)LCallData)->IntValue;
  break;

  case CR_GRIDXCOUNT:
   LRenderInfo->GridXCount=((XeScaleCallbackStruct*)LCallData)->IntValue;
   LRenderInfo->UpdateFlags|=E3dUF_VOXELIZE;
  break;

  case CR_GRIDYCOUNT:
   LRenderInfo->GridYCount=((XeScaleCallbackStruct*)LCallData)->IntValue;
   LRenderInfo->UpdateFlags|=E3dUF_VOXELIZE;
  break;

  case CR_GRIDZCOUNT:
   LRenderInfo->GridZCount=((XeScaleCallbackStruct*)LCallData)->IntValue;
   LRenderInfo->UpdateFlags|=E3dUF_VOXELIZE;
  break;
 }
}


//========================================
// Camera settings callback
//========================================
static void _DCB_Camera(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 E3dRenderInfo*	LRenderInfo=&(E3d_Scene->RenderInfo);

 switch((int)LClientData)
 {
  case CR_FIELD_OF_VIEW:
   LRenderInfo->Camera->FieldOfView=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;

  case CR_FOCAL_LENGTH:
   LRenderInfo->Camera->FocalLength=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;

  case CR_APERTURE:
   LRenderInfo->Camera->Aperture=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;

  case CR_X_ZOOM:
   LRenderInfo->Camera->XZoom=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;

  case CR_Y_ZOOM:
   LRenderInfo->Camera->YZoom=((XeScaleCallbackStruct*)LCallData)->FloatValue;
   E3dp_Redraw3DWindow(E3dp_Main3DWindow);
  break;
 }
}


//========================================
// Renderer selection
//========================================
static void _DCB_RendererType(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 E3dRenderInfo*	LRenderInfo=&(E3d_Scene->RenderInfo);
 E3dRenderer*	LRenderer=(E3dRenderer*)(((EguiOptionMenuCallbackStruct*)LCallData)->Value);

 if(LRenderInfo->Renderer!=LRenderer)
 {
  LRenderInfo->Renderer=LRenderer;
 }
}


//========================================
// Lens type selection
//========================================
static void _DCB_LensType(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 E3dRenderInfo*	LRenderInfo=&(E3d_Scene->RenderInfo);

 LRenderInfo->Camera->LensType=(int)LClientData;
 _ManageLensWidgets(LRenderInfo->Camera);
}


//========================================
// Color panel callback
//========================================
static void _CB_ColorChanged(EcColorPanelRec* LColorPanel, EPointer LClientData, EPointer LCallData)
{
 EcColorPanelCallbackStruct*	LCPCBR;
 E3dRenderInfo*			LRenderInfo=&(E3d_Scene->RenderInfo);
 EguiVisual*			LVisual=EGUI_TruecolorVisual;
 int				LColorIndex;


 LCPCBR=(EcColorPanelCallbackStruct*)LCallData;

 if(LCPCBR->NumOfColors>0) LColorIndex=LCPCBR->ColorIDs[0];
 else return;

 LRenderInfo->BackgroundRGBAiColor.R=LColorPanel->RGBAiColors[LColorIndex].R;
 LRenderInfo->BackgroundRGBAiColor.G=LColorPanel->RGBAiColors[LColorIndex].G;
 LRenderInfo->BackgroundRGBAiColor.B=LColorPanel->RGBAiColors[LColorIndex].B;
 LRenderInfo->BackgroundRGBAiColor.A=LColorPanel->RGBAiColors[LColorIndex].A;

 if(LVisual)
 {
  XtVaSetValues(_BackgroundColorSwatchW, XeNbackgroundColor, Ec_XGetRGBAiColor(XtDisplay(_BackgroundColorSwatchW), LVisual->X_Colormap, &(LRenderInfo->BackgroundRGBAiColor)), NULL);
 }
}



//========================================
// CUpdate RenderSetup dialog
//========================================
void _RenderSetupUpdateDialog(E3dRenderInfo* LRenderInfo)
{
 XeScaleSetValue(_XSizeW, LRenderInfo->ImageXSize, False);
 XeScaleSetValue(_YSizeW, LRenderInfo->ImageYSize, False);
 if(_StartPixelSizeW) XeScaleSetValue(_StartPixelSizeW, LRenderInfo->StartPixelSize, False);


 XeToggleButtonSetState(_Progressive1x1BW, (Boolean)(LRenderInfo->StartPixelSize==1), False);
 XeToggleButtonSetState(_Progressive2x2BW, (Boolean)(LRenderInfo->StartPixelSize==2), False);
 XeToggleButtonSetState(_Progressive4x4BW, (Boolean)(LRenderInfo->StartPixelSize==4), False);
 XeToggleButtonSetState(_Progressive8x8BW, (Boolean)(LRenderInfo->StartPixelSize==8), False);
 XeToggleButtonSetState(_Progressive16x16BW, (Boolean)(LRenderInfo->StartPixelSize==16), False);


 XeToggleButtonSetState(_FisheyeBW, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_FISHEYE), False);

 _ManageLensWidgets(LRenderInfo->Camera);


// XeToggleButtonSetState(_KeepRatioW, True, False);

 XeToggleButtonSetState(_AntiAliasingNoneBW, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_NONE), False);
 XeToggleButtonSetState(_AntiAliasing4xBW, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_4x), False);
// XeToggleButtonSetState(_AntiAliasing6xBW, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_6x), False);
 XeToggleButtonSetState(_AntiAliasing9xBW, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_9x), False);


/*
 XeToggleButtonSetState(_FogBW, LRenderInfo->Fog, False);
 XeScaleSetValueD(_FogNearScaleW, LRenderInfo->FogNear, False);
 XeScaleSetValueD(_FogFarScaleW, LRenderInfo->FogFar, False);
*/

 Ec_ColorPanelSetRGBAiColor(_ColorPanel, 0, &(LRenderInfo->BackgroundRGBAiColor));

 XeToggleButtonSetState(_ShadowsBW, LRenderInfo->Shadows, False);
 XeToggleButtonSetState(_ReflectionsBW, LRenderInfo->Reflections, False);
 XeToggleButtonSetState(_TransparencyBW, LRenderInfo->Transparency, False);
 XeToggleButtonSetState(_RefractionsBW, LRenderInfo->Refractions, False);
 XeScaleSetValue(_MaxRayDepthW, LRenderInfo->MaxRayDepth, False);

 XeScaleSetValue(_GridXCountW, LRenderInfo->GridXCount, False);
 XeScaleSetValue(_GridYCountW, LRenderInfo->GridYCount, False);
 XeScaleSetValue(_GridZCountW, LRenderInfo->GridZCount, False);
}



//========================================
// Pop up Render-setup dialog
//========================================
static void _MCB_RenderSetup(EguiItem LGUIItem, EPointer LClientData, EPointer LCallData)
{
 E3dRenderInfo*	LRenderInfo=&(E3d_Scene->RenderInfo);

 if(_RenderSetupDialog==NULL)
 {
  E3dCamera*		LCamera=LRenderInfo->Camera;
  XeString		LXeStr;
  Widget		LTopMatrixW, LMatrixW;
  Widget		LIndentWs[7];			// For indenting the XeScale Widgets
  Widget		LTraverseWs[16];		// For TextField traversal
  EguiVisual*		LVisual=EGUI_TruecolorVisual;
  EguiItem		LDialog, LI;
  EguiDialogRec*	LD;
  EguiArg		LArgs[32];
  int			LArgCnt;
  int			LIndentN, LTraverseN;


  LArgCnt=0;
  EguiSetArg(EguiNallowShellResize, True, LArgs, LArgCnt);
  EguiSetArg(EguiNstretchButtons, False, LArgs, LArgCnt);
  EguiSetArg(EguiNworkAreaType, EguiMATRIX, LArgs, LArgCnt);
  EguiSetArg(EguiNwmDecorations, EguiWM_DECOR_BORDER|EguiWM_DECOR_RESIZEH|EguiWM_DECOR_TITLE, LArgs, LArgCnt);
  EguiSetArg(EguiNtitle, "Rendering setup", LArgs, LArgCnt);EguiSetArg(EguiNiconName, "Rendering setup", LArgs, LArgCnt);
  if((LDialog=EGUI_CreateDialog(EguiDIALOG_TEMPLATE, "Render setup", E3dp_TopShell, LArgs, LArgCnt))==NULL) return;

  _RenderSetupDialog=LDialog;
  LArgCnt=0;
  EguiSetArg(EguiNshowAsDefault, True, LArgs, LArgCnt);
  LI=EGUI_CreatePushButton("Close", LDialog, LArgs, LArgCnt);
  EGUI_AddCallback(LI, EguiNactivateCallback, _DCB_RenderSetup, (EPointer)EguiOK);

/*
  LI=EGUI_CreatePushButton("Cancel", LDialog, NULL, 0);
  EGUI_AddCallback(LI, EguiNactivateCallback, _DCB_RenderSetup, (EPointer)EguiCANCEL);
*/

  LD=(EguiDialogRec*)LDialog;
  LTopMatrixW=EGUI_DialogGetChild(LDialog, EguiDIALOG_WORK_AREA);
  EXtStart;
  EXtSetArg(XeNorientation, XeVERTICAL);
  EXtSetArg(XeNySpacing, 4);
  XtSetValues(LTopMatrixW, Args, ArgCnt);



// Renderer selection
//
  {
   EguiOptionMenuRec*	LOptionMenuItem;
   int			LC, LNumOfRenderersFound=0;


   LOptionMenuItem=_RenderersOM;
   for(LC=0;LC<E3d_NumOfRenderers;LC++)
   {
    LOptionMenuItem->Name=strdup(E3d_Renderers[LC]->Name);
    LOptionMenuItem->Callback=NULL;
    LOptionMenuItem->Value=(int)(E3d_Renderers[LC]);
    LOptionMenuItem->ClientData=(XtPointer)(E3d_Renderers[LC]);
    LOptionMenuItem->Icon=NULL;
    LNumOfRenderersFound++;LOptionMenuItem++;
   }

   if((LRenderInfo->Renderer==NULL)&&(E3d_NumOfRenderers>0))
   {
    LRenderInfo->Renderer=E3d_RendererFindByName("Ray-tracer");

    if(LRenderInfo->Renderer==NULL) LRenderInfo->Renderer=E3d_Renderers[0];
   }


   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNbuttonColor, EGUI_ButtonColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_MenuFontList);
   EXtSetArg(XeNlabelFontList, EGUI_LabelFontList);
   EXtSetArg(XeNcastShadowWidth, 4);
   EXtSetArg(XeNmenuPaneBackground, EGUI_OptionMenuColor);
   _SaveFormatsW=EGUI_OptionMenuCreate(LTopMatrixW, NULL, _RenderersOM, LNumOfRenderersFound, (int)(LRenderInfo->Renderer), "Renderer:", _DCB_RendererType, NULL, Args, ArgCnt);
  }



// Image settings drawer
//
  {
   EGUIFolder*	LDrawer=&_ImageSettingsDrawer;
   Widget	LDrawerW=EGUI_CreateDrawer(LTopMatrixW, LDrawer, "Image", 0, TRUE, TRUE);


   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeVERTICAL);
   EXtSetArg(XeNySpacing, 3);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LDrawer->FolderW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawerW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNxSpacing, 2);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawer->FolderW, Args, ArgCnt);


   _ImageAspectRatio=((float)(LRenderInfo->ImageXSize))/((float)(LRenderInfo->ImageYSize));

   LTraverseN=0;
   EXtStart;
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNtextFieldDigits, 4);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, MAX_XRES);EXtSetArg(XeNvalue, LRenderInfo->ImageXSize);
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNcreateScale, False);
   EXtSetArg(XeNactivateOnLeave, True);
//   EXtSetArg(XeNactivateOnTextChange, True);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   EXtSetArg(XeNactivateOnTextChange, True);
   LTraverseWs[LTraverseN++]=_XSizeW=XtCreateManagedWidget("Resolution:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_XSizeW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_XSIZE));

   EXtStart;
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNtextFieldDigits, 4);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, MAX_YRES);EXtSetArg(XeNvalue, LRenderInfo->ImageYSize);
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNcreateScale, False);
   EXtSetArg(XeNactivateOnLeave, True);
//   EXtSetArg(XeNactivateOnTextChange, True);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   EXtSetArg(XeNactivateOnTextChange, True);
   LTraverseWs[LTraverseN++]=_YSizeW=XtCreateManagedWidget("x", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_YSizeW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_YSIZE);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNmarginWidth, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
   EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, _KeepRatio);
   EXtSetArg(XeNheightAdjustable, False);
   _E3dM_SetToolTip("When changing the image width, adjust the height to maintain the aspect ratio and vice versa.");
   _KeepRatioW=XtCreateManagedWidget("Keep ratio", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_KeepRatioW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_KEEP_RATIO);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNmarginTop, 4);
   EXtSetArg(XeNmarginHeight, 1);EXtSetArg(XeNmarginWidth, 2);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNwidthAdjustable, FALSE);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   XtCreateManagedWidget("Progressive refinement (mosaic) from:", xeLabelWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNmarginLeft, 4);EXtSetArg(XeNmarginWidth, 0);
   EXtSetArg(XeNxSpacing, 2);
   EXtSetArg(XeNradioBehavior, True);
   EXtSetArg(XeNradioAlwaysOne, True);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->StartPixelSize==1));
   _E3dM_SetToolTip("Render normally (no progressive refinement)");
   _Progressive1x1BW=XtCreateManagedWidget("1x1", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_Progressive1x1BW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_PROGRESSIVE_1x1);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->StartPixelSize==2));
   _E3dM_SetToolTip("Initially, only compute 1 pixel in a 2x2-pixel area, then refine the image");
   _Progressive2x2BW=XtCreateManagedWidget("2x2", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_Progressive2x2BW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_PROGRESSIVE_2x2);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->StartPixelSize==4));
   _E3dM_SetToolTip("Initially, only compute 1 pixel in a 4x4-pixel area,\nthen refine the image progressively");
   _Progressive4x4BW=XtCreateManagedWidget("4x4", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_Progressive4x4BW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_PROGRESSIVE_4x4);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->StartPixelSize==8));
   _E3dM_SetToolTip("Initially, only compute 1 pixel in a 8x8-pixel area,\nthen refine the image progressively");
   _Progressive8x8BW=XtCreateManagedWidget("8x8", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_Progressive8x8BW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_PROGRESSIVE_8x8);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->StartPixelSize==16));
   _E3dM_SetToolTip("Initially, only compute 1 pixel in a 16x16-pixel area,\nthen refine the image progressively");
   _Progressive16x16BW=XtCreateManagedWidget("16x16", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_Progressive16x16BW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_PROGRESSIVE_16x16);
   if(LXeStr) XeStringFree(LXeStr);

 /*
   EXtStart;
   EXtSetArg(XeNtextFieldDigits, 5);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000000);EXtSetArg(XeNvalue, LRenderInfo->StartPixelSize);
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNcreateScale, False);
   EXtSetArg(XeNactivateOnLeave, True);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   LTraverseWs[LTraverseN++]=_StartPixelSizeW=XtCreateManagedWidget("Progressive res from:", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_StartPixelSizeW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_STARTPIXELSIZE);
 */


   EXtStart;
   EXtSetArg(XeNmarginTop, 7);
   EXtSetArg(XeNmarginHeight, 1);EXtSetArg(XeNmarginWidth, 2);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNwidthAdjustable, FALSE);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   XtCreateManagedWidget("Anti-aliasing:", xeLabelWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNmarginLeft, 4);EXtSetArg(XeNmarginWidth, 0);
   EXtSetArg(XeNxSpacing, 2);
   EXtSetArg(XeNradioBehavior, True);
   EXtSetArg(XeNradioAlwaysOne, True);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_NONE));
   _AntiAliasingNoneBW=XtCreateManagedWidget("None", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_AntiAliasingNoneBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_ANTIALIASING_NONE);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_4x));
   _AntiAliasing4xBW=XtCreateManagedWidget("4x", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_AntiAliasing4xBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_ANTIALIASING_4x);

/*
   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_6x));
   _AntiAliasing6xBW=XtCreateManagedWidget("6x", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_AntiAliasing6xBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_ANTIALIASING_6x);
*/

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->AntiAliasing==E3dAA_9x));
   _AntiAliasing9xBW=XtCreateManagedWidget("9x", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_AntiAliasing9xBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_ANTIALIASING_9x);



   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginTop, 8);
   EXtSetArg(XeNmarginHeight, 1);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, LRenderInfo->CreateHDRImage);
   _E3dM_SetToolTip(
"Maintain the full range of the red, green, blue and alpha components of each pixel, as they were computed\n\
by the renderer before gamma correction, clamping to the 0.0-1.0 range etc. (before 'tone-mapping').\n\
If you render an image with this option, you can save it into an '.hdr' file that stores each color\n\
component as a 32-bit floating-point value, and manipulate it later (re-'expose' it with a different gamma\n\
value, contrast, brightness etc.) without loss of shadow or highlight detail.\n\
HDR images are essential for illumination-maps, where one pixel might have an intensity of 2000\n\
(outdoor lighting) while another one might be 0.1 (a candle).");
   _HDRImageBW=XtCreateManagedWidget("High Dynamic Range (HDR) image", xeToggleButtonWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_HDRImageBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_HDR_IMAGE);
  }


// Background color folder
//
  {
   EGUIFolder*	LDrawer=&_BackgroundColorDrawer;
   Widget	LDrawerW;


   EXtStart;
   EXtSetArg(XeNshadowThickness, 2);
   EXtSetArg(XeNshadowType, XeSHADOW_ETCHED_IN);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   XtCreateManagedWidget("", xeSeparatorWidgetClass, LTopMatrixW, Args, ArgCnt);


   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNxSpacing, 12);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LTopMatrixW, Args, ArgCnt);

   LDrawerW=EGUI_CreateDrawer(LMatrixW, LDrawer, "Background color", 0, FALSE, FALSE);

   EXtStart;
   EXtSetArg(XeNclearBackground, True);
   EXtSetArg(XeNwidth, 42);
   EXtSetArg(XeNgapWidth, 0);EXtSetArg(XeNborderWidth, 1);EXtSetArg(XeNborderColor, 0);
   EXtSetArg(XeNmarginHeight, 1);
   if(LVisual)
   {
    EXtSetArg(XeNvisualInfo, LVisual->X_VisualInfo);
    EXtSetArg(XeNcolormap, LVisual->X_Colormap);
    EXtSetArg(XeNbackground, Ec_XGetRGBAiColor(XtDisplay(LTopMatrixW), LVisual->X_Colormap, &(LRenderInfo->BackgroundRGBAiColor)));
   }
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   _BackgroundColorSwatchW=XtCreateManagedWidget(" ", xePushButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_BackgroundColorSwatchW, XeNactivateCallback, (XtCallbackProc)_EGUICB_FolderOpenClose, (XtPointer)LDrawer);



   _ColorPanel=Ec_VaCreateColorPanel(LTopMatrixW, "BackgroundColor", EguiNcolorChangedCallback, _CB_ColorChanged,
		 EguiNcolorComponentType, EcINTEGER_0_255, EguiNnumOfColors, 256, EguiNpaletteDepth, 8,
		 EguiNcreateColorSwatches, FALSE, EguiNcreatePalette, FALSE, EguiNalphaOn, TRUE, EguiNcreateColorWheel, TRUE, NULL);

   Ec_ColorPanelSetRGBAiColor(_ColorPanel, 0, &(LRenderInfo->BackgroundRGBAiColor));

   LDrawer->FolderW=_ColorPanel->TopMatrixW;
  }


// Camera settings drawer
//
  {
   Widget	LDrawerW;
   EGUIFolder*	LDrawer=&_CameraSettingsDrawer;


   EXtStart;
   EXtSetArg(XeNshadowThickness, 2);
   EXtSetArg(XeNshadowType, XeSHADOW_ETCHED_IN);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   XtCreateManagedWidget("", xeSeparatorWidgetClass, LTopMatrixW, Args, ArgCnt);


   LDrawerW=EGUI_CreateDrawer(LTopMatrixW, LDrawer, "Camera", 0, TRUE, FALSE);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeVERTICAL);
   EXtSetArg(XeNySpacing, 4);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LDrawer->FolderW=XtCreateWidget("MatrixW", xeMatrixWidgetClass, LDrawerW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNmarginTop, 3);
   EXtSetArg(XeNmarginWidth, 0);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNwidthAdjustable, FALSE);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   XtCreateManagedWidget("Lens (projection) type:", xeLabelWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeVERTICAL);
//   EXtSetArg(XeNorientation, XeHORIZONTAL);
//   EXtSetArg(XeNnumOfColumns, 2);
   EXtSetArg(XeNmarginWidth, 0);
   EXtSetArg(XeNxSpacing, 2);
   EXtSetArg(XeNradioBehavior, True);
   EXtSetArg(XeNradioAlwaysOne, True);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
//   EXtSetArg(XeNindicatorOn, False);
/*
   EXtSetArg(XeNlabelType, XePIXMAP_STRING_HORIZONTAL);
   EXtSetArg(XeNlabelPixmap, EGUI_VaCImageToPixmap(&(Image_LensPerspective), EguiNbackground, &EGUI_BackgroundRGBAiColor, NULL));
   EXtSetArg(XeNactivePixmap, EGUI_VaCImageToPixmap(&(Image_LensPerspectiveActive), EguiNbackground, &EGUI_BackgroundRGBAiColor, NULL));
   EXtSetArg(XeNarmPixmap, EGUI_VaCImageToPixmap(&(Image_LensPerspectiveArm), EguiNbackground, &EGUI_BackgroundRGBAiColor, NULL));
*/

   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_PERSPECTIVE));
   _E3dM_SetToolTip("Your every-day perspective camera / lens.");
   _PerspectiveBW=XtCreateManagedWidget("Perspective", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_PerspectiveBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_PERSPECTIVE);
   if(LXeStr) XeStringFree(LXeStr);

/*
   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNindicatorOn, False);

   EXtSetArg(XeNlabelType, XePIXMAP_STRING_HORIZONTAL);
   EXtSetArg(XeNlabelPixmap, EGUI_VaCImageToPixmap(&(Image_LensOrtho), EguiNbackground, &EGUI_BackgroundRGBAiColor, NULL));
   EXtSetArg(XeNactivePixmap, EGUI_VaCImageToPixmap(&(Image_LensOrthoActive), EguiNbackground, &EGUI_BackgroundRGBAiColor, NULL));
   EXtSetArg(XeNarmPixmap, EGUI_VaCImageToPixmap(&(Image_LensOrthoArm), EguiNbackground, &EGUI_BackgroundRGBAiColor, NULL));

   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_ORTHO));
   _E3dM_SetToolTip("This 'lens' has an infinite focal length and thus provides no perspective.\nIt is very useful for creating textures and other images where perspective is an 'unwanted feature'.");
   _OrthoBW=XtCreateManagedWidget("Parallel (orthogonal)", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_OrthoBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_ORTHO);
   if(LXeStr) XeStringFree(LXeStr);
*/

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_FISHEYE));
   _E3dM_SetToolTip("This lens has a 180-degree field-of-view\nIt lets you create environment-maps and illumination-maps (see HDR).\nAn image created this way, when mapped on a hemisphere (with XY\ntexture-mapping), will yield a 180-degree view of the scene.");
   _FisheyeBW=XtCreateManagedWidget("Fish-eye", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_FisheyeBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_FISHEYE);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_REAR_FISHEYE));
   _E3dM_SetToolTip("This allows you to make two matching 'fish-eye' images for a full, 360 degree\nview of the scene, without having to manually turn the camera 180 degrees.");
   _RearFisheyeBW=XtCreateManagedWidget("Rear-view fish-eye", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_RearFisheyeBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_REAR_FISHEYE);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_ANGLE_MAP));
   _E3dM_SetToolTip(
"This lens is similar to the fish-eye, but it has a 360 by 360-degree field-of-view.\n\
Points behind the camera will be projected around the edge of the 'image circle'.\n\
Among many applications, this projection is used by light probes.");
   _AngleMapBW=XtCreateManagedWidget("Angle map", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_AngleMapBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_ANGLE_MAP);
   if(LXeStr) XeStringFree(LXeStr);

/*
   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_PANORAMA));
   _E3dM_SetToolTip("360-degree panorama (cylindrical mapping).\nCreate an image that, when mapped on the inside of a cylinder (with cylindrical\ntexture-mapping), will yield a 360-degree panoramic view of the scene.");
   _PanoramaBW=XtCreateManagedWidget("Panorama", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_PanoramaBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_PANORAMA);
   if(LXeStr) XeStringFree(LXeStr);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNactivateOnArm, True);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, (Boolean)(LRenderInfo->Camera->LensType==E3dLENS_PANORAMA));
   _E3dM_SetToolTip("Full 360-degree view (spherical mapping).\nCreate an image that, when mapped on the inside of a sphere (with\nspherical texture-mapping), will yield a full 360-degree view of the scene.");
   _SphericalBW=XtCreateManagedWidget("Spherical", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_SphericalBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_LensType, (XtPointer)E3dLENS_SPHERICAL);
   if(LXeStr) XeStringFree(LXeStr);
*/

   LIndentN=0;
   EXtStart;
   EXtSetArg(XeNtextFieldDigits, 5);EXtSetArg(XeNdecimalPoints, 2);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 17999);EXtSetArg(XeNvalue, (int)(LCamera->FieldOfView*100.0));
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_FieldOfViewScaleW=XtCreateManagedWidget("Field of view:", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_FieldOfViewScaleW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_Camera, (XtPointer)CR_FIELD_OF_VIEW);

/*
   EXtStart;
   EXtSetArg(XeNtextFieldDigits, 5);EXtSetArg(XeNdecimalPoints, 2);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000000);EXtSetArg(XeNvalue, (int)(LCamera->FocalLength*10000.0));
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_FocalLengthW=XtCreateManagedWidget("Focal length:", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_FocalLengthW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_Camera, (XtPointer)CR_FOCAL_LENGTH);

   EXtStart;
   EXtSetArg(XeNtextFieldDigits, 5);EXtSetArg(XeNdecimalPoints, 1);
   EXtSetArg(XeNminimum, 0);EXtSetArg(XeNmaximum, 320);EXtSetArg(XeNvalue, (int)(LCamera->Aperture*10.0));
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_ApertureW=XtCreateManagedWidget("Aperture:", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_ApertureW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_Camera, (XtPointer)CR_APERTURE);

   EXtStart;
   EXtSetArg(XeNtextFieldDigits, 5);EXtSetArg(XeNdecimalPoints, 2);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000000);EXtSetArg(XeNvalue, (int)(LCamera->XZoom*100.0));
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_XZoomW=XtCreateManagedWidget("X zoom:", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_XZoomW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_Camera, (XtPointer)CR_X_ZOOM);

   EXtStart;
   EXtSetArg(XeNtextFieldDigits, 5);EXtSetArg(XeNdecimalPoints, 2);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000000);EXtSetArg(XeNvalue, (int)(LCamera->YZoom*100.0));
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_YZoomW=XtCreateManagedWidget("Y zoom:", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_YZoomW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_Camera, (XtPointer)CR_Y_ZOOM);
*/


   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, LCamera->Glow);
   _E3dM_SetToolTip("Also called 'blooming'. With this option turned on, a halo will appear around bright objects.\nIt adds a nice ambience to images and makes them look more realistic.");
   _FogBW=XtCreateManagedWidget("Glow", xeToggleButtonWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_FogBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_Camera, (XtPointer)CR_GLOW);



   XeIndentWidgetsFromLeft(LIndentWs, LIndentN, 4);
   _ManageLensWidgets(LCamera);
  }



/*
  EXtStart;
  EXtSetArg(XeNshadowThickness, 2);
  EXtSetArg(XeNshadowType, XeSHADOW_ETCHED_IN);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  XtCreateManagedWidget("", xeSeparatorWidgetClass, LTopMatrixW, Args, ArgCnt);

  EXtStart;
  EXtSetArg(XeNshadowThickness, 0);
  EXtSetArg(XeNhighlightThickness, 0);
  EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
  EXtSetArg(XeNmarginBottom, 0);
  EXtSetArg(XeNrecomputeSize, False);
  EXtSetArg(XeNbackground, EGUI_BackgroundColor);
  EXtSetArg(XeNforeground, EGUI_ForegroundColor);
  EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
  EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
  EXtSetArg(XeNfontList, EGUI_LabelFontList);
  EXtSetArg(XeNselectColor, EGUI_HighlightColor);
  EXtSetArg(XeNset, LRenderInfo->Fog);
  _FogBW=XtCreateManagedWidget("Fog", xeToggleButtonWidgetClass, LTopMatrixW, Args, ArgCnt);
  XtAddCallback(_FogBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_FOG);

  LIndentN=0;
  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 8);EXtSetArg(XeNdecimalPoints, 4);
  EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 10000000);EXtSetArg(XeNvalue, (int)(LRenderInfo->FogNear*10000.0));
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNorientation, XeHORIZONTAL);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_FogNearScaleW=XtCreateManagedWidget("Fog near:", xeScaleWidgetClass, LTopMatrixW, Args, ArgCnt);
  XtAddCallback(_FogNearScaleW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_FOGNEAR));

  EXtStart;
  EXtSetArg(XeNtextFieldDigits, 8);EXtSetArg(XeNdecimalPoints, 4);
  EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 10000000);EXtSetArg(XeNvalue, (int)(LRenderInfo->FogFar*10000.0));
  EXtSetArg(XeNincrement, 10);
  EXtSetArg(XeNorientation, XeHORIZONTAL);
  E3dp_SetScaleArgs(Args, &ArgCnt);
  LIndentWs[LIndentN++]=LTraverseWs[LTraverseN++]=_FogFarScaleW=XtCreateManagedWidget("Fog far:", xeScaleWidgetClass, LTopMatrixW, Args, ArgCnt);
  XtAddCallback(_FogFarScaleW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_FOGFAR));

  XeIndentWidgetsFromLeft(LIndentWs, LIndentN, 4);
*/


// Ray-tracing options folder
//
  {
   Widget	LDrawerW;
   EGUIFolder*	LDrawer=&_RayTracingOptionsDrawer;


   EXtStart;
   EXtSetArg(XeNshadowThickness, 2);
   EXtSetArg(XeNshadowType, XeSHADOW_ETCHED_IN);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   XtCreateManagedWidget("", xeSeparatorWidgetClass, LTopMatrixW, Args, ArgCnt);


   LDrawerW=EGUI_CreateDrawer(LTopMatrixW, LDrawer, "Ray-tracing options", 0, TRUE, FALSE);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeVERTICAL);
   EXtSetArg(XeNySpacing, 4);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LDrawer->FolderW=XtCreateWidget("MatrixW", xeMatrixWidgetClass, LDrawerW, Args, ArgCnt);


   EXtStart;
   EXtSetArg(XeNmarginWidth, 0);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeVERTICAL);
   EXtSetArg(XeNnumOfColumns, 2);
   EXtSetArg(XeNxSpacing, 12);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
   EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, LRenderInfo->Shadows);
   _ShadowsBW=XtCreateManagedWidget("Shadows", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_ShadowsBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_SHADOWS);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
   EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, LRenderInfo->Reflections);
   _ReflectionsBW=XtCreateManagedWidget("Reflections", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_ReflectionsBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_REFLECTIONS);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
   EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, LRenderInfo->Transparency);
   _TransparencyBW=XtCreateManagedWidget("Transparent objects", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_TransparencyBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_TRANSPARENCY);

   EXtStart;
   EXtSetArg(XeNshadowThickness, 0);
   EXtSetArg(XeNhighlightThickness, 0);
   EXtSetArg(XeNmarginLeft, 0);EXtSetArg(XeNmarginRight, 0);EXtSetArg(XeNmarginTop, 0);
   EXtSetArg(XeNmarginBottom, 0);
   EXtSetArg(XeNrecomputeSize, False);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNtopShadowColor, EGUI_TopShadowColor);
   EXtSetArg(XeNbottomShadowColor, EGUI_BottomShadowColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNselectColor, EGUI_HighlightColor);
   EXtSetArg(XeNset, LRenderInfo->Refractions);
   _RefractionsBW=XtCreateManagedWidget("Refractions", xeToggleButtonWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_RefractionsBW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)CR_REFRACTIONS);

   EXtStart;
   EXtSetArg(XeNmarginWidth, 4);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNtextFieldDigits, 5);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000);EXtSetArg(XeNvalue, LRenderInfo->MaxRayDepth);
   EXtSetArg(XeNscaleMaximum, 42);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   LTraverseWs[LTraverseN++]=_MaxRayDepthW=XtCreateManagedWidget("Ray depth", xeScaleWidgetClass, LDrawer->FolderW, Args, ArgCnt);
   XtAddCallback(_MaxRayDepthW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_RAYDEPTH));
  }


// Advanced options folder
//
  {
   Widget	LDrawerW;
   EGUIFolder*	LDrawer=&_AdvancedOptionsDrawer;


   EXtStart;
   EXtSetArg(XeNshadowThickness, 2);
   EXtSetArg(XeNshadowType, XeSHADOW_ETCHED_IN);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   XtCreateManagedWidget("", xeSeparatorWidgetClass, LTopMatrixW, Args, ArgCnt);


   LDrawerW=EGUI_CreateDrawer(LTopMatrixW, LDrawer, "Advanced options", 0, TRUE, FALSE);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeVERTICAL);
   EXtSetArg(XeNySpacing, 4);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LDrawer->FolderW=XtCreateWidget("MatrixW", xeMatrixWidgetClass, LDrawerW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNforeground, EGUI_ForegroundColor);
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNfontList, EGUI_LabelFontList);
   EXtSetArg(XeNwidthAdjustable, FALSE);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   XtCreateManagedWidget("Voxel grid resolution:", xeLabelWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNbackground, EGUI_BackgroundColor);
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNxSpacing, 2);
   EXtSetArg(XeNwidthAdjustable, False);EXtSetArg(XeNxAlignment, XeALIGN_BEGINNING);
   LMatrixW=XtCreateManagedWidget("MatrixW", xeMatrixWidgetClass, LDrawer->FolderW, Args, ArgCnt);

   EXtStart;
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNtextFieldDigits, 5);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000);EXtSetArg(XeNvalue, LRenderInfo->GridXCount);
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNcreateScale, False);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   EXtSetArg(XeNactivateOnTextChange, True);
   LTraverseWs[LTraverseN++]=_GridXCountW=XtCreateManagedWidget("X:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_GridXCountW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_GRIDXCOUNT));

   EXtStart;
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNtextFieldDigits, 5);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000);EXtSetArg(XeNvalue, LRenderInfo->GridYCount);
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNcreateScale, False);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   EXtSetArg(XeNactivateOnTextChange, True);
   LTraverseWs[LTraverseN++]=_GridYCountW=XtCreateManagedWidget("Y:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_GridYCountW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_GRIDYCOUNT));

   EXtStart;
   EXtSetArg(XeNorientation, XeHORIZONTAL);
   EXtSetArg(XeNtextFieldDigits, 5);
   EXtSetArg(XeNminimum, 1);EXtSetArg(XeNmaximum, 1000);EXtSetArg(XeNvalue, LRenderInfo->GridZCount);
   EXtSetArg(XeNincrement, 10);
   EXtSetArg(XeNcreateScale, False);
   E3dp_SetScaleArgs(Args, &ArgCnt);
   EXtSetArg(XeNheightAdjustable, False);
   EXtSetArg(XeNactivateOnTextChange, True);
   LTraverseWs[LTraverseN++]=_GridZCountW=XtCreateManagedWidget("Z:", xeScaleWidgetClass, LMatrixW, Args, ArgCnt);
   XtAddCallback(_GridZCountW, XeNvalueChangedCallback, (XtCallbackProc)_DCB_RenderSetup, (XtPointer)(CR_GRIDZCOUNT));
  }


// Set up TextField traversal
//
  XeRingTraversal(LTraverseWs, LTraverseN);
 }
 else _RenderSetupUpdateDialog(LRenderInfo);

 if(_RenderSetupDialog) EGUI_RaiseShell(_RenderSetupDialog);
}


//========================================
// Key callback
//========================================
static void E3dKCB_RenderSetup(unsigned short LKey, unsigned int LModifiers, int LKeyEventType, EPointer LClientData)
{
 _MCB_RenderSetup((EguiItem)NULL, NULL, (EPointer)0);
}


//========================================
// Entry point of the plugin
//========================================
int Plugin_Init(EPlugin* LPlugin)
{
 _Plugin=LPlugin;

 _MenuButton=EGUI_AddPushButton("Menu->Render", "Render setup", '\0', "Shift <Key>R", "Shift+R", FALSE, NULL, _MCB_RenderSetup, (EPointer)0);

 E_KeySetCallback("Render setup", (unsigned short)'R', EShiftMask, EKeyPRESS, E3dKCB_RenderSetup, (EPointer)0);

 return(0);
}


//========================================
// Exit method of the plugin
//========================================
int Plugin_Exit()
{
 if(_MenuButton) EGUI_DestroyItem(_MenuButton);

 E_KeyRemoveCallback((unsigned short)'R', EShiftMask, EKeyPRESS, E3dKCB_RenderSetup, (EPointer)0);

 return(0);
}
