/*======================================================================*/
/* Color library header file						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Sep-12 23:54:44					*/
/*									*/
/* ColorPanel Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef	_EColor_h
#define	_EColor_h

#include <ETypes.h>

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#define	EcRadianFactor	57.29577951

#define Ec_AutoDepth	0

#define Ec_COLOR_CHANGED	1

#define EcLumaR		0.212671
#define EcLumaG		0.715160
#define EcLumaB		0.072169

#define EcLumaIR	54
#define EcLumaIG	183
#define EcLumaIB	19


/*
#define EcLumaR		0.3086
#define EcLumaG		0.6094
#define EcLumaB		0.0820

#define EcLumaIR	79
#define EcLumaIG	156
#define EcLumaIB	21
*/

/*------------------------------*/
/* Macros			*/
/*------------------------------*/
#define EcM_LumaI(r,g,b)	((EcLumaIR*(r)+EcLumaIG*(g)+EcLumaIB*(b))>>8)
#define EcM_Luma(r,g,b)		(EcLumaR*(r)+EcLumaG*(g)+EcLumaB*(b))
#define EcM_LumaRGBA(RGBA)	((EcLumaIR*(((RGBA)>>24)&0xFF)+EcLumaIG*(((RGBA)>>16)&0xFF)+EcLumaIB*(((RGBA)>>8)&0xFF))>>8)
#define EcM_LumaABGR(ABGR)	((EcLumaIR*((ABGR)&0xFF))+EcLumaIG*(((ABGR)>>8)&0xFF)+EcLumaIB*(((ABGR)>>16)&0xFF))>>8)
#define EcM_ABGRToARGB(ABGR)	((ABGR&0xFF000000)|((ABGR&0x000000FF)<<16)|(ABGR&0x0000FF00)|((ABGR&0x00FF0000)>>16))
#define EcM_ABGRToRGBA(ABGR)	(((ABGR&0xFF000000)>>24)|((ABGR&0x00FF0000)>>8)|((ABGR&0x0000FF00)<<8)|((ABGR&0x000000FF)<<24))

#define EcM_RGBAi_to_RGBAp8(ci)		(((((unsigned long)(ci.R))&0xFF00)<<16)|((((unsigned long)(ci.G))&0xFF00)<<8)|(((unsigned long)(ci.B))&0xFF00)|((((unsigned long)(ci.A))&0xFF00)>>8))
#define EcM_RGBAiPTR_to_RGBAp8(ci)	(((((unsigned long)(ci->R))&0xFF00)<<16)|((((unsigned long)(ci->G))&0xFF00)<<8)|(((unsigned long)(ci->B))&0xFF00)|((((unsigned long)(ci->A))&0xFF00)>>8))
#define EcM_RGBAi_to_RGBf(ci, cf)		(cf).R=(float)(ci.R)*0.0000152,(cf).G=(float)(ci.G)*0.0000152,(cf).B=(float)(ci.B)*0.0000152
#define EcM_R_RGBA(RGBA)	(((RGBA)>>24)&0xFF)
#define EcM_G_RGBA(RGBA)	(((RGBA)>>16)&0xFF)
#define EcM_B_RGBA(RGBA)	(((RGBA)>>8)&0xFF)
#define EcM_A_RGBA(RGBA)	((RGBA)&0xFF)


#ifdef BYTE_LITTLE_ENDIAN
#define EcM_R_MEM_RGBA(RGBA)	((RGBA)&0xFF)
#define EcM_G_MEM_RGBA(RGBA)	(((RGBA)>>8)&0xFF)
#define EcM_B_MEM_RGBA(RGBA)	(((RGBA)>>16)&0xFF)
#define EcM_A_MEM_RGBA(RGBA)	(((RGBA)>>24)&0xFF)
#else
#define EcM_R_MEM_RGBA(RGBA)	(((RGBA)>>24)&0xFF)
#define EcM_G_MEM_RGBA(RGBA)	(((RGBA)>>16)&0xFF)
#define EcM_B_MEM_RGBA(RGBA)	(((RGBA)>>8)&0xFF)
#define EcM_A_MEM_RGBA(RGBA)	((RGBA)&0xFF)
#endif // BYTE_LITTLE_ENDIAN

#define EcM_R_ABGR(ABGR)	((ABGR)&0xFF)
#define EcM_G_ABGR(ABGR)	(((ABGR)>>8)&0xFF)
#define EcM_B_ABGR(ABGR)	(((ABGR)>>16)&0xFF)
#define EcM_A_ABGR(ABGR)	(((ABGR)>>24)&0xFF)
#define EcM_PackRGBA(r,g,b,a)	((((EcRGBAp8Color)(r))<<24)|(((EcRGBAp8Color)(g))<<16)|(((EcRGBAp8Color)(b))<<8)|((EcRGBAp8Color)(a)))


// FIXME
// Shouldn't use these
//
/*
#ifdef sgi
#define EcM_GetColorPixelValue(r,g,b)	(Pixel)((r)|((g)<<8)|((b)<<16)|0xFF000000)
#else
#define EcM_GetColorPixelValue(r,g,b)	(Pixel)(((r)<<24)|((g)<<16)|((b)<<8)|0x000000FF)
#endif
*/

// Packed integer color
//
typedef unsigned long	EcRGBAp8Color;

// Integer-component RGB color 
// Normal range: 0...0xFFFF
//
typedef struct
{
 int	R, G, B;
} EcRGBiColor;


// Integer-component RGBA color 
// Normal range: 0...0xFFFF
//
typedef struct
{
 int	R, G, B, A;
} EcRGBAiColor;


// Float-component color
// Normal range:	0.0...1.0
typedef struct
{
 float	R, G, B;
} EcRGBfColor;

// Float-component color
// Normal range:	0.0...1.0
typedef struct
{
 float	R, G, B, A;
} EcRGBAfColor;



extern void		Ec_SetRGBAiColor(EcRGBAiColor* LColor, int LR, int LG, int LB, int LA);
extern void		Ec_SetRGBfColor(EcRGBfColor* LColor, float LR, float LG, float LB);


extern EcRGBiColor*	Ec_GetRGBiShade(EcRGBiColor* LColor, EcRGBiColor* LColorRet, double LBrightnessFactor);
extern EcRGBAiColor*	Ec_GetRGBAiShade(EcRGBAiColor* LColor, EcRGBAiColor* LColorRet, double LBrightnessFactor);

extern void		Ec_FColorShadeBy(EcRGBfColor* LColor, EcRGBfColor* LColorLum, EcRGBfColor* LDstColor);

extern EcRGBAp8Color	Ec_GetRGBp8Shade(EcRGBAp8Color LColor, double LBrightnessFactor);
extern EcRGBAp8Color	Ec_GetRGBAp8Shade(EcRGBAp8Color LColor, double LBrightnessFactor);

extern double		Ec_GetAngle(double LXPos, double LYPos);
extern EcRGBAp8Color	Ec_FloatsToPackedRGBA(double LR, double LG, double LB, double LA);
extern void		Ec_HSV_To_RGB(double LHue, double LSaturation, double LValue, int* LR, int* LG, int* LB);
extern void		Ec_HLS_To_RGB(double LHue, double LLevel,  double LSaturation, int* LR, int* LG, int* LB);



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EColor_h
