/*======================================================================*/
/* Color library GUI							*/
/*									*/
/* - Color-wheel							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Sep-12 22:55:41					*/
/*									*/
/* ColorPanel Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef	_EColorWheel_h
#define	_EColorWheel_h

#include <Color/Color.h>
#include <EGUI/EGUI.h>

#define EcMAX_COLORWHEEL_XSIZE	200
#define EcMAX_COLORWHEEL_YSIZE	200

typedef struct EcColorWheelRec
{
 Widget		MatrixW, DrawW, ValueW;
 Pixmap		WheelPixmap;
 XImage*	WheelImage;
 Dimension	MarginWidth;
 int		XSize, YSize;
 int		ValueI;
 float		ValueF;
 int		CursorX, CursorY;
 int		IR, IG, IB;
 float		FR, FG, FB;
 float		Hues[EcMAX_COLORWHEEL_YSIZE][EcMAX_COLORWHEEL_XSIZE];
 float		Saturations[EcMAX_COLORWHEEL_YSIZE][EcMAX_COLORWHEEL_XSIZE];
 int		VType;
 void		(*CallbackProc)(struct EcColorWheelRec*, EPointer, EPointer);
 EPointer	ClientData;
 EBool		HSValid;
} EcColorWheelRec;

typedef void	(*EcColorWheelCallbackProc)(EcColorWheelRec*, EPointer, EPointer);

typedef struct
{
 int		reason;
 EcRGBAiColor	RGBAiColor;
 EcRGBAfColor	RGBAfColor;
} EcColorWheelCallbackStruct;





extern EcColorWheelRec*	Ec_ColorWheelCreate(Widget LParentW, Widget LLeftWidget, Widget LRightWidget, unsigned int LXSize, unsigned int LYSize, int LVType, EcColorWheelCallbackProc LCallback, EPointer LClientData);
extern void		Ec_ColorWheelRedraw(EcColorWheelRec* LCW);
extern void		Ec_ColorWheelSetRGBiColor(EcColorWheelRec* LCW, EcRGBiColor* LRGBiColor);
extern void		Ec_ColorWheelSetRGBfColor(EcColorWheelRec* LCW, EcRGBfColor* LRGBfColor);
extern void		Ec_ColorWheelSetRGBAfColor(EcColorWheelRec* LCW, EcRGBAfColor* LRGBfColor);

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif // _EColorWheel_h
