/*======================================================================*/
/* 3DWindow header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Nov-23 23:21:35					*/
/*									*/
/* 3DPanel(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3D3DWindow_h
#define _E3D3DWindow_h


#ifndef _E3DPanel_h
#include <E3D/Panel.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



#define E3dShadowMapCore()\
 EBool	ShadowMapValid

typedef struct
{
 E3dShadowMapCore();
} E3dShadowMap;



#define MAX_MODELWINDOWNUM	4
#define E3dpMAIN_WINDOW		1


#define E3dWF_NONE		 0
#define E3dWF_CREATED		 1
#define E3dWF_MANAGED		(1<<1)
#define E3dWF_ALIVE		(1<<2)
#define	E3dWF_DRAWABLE		(WF_CREATED|WF_MANAGED|WF_ALIVE)
#define E3dWF_ZOOM		(1<<3)
#define E3dWF_ZOOMHORIZ		(1<<4)
#define E3dWF_ZOOMVERT		(1<<5)
#define E3dWF_ALL		0x3F

#define E3dHF_NONE		 0
#define E3dHF_VIEWMODE		 1
#define E3dHF_SETTINGS		(1<<1)
#define E3dHF_DISPLAYMODE	(1<<2)
#define E3dHF_SIZE		(1<<3)
#define E3dHF_ALL		0xF

// Display flags for 3D windows
// Display-mode flags
//
#define E3dDF_NONE		0x00
#define E3dDF_WIREFRAME		0x01
#define E3dDF_SOLID		0x02
#define E3dDF_Z_BUFFER		0x04

#define E3dDF_DEPTH_CUE		0x08
#define E3dDF_COLOR		0x10
#define E3dDF_LIGHTING		0x20
#define E3dDF_FINAL		0x40	// Use final background color (black if there is no ambient light)
#define E3dDF_RAY_TRACING	0x80	// Use final background color (black if there is no ambient light)

#define E3dDF_MODEMASK		0x7F


// Display modes for 3D windows
//
#define E3dDM_Wireframe		E3dDF_WIREFRAME
#define E3dDM_WireAndZ		(E3dDF_WIREFRAME|E3dDF_Z_BUFFER)
#define E3dDM_WireDepthCue	(E3dDF_WIREFRAME|E3dDF_DEPTH_CUE|E3dDF_Z_BUFFER)
#define E3dDM_HiddenLine	(E3dDF_SOLID|E3dDF_Z_BUFFER)
#define E3dDM_ColorWire		(E3dDF_WIREFRAME|E3dDF_COLOR|E3dDF_Z_BUFFER)
#define E3dDM_ShadedWire	(E3dDF_WIREFRAME|E3dDF_LIGHTING|E3dDF_Z_BUFFER)
#define E3dDM_Solid		(E3dDF_SOLID|E3dDF_COLOR|E3dDF_Z_BUFFER)
#define E3dDM_SolidAndWire	(E3dDF_WIREFRAME|E3dDF_SOLID|E3dDF_Z_BUFFER)
#define E3dDM_ShadedSolid	(E3dDF_SOLID|E3dDF_LIGHTING|E3dDF_Z_BUFFER)
#define E3dDM_ShadedSolidAndWire (E3dDF_WIREFRAME|E3dDF_SOLID|E3dDF_LIGHTING|E3dDF_Z_BUFFER)
#define E3dDM_ShadedSolidFinal	(E3dDF_SOLID|E3dDF_LIGHTING|E3dDF_FINAL|E3dDF_Z_BUFFER)
#define E3dDM_RayTracing	(E3dDF_SOLID|E3dDF_RAY_TRACING)




// Display flags for 3D windows
// Extra flags
//
#define E3dDF_TEXTURE		(1<<9)
#define E3dDF_LINEANTIALIAS	(1<<12)
#define E3dDF_POLYANTIALIAS	(1<<13)
#define E3dDF_FULLANTIALIAS	(1<<14)

#define E3dDF_EXTRAFLAGS	0x7F00

// Display flags for 3D windows
// Object flags
//
#define E3dDF_SELECTED		(1<<20)
#define E3dDF_LOCKED		(1<<21)

#define E3dDF_MODELFLAGS	0x300000


#define E3dDF_ALL		(E3dDF_MODEMASK|E3dDF_EXTRAFLAGS|E3dDF_MODELFLAGS)




// View modes for windows
//
#define E3dVM_FRONT		1
#define E3dVM_LEFT		(1<<1)
#define E3dVM_RIGHT		(1<<2)
#define E3dVM_TOP		(1<<3)
#define E3dVM_BOTTOM		(1<<4)
#define E3dVM_PERSPECTIVE	(1<<5)
#define E3dVM_SCHEMATICS	(1<<6)
#define E3dVM_ANIMATION		(1<<7)
#define E3dVM_ALL		0xFF

#define E3dVM_NORMAL3D		(E3dVM_FRONT|E3dVM_LEFT|E3dVM_RIGHT|E3dVM_TOP|E3dVM_BOTTOM|E3dVM_PERSPECTIVE)


/*==============================================*/
/* Rendering flags for windows and buffers	*/
/*==============================================*/
/*----------------------------------------------------------------------*/
/* What to render in the window/what is rendered in the speedup-buffer	*/
/* or what supposed to be in the speedup-buffer before copying from it	*/
/*----------------------------------------------------------------------*/
#define RD_ItemControls		1	// Controls (grid, axis)
#define RD_ItemCamera		(1<<1)	// Camera and interest point
#define RD_ItemUnselected	(1<<2)	// Unselected models
#define RD_ItemSelected		(1<<3)	// Selected models
#define RD_ItemAll		0x000F

/*--------------------------------------------------------------*/
/* Rendering control flags					*/
/*--------------------------------------------------------------*/
#define RC_CLEAR		(1<<8)	// Clear window before drawing
#define RC_CopyFromTrBuffer	(1<<9)	// Copy from speedup buffer
#define RC_CopyToQEBuffer	(1<<10)	// Copy rendered image to QuickExpose buffer
#define RC_DefineLights		(1<<11)	// Redefine lights
#define RC_SwapBuffers		(1<<12)	// Display rendered image
#define RC_ControlAll		0x1F00
#define RF_ALL			0x1F0F



enum { CSSTEREO_ONE_ZERO=0, CSSTEREO_ONE_ONE };

// 3D stereoscopic modes
//
enum
{
 E3dStereoNONE=0,
 E3dStereoANAGLYPH,
 E3dStereoSHUTTER,
 E3dStereoPOLARIZED,
};


// 3DWindow settings
//
typedef struct
{
 E3d3DPosition	GridSize;
 E3d3DPosition	GridDisplay;
 E3d3DPosition	SubGridDisplay;
 int		GridXCount, GridYCount, GridZCount;
 E3dCoordinate	EyeDistance;

 unsigned char	StereoMode;
 unsigned char	ShadowMode;

 EBool		GridSnapToX, GridSnapToY, GridSnapToZ,	// For perspective views
		GridXYOn, GridXZOn, GridYZOn,
		GridOn,					// For orthogonal views
		AxisOn,
		RulerOn,
		TexturesOn,
		TransparencyOn,
		ShadowsOn,
		LineAntiAliasing,
		PolygonAntiAliasing,
		FullAntiAliasing;
} E3dWindowSettings;


#ifndef _E3dWindow
#define _E3dWindow
typedef struct E3dWindow_S	E3dWindow;
#endif

struct E3dWindow_S
{
 E3dPanel*		Panel;

 unsigned int		WindowFlags;
 unsigned int		HeaderFlags;
 unsigned int		DisplayMode, LastDisplayMode;
 unsigned int		ViewMode, LastViewMode;			// Perspective, Top, Front etc.

 int			XSize, YSize;

 unsigned int		Visibility;				// Unobscured, partially obscured, fully obscured
 float			ZoomMin, ZoomMax;

 E3dCamera		PerspectiveCamera;
 E3dCamera		TopCamera;
 E3dCamera		FrontCamera;
 E3dCamera		RightCamera;
 E3dCamera		SchematicsCamera;
 E3dCamera		AnimationCamera;			// Function curves

 double			AspectRatio;

 float			FieldOfViewMin, FieldOfViewMax;		// Field of view range

 unsigned int		DisplayFunctionFlags;
 int			CSStereoBlendingFunct;			// Blending function for anaglyph stereoscopic display

 void			(*CustomDisplayFunction)(int);

 EguiMenuRec*		ViewModeMenuBar;
 EguiMenuRec*		DisplayModeMenuBar;

#ifdef EGUIXe
 Widget			MatrixW;
 Widget			HeaderFormW;
 Widget			ViewModeCascadeBW, TopModeW, FrontModeW, RightModeW, PerspectiveModeW, SchematicsModeW, AnimationModeW;
 Widget			WindowSettingsButtonW;
 Widget			DisplayModeCascadeBW;

 Widget			DMW_Wireframe,
			DMW_WireAndZ,
			DMW_WireDepthCue,
			DMW_HiddenLine,
			DMW_ColorWire,
			DMW_ShadedWire,
			DMW_Solid,
			DMW_SolidAndWire,
			DMW_ShadedSolid,
			DMW_ShadedSolidAndWire,
			DMW_ShadedSolidFinal,
			DMW_RayTracing;

 Widget			TexturesBW, SizeButtonW;
 Widget			SchemLayoutBW;				// Lay out hierarchies on Schematic-view

 Widget			FrameW;
 Widget			GLXW;					// The GLX widget
 Window			XWindow;
#endif // EGUIXe



 E3dWindowSettings	Settings;
 E3dRenderInfo		RenderInfo;

// EBool flags at the end (padding)
//
 EBool			LightOn;				// Hardware lighting is active in this window
};





/*------------------------------*/
/* From GUI.c			*/
/*------------------------------*/
extern E3dWindow*	E3dp_Active3DWindow;		// The active window
extern E3dWindow*	E3dp_Main3DWindow;

extern int		E3dp_NumOf3DWindows;
extern E3dWindow*	E3dp_3DWindows[MAX_MODELWINDOWNUM];


/*------------------------------*/
/* From Panel/3DWindow.c	*/
/*------------------------------*/
extern EpImage*		E3d_WindowGetImage(E3dWindow* L3DWindow, EpImage* LDImage);

extern void		E3dp_3DWindowRefreshCameras(E3dWindow* L3DWindow);

extern void		E3d_3DWindowDefault(E3dWindow* L3DWindow);

extern E3dWindow*	E3dp_Create3DWindow(E3dPanel* L3DPanel, int LModelWindowN, int LWindowFlags, int LHeaderFlags, int LDisplayFlags, int LViewMode, void (*LCustomDisplayFunction)(int), int LDisplayFunctionFlags);

extern E3dCamera*	E3dp_WindowGetActiveCamera(E3dWindow* L3DWindow);
extern void		E3dp_3DWindowFullRefresh(E3dWindow* L3DWindow);

extern void		E3dp_Refresh3DWindows(unsigned long LDisplayFlags, unsigned long LViewModes);
extern void		E3dp_Redraw3DWindows(unsigned long LDisplayFlags, unsigned long LViewModes);


extern void		E3dp_InitPreferences();
extern void		E3dp_Set3DModelPanelLayout();
extern void		E3dp_VaSetValues(int LID, ...);
extern void		E3dp_SetDisplayModeByNum(E3dWindow* LModelWindow, int LDispMode, EBool LSetCurrent);
extern void		E3dp_ResetCameraOn3DWindows();



/*------------------------------*/
/* From Panel/3DWindow_X.c	*/
/*------------------------------*/
extern Window		E3dp_CurrentGLXWindow;		// The active current window as far as GLX is concerned


/*------------------------------*/
/* From Panel/Camera.c		*/
/*------------------------------*/
extern void		E3dp_CameraControl(E3dWindow* L3DWindow, int LPtrX, int LPtrY, unsigned int LState);
extern void		E3dp_3DWindowResetCameras(E3dWindow* L3DWindow);


/*------------------------------*/
/* From Panel/Display.c		*/
/*------------------------------*/
extern void		E3dp_Redraw3DWindow(E3dWindow* L3DWindow);
extern void		E3dp_WindowsRedrawByChangeFlags(unsigned int LChanged);


/*------------------------------*/
/* From Panel/MenuBar.c		*/
/*------------------------------*/
extern void		E3dp_SetSelectionMode(int LMode);
extern Widget		E3d_AddMenuButton(EguiMenuRec* LMenu, EguiItem LItem, Widget LBeforeW);


extern void		E3dp_SetMenuBar(E3dPanel* L3DPanel, EBool LSwitch);


extern E3d3DPosition	E3dp_CameraPos, E3dp_InterestPos;				// Global camera parameters
extern E3dVector	E3dp_CameraDirection;
extern E3dRotation	E3dp_CameraRot;
extern float		E3dp_ViewDistance;
extern float		E3dp_FieldOfView;
extern float		E3dp_EyeDistance;


/*------------------------------*/
/* From Panel/PanelLayout.c	*/
/*------------------------------*/
extern void		E3dp_3DWindowsLayout(E3dPanel* L3DPanel);
extern void		E3dp_3DWindowsPanelSetAttachments(E3dPanel* L3DPanel);
extern void		E3dp_MenuBarSetPanelAttachments(E3dPanel* L3DPanel);


/*------------------------------*/
/* From Panel/Schematics.c	*/
/*------------------------------*/
extern void		E3d_ModelHrcRefresSchemPositions(E3dModel* LRootModel);
extern int		E3dp_SceneLayoutOnSchematics(E3dScene* LScene);


/*------------------------------*/
/* From Panel/ToolPanel.c	*/
/*------------------------------*/
extern void		E3dp_SetToolPanel(E3dPanel* L3DPanel, EBool LSwitch);


/*------------------------------*/
/* From Panel/TransformPanel.c	*/
/*------------------------------*/
extern int		E3dp_PrevPtrX, E3dp_PrevPtrY;

extern int		E3dp_BasePtrX, E3dp_BasePtrY;
extern E3d3DPosition	E3dp_TranslateBase;
extern E3d3DPosition	E3dp_ScaleBase;


extern void		E3dp_InitPointMove(E3dWindow* L3DWindow, int LPtrX, int LPtrY, E3dCoordinate LX, E3dCoordinate LY, E3dCoordinate LZ, EBool LStoreForUndo);

extern void		E3dp_TransformPanelUpdate(int LScaleFlags, int LRotFlags, int LTransFlags, EBool LSelectionChanged);

extern void		E3dp_TransformPanelToggle(E3dPanel* L3DPanel, EBool LSwitch);

extern void		E3dp_InteractiveTransform(E3dWindow* L3DWindow, int LPtrX, int LPtrY, unsigned int LState);



extern void		E3dp_ModelRemoveHrcFromScene(E3dModel* LRootModel);


extern void		E3dp_SetToolPanel(E3dPanel* L3DPanel, EBool LSwitch);

extern void		E3dp_ReadAndInitPlugins(char* LPath, char* LFileName);
extern void		E3dp_FreePlugins();



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3D3DWindow_h
