/*======================================================================*/
/* Drawing macros etc.							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-20 23:21:35					*/
/*									*/
/* 3DPanel(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DDefaultDrawingMacros_h
#define _E3DDefaultDrawingMacros_h


#ifndef _E3DPanel_h
#include <E3D/Panel.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


//------------------------------------------------
// Polygon drawing macros: Textured
//------------------------------------------------
#define E3dM_DrawPolygon2DTextured()\
 if((mITriangle=mPolygon->ITriangles)==NULL)\
 {\
  mVertexNode=mPolygon->VertexNodes;\
  mVN=mPolygon->NumOfExteriorVertices;\
  glBegin(GL_POLYGON);\
   for(mVC=0;mVC<mVN;mVC++, mVertexNode++) { glTexCoord2fv(&(mVertexNode->S));MglVertex3v(mVertexNode->GLVertex); }\
  glEnd();\
 }\
 else\
 {\
  mPC1=mPolygon->NumOfTriangles;\
  glBegin(GL_TRIANGLES);\
  do\
  {\
   mVertexNodeP=mITriangle->VertexNodes;\
   mVertexNode=mVertexNodeP[0];glTexCoord2fv(&(mVertexNode->S));MglVertex3v(mVertexNode->GLVertex);\
   mVertexNode=mVertexNodeP[1];glTexCoord2fv(&(mVertexNode->S));MglVertex3v(mVertexNode->GLVertex);\
   mVertexNode=mVertexNodeP[2];glTexCoord2fv(&(mVertexNode->S));MglVertex3v(mVertexNode->GLVertex);\
   mITriangle++;\
  } while(--mPC1);\
  glEnd();\
 }


#define E3dM_DrawPolygonSmooth2DTextured()\
 if((mITriangle=mPolygon->ITriangles)==NULL)\
 {\
  mVN=mPolygon->NumOfExteriorVertices;\
  mVertexNode=mPolygon->VertexNodes;\
  glBegin(GL_POLYGON);\
   for(mVC=0;mVC<mVN;mVC++, mVertexNode++) { glTexCoord2fv(&(mVertexNode->S));MglNormal3v(mVertexNode->GLNormal);MglVertex3v(mVertexNode->GLVertex); }\
  glEnd();\
 }\
 else\
 {\
  mPC1=mPolygon->NumOfTriangles;\
  glBegin(GL_TRIANGLES);\
  do\
  {\
   mVertexNodeP=mITriangle->VertexNodes;\
   mVertexNode=mVertexNodeP[0];glTexCoord2fv(&(mVertexNode->S));MglNormal3v(mVertexNode->GLNormal);MglVertex3v(mVertexNode->GLVertex);\
   mVertexNode=mVertexNodeP[1];glTexCoord2fv(&(mVertexNode->S));MglNormal3v(mVertexNode->GLNormal);MglVertex3v(mVertexNode->GLVertex);\
   mVertexNode=mVertexNodeP[2];glTexCoord2fv(&(mVertexNode->S));MglNormal3v(mVertexNode->GLNormal);MglVertex3v(mVertexNode->GLVertex);\
   mITriangle++;\
  } while(--mPC1);\
  glEnd();\
 }


//----------------------------------------------------------------
// Draw TriangleStrip with constant color and a 2DTexture
//----------------------------------------------------------------
#define E3dM_DrawTriangleStripConst2DTextured()\
 mVN=mTriangleStrip->NumOfVertices;\
 mVertexNode=mTriangleStrip->VertexNodes;\
 glBegin(GL_TRIANGLE_STRIP);\
  for(mVC=0;mVC<mVN;mVC++, mVertexNode++) { glTexCoord2fv(&(mVertexNode->S));MglVertex3v(mVertexNode->GLVertex); }\
 glEnd();


//----------------------------------------------------------------
// Draw Shaded TriangleStrip with a 2DTexture
//----------------------------------------------------------------
#define E3dM_DrawTriangleStripShaded2DTextured()\
 mVN=mTriangleStrip->NumOfVertices;\
 mVertexNode=mTriangleStrip->VertexNodes;\
 glBegin(GL_TRIANGLE_STRIP);\
  for(mVC=0;mVC<mVN;mVC++, mVertexNode++) { glTexCoord2fv(&(mVertexNode->S));MglNormal3v(mVertexNode->GLNormal);MglVertex3v(mVertexNode->GLVertex); }\
 glEnd();


//----------------------------------------------------------------
// Draw Shaded PolyGroup with a 2D Texture
//----------------------------------------------------------------
#define E3dM_DrawPolyGroupShadedSolid2DTextured()\
{\
 E3dGLMaterial*		mGLMaterial;\
 E3dPolygon*		mPolygon;\
 E3dITriangle*		mITriangle;\
 E3dTriangleStrip*	mTriangleStrip;\
 E3dVertexNode*		mVertexNode;\
 E3dVertexNode**	mVertexNodeP;\
 unsigned int		mPolyCnt, mPC1,\
			mVC, mVN;\
\
\
 switch(LMaterial->Type)\
 {\
  case E3dMAT_CONSTANT:\
   mGLMaterial=&(LMaterial->GLMaterial);\
   glDisable(GL_LIGHTING);\
   E3dM_glColorRGBAp8(mGLMaterial->FlatColor);\
   E3dM_DrawPolyGroupConstSolid2DTextured();\
  break;\
\
  case E3dMAT_LAMBERT:\
  case E3dMAT_PHONG:\
  case E3dMAT_BLINN:\
   glEnable(GL_LIGHTING);\
   if(LMaterial->NumOf2DTextures>0)\
   {\
    glEnable(GL_TEXTURE_2D);\
    mGLMaterial=&(LMaterial->GL2DTextureMaterial);\
/*       mGLMaterial=LPlasterGLMaterial;*/\
\
    E3d_MaterialDefineGL(mGLMaterial);\
\
    L2DTexture=LMaterial->Textures2D[0];\
\
    E3dGLM_Setup2DTexture(L2DTexture);\
\
/* Draw primitives	*/\
    switch(L2DTexture->MappingMethod)\
    {\
     case E3dTXT_ENVIRONMENT_MAP:\
      if(LPolyGroup->GLArrayVertexNormalST)\
      {\
       glEnableClientState(GL_VERTEX_ARRAY);\
       glEnableClientState(GL_NORMAL_ARRAY);\
       glDisableClientState(GL_TEXTURE_COORD_ARRAY);\
       glVertexPointer(3, GL_FLOAT, sizeof(E3dGLShadedSTVertex), LPolyGroup->GLArrayVertexNormalST);\
       glNormalPointer(GL_FLOAT, sizeof(E3dGLShadedSTVertex), (char*)(LPolyGroup->GLArrayVertexNormalST)+sizeof(E3dGLCoordinate)*3);\
       glDrawElements(GL_TRIANGLES, LPolyGroup->GLTriangleCount*3, GL_UNSIGNED_INT, LPolyGroup->GLTriangleVertexIndexArray);\
      }\
      else if((mPolyCnt=LPolyGroup->NumOfTriangleStrips)>0)\
      {\
       glDisable(GL_CULL_FACE);\
       mTriangleStrip=LPolyGroup->TriangleStrips;\
       do\
       {\
	E3dM_DrawTriangleStripVertexNormal();\
	mTriangleStrip++;\
       } while(--mPolyCnt);\
       glEnable(GL_CULL_FACE);\
      }\
      else if((mPolyCnt=LPolyGroup->NumOfPolygons)>0)\
      {\
       mPolygon=LPolyGroup->Polygons;\
\
       if((LPolyGroup->Flags&E3dUSE_VERTEX_NORMALS)==0)\
       {\
	do\
	{\
	 MglNormal3v(mPolygon->GLNormal);\
	 E3dM_DrawPolygon();\
	 mPolygon++;\
	} while(--mPolyCnt);\
       }\
       else\
       {\
	do\
	{\
	 E3dM_DrawPolygonVertexNormal();\
	 mPolygon++;\
	} while(--mPolyCnt);\
       }\
      }\
     break;\
\
     default:\
      if(LPolyGroup->GLArrayVertexNormalST)\
      {\
       glEnableClientState(GL_VERTEX_ARRAY);\
       glEnableClientState(GL_NORMAL_ARRAY);\
       glEnableClientState(GL_TEXTURE_COORD_ARRAY);\
       glVertexPointer(3, GL_FLOAT, sizeof(E3dGLShadedSTVertex), LPolyGroup->GLArrayVertexNormalST);\
       glNormalPointer(GL_FLOAT, sizeof(E3dGLShadedSTVertex), (char*)(LPolyGroup->GLArrayVertexNormalST)+sizeof(E3dGLCoordinate)*3);\
       glTexCoordPointer(2, GL_FLOAT, sizeof(E3dGLShadedSTVertex), (char*)(LPolyGroup->GLArrayVertexNormalST)+sizeof(E3dGLCoordinate)*3+sizeof(GLfloat)*3);\
       glDrawElements(GL_TRIANGLES, LPolyGroup->GLTriangleCount*3, GL_UNSIGNED_INT, LPolyGroup->GLTriangleVertexIndexArray);\
      }\
      else if((mPolyCnt=LPolyGroup->NumOfTriangleStrips)>0)\
      {\
       glDisable(GL_CULL_FACE);\
       mTriangleStrip=LPolyGroup->TriangleStrips;\
       do\
       {\
	E3dM_DrawTriangleStripShaded2DTextured();\
	mTriangleStrip++;\
       } while(--mPolyCnt);\
       glEnable(GL_CULL_FACE);\
      }\
      else if((mPolyCnt=LPolyGroup->NumOfPolygons)>0)\
      {\
       mPolygon=LPolyGroup->Polygons;\
\
       if((LPolyGroup->Flags&E3dUSE_VERTEX_NORMALS)==0)\
       {\
	do\
	{\
	 MglNormal3v(mPolygon->GLNormal);\
	 E3dM_DrawPolygon2DTextured();\
	 mPolygon++;\
	} while(--mPolyCnt);\
       }\
       else\
       {\
	do\
	{\
	 E3dM_DrawPolygonSmooth2DTextured();\
	 mPolygon++;\
	} while(--mPolyCnt);\
       }\
      }\
     break;\
    }\
   }\
   else\
   {\
    mGLMaterial=&(LMaterial->GLMaterial);\
    E3d_MaterialDefineGL(mGLMaterial);\
    glDisable(GL_TEXTURE_2D);\
/* Draw primitives	*/\
    if(LPolyGroup->GLArrayVertexNormal)\
    {\
     glEnableClientState(GL_VERTEX_ARRAY);\
     glEnableClientState(GL_NORMAL_ARRAY);\
     glDisableClientState(GL_TEXTURE_COORD_ARRAY);\
     glVertexPointer(3, GL_FLOAT, sizeof(E3dGLShadedVertex), LPolyGroup->GLArrayVertexNormal);\
     glNormalPointer(GL_FLOAT, sizeof(E3dGLShadedVertex), (char*)(LPolyGroup->GLArrayVertexNormal)+sizeof(E3dGLCoordinate)*3);\
     glDrawElements(GL_TRIANGLES, LPolyGroup->GLTriangleCount*3, GL_UNSIGNED_INT, LPolyGroup->GLTriangleVertexIndexArray);\
    }\
    else if((mPolyCnt=LPolyGroup->NumOfTriangleStrips)>0)\
    {\
     glDisable(GL_CULL_FACE);\
     mTriangleStrip=LPolyGroup->TriangleStrips;\
     do\
     {\
      E3dM_DrawTriangleStripVertexNormal();\
      mTriangleStrip++;\
     } while(--mPolyCnt);\
     glEnable(GL_CULL_FACE);\
    }\
    else if((mPolyCnt=LPolyGroup->NumOfPolygons)>0)\
    {\
     mPolygon=LPolyGroup->Polygons;\
\
     if((LPolyGroup->Flags&E3dUSE_VERTEX_NORMALS)==0)\
     {\
      do\
      {\
       MglNormal3v(mPolygon->GLNormal);\
       E3dM_DrawPolygon();\
       mPolygon++;\
      } while(--mPolyCnt);\
     }\
     else\
     {\
      do\
      {\
       E3dM_DrawPolygonVertexNormal();\
       mPolygon++;\
      } while(--mPolyCnt);\
     }\
    }\
   }\
  break;\
 }\
}



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DDefaultDrawingMacros_h
