/*======================================================================*/
/* E3D library								*/
/*									*/
/* Standard header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Nov-27 23:50:21					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3D_h
#define _E3D_h

#ifndef _E3DTypes_h
#include <E3D/Types.h>
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif



/*--------------------------------------------------------------*/
/* Macro functions						*/
/*--------------------------------------------------------------*/




/*==============================================================*/
/* Initialize X,Y,Z rotation					*/
/*==============================================================*/
#define E3dM_RotationInit(rot,mx,my,mz)	(rot).X=(mx),(rot).Y=(my),(rot).Z=(mz)


/*==============================================================*/
/* Initialize X,Y,Z position					*/
/*==============================================================*/
#define E3dM_PositionInit(pos,mx,my,mz)	(pos).X=(mx),(pos).Y=(my),(pos).Z=(mz)


/*======================================*/
/* Copy a vector			*/
/*======================================*/
#define E3dM_VectorCopy(sv,dv)	(dv).X=(sv).X,(dv).Y=(sv).Y,(dv).Z=(sv).Z,(dv).Length=(sv).Length


/*--------------------------------------------------------------*/
/* Function prototypes						*/
/*--------------------------------------------------------------*/
extern long		E3d_GetSeconds();

extern E3dCoordinate	E3d_SnapCoordinateTo(E3dCoordinate LF, E3dCoordinate LS);
extern void		E3d_ColorShadeByLuma(EcRGBAiColor* LColorLum, EcRGBAiColor* LColor, EcRGBAiColor* LColorRet);
extern void		E3d_3DPositionInit(E3d3DPosition* LPosition,double LX,double LY,double LZ);
extern void		E3d_3DPositionCopy(E3d3DPosition* LSrcPosition,E3d3DPosition* LDstPosition);
extern void		E3d_VectorInit(E3dVector* LVector,double LX,double LY,double LZ);
extern void		E3d_VectorCopy(E3dVector* LSrcVector,E3dVector* LDstVector);
extern void		E3d_VectorCrossProduct(E3dVector* LVectorA, E3dVector* LVectorB, E3dVector* LVectorC);

extern void		E3d_RotationInit(E3dRotation* LRotation,double LX,double LY,double LZ);

extern void		E3d_CallCallbacks(void* LItem, E3dCallbackRec* LCallbacks, unsigned int LNumOfCallbacks, EPointer LCallData);
extern EBool		E3d_CallOutputs(void* LItem, E3dInterface** LOutputs, unsigned int LNumOfOutputs, EPointer LCallData);


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3D_h
