/*==============================================================================*/
/* DESCRIPTION:	E3d macros							*/
/*										*/
/* AUTHOR:	Gabor Nagy							*/
/* DATE:	2002-Nov-23 18:08:03						*/
/*										*/
/* Copyright (C) 1999 by Sony Computer Entertainment. All rights reserved.	*/
/*==============================================================================*/

#include <E3D/Face.h>

#include <E3D/Mesh.h>

#include <E3D/Model.h>

#include <E3D/Material.h>

#include <E3D/Matrix.h>

#include <E3D/Light.h>

#include <E3D/Scene.h>

#include <E3D/Camera.h>


// Flags for CDs_AssembleModelsN()
//
#define	CDS_GET_LIGHTS		0x01
#define	CDS_VU1_ENVMAP		0x10



#define ETXT_FREEHAND			E3dTXT_FREEHAND


#define EImage				EpImage


#define EScene				E3dScene

#define ECoordinate			E3dCoordinate
#define EGLCoordinate			E3dGLCoordinate
#define E3DPosition			E3d3DPosition


#define EMatrix				E3dMatrix

#define EModelClass			E3dModelClass
#define EModelInfo			E3dModelInfo
#define ENode				E3dNode
#define EJointNode			E3dJointModel
#define EModel				E3dModel

#define EGeometryClass			E3dGeometryClass
#define EGeometryInfo			E3dGeometryInfo
#define EGeometry			E3dGeometry

#define EMesh				E3dMesh
#define ESkinMesh			E3dSkinMesh
#define ESpline				E3dSpline
#define EFace				E3dFace

#define EPolyGroup			E3dPolyGroup
#define EPolyGroupClass			E3dPolyGroupClass
#define EPolyGroupInfo			E3dPolyGroupInfo

#define EPolygon			E3dPolygon
#define ETriangleStrip			E3dTriangleStrip

#define EVertex				E3dVertex
#define ESkinVertex			E3dSkinVertex
#define EVertexNode			E3dVertexNode

#define ESplineCV			E3dSplineCV
#define EBezierCV			E3dBezierCV

#define EMaterial			E3dMaterial
#define EGLMaterial			E3dGLMaterial
#define EShaderClass			E3dShaderClass
#define EShader				E3dShader
#define E2DTexture			E3d2DTexture

#define ERenderInfo			E3dRenderInfo
#define ECamera				E3dCamera
#define	ELight				E3dLight

#define	EShadowMap			E3dShadowMap
#define	EShadowMapCore			E3dShadowMapCore



#define EWeight				E3dWeight


#define EWindow				E3dWindow


#define EVTXF_TAGGED			E3dVTXF_TAGGED

#define	ESVTXF_BONESOK			E3dSVTXF_BONESOK

#define EMDL_NORMAL			E3dMDL_NORMAL
#define EMDL_LIGHT			E3dMDL_LIGHT
#define EMDL_JOINT			E3dMDL_JOINT
#define EMDL_BONE			E3dMDL_BONE

#define	EGEO_MESH			E3dGEO_MESH
#define	EGEO_SKINMESH			E3dGEO_SKINMESH
#define	EGEO_SPLINE			E3dGEO_SPLINE
#define	EGEO_FACE			E3dGEO_FACE
#define	ELIGHT_POINT			E3dLIGHT_POINT

#define ESPL_BEZIER			E3dSPL_BEZIER

#define	EUSE_VERTEX_NORMALS		E3dUSE_VERTEX_NORMALS
#define	ENormalNONE			E3dNormalNONE
#define	ENormalFROM_DISCONTINUITY_ANGLE	E3dNormalFROM_DISCONTINUITY_ANGLE

#define	caseEMESH			caseE3dMESH


#define	E_NotFound2DTextureImage	E3d_NotFound2DTextureImage



#define E_Verbose			E3d_Verbose
#define E_CurrentGLXWindow		E3dp_CurrentGLXWindow
#define E_Current2DGLTexture		E3d_Current2DGLTexture


// Macros
//
#define EM_InitBezierCV				E3dM_InitBezierCV
#define EM_InitSplineCV				E3dM_InitSplineCV

#define EM_VectorCrossProduct			E3dM_VectorCrossProduct
#define EM_ABS					E3dM_ABS
#define EM_MatrixTransform3x4			E3dM_MatrixTransform3x4


// Functions
//
#define E_CameraAllocate			E3d_CameraAllocate

#define E_MatrixCopy				E3d_MatrixCopy
#define E_MatrixTranslate			E3d_MatrixTranslate
#define E_MatrixInvert3x3			E3d_MatrixInvert3x3
#define E_MatrixInvert3x4			E3d_MatrixInvert3x4
#define E_MatrixInvert4x4			E3d_MatrixInvert4x4

#define E_LightCreateAndAddToScene		E3d_LightCreateAndAddToScene

#define E_ShaderAllocate			E3d_ShaderAllocate
#define E_ShaderClassFindByName			E3d_ShaderClassFindByName
#define E_ShaderClassRegisterInactive		E3d_ShaderClassRegisterInactive
#define E_MaterialAllocate			E3d_MaterialAllocate
#define E_MaterialFree				E3d_MaterialFree
#define E_2DTextureAllocate			E3d_2DTextureAllocate
#define E_2DTextureDefault			E3d_2DTextureDefault
#define E_VerticesAllocate			E3d_VerticesAllocate
#define E_SkinVerticesAllocate			E3d_SkinVerticesAllocate
#define E_PolyGroupAllocate			E3d_PolyGroupAllocate
#define E_PolygonsAllocate			E3d_PolygonsAllocate
#define E_PolygonVertexNodesAllocate		E3d_PolygonVertexNodesAllocate
#define E_TriangleStripVertexNodeAllocate	E3d_TriangleStripVertexNodeAllocate

#define E_PolyGroupClassFindByName		E3d_PolyGroupClassFindByName
#define E_PolyGroupInfoByClass			E3d_PolyGroupInfoByClass

#define E_GeometryFree				E3d_GeometryFree
#define E_GeometryInfoByClass			E3d_GeometryInfoByClass
#define E_GeometryClassFindByName		E3d_GeometryClassFindByName

#define E_MeshAddTriangleStrip			E3d_MeshAddTriangleStrip
#define E_MeshAllocate				E3d_MeshAllocate
#define E_MeshAppendPolyGroup			E3d_MeshAppendPolyGroup
#define E_SkinMeshAllocate			E3d_SkinMeshAllocate

#define E_SplineAllocate			E3d_SplineAllocate
#define E_SplineCVsAllocate			E3d_SplineCVsAllocate
#define E_SplineUpdateSegmentLengths		E3d_SplineUpdateSegmentLengths

#define E_FaceAllocate				E3d_FaceAllocate

#define E_ModelAllocate				E3d_ModelAllocate
#define E_JointModelAllocate			E3d_JointModelAllocate
#define E_ModelAppendGeometry			E3d_ModelAppendGeometry

#define E_ModelInfoByClass			E3d_ModelInfoByClass
#define E_ModelClassFindByName			E3d_ModelClassFindByName

#define E_PrintMessage				E3dp_PrintMessage


#define EGL_2DTextureSetMapping			E3dGL_2DTextureSetMapping


#define EGL_ExtensionSupported			E3dGL_ExtensionSupported

#define E_Log					E3dp_Log

#define E_RenderingHWInfo			E3dp_RenderingHWInfo
#define EShadowDEPTH_MAPPING			E3dShadowDEPTH_MAPPING


#define EBB_ALL					E3dBB_ALL
#define E_GeometryGetTransformedBoundingBox	E3d_GeometryGetTransformedBoundingBox
