/*======================================================================*/
/* 3DPanel header file							*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-17 23:21:35					*/
/*									*/
/* 3DPanel(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DPanel_h
#define _E3DPanel_h

#include <EPrefs.h>

#include <EGUI/EGUI.h>
#include <EGUI/Menu.h>


#ifndef _E3DCamera_h
#include <E3D/Camera.h>
#endif


#ifndef _E3DMesh_h
#include <E3D/Mesh.h>
#endif


#ifndef _E3DModel_h
#include <E3D/Model.h>
#endif


#ifndef _E3DScene_h
#include <E3D/Scene.h>
#endif



#ifdef EGUIXe
#include <GL/glx.h>
#include <Xe/GLDraw.h>
#include <EGUI/Dialog.h>
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif

#ifdef sgi
#define	E3dGL_POLYGON_OFFSET_SUPPORTED
#endif


// OpenGL macros
//
#define E3dM_glColorRGBAp8(c)		glColor4ub(EcM_R_RGBA(c),EcM_G_RGBA(c),EcM_B_RGBA(c),EcM_A_RGBA(c))
#define E3dM_glColorRGBAi(c)		glColor4ub(((c).R)>>8, ((c).G)>>8, ((c).B)>>8, ((c).A)>>8)
#define E3dM_glColorRGBAiPTR(c)		glColor4ub(((c)->R)>>8, ((c)->G)>>8, ((c)->B)>>8, ((c)->A)>>8)
#define E3dM_glClearColorRGBAp8(c)	glClearColor((float)(EcM_R_RGBA(c))*0.039064,(float)(EcM_G_RGBA(c))*0.039064,(float)(EcM_B_RGBA(c))*0.039064,(float)(EcM_A_RGBA(c))*0.039064)
#define E3dM_glClearColorRGBAi(c)	glClearColor((float)((c).R)*0.0000152, (float)((c).R)*0.0000152, (float)((c).R)*0.0000152, (float)((c).R)*0.0000152)

#ifdef E3dDOUBLE_PRECISION
#define MglVertex3	glVertex3d
#define MglVertex3v	glVertex3dv
#define MglNormal3	glNormal3d
#define MglNormal3v	glNormal3dv
#define MglTexCoord2	glTexCoord2d
#define MglTexCoord2v	glTexCoord2dv
#define MglRasterPos3	glRasterPos3d
#else
#define MglVertex3	glVertex3f
#define MglVertex3v	glVertex3fv
#define MglNormal3	glNormal3f
#define MglNormal3v	glNormal3fv
#define MglTexCoord2	glTexCoord2f
#define MglTexCoord2v	glTexCoord2fv
#define MglRasterPos3	glRasterPos3f
#endif // DOUBLE_PRECISION


#define ME3dVertex3dot(v)	MglVertex3((v).X, (v).Y, (v).Z)

#define ME3dVertex2i(v)		glVertex2i((v)[E3dX], (v)[E3dY])
#define ME3dVertex3i(v)		glVertex3i((v)[E3dX], (v)[E3dY], (v)[E3dZ])

#define	E3dpPOINTERMODE_STACKDEPTH	16


// 3DPanel built-in function codes
//
enum
{
 E3dCR_DISPLAY_CONTROLS=1,
 E3dCR_DELETE_LIGHTS,
 E3dCR_DELETE_SELECTION,
 E3dCR_DELETE_ALL_HIERARCHIES,
 E3dCR_DELETE_ALL,
 E3dCR_TOGGLE_MENU
};

#define E3dpNselectingEnabled	"selectingEnabled"
#define E3dpNdeletingEnabled	"deletingEnabled"

#define			E3dp3DPANEL_FRACTION_BASE	10000

// Maximum displayed grid-count for perspective mode
//
#define E3dpGRID_MAX	160


enum { E3dp_MSG_ERROR };

// Transformation targets
//
enum
{
 E3dpTT_OBJECT=1,
 E3dpTT_OBJECT_TMP_FROM_TAG,	// There were no tagged points when the user tried to transform TT_TAG,
				// so we temporariy switched to TT_OBJECT. We have to switch back when he/she releases the mouse button.
 E3dpTT_TAG,
 E3dpTT_CENTER,
 E3dpTT_TEXTURE
};

#define caseE3dpTT_OBJECT()\
  case E3dpTT_OBJECT:\
  case E3dpTT_OBJECT_TMP_FROM_TAG

// Transformation modes
//
enum
{
 E3dpTM_NONE=0,
 E3dpTM_VIEW,
 E3dpTM_LOCAL,
 E3dpTM_GLOBAL,
 E3dpTM_PLANE,
 E3dpTM_REFERENCE
};


// Selecting modes
//
enum
{
 E3dpSELM_SINGLE,
 E3dpSELM_MULTI
};


#define E3dpSCALEX	0x001
#define E3dpSCALEY	0x002
#define E3dpSCALEZ	0x004
#define E3dpROTATEX	0x010
#define E3dpROTATEY	0x020
#define E3dpROTATEZ	0x040
#define E3dpTRANSLATEX	0x100
#define E3dpTRANSLATEY	0x200
#define E3dpTRANSLATEZ	0x400


/*----------------------*/
/* Pointer modes	*/
/*----------------------*/
enum
{
 E3dpPTR_NONE=0,
 E3dpPTR_SCALING,			// Interactive transforms
 E3dpPTR_ROTATING,
 E3dpPTR_TRANSLATING,
 E3dpPTR_ORBIT_STANDBY,			// 'O' key held down
 E3dpPTR_ORBIT,				// 'O' key held down
 E3dpPTR_TRACK_ZOOM_STANDBY,		// 'Z' key held down
 E3dpPTR_TRACK,				// 'Z' key held down
 E3dpPTR_ZOOM,				// 'Z' key held down
 E3dpPTR_DOLLY_STANDBY,			// 'P' key held down
 E3dpPTR_DOLLY,				// 'P' key held down
 E3dpPTR_BANK_STANDBY,			// 'R' key held down
 E3dpPTR_BANK,				// 'R' key held down
 E3dpPTR_ORBIT_DOLLY_TRACK_STANDBY,	// 'Ctrl' key held down
 E3dpPTR_ORBIT_ODT,			// 'Ctrl' key held down
 E3dpPTR_DOLLY_ODT,			// 'Ctrl' key held down
 E3dpPTR_TRACK_ODT,			// 'Ctrl' key held down
 E3dpPTR_BANK_ZOOM_STANDBY,		// 'Ctrl+Shift' keys held down
 E3dpPTR_BANK_BZ,			// 'Ctrl+Shift' keys held down
 E3dpPTR_ZOOM_BZ,			// 'Ctrl+Shift' keys held down
 E3dpPTR_ORBIT_TRACK_DOLLY_STANDBY,	// 'Alt' key held down (Maya-like camera control)
 E3dpPTR_ORBIT_OTD,			// 'Alt' key held down (Maya-like camera control)
 E3dpPTR_TRACK_OTD,			// 'Alt' key held down (Maya-like camera control)
 E3dpPTR_DOLLY_OTD,			// 'Alt' key held down (Maya-like camera control)
 E3dpPTR_DELETING,			// 'Del' key held down
 E3dpPTR_SELECTING,			// 'Space' key held down
 E3dpPTR_POLY_PAINT,			// 'G' key and right mouse button Polygon-selection mode
 E3dpPTR_UNDO_REDO,			// 'U' key
 E3dpPTR_PICK,				// Generic pick mode
 E3dpPTR_PICK_MODEL,
 E3dpPTR_PICK_GEOMETRY,
 E3dpPTR_PICK_MESH,
 E3dpPTR_PICK_POLYGROUP,
 E3dpPTR_PICK_POLYGON,
 E3dpPTR_PICK_VERTEX,
 E3dpPTR_PICK_EDGE,
 E3dpPTR_PICK_SPLINE,
 E3dpPTR_TAG_POINT,			// Tag/untag single point
 E3dpPTR_TAG_POINTS_STANDBY,		// 'T'
 E3dpPTR_TAG_POINTS,
 E3dpPTR_TAG_LINE_STANDBY,		// Mesh Edge or Spline segment
 E3dpPTR_TAG_LINE,
 E3dpPTR_LASSO_TAG_POINTS_STANDBY,
 E3dpPTR_LASSO_TAG_POINTS,
 E3dpPTR_MOVE_POINT_STANDBY,
 E3dpPTR_MOVE_POINT,
 E3dpPTR_SELECT_ZOOM_REGION_STANDBY,	// 'Shift+Z'
 E3dpPTR_SELECT_ZOOM_REGION
};


/*--------------------------------------*/
/* Rendering hardware information	*/
/*--------------------------------------*/
// Vertex-array support
//
enum
{
 E3dVtxArrNONE=0,
 E3dVtxArrNORMAL,
 E3dVtxArrFAST
};


// Shadow-mapping modes
//
enum
{
 E3dShadowNONE=0,
 E3dShadowDUAL_TEXTURE,
 E3dShadowDEPTH_MAPPING
};

typedef struct
{
 char*	Vendor;
 char*	Model;

// Rendering features supported by the hardware
//
 int	VertexArrays;
 int	Shadows;
} E3dHardwareInfo;

typedef struct E3dPanel_S	E3dPanel;

struct E3dPanel_S
{
 Widget		TopMatrixW, MiddleMatrixW, M3DWindowLayoutW;
 Widget		ToolPanelW, ToolPanelBW, ToolPanelPW,
		StatusPanelW, StatusPanelBW, StatusPanelPW,
		TimePanelW, TimePanelBW, TimePanelPW, TimeExtPanelMatrixW;
 EguiMenuRec*	MenuBar;
 GLXContext	EGLXContext;
};



typedef struct
{
 Widget		CascadeBW;
 Pixmap		Icon, IconActive, IconArmed;
} E3dMenuButtonRec;

enum
{
 E3dpPLACE_LEFT=0,
 E3dpPLACE_RIGHT,
 E3dpPLACE_TOP,
 E3dpPLACE_BOTTOM
};


// MenuBarCascadeButtonType
//
enum
{
 E3dpMBT_ICON=0,
 E3dpMBT_TEXT,
 E3dpMBT_ICON_AND_TEXT
};



typedef struct
{
 char*		LogFile;
 char*		ResourcePath;
 char*		PluginPath;
 char*		FileIOPluginPath;
 char*		ImageFileIOPluginPath;
 char*		TexturePath;
 unsigned short	GLValueType;
 E3d3DPosition	DefCameraPos, DefInterestPos;
 float		DefZoom, DefFieldOfView;
 double		DefZNear, DefZFar;
 float		DollyStep1, DollyStep2, DollyStep3;		// Mouse motion/transformation proportions
 float		RollStep, OrbitStepLongitude, OrbitStepLatitude,
		FrameToTime, FrameToTimeStep;

 E3d3DPosition	ScalingStep;
 E3d3DPosition	RotatingStep;
 E3d3DPosition	TranslatingStep;
 E3d3DPosition	DefGridDisplay;
 E3d3DPosition	DefSubGridDisplay;
 EBool		GridOn, GridXYOn, GridXZOn, GridYZOn;
 unsigned short	GridXCount, GridYCount, GridZCount;
 EBool		AxisOn, RulerOn;
 float		DefEyeDistance;

 EcRGBAiColor	MenuRGBAiColor, PanelRGBAiColor, LabelRGBAiColor;

 EcRGBAiColor	BackgroundRGBAiColor,
		GridRGBAiColor, SubGridRGBAiColor, ShadedGridRGBAiColor, ShadedSubGridRGBAiColor, AxisRGBAiColor, ShadedAxisRGBAiColor,
		WireRGBAiColor, HWireRGBAiColor, SelGeoWireRGBAiColor, SelSubGeoWireRGBAiColor,
		TextureProjectorRGBAiColor,
		VertexRGBAiColor, HVertexRGBAiColor, ActivePointRGBAiColor, TaggedPointRGBAiColor,
		ActiveEdgeRGBAiColor, SelectedEdgeRGBAiColor,
		Line1RGBAiColor, Line2RGBAiColor,
		SelectedPolygonRGBAiColor, ShadedSelectedPolygonRGBAiColor,
		NormalRGBAiColor,
		LockedItemRGBAiColor,
		LeftEyeRGBAiColor, RightEyeRGBAiColor;
 int		PointSize, TaggedPointSize, PickPointSize;
 float		LineWidth;

 int		MenuBarPlacement, MenuBarCascadeButtonType;

 EBool		PolyPaintOnSelectionOnly;			// Only ray-intersect selected objects when selecting Polygons
 EBool		ShowCamera, MoveCameraWith3DCursor;


 EBool		Show3DCursor,
		ShowVertices,
		ShowControlPoints,
		ShowLines,
		ShowCenters,
		ShowPolygonNormals,
		ShowVertexNormals,
		ShowTags,
		ShowSelectedPolygons,
		ShowWireframeOfHiddenObjects,
		ShowTextureProjectors,
		ShowGridsInShadedMode,
		ShowLampsInWireMode,
		ShowLampsInSolidMode,
		ShowSplinesInSolidMode;

 EBool		UseQuickExposeBuffer,
		UseTransformBuffer,	// Use image buffer for transformations in wireframe (only re-render objects being transformed)
		UseCameraSpeedupBuffer;	// Similar as above for the camera
 EBool		SelectingEnabled, DeletingEnabled;
 EBool		UseGLDisplayLists, UseGLVertexArrays;

 EBool		HighlightActive3DWindow;

 EBool		MenuBarOn, TransformPanelOn, HeadersOn, TimePanelOn, TimeExtPanelOn,
		ToolPanelOn,
		InfoFolderOpen,
		DisplayFolderOpen,
		CameraFolderOpen,
		LightFolderOpen,
		CreateFolderOpen,
		CloneFolderOpen,
		TransformFolderOpen,
		HierarchyFolderOpen,
		GeometryFolderOpen,
		SplineFolderOpen,
		MaterialFolderOpen,
		SurfaceFolderOpen,
		DeleteFolderOpen,
		EffectFolderOpen,
		RenderFolderOpen,
		SelectFolderOpen,
		HistoryFolderOpen,
		AnimationFolderOpen,
		StatusPanelOn;
} E3dpPrefs;


typedef struct
{
 EcRGBAiColor	BackgroundRGBAiColor,
		GridRGBAiColor, SubGridRGBAiColor, ShadedGridRGBAiColor, ShadedSubGridRGBAiColor, AxisRGBAiColor, ShadedAxisRGBAiColor,
		WireRGBAiColor, HWireRGBAiColor, SelGeoWireRGBAiColor, SelSubGeoWireRGBAiColor, LockedItemRGBAiColor, TextureProjectorRGBAiColor,
		VertexRGBAiColor, TaggedPointRGBAiColor, ActivePointRGBAiColor,
		ActiveEdgeRGBAiColor, SelectedEdgeRGBAiColor,
		Line1RGBAiColor, Line2RGBAiColor, HVertexRGBAiColor,
		SelectedPolygonRGBAiColor, ShadedSelectedPolygonRGBAiColor,
		NormalRGBAiColor;

 EcRGBAp8Color	BackgroundRGBAp8Color, SelectedPolygonRGBAp8Color, ShadedSelectedPolygonRGBAp8Color;

 E3dRenderInfo*	RenderInfo;
 E3dMatrix	WorldToScreenMatrix;		// Projection*Camera transformation matrix
} E3dDrawContext;

enum
{
 AM_ANIM,
 AM_MOVIE
};



// Geometry panel
//
typedef struct
{
 EGUIFolder	Folder;
 Widget		NameW, CastsShadowsW, ReceivesShadowsW,
		LODScaleW, LODReferenceScaleW;
 EGUIFolder	LODFolder;
 E3dGeometry*	Geometry;
 E3dGeometry*	CurrentLOD;
 EBool		PrgChangedName;
} E3dGeometryPanel;


// Model panel
//
typedef struct
{
 EGUIFolder	Folder;
 Widget		NameW,
		RotOrderW,
		StatsLW, StatsValLW,
		BBoxValLW,
		JointInfoSeparatorW,
		XAngleMinW, XAngleMaxW,
		YAngleMinW, YAngleMaxW,
		ZAngleMinW, ZAngleMaxW,
		XAngularDampeningW,
		YAngularDampeningW,
		ZAngularDampeningW;
 E3dModel*	Model;
 EGUIFolder	JointOptionsDrawer;
 EBool		FollowSelection,
		PrgChangedName;
} E3dModelPanel;



/*------------------------------*/
/* From Prefs.c			*/
/*------------------------------*/
extern E3dpPrefs	E3dp_Prefs;

#ifdef EGUIXe
extern Display*		E3dp_Display;
extern int		E3dp_Screen;
extern Colormap		E3dp_Colormap;
extern XtAppContext	E3dp_AppContext;
extern Pixel		E3dp_ProgressIndicatorColor;

extern Widget		E3dp_ModelSysFormW;
extern GLXContext	E3dp_GLContext;

extern Cursor		E3dp_BusyCursor,
			E3dp_OrbitCursor, E3dp_RollCursor, E3dp_TrackZoomCursor, E3dp_TrackCursor, E3dp_ZoomCursor, E3dp_DollyCursor;
#endif // EGUIXe


extern EBool		E3dp_Selecting;
extern int		E3dp_SelectionMode;
extern int		E3dp_PointerMode;

extern int		E3dp_PointerModeStack[E3dpPOINTERMODE_STACKDEPTH];
extern int		E3dp_PointerModeStackPtr;

extern E3dMatrix	E3dp_3DCursorMatrix;


extern void		(*E3dp_EventLoopFunction)();


extern void		E3dp_SetScaleArgs(ArgList LArgs, Cardinal* LArgCnt);



/*------------------------------*/
/* From E3MenuF.c		*/
/*------------------------------*/
extern void		E3dp_Log(int LType, char* LPrefix, char* LMessage, ...);
extern void		E3dp_ReadSettings(char* LName, EResource* LResources);


/*------------------------------*/
/* From E3DP0.c			*/
/*------------------------------*/
extern int		E3dp_ScaleWidth, E3dp_SliderLength, E3dp_SliderWidth;


/*------------------------------*/
/* From Mesh.c			*/
/*------------------------------*/
extern void	(*E3dNV_AGPMemAllocateProc)();
extern char*	(*E3d_AGPMallocProc)(unsigned int, void**);
extern void	(*E3d_AGPFreeProc)(void*);


/*------------------------------*/
/* From Panel/3DPanel.c		*/
/*------------------------------*/
extern E3dPanel*	E3dp_3DPanel;


// Default plugin icons, linked to ToolPanel.a
//
extern EpCImage		Image_Plugin;
extern EpCImage		Image_PluginActive;
extern EpCImage		Image_PluginArm;
extern EpCImage		Image_PluginBig;


extern EUndoStack	E3dp_UndoStack;

// 3D Icon models
//
extern int		E3d_ToolIconXSize, E3d_ToolIconYSize,
			E3d_ToolBigIconXSize, E3d_ToolBigIconYSize;	// For tool dialogs

extern E3dModel*	E3d_3DCursorModel;
extern E3dModel*	E3d_SpotlightModel;
extern E3dModel*	E3d_WireCameraModel;
extern E3dModel*	E3d_SolidCameraModel;
extern E3dModel*	E3d_CameraInterestModel;

extern E3dMesh*		E3d_BulbMesh;

extern Pixel		E3dp_RedPixel, E3dp_GreenPixel, E3dp_BluePixel;

extern EguiItem		E3dp_TopShell;

extern void		E3dp_ResetWorkModes();

extern E3dModel*	E3dp_Read3DIconModel(char* LFileName);

extern void		E3dp_SceneRead2DTextures(E3dScene* LScene, EBool LForceReread);
extern void		E3dp_SyncGUI();

extern void		E3dp_SetBackKeyboardControl();

extern void		E3dp_SetPointerMode(int LPointerMode);
extern void		E3dp_PushPointerMode(int LPointerMode);
extern void		E3dp_PopPointerMode();

#ifdef EGUIXe
extern XVisualInfo*	E3dp_GLVisualId;

extern E3dPanel*	E3dp_Create3DPanel(E3dScene* LScene, EguiItem LTopShell, Widget LParentW, int LCols, int LRows, void (*LExitFunction)(), void (*LEventLoopFunction)(EguiEvent*));
#endif // EGUIXe


extern void		E3dp_Free3DPanel(E3dPanel* L3DPanel);

extern void		E3dp_AppendOps1Operator(EOperator* LOperator);
extern void		E3dp_Undo(E3dPanel* LPanel);
extern void		E3dp_Redo(E3dPanel* LPanel);



/*------------------------------*/
/* From Panel/TimePanel.c	*/
/*------------------------------*/
extern void		E3dp_SetTimePanel(E3dPanel* L3DPanel, EBool LSwitch, EBool LSwitchExt);


/*------------------------------*/
/* From Panel/Display.c		*/
/*------------------------------*/
extern E3dHardwareInfo	E3dp_RenderingHWInfo;
extern EBool		E3dp_RedrawShadowMap;

extern EBool		E3dGL_HasOpenGL12;
extern EBool		E3dGL_HasTextureBorderClamp;
extern EBool		E3dGL_HasTextureEdgeClamp;

extern EBool		E3dGL_ExtensionSupported(const char* LName);
extern int		E3dGL_InitExtensions();

extern EBool		E3dp_DrawMeshVerticesIfPolyGroupSelected;


/*------------------------------*/
/* From Panel/GeometryPanel.c	*/
/*------------------------------*/
extern void		E3d_GeometryPanelUpdate(E3dGeometryPanel* LGeometryPanel, E3dGeometry* LGeometry);
extern Widget		E3d_GeometryPanelCreate(Widget LParentW, E3dGeometryPanel* LGeometryPanel, E3dGeometry* LGeometry, EBool LCreateFolder);
extern void		E3d_GeometryPanelFree(E3dGeometryPanel* LGeometryPanel, EBool LFreeStructure);

extern EguiItem		E3d_GeometryDialogCreate(char* LName, E3dGeometry* LGeometry, E3dGeometryPanel* LGeometryPanel, EguiCallbackProc LCB, EpCImage* LIconImage);
extern EguiItem		E3d_VaGeometryDialogCreate(char* LName, E3dGeometry* LGeometry, E3dGeometryPanel* LGeometryPanel, ...);


/*------------------------------*/
/* From Panel/ModelPanel.c	*/
/*------------------------------*/
extern void		E3d_ModelPanelUpdate(E3dModelPanel* LModelPanel, E3dModel* LModel);
extern Widget		E3d_ModelPanelCreate(Widget LParentW, E3dModelPanel* LModelPanel, E3dModel* LModel, EBool LCreateFolder);
extern void		E3d_ModelPanelFree(E3dModelPanel* LModelPanel, EBool LFreeStructure);

extern EguiItem		E3d_ModelDialogCreate(char* LName, E3dModel* LModel, E3dModelPanel* LModelPanel, EguiCallbackProc LCB, EpCImage* LIconImage);
extern EguiItem		E3d_VaModelDialogCreate(char* LName, E3dModel* LModel, E3dModelPanel* LModelPanel, ...);


/*------------------------------*/
/* From Panel/MenuBar.c		*/
/*------------------------------*/
extern void		E3dp_SetSelectionMode(int LMode);
extern Widget		E3d_AddMenuButton(EguiMenuRec* LMenu, EguiItem LItem, Widget LBeforeW);


extern void		E3dp_SetMenuBar(E3dPanel* L3DPanel, EBool LSwitch);


extern E3d3DPosition	E3dp_CameraPos, E3dp_InterestPos;				// Global camera parameters
extern E3dVector	E3dp_CameraDirection;
extern E3dRotation	E3dp_CameraRot;
extern float		E3dp_ViewDistance;
extern float		E3dp_FieldOfView;
extern float		E3dp_EyeDistance;


/*------------------------------*/
/* From Panel/PanelLayout.c	*/
/*------------------------------*/
extern void		E3dp_3DWindowsLayout(E3dPanel* L3DPanel);
extern void		E3dp_3DWindowsPanelSetAttachments(E3dPanel* L3DPanel);
extern void		E3dp_MenuBarSetPanelAttachments(E3dPanel* L3DPanel);


/*------------------------------*/
/* From Panel/Schematics.c	*/
/*------------------------------*/
extern void		E3d_ModelHrcRefresSchemPositions(E3dModel* LRootModel);
extern int		E3dp_SceneLayoutOnSchematics(E3dScene* LScene);


/*------------------------------*/
/* From Panel/ToolPanel.c	*/
/*------------------------------*/
extern void		E3dp_SetToolPanel(E3dPanel* L3DPanel, EBool LSwitch);


/*------------------------------*/
/* From Panel/TransformPanel.c	*/
/*------------------------------*/
extern int		E3dp_PrevPtrX, E3dp_PrevPtrY;

extern int		E3dp_BasePtrX, E3dp_BasePtrY;
extern E3d3DPosition	E3dp_TranslateBase;
extern E3d3DPosition	E3dp_ScaleBase;

extern unsigned int		E3dp_NumOfShapeSnapshots;
extern E3dShapeSnapshot*	E3dp_ShapeSnapshots;


extern void		E3dp_TransformPanelUpdate(int LScaleFlags, int LRotFlags, int LTransFlags, EBool LSelectionChanged);

extern void		E3dp_TransformPanelToggle(E3dPanel* L3DPanel, EBool LSwitch);

extern void		E3dp_ModelRemoveHrcFromScene(E3dModel* LRootModel);

extern void		E3dp_SetToolPanel(E3dPanel* L3DPanel, EBool LSwitch);

extern void		E3dp_ReadAndInitPlugins(char* LPath, char* LFileName);
extern void		E3dp_FreePlugins();





#define _E3dM_SetToolTip(mTip)\
 if((LXeStr=XeStringVaCreate(True, XeSTRING_COMPONENT_CHARSET, "tag1", XeSTRING_COMPONENT_ALIGN, XeSTRING_ALIGN_LEFT, XeSTRING_COMPONENT_TEXT, mTip, XeSTRING_COMPONENT_UNKNOWN))!=NULL)\
 {\
  EXtSetArg(XeNtipBackground, Ec_XGetRGBAiColor(E3dp_Display, DefaultColormap(E3dp_Display, E3dp_Screen), &EGUI_ToolTipBackgroundRGBAiColor));\
  EXtSetArg(XeNtipFontList, EGUI_LabelFontList);\
  EXtSetArg(XeNtipString, LXeStr);\
 }





#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DPanel_h
