/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Picking-related functions header file				*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-24 22:10:11					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DPick_h
#define _E3DPick_h

#ifndef _E3DItem_h
#include <E3D/Item.h>
#endif

#ifndef _E3D3DWindow_h
#include <E3D/3DWindow.h>
#endif

#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


typedef struct
{
 int		Reason;
 int		PtrX, PtrY;			// Pointer position
 E3dWindow*	MWindow;			// 3DWindow the where the Pick occured
 E3dCamera*	Camera;				// The Camera from which the pick was performed
 E3d3DPosition	RayOrigin, RayDirection;	// The ray that was cast to pick an object
 E3d3DPosition	WorldPosition;
 E3dCoordinate	SnapToXV, SnapToYV, SnapToZV;

 unsigned int	Modifiers;
 int		Button;
 EBool		SnapToX, SnapToY, SnapToZ;
} E3dPickCallbackStruct;


typedef void	(*E3dPickCallbackProc)(E3dPickCallbackStruct*, int, E3dItem*);


//----------------------------------------
// From Panel/Pick.c
//----------------------------------------
extern int			E3d_PickMode;
extern E3dPickCallbackProc	E3d_PickCallback;


extern int		E3dp_PickRequest(int LWhat, E3dPickCallbackProc LPickCallback, int LTimeOut, EBool LActivateOnMotion);
extern void		E3dp_PickEnd();
extern void		E3dp_PickAbort();


extern E3dCamera*	E3d_WindowCastPrimaryRay(E3dWindow* L3DWindow, int LMX, int LMY, E3dRay* LRay);

extern int		E3d_WindowRectanglePickItems(E3dWindow* L3DWindow, int LPickTargets, E3dItem* LItems, int LX, int LY, int LXSize, int LYSize);


#define E3dM_WindowPointPickItems(m3DWindow, mTarget, mPickedItems, mX, mY)\
 E3d_WindowRectanglePickItems(m3DWindow, mTarget, mPickedItems, mX-(E3dp_Prefs.PickPointSize)/2, mY-(E3dp_Prefs.PickPointSize/2), E3dp_Prefs.PickPointSize, E3dp_Prefs.PickPointSize)



#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DPick_h
