/*======================================================================*/
/* 3DLib								*/
/*									*/
/* Generic "Shape" header file						*/
/*									*/
/* AUTHOR:	Gabor Nagy						*/
/* DATE:	1996-Dec-09 23:18:50					*/
/*									*/
/* 3DLib(TM) Copyright (C) 1995 by Gabor Nagy. All rights reserved.	*/
/*======================================================================*/
#ifndef _E3DShape_h
#define _E3DShape_h

#ifndef _E3DFace_h
#include <E3D/Face.h>
#endif

#ifndef _E3DModel_h
#include <E3D/Model.h>
#endif

#ifndef _E3DMesh_h
#include <E3D/Mesh.h>
#endif

#ifndef _E3DPolygon_h
#include <E3D/Polygon.h>
#endif


#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
extern "C" {
#endif


// These structures are used for taking "snapshots" of Vertices/Points/Spline keys etc. for interactive
// transforming and for Undo/Redo of transforming and deleting Points
//
typedef struct
{
 E3dMesh*		Mesh;			// This always has to be the 1st field

 E3dSnapshotVertex*	SnapshotVertices;
 unsigned int		NumOfPoints, PointSize;
} E3dMeshVerticesSnapshot;


typedef struct
{
 E3dSpline*		Spline;			// This always has to be the 1st field

 void*			SnapshotCVs;
 unsigned int		NumOfCVs, CVSize;
 char			SubCV;			// For Bezier curves
} E3dSplineCVsSnapshot;


typedef struct
{
 E3dFace*		Face;			// This always has to be the 1st field

 E3dSplineCVsSnapshot*	SplineCVsSnapshots;
 unsigned int		NumOfSplineCVsSnapshots;
} E3dFaceCVsSnapshot;



typedef struct
{
 E3dGeometry*		Geometry;		// This always has to be the 1st field

 void*			Points;
 unsigned int		NumOfPoints, PointSize;
} E3dPointSnapshotGeo;


// The generic structure.
// It's in a union to have a unified size, so we can use an array of structs,
// instead of an array of pointers to avoid memory fragmentation
//
typedef union
{
 E3dGeometry*			Geometry;

 E3dMeshVerticesSnapshot	MeshVertices;
 E3dSplineCVsSnapshot		SplineCVs;
 E3dFaceCVsSnapshot		FaceCVs;
} E3dShapeSnapshot;





extern void		E3d_ShapeSnapshotFree(E3dShapeSnapshot* LShapeSnapshot);







#if defined (__cplusplus) && (!(defined (__CPLUSLIBS)))
}	// Close scope of 'extern "C"' declaration which encloses file.
#endif

#endif	// _E3DShape_h
